/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.audit;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.audit.AuditEndpoint;
import org.wildfly.security.audit.FileAuditEndpoint;

public class RotatingFileAuditEndpoint
extends FileAuditEndpoint {
    private final long rotateSize;
    private final int maxBackupIndex;
    private final boolean rotateOnBoot;
    private final SimpleDateFormat format;
    private final Period period;
    private final TimeZone timeZone;
    private String nextSuffix;
    private long nextRollover = Long.MAX_VALUE;
    private volatile long currentSize = 0L;

    RotatingFileAuditEndpoint(Builder builder) throws IOException {
        super(builder);
        this.rotateSize = builder.rotateSize;
        this.maxBackupIndex = builder.maxBackupIndex;
        this.rotateOnBoot = builder.rotateOnBoot;
        this.format = builder.format;
        this.period = builder.period;
        this.timeZone = builder.timeZone;
        File file = this.getFile();
        this.calcNextRollover(file != null && file.lastModified() > 0L ? file.lastModified() : System.currentTimeMillis());
        if (this.rotateOnBoot && this.maxBackupIndex > 0 && file != null && file.exists() && file.length() > 0L) {
            this.rotate(file);
        }
    }

    @Override
    protected void write(byte[] bytes) throws IOException {
        super.write(bytes);
        this.currentSize += (long)bytes.length;
    }

    @Override
    protected void preWrite(Date date) {
        long recordMillis = date.getTime();
        if (recordMillis >= this.nextRollover) {
            try {
                File file = this.getFile();
                this.closeStreams();
                Path target = Paths.get(file.getAbsolutePath() + this.nextSuffix, new String[0]);
                Files.move(file.toPath(), target, StandardCopyOption.REPLACE_EXISTING);
                this.setFile(file);
                this.currentSize = 0L;
            }
            catch (IOException e) {
                ElytronMessages.audit.unableToRotateLogFile(e);
            }
            this.calcNextRollover(recordMillis);
        } else if (this.currentSize > this.rotateSize && this.maxBackupIndex > 0) {
            try {
                File file = this.getFile();
                if (file == null) {
                    return;
                }
                this.rotate(file);
                this.currentSize = 0L;
            }
            catch (IOException e) {
                ElytronMessages.audit.unableToRotateLogFile(e);
            }
        }
    }

    private void rotate(File file) throws IOException {
        this.closeStreams();
        Path fileWithSuffix = Paths.get(file.getAbsolutePath() + this.nextSuffix, new String[0]);
        Files.deleteIfExists(Paths.get(fileWithSuffix + "." + this.maxBackupIndex, new String[0]));
        for (int i = this.maxBackupIndex - 1; i >= 1; --i) {
            Path src = Paths.get(fileWithSuffix + "." + i, new String[0]);
            if (!Files.exists(src, new LinkOption[0])) continue;
            Path target = Paths.get(fileWithSuffix + "." + (i + 1), new String[0]);
            Files.move(src, target, StandardCopyOption.REPLACE_EXISTING);
        }
        Files.move(file.toPath(), Paths.get(fileWithSuffix + ".1", new String[0]), StandardCopyOption.REPLACE_EXISTING);
        this.setFile(file);
    }

    private void calcNextRollover(long fromTime) {
        if (this.period == Period.NEVER || this.format == null) {
            this.nextRollover = Long.MAX_VALUE;
            return;
        }
        this.nextSuffix = this.format.format(new Date(fromTime));
        Calendar calendar = Calendar.getInstance(this.timeZone);
        calendar.setTimeInMillis(fromTime);
        Period period = this.period;
        switch (period) {
            default: {
                calendar.set(2, 0);
            }
            case MONTH: {
                calendar.set(5, 0);
                calendar.clear(4);
            }
            case WEEK: {
                if (period == Period.WEEK) {
                    calendar.set(7, calendar.getFirstDayOfWeek());
                } else {
                    calendar.clear(7);
                }
                calendar.clear(8);
            }
            case DAY: {
                calendar.set(11, 0);
            }
            case HALF_DAY: {
                if (period == Period.HALF_DAY) {
                    calendar.set(10, 0);
                } else {
                    calendar.set(10, 0);
                    calendar.set(9, 0);
                }
            }
            case HOUR: {
                calendar.set(12, 0);
            }
            case MINUTE: 
        }
        calendar.set(13, 0);
        calendar.set(14, 0);
        switch (period) {
            case YEAR: {
                calendar.add(1, 1);
                break;
            }
            case MONTH: {
                calendar.add(2, 1);
                break;
            }
            case WEEK: {
                calendar.add(3, 1);
                break;
            }
            case DAY: {
                calendar.add(5, 1);
                break;
            }
            case HALF_DAY: {
                calendar.add(9, 1);
                break;
            }
            case HOUR: {
                calendar.add(11, 1);
                break;
            }
            case MINUTE: {
                calendar.add(12, 1);
            }
        }
        this.nextRollover = calendar.getTimeInMillis();
    }

    private static <T extends Comparable<? super T>> T min(T a, T b) {
        return a.compareTo(b) <= 0 ? a : b;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends FileAuditEndpoint.Builder {
        private long rotateSize = 655360L;
        private int maxBackupIndex = 1;
        private boolean rotateOnBoot;
        SimpleDateFormat format;
        Period period = Period.NEVER;
        TimeZone timeZone = TimeZone.getDefault();

        Builder() {
        }

        public Builder setRotateSize(long rotateSize) {
            this.rotateSize = rotateSize;
            return this;
        }

        public Builder setMaxBackupIndex(int maxBackupIndex) {
            this.maxBackupIndex = maxBackupIndex;
            return this;
        }

        public Builder setRotateOnBoot(boolean rotateOnBoot) {
            this.rotateOnBoot = rotateOnBoot;
            return this;
        }

        public Builder setTimeZone(TimeZone timeZone) {
            this.timeZone = (TimeZone)Assert.checkNotNullParam((String)"timeZone", (Object)timeZone);
            return this;
        }

        public Builder setSuffix(String suffix) throws IllegalArgumentException {
            this.format = new SimpleDateFormat(suffix);
            this.format.setTimeZone(this.timeZone);
            int len = suffix.length();
            this.period = Period.NEVER;
            block11: for (int i = 0; i < len; ++i) {
                switch (suffix.charAt(i)) {
                    case 'y': {
                        this.period = (Period)((Object)RotatingFileAuditEndpoint.min((Comparable)((Object)this.period), (Comparable)((Object)Period.YEAR)));
                        continue block11;
                    }
                    case 'M': {
                        this.period = (Period)((Object)RotatingFileAuditEndpoint.min((Comparable)((Object)this.period), (Comparable)((Object)Period.MONTH)));
                        continue block11;
                    }
                    case 'W': 
                    case 'w': {
                        this.period = (Period)((Object)RotatingFileAuditEndpoint.min((Comparable)((Object)this.period), (Comparable)((Object)Period.WEEK)));
                        continue block11;
                    }
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'd': {
                        this.period = (Period)((Object)RotatingFileAuditEndpoint.min((Comparable)((Object)this.period), (Comparable)((Object)Period.DAY)));
                        continue block11;
                    }
                    case 'a': {
                        this.period = (Period)((Object)RotatingFileAuditEndpoint.min((Comparable)((Object)this.period), (Comparable)((Object)Period.HALF_DAY)));
                        continue block11;
                    }
                    case 'H': 
                    case 'K': 
                    case 'h': 
                    case 'k': {
                        this.period = (Period)((Object)RotatingFileAuditEndpoint.min((Comparable)((Object)this.period), (Comparable)((Object)Period.HOUR)));
                        continue block11;
                    }
                    case 'm': {
                        this.period = (Period)((Object)RotatingFileAuditEndpoint.min((Comparable)((Object)this.period), (Comparable)((Object)Period.MINUTE)));
                        continue block11;
                    }
                    case '\'': {
                        while (suffix.charAt(++i) != '\'') {
                        }
                        continue block11;
                    }
                    case 'S': 
                    case 's': {
                        throw ElytronMessages.audit.rotatingBySecondUnsupported(suffix);
                    }
                }
            }
            return this;
        }

        @Override
        public AuditEndpoint build() throws IOException {
            return new RotatingFileAuditEndpoint(this);
        }
    }

    public static enum Period {
        MINUTE,
        HOUR,
        HALF_DAY,
        DAY,
        WEEK,
        MONTH,
        YEAR,
        NEVER;

    }
}

