/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.security.PermissionCollection;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.ParametricPrivilegedExceptionAction;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.client.PeerIdentity;
import org.wildfly.security.auth.permission.ChangeRoleMapperPermission;
import org.wildfly.security.auth.permission.RunAsPrincipalPermission;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmInfo;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.event.RealmIdentityFailedAuthorizationEvent;
import org.wildfly.security.auth.server.event.RealmIdentitySuccessfulAuthorizationEvent;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.RoleMapper;

public final class SecurityIdentity {
    static final PeerIdentity[] NO_PEER_IDENTITIES = new PeerIdentity[0];
    private static final RuntimePermission SET_RUN_AS_PERMISSION = new RuntimePermission("setRunAsPermission");
    private final SecurityDomain securityDomain;
    private final Principal principal;
    private final AuthorizationIdentity authorizationIdentity;
    private final RealmInfo realmInfo;
    private final Map<String, RoleMapper> roleMappers;
    private final PeerIdentity[] peerIdentities;

    SecurityIdentity(SecurityDomain securityDomain, Principal principal, RealmInfo realmInfo, AuthorizationIdentity authorizationIdentity, Map<String, RoleMapper> roleMappers) {
        this.securityDomain = securityDomain;
        this.principal = principal;
        this.realmInfo = realmInfo;
        this.authorizationIdentity = authorizationIdentity;
        this.roleMappers = roleMappers;
        this.peerIdentities = NO_PEER_IDENTITIES;
    }

    SecurityIdentity(SecurityIdentity old, PeerIdentity[] newPeerIdentities) {
        this.securityDomain = old.securityDomain;
        this.principal = old.principal;
        this.realmInfo = old.realmInfo;
        this.authorizationIdentity = old.authorizationIdentity;
        this.roleMappers = old.roleMappers;
        this.peerIdentities = newPeerIdentities;
    }

    SecurityIdentity(SecurityIdentity old, Map<String, RoleMapper> roleMappers) {
        this.securityDomain = old.securityDomain;
        this.principal = old.principal;
        this.realmInfo = old.realmInfo;
        this.authorizationIdentity = old.authorizationIdentity;
        this.roleMappers = roleMappers;
        this.peerIdentities = old.peerIdentities;
    }

    SecurityDomain getSecurityDomain() {
        return this.securityDomain;
    }

    RealmInfo getRealmInfo() {
        return this.realmInfo;
    }

    AuthorizationIdentity getAuthorizationIdentity() {
        return this.authorizationIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAs(Runnable action) {
        if (action == null) {
            return;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            PeerIdentity.runAsAll(action, this.peerIdentities);
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runAs(Callable<T> action) throws Exception {
        if (action == null) {
            return null;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            T t = PeerIdentity.runAsAll(action, this.peerIdentities);
            return t;
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runAs(PrivilegedAction<T> action) {
        if (action == null) {
            return null;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            T t = PeerIdentity.runAsAll(action, this.peerIdentities);
            return t;
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    public <T> T runAs(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        if (action == null) {
            return null;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            T t = PeerIdentity.runAsAll(action, this.peerIdentities);
            return t;
        }
        catch (RuntimeException | PrivilegedActionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, P> T runAs(P parameter, ParametricPrivilegedAction<T, P> action) {
        if (action == null) {
            return null;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            T t = PeerIdentity.runAsAll(parameter, action, this.peerIdentities);
            return t;
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    public <T, P> T runAs(P parameter, ParametricPrivilegedExceptionAction<T, P> action) throws PrivilegedActionException {
        if (action == null) {
            return null;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            T t = PeerIdentity.runAsAll(parameter, action, this.peerIdentities);
            return t;
        }
        catch (RuntimeException | PrivilegedActionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    public <T, R> R runAsFunction(Function<T, R> action, T parameter) {
        if (action == null) {
            return null;
        }
        return (R)this.runAsFunction(Function::apply, action, parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, U, R> R runAsFunction(BiFunction<T, U, R> action, T parameter1, U parameter2) {
        if (action == null) {
            return null;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            R r = PeerIdentity.runAsAllFunction(parameter1, parameter2, action, this.peerIdentities);
            return r;
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    public <T> void runAsConsumer(Consumer<T> action, T parameter) {
        if (action == null) {
            return;
        }
        this.runAsConsumer(Consumer::accept, action, parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, U> void runAsConsumer(BiConsumer<T, U> action, T parameter1, U parameter2) {
        if (action == null) {
            return;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            PeerIdentity.runAsAllConsumer(parameter1, parameter2, action, this.peerIdentities);
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runAsSupplier(Supplier<T> action) {
        if (action == null) {
            return null;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            T t = PeerIdentity.runAsAllSupplier(action, this.peerIdentities);
            return t;
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    public Set<String> getRoles() {
        return this.securityDomain.mapRoles(this);
    }

    public Set<String> getRoles(String category) {
        return this.getRoles(category, false);
    }

    public Set<String> getRoles(String category, boolean fallbackToDefault) {
        RoleMapper roleMapper = this.roleMappers.get(category);
        return roleMapper == null ? (fallbackToDefault ? this.getRoles() : Collections.emptySet()) : roleMapper.mapRoles(this.securityDomain.mapRoles(this));
    }

    public SecurityIdentity withRoleMapper(String category, RoleMapper roleMapper) {
        Map<String, RoleMapper> newMap;
        Assert.checkNotNullParam((String)"category", (Object)category);
        Assert.checkNotNullParam((String)"roleMapper", (Object)roleMapper);
        Map<String, RoleMapper> roleMappers = this.roleMappers;
        RoleMapper existingRoleMapper = roleMappers.get(category);
        if (existingRoleMapper == roleMapper) {
            return this;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ChangeRoleMapperPermission(category));
        }
        if (roleMappers.isEmpty() || roleMappers.size() == 1 && roleMappers.keySet().iterator().next().equals(category)) {
            newMap = Collections.singletonMap(category, roleMapper);
        } else {
            newMap = new HashMap<String, RoleMapper>(roleMappers);
            newMap.put(category, roleMapper);
        }
        return new SecurityIdentity(this, newMap);
    }

    public SecurityIdentity createRunAsIdentity(String name) throws SecurityException {
        return this.createRunAsIdentity(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityIdentity createRunAsIdentity(String name, boolean authorize) throws SecurityException {
        SecurityManager sm;
        Assert.checkNotNullParam((String)"name", (Object)name);
        SecurityDomain domain = this.securityDomain;
        name = domain.getPreRealmRewriter().rewriteName(name);
        if (name == null) {
            throw ElytronMessages.log.invalidName();
        }
        String realmName = domain.mapRealmName(name, null, null);
        NamePrincipal principal = new NamePrincipal(name);
        if (this.principal.equals(principal)) {
            return this;
        }
        RealmInfo realmInfo = domain.getRealmInfo(realmName);
        name = domain.getPostRealmRewriter().rewriteName(name);
        if (name == null) {
            throw ElytronMessages.log.invalidName();
        }
        name = realmInfo.getNameRewriter().rewriteName(name);
        if (name == null) {
            throw ElytronMessages.log.invalidName();
        }
        if (authorize) {
            RunAsPrincipalPermission permission = new RunAsPrincipalPermission(name);
            if (!this.getPermissions().implies(permission)) {
                SecurityRealm.safeHandleRealmEvent(realmInfo.getSecurityRealm(), new RealmIdentityFailedAuthorizationEvent(this.authorizationIdentity, this.principal, principal));
                throw ElytronMessages.log.unauthorizedRunAs(this.principal, principal, permission);
            }
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(SET_RUN_AS_PERMISSION);
        }
        SecurityRealm securityRealm = realmInfo.getSecurityRealm();
        RealmIdentity realmIdentity = securityRealm.getRealmIdentity(name, null, null);
        AuthorizationIdentity newAuthorizationIdentity = realmIdentity.getAuthorizationIdentity();
        SecurityRealm.safeHandleRealmEvent(securityRealm, new RealmIdentitySuccessfulAuthorizationEvent(this.authorizationIdentity, this.principal, principal));
        try {
            SecurityIdentity securityIdentity = new SecurityIdentity(domain, principal, realmInfo, newAuthorizationIdentity, this.roleMappers);
            realmIdentity.dispose();
            return securityIdentity;
        }
        catch (Throwable throwable) {
            try {
                realmIdentity.dispose();
                throw throwable;
            }
            catch (RealmUnavailableException ex) {
                throw ElytronMessages.log.runAsAuthorizationFailed(this.principal, principal, ex);
            }
        }
    }

    public SecurityIdentity withPeerIdentity(PeerIdentity peerIdentity) {
        if (peerIdentity == null) {
            return this;
        }
        PeerIdentity[] peerIdentities = this.peerIdentities;
        int length = peerIdentities.length;
        for (int i = 0; i < length; ++i) {
            if (!peerIdentities[i].isSamePeerIdentityContext(peerIdentity)) continue;
            PeerIdentity[] newPeerIdentities = (PeerIdentity[])peerIdentities.clone();
            newPeerIdentities[i] = peerIdentity;
            return new SecurityIdentity(this, newPeerIdentities);
        }
        PeerIdentity[] newPeerIdentities = Arrays.copyOf(peerIdentities, length + 1);
        newPeerIdentities[length] = peerIdentity;
        return new SecurityIdentity(this, newPeerIdentities);
    }

    public PermissionCollection getPermissions() {
        return this.securityDomain.mapPermissions(this);
    }

    public Attributes getAttributes() {
        return this.authorizationIdentity.getAttributes().asReadOnly();
    }

    public Principal getPrincipal() {
        return this.principal;
    }
}

