/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.wildfly.security.ssl.AbstractDelegatingSSLServerSocketFactory;
import org.wildfly.security.ssl.ConfiguredSSLServerSocket;
import org.wildfly.security.ssl.SSLConfigurator;

final class ConfiguredSSLServerSocketFactory
extends AbstractDelegatingSSLServerSocketFactory {
    private final SSLContext sslContext;
    private final SSLConfigurator sslConfigurator;

    ConfiguredSSLServerSocketFactory(SSLServerSocketFactory delegate, SSLContext sslContext, SSLConfigurator sslConfigurator) {
        super(delegate);
        this.sslContext = sslContext;
        this.sslConfigurator = sslConfigurator;
    }

    @Override
    public ServerSocket createServerSocket() throws IOException {
        return this.wrap(super.createServerSocket());
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        return this.wrap(super.createServerSocket(port));
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        return this.wrap(super.createServerSocket(port, backlog));
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        return this.wrap(super.createServerSocket(port, backlog, ifAddress));
    }

    private ServerSocket wrap(ServerSocket original) throws IOException {
        if (original instanceof SSLServerSocket) {
            SSLServerSocket sslServerSocket = (SSLServerSocket)original;
            SSLContext sslContext = this.sslContext;
            SSLConfigurator sslConfigurator = this.sslConfigurator;
            sslConfigurator.configure(sslContext, sslServerSocket);
            return new ConfiguredSSLServerSocket(sslServerSocket, sslContext, sslConfigurator);
        }
        return original;
    }
}

