/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500;

import java.security.cert.X509Certificate;
import java.util.Arrays;

public final class X500 {
    public static final X509Certificate[] NO_CERTIFICATES = new X509Certificate[0];
    public static final String OID_CN = "2.5.4.3";
    public static final String OID_C = "2.5.4.6";
    public static final String OID_L = "2.5.4.7";
    public static final String OID_ST = "2.5.4.8";
    public static final String OID_STREET = "2.5.4.9";
    public static final String OID_O = "2.5.4.10";
    public static final String OID_OU = "2.5.4.11";
    public static final String OID_UID = "0.9.2342.19200300.100.1.1";
    public static final String OID_DC = "0.9.2342.19200300.100.1.25";

    private X500() {
    }

    public static X509Certificate[] asX509CertificateArray(Object ... certificates) throws ArrayStoreException {
        if (certificates.length == 0) {
            return NO_CERTIFICATES;
        }
        if (certificates instanceof X509Certificate[]) {
            return (X509Certificate[])certificates;
        }
        return (X509Certificate[])Arrays.copyOf(certificates, certificates.length, X509Certificate[].class);
    }
}

