/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server.event;

import java.time.Instant;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.event.SecurityEventVisitor;

public abstract class SecurityEvent {
    private final Instant instant = Instant.now();
    private final SecurityIdentity securityIdentity;

    SecurityEvent(SecurityIdentity securityIdentity) {
        this.securityIdentity = (SecurityIdentity)Assert.checkNotNullParam((String)"securityIdentity", (Object)securityIdentity);
    }

    public SecurityIdentity getSecurityIdentity() {
        return this.securityIdentity;
    }

    public Instant getInstant() {
        return this.instant;
    }

    public <P, R> R accept(SecurityEventVisitor<P, R> visitor, P param) {
        return visitor.handleUnknownEvent(this, param);
    }
}

