/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2015 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wildfly.security.auth.callback;

import static org.wildfly.common.Assert.checkNotNullParam;

import java.io.Serializable;

import javax.net.ssl.SSLSession;

/**
 * A callback which provides information to the callback handler about the established SSLSession.
 *
 * @author <a href="mailto:david.lloyd@redhat.com">David M. Lloyd</a>
 */
public final class SSLCallback implements ExtendedCallback, Serializable {

    private static final long serialVersionUID = 7854221380587494535L;

    /**
     * @serial The SSL session.
     */
    private final SSLSession sslSession;

    /**
     * Construct a new instance.
     *
     * @param sslSession the {@link SSLSession}
     */
    public SSLCallback(final SSLSession sslSession) {
        this.sslSession = checkNotNullParam("sslSession", sslSession);
    }

    /**
     * Get the SSL session in force.
     *
     * @return the SSL session in force
     */
    public SSLSession getSslSession() {
        return sslSession;
    }

}
