package org.wildfly.security._private;

import java.security.ProtectionDomain;
import java.io.InterruptedIOException;
import java.io.Serializable;
import javax.xml.stream.XMLStreamReader;
import org.wildfly.security.http.HttpAuthenticationException;
import java.security.cert.CertificateException;
import java.lang.String;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLProtocolException;
import org.wildfly.security.permission.InvalidPermissionClassException;
import java.time.ZonedDateTime;
import org.wildfly.security.authz.AuthorizationCheckException;
import java.io.EOFException;
import java.security.Permission;
import javax.naming.NamingException;
import javax.security.jacc.PolicyContextException;
import java.util.List;
import java.security.spec.InvalidKeySpecException;
import org.wildfly.client.config.ConfigurationXMLStreamReader;
import java.lang.ClassNotFoundException;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;
import org.wildfly.security.credential.store.CredentialStore.ProtectionParameter;
import org.wildfly.security.authz.AuthorizationFailureException;
import java.lang.IndexOutOfBoundsException;
import org.wildfly.security.asn1.ASN1Exception;
import java.security.GeneralSecurityException;
import org.wildfly.security.credential.store.UnsupportedCredentialTypeException;
import org.wildfly.security.auth.callback.FastUnsupportedCallbackException;
import java.lang.NumberFormatException;
import org.wildfly.security.mechanism.scram.ScramServerErrorCode;
import java.util.concurrent.atomic.AtomicBoolean;
import java.lang.Throwable;
import javax.security.auth.login.LoginException;
import java.lang.Class;
import java.util.Arrays;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.security.auth.permission.RunAsPrincipalPermission;
import java.lang.IllegalStateException;
import org.wildfly.security.permission.PermissionVerifier;
import org.jboss.logging.DelegatingBasicLogger;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.jboss.logging.Logger;
import javax.net.ssl.SSLHandshakeException;
import java.lang.RuntimeException;
import java.security.UnrecoverableKeyException;
import org.jboss.logging.BasicLogger;
import java.io.InvalidObjectException;
import java.security.spec.InvalidParameterSpecException;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.audit.EventPriority;
import java.nio.file.Path;
import javax.annotation.Generated;
import org.wildfly.security.mechanism.scram.ScramServerException;
import javax.xml.namespace.QName;
import org.wildfly.security.auth.server.SecurityRealm;
import java.lang.SecurityException;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.InvalidKeyException;
import org.wildfly.security.util.DecodeException;
import java.lang.Exception;
import javax.security.auth.callback.Callback;
import java.security.Principal;
import java.util.NoSuchElementException;
import javax.xml.stream.Location;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-06-02T17:47:46+0100")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    @Override
    public final void logVersion(final String versionString) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, logVersion$str(), versionString);
    }
    private static final String logVersion = "ELY00001: WildFly Elytron version %s";
    protected String logVersion$str() {
        return logVersion;
    }
    private static final String emptyParameter = "ELY00002: Parameter %s is empty";
    protected String emptyParameter$str() {
        return emptyParameter;
    }
    @Override
    public final IllegalArgumentException emptyParameter(final String parameter) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(emptyParameter$str(), parameter));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String builderAlreadyBuilt = "ELY00003: This builder has already been built";
    protected String builderAlreadyBuilt$str() {
        return builderAlreadyBuilt;
    }
    @Override
    public final IllegalStateException builderAlreadyBuilt() {
        final IllegalStateException result = new IllegalStateException(String.format(builderAlreadyBuilt$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unrecognizedAlgorithm = "ELY00004: Unrecognized algorithm \"%s\"";
    protected String unrecognizedAlgorithm$str() {
        return unrecognizedAlgorithm;
    }
    @Override
    public final IllegalArgumentException unrecognizedAlgorithm(final String algorithm) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(unrecognizedAlgorithm$str(), algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotInstantiateSelfReferentialFactory = "ELY00005: Cannot instantiate self-referential factory";
    protected String cannotInstantiateSelfReferentialFactory$str() {
        return cannotInstantiateSelfReferentialFactory;
    }
    @Override
    public final IllegalStateException cannotInstantiateSelfReferentialFactory() {
        final IllegalStateException result = new IllegalStateException(String.format(cannotInstantiateSelfReferentialFactory$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedTrailingGarbageInX500principal = "ELY00006: Unexpected trailing garbage in X.500 principal";
    protected String unexpectedTrailingGarbageInX500principal$str() {
        return unexpectedTrailingGarbageInX500principal;
    }
    @Override
    public final IllegalArgumentException unexpectedTrailingGarbageInX500principal() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(unexpectedTrailingGarbageInX500principal$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void credentialDestroyingFailed(final Throwable cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, cause, credentialDestroyingFailed$str());
    }
    private static final String credentialDestroyingFailed = "ELY00007: Credential destroying failed";
    protected String credentialDestroyingFailed$str() {
        return credentialDestroyingFailed;
    }
    private static final String credentialNotSupported = "ELY00008: The given credential is not supported here";
    protected String credentialNotSupported$str() {
        return credentialNotSupported;
    }
    @Override
    public final IllegalArgumentException credentialNotSupported() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(credentialNotSupported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String generalInvalidName = "ELY00009: Invalid name \"%s\"";
    protected String generalInvalidName$str() {
        return generalInvalidName;
    }
    @Override
    public final IllegalArgumentException generalInvalidName(final String str) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(generalInvalidName$str(), str));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String locatorFieldNotSet = "ELY00010: Identity locator field \"%s\" is not set";
    protected String locatorFieldNotSet$str() {
        return locatorFieldNotSet;
    }
    @Override
    public final IllegalStateException locatorFieldNotSet(final String fieldName) {
        final IllegalStateException result = new IllegalStateException(String.format(locatorFieldNotSet$str(), fieldName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSuchAlgorithmCreateService = "ELY00011: Unable to create service for '%s.%s' ";
    protected String noSuchAlgorithmCreateService$str() {
        return noSuchAlgorithmCreateService;
    }
    @Override
    public final NoSuchAlgorithmException noSuchAlgorithmCreateService(final String serviceType, final String algorithm, final Throwable cause) {
        final NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(noSuchAlgorithmCreateService$str(), serviceType, algorithm), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToLoadOidsFromPropertiesFile = "ELY00012: Unable to load OIDs database from properties file";
    protected String unableToLoadOidsFromPropertiesFile$str() {
        return unableToLoadOidsFromPropertiesFile;
    }
    @Override
    public final IllegalStateException unableToLoadOidsFromPropertiesFile(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(unableToLoadOidsFromPropertiesFile$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nameAlreadySet = "ELY01000: Authentication name was already set on this context";
    protected String nameAlreadySet$str() {
        return nameAlreadySet;
    }
    @Override
    public final IllegalStateException nameAlreadySet() {
        final IllegalStateException result = new IllegalStateException(String.format(nameAlreadySet$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlNoModuleFound = "ELY01001: No module found for identifier \"%s\"";
    protected String xmlNoModuleFound$str() {
        return xmlNoModuleFound;
    }
    @Override
    public final ConfigXMLParseException xmlNoModuleFound(final XMLStreamReader reader, final Exception e, final String moduleIdentifier) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(xmlNoModuleFound$str(), moduleIdentifier), reader, e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlInvalidPortNumber = "ELY01002: Invalid port number \"%s\" specified for attribute \"%s\" of element \"%s\"; expected a numerical value between 1 and 65535 (inclusive)";
    protected String xmlInvalidPortNumber$str() {
        return xmlInvalidPortNumber;
    }
    @Override
    public final ConfigXMLParseException xmlInvalidPortNumber(final XMLStreamReader reader, final String attributeValue, final String attributeName, final QName elementName) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(xmlInvalidPortNumber$str(), attributeValue, attributeName, elementName), reader);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noAuthenticationInProgress = "ELY01003: No authentication is in progress";
    protected String noAuthenticationInProgress$str() {
        return noAuthenticationInProgress;
    }
    @Override
    public final IllegalStateException noAuthenticationInProgress() {
        final IllegalStateException result = new IllegalStateException(String.format(noAuthenticationInProgress$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String authenticationAlreadyComplete = "ELY01004: Authentication already complete on this context";
    protected String authenticationAlreadyComplete$str() {
        return authenticationAlreadyComplete;
    }
    @Override
    public final IllegalStateException authenticationAlreadyComplete() {
        final IllegalStateException result = new IllegalStateException(String.format(authenticationAlreadyComplete$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String realmMapDoesNotContainDefault = "ELY01005: Realm map does not contain mapping for default realm '%s'";
    protected String realmMapDoesNotContainDefault$str() {
        return realmMapDoesNotContainDefault;
    }
    @Override
    public final IllegalArgumentException realmMapDoesNotContainDefault(final String defaultRealm) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(realmMapDoesNotContainDefault$str(), defaultRealm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noRealmFoundInProperties = "ELY01006: No realm name found in users property file - file must contain \"#$REALM_NAME=RealmName$\" line";
    protected String noRealmFoundInProperties$str() {
        return noRealmFoundInProperties;
    }
    @Override
    public final RealmUnavailableException noRealmFoundInProperties() {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(noRealmFoundInProperties$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void debugJAASAuthenticationFailure(final Principal principal, final Throwable cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.DEBUG, cause, debugJAASAuthenticationFailure$str(), principal);
    }
    private static final String debugJAASAuthenticationFailure = "ELY01007: JAAS authentication failed for principal %s";
    protected String debugJAASAuthenticationFailure$str() {
        return debugJAASAuthenticationFailure;
    }
    private static final String failedToCreateLoginContext = "ELY01008: Failed to create login context";
    protected String failedToCreateLoginContext$str() {
        return failedToCreateLoginContext;
    }
    @Override
    public final RealmUnavailableException failedToCreateLoginContext(final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(failedToCreateLoginContext$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToInstantiateCustomHandler = "ELY01009: Failed to instantiate custom CallbackHandler";
    protected String failedToInstantiateCustomHandler$str() {
        return failedToInstantiateCustomHandler;
    }
    @Override
    public final RealmUnavailableException failedToInstantiateCustomHandler(final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(failedToInstantiateCustomHandler$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToConvertCredentialToPassword = "ELY01010: Credential cannot be converted to a password";
    protected String failedToConvertCredentialToPassword$str() {
        return failedToConvertCredentialToPassword;
    }
    @Override
    public final FastUnsupportedCallbackException failedToConvertCredentialToPassword(final Callback callback) {
        final FastUnsupportedCallbackException result = new FastUnsupportedCallbackException(callback, String.format(failedToConvertCredentialToPassword$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unrecognizedPrincipalType = "ELY01011: Unrecognized principal type for %s";
    protected String unrecognizedPrincipalType$str() {
        return unrecognizedPrincipalType;
    }
    @Override
    public final IllegalArgumentException unrecognizedPrincipalType(final Principal principal) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(unrecognizedPrincipalType$str(), principal));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemRealmFailedToOpen = "ELY01012: Filesystem-backed realm unexpectedly failed to open path \"%s\" for identity name \"%s\"";
    protected String fileSystemRealmFailedToOpen$str() {
        return fileSystemRealmFailedToOpen;
    }
    @Override
    public final RealmUnavailableException fileSystemRealmFailedToOpen(final Path path, final String finalName, final IOException cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(fileSystemRealmFailedToOpen$str(), path, finalName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemRealmFailedToRead = "ELY01013: Filesystem-backed realm unexpectedly failed to read path \"%s\" for identity name \"%s\"";
    protected String fileSystemRealmFailedToRead$str() {
        return fileSystemRealmFailedToRead;
    }
    @Override
    public final RealmUnavailableException fileSystemRealmFailedToRead(final Path path, final String finalName, final Exception cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(fileSystemRealmFailedToRead$str(), path, finalName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidEmptyName = "ELY01014: Invalid empty name given";
    protected String invalidEmptyName$str() {
        return invalidEmptyName;
    }
    @Override
    public final IllegalArgumentException invalidEmptyName() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidEmptyName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemRealmInvalidContent = "ELY01015: Filesystem-backed realm encountered invalid file content in path \"%s\" line %d for identity name \"%s\"";
    protected String fileSystemRealmInvalidContent$str() {
        return fileSystemRealmInvalidContent;
    }
    @Override
    public final RealmUnavailableException fileSystemRealmInvalidContent(final Path path, final int lineNumber, final String name) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(fileSystemRealmInvalidContent$str(), path, lineNumber, name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemRealmMissingAttribute = "ELY01016: Filesystem-backed realm encountered missing required attribute \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    protected String fileSystemRealmMissingAttribute$str() {
        return fileSystemRealmMissingAttribute;
    }
    @Override
    public final RealmUnavailableException fileSystemRealmMissingAttribute(final String attribute, final Path path, final int lineNumber, final String name) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(fileSystemRealmMissingAttribute$str(), attribute, path, lineNumber, name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemRealmInvalidPasswordFormat = "ELY01017: Filesystem-backed realm encountered invalid password format \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    protected String fileSystemRealmInvalidPasswordFormat$str() {
        return fileSystemRealmInvalidPasswordFormat;
    }
    @Override
    public final RealmUnavailableException fileSystemRealmInvalidPasswordFormat(final String format, final Path path, final int lineNumber, final String name) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(fileSystemRealmInvalidPasswordFormat$str(), format, path, lineNumber, name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemRealmInvalidPasswordAlgorithm = "ELY01018: Filesystem-backed realm encountered invalid password algorithm \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    protected String fileSystemRealmInvalidPasswordAlgorithm$str() {
        return fileSystemRealmInvalidPasswordAlgorithm;
    }
    @Override
    public final RealmUnavailableException fileSystemRealmInvalidPasswordAlgorithm(final String algorithm, final Path path, final int lineNumber, final String name) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(fileSystemRealmInvalidPasswordAlgorithm$str(), algorithm, path, lineNumber, name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToObtainExclusiveAccess = "ELY01019: Unable to obtain exclusive access to backing identity";
    protected String unableToObtainExclusiveAccess$str() {
        return unableToObtainExclusiveAccess;
    }
    @Override
    public final RealmUnavailableException unableToObtainExclusiveAccess() {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(unableToObtainExclusiveAccess$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemUpdatedFailed = "ELY01020: Filesystem-backed realm failed to update identity \"%s\"";
    protected String fileSystemUpdatedFailed$str() {
        return fileSystemUpdatedFailed;
    }
    @Override
    public final RealmUnavailableException fileSystemUpdatedFailed(final String name, final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(fileSystemUpdatedFailed$str(), name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemRealmDeleteFailed = "ELY01021: Filesystem-backed realm failed to delete identity \"%s\"";
    protected String fileSystemRealmDeleteFailed$str() {
        return fileSystemRealmDeleteFailed;
    }
    @Override
    public final RealmUnavailableException fileSystemRealmDeleteFailed(final String name, final IOException e) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(fileSystemRealmDeleteFailed$str(), name), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemRealmNotFound = "ELY01022: Filesystem-backed realm failed to find identity \"%s\"";
    protected String fileSystemRealmNotFound$str() {
        return fileSystemRealmNotFound;
    }
    @Override
    public final RealmUnavailableException fileSystemRealmNotFound(final String name) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(fileSystemRealmNotFound$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemRealmFailedToWrite = "ELY01023: Filesystem-backed realm failed to write to file \"%s\" for identity \"%s\"";
    protected String fileSystemRealmFailedToWrite$str() {
        return fileSystemRealmFailedToWrite;
    }
    @Override
    public final RealmUnavailableException fileSystemRealmFailedToWrite(final Path tempPath, final String name, final Exception e) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(fileSystemRealmFailedToWrite$str(), tempPath, name), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemRealmAlreadyExists = "ELY01024: Filesystem-backed realm cannot create duplicate identity for identity \"%s\"";
    protected String fileSystemRealmAlreadyExists$str() {
        return fileSystemRealmAlreadyExists;
    }
    @Override
    public final RealmUnavailableException fileSystemRealmAlreadyExists(final String name, final Throwable e) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(fileSystemRealmAlreadyExists$str(), name), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemRealmCertificateReadError = "ELY01025: Filesystem-backed realm encountered invalid certificate format \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    protected String fileSystemRealmCertificateReadError$str() {
        return fileSystemRealmCertificateReadError;
    }
    @Override
    public final RealmUnavailableException fileSystemRealmCertificateReadError(final String format, final Path path, final int lineNumber, final String name) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(fileSystemRealmCertificateReadError$str(), format, path, lineNumber, name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemRealmUnsupportedKeyFormat = "ELY01026: Filesystem-backed realm encountered invalid key format \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    protected String fileSystemRealmUnsupportedKeyFormat$str() {
        return fileSystemRealmUnsupportedKeyFormat;
    }
    @Override
    public final RealmUnavailableException fileSystemRealmUnsupportedKeyFormat(final String format, final Path path, final int lineNumber, final String name) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(fileSystemRealmUnsupportedKeyFormat$str(), format, path, lineNumber, name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemRealmUnsupportedKeyAlgorithm = "ELY01027: Filesystem-backed realm encountered invalid key algorithm for format \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    protected String fileSystemRealmUnsupportedKeyAlgorithm$str() {
        return fileSystemRealmUnsupportedKeyAlgorithm;
    }
    @Override
    public final RealmUnavailableException fileSystemRealmUnsupportedKeyAlgorithm(final String format, final Path path, final int lineNumber, final String name, final Exception e) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(fileSystemRealmUnsupportedKeyAlgorithm$str(), format, path, lineNumber, name), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPortNumber = "ELY01028: Invalid port number \"%d\"";
    protected String invalidPortNumber$str() {
        return invalidPortNumber;
    }
    @Override
    public final IllegalArgumentException invalidPortNumber(final int port) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidPortNumber$str(), port));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidHostSpec = "ELY01029: Invalid host specification \"%s\"";
    protected String invalidHostSpec$str() {
        return invalidHostSpec;
    }
    @Override
    public final IllegalArgumentException invalidHostSpec(final String hostSpec) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidHostSpec$str(), hostSpec));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToReadCredential = "ELY01030: Unable to read credential";
    protected String unableToReadCredential$str() {
        return unableToReadCredential;
    }
    @Override
    public final IOException unableToReadCredential(final Exception e) {
        final IOException result = new IOException(String.format(unableToReadCredential$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingReferenceInExtends = "ELY01031: Missing reference in extends";
    protected String missingReferenceInExtends$str() {
        return missingReferenceInExtends;
    }
    @Override
    public final IllegalArgumentException missingReferenceInExtends() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(missingReferenceInExtends$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidCombinationOfObtainableAndVerifiable = "ELY01032: Invalid combination of obtainable and verifiable";
    protected String invalidCombinationOfObtainableAndVerifiable$str() {
        return invalidCombinationOfObtainableAndVerifiable;
    }
    @Override
    public final IllegalArgumentException invalidCombinationOfObtainableAndVerifiable() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidCombinationOfObtainableAndVerifiable$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String userDoesNotExist = "ELY01033: User does not exist";
    protected String userDoesNotExist$str() {
        return userDoesNotExist;
    }
    @Override
    public final IllegalStateException userDoesNotExist() {
        final IllegalStateException result = new IllegalStateException(String.format(userDoesNotExist$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidCredentialTypeSpecified = "ELY01034: Invalid credential type specified";
    protected String invalidCredentialTypeSpecified$str() {
        return invalidCredentialTypeSpecified;
    }
    @Override
    public final IllegalStateException invalidCredentialTypeSpecified() {
        final IllegalStateException result = new IllegalStateException(String.format(invalidCredentialTypeSpecified$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToCreateKeyManager = "ELY01035: Unable to create key manager";
    protected String unableToCreateKeyManager$str() {
        return unableToCreateKeyManager;
    }
    @Override
    public final IOException unableToCreateKeyManager(final Exception e) {
        final IOException result = new IOException(String.format(unableToCreateKeyManager$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToCreateTrustManager = "ELY01036: Unable to create trust manager";
    protected String unableToCreateTrustManager$str() {
        return unableToCreateTrustManager;
    }
    @Override
    public final IOException unableToCreateTrustManager(final Exception e) {
        final IOException result = new IOException(String.format(unableToCreateTrustManager$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String certificateChainIsEmpty = "ELY01037: Certificate chain is empty";
    protected String certificateChainIsEmpty$str() {
        return certificateChainIsEmpty;
    }
    @Override
    public final IllegalArgumentException certificateChainIsEmpty() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(certificateChainIsEmpty$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotGetRsaKeyFromQuery = "ELY01038: Could get not RSA key from query";
    protected String couldNotGetRsaKeyFromQuery$str() {
        return couldNotGetRsaKeyFromQuery;
    }
    @Override
    public final RuntimeException couldNotGetRsaKeyFromQuery(final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(couldNotGetRsaKeyFromQuery$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidAlgorithm = "ELY01039: Invalid algorithm \"%s\"";
    protected String invalidAlgorithm$str() {
        return invalidAlgorithm;
    }
    @Override
    public final RuntimeException invalidAlgorithm(final String algorithm, final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(invalidAlgorithm$str(), algorithm), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotParsePrivateKey = "ELY01040: Could not parse private key";
    protected String couldNotParsePrivateKey$str() {
        return couldNotParsePrivateKey;
    }
    @Override
    public final RuntimeException couldNotParsePrivateKey(final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(couldNotParsePrivateKey$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotObtainCredential = "ELY01041: Could not obtain credential";
    protected String couldNotObtainCredential$str() {
        return couldNotObtainCredential;
    }
    @Override
    public final RuntimeException couldNotObtainCredential() {
        final RuntimeException result = new RuntimeException(String.format(couldNotObtainCredential$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotObtainCredentialWithCause = "ELY01042: Could not obtain credential";
    protected String couldNotObtainCredentialWithCause$str() {
        return couldNotObtainCredentialWithCause;
    }
    @Override
    public final RuntimeException couldNotObtainCredentialWithCause(final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(couldNotObtainCredentialWithCause$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPasswordKeySpecificationForAlgorithm = "ELY01043: Invalid password key specification for algorithm \"%s\"";
    protected String invalidPasswordKeySpecificationForAlgorithm$str() {
        return invalidPasswordKeySpecificationForAlgorithm;
    }
    @Override
    public final RuntimeException invalidPasswordKeySpecificationForAlgorithm(final String algorithm, final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(invalidPasswordKeySpecificationForAlgorithm$str(), algorithm), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String saltIsExpectedWhenCreatingPasswords = "ELY01044: Salt is expected when creating \"%s\" passwords";
    protected String saltIsExpectedWhenCreatingPasswords$str() {
        return saltIsExpectedWhenCreatingPasswords;
    }
    @Override
    public final RuntimeException saltIsExpectedWhenCreatingPasswords(final String type) {
        final RuntimeException result = new RuntimeException(String.format(saltIsExpectedWhenCreatingPasswords$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotObtainPasswordFactoryForAlgorithm = "ELY01045: Could not obtain PasswordFactory for algorithm \"%s\"";
    protected String couldNotObtainPasswordFactoryForAlgorithm$str() {
        return couldNotObtainPasswordFactoryForAlgorithm;
    }
    @Override
    public final RuntimeException couldNotObtainPasswordFactoryForAlgorithm(final String algorithm, final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(couldNotObtainPasswordFactoryForAlgorithm$str(), algorithm), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownPasswordTypeOrAlgorithm = "ELY01046: Unknown password type or algorithm \"%s\"";
    protected String unknownPasswordTypeOrAlgorithm$str() {
        return unknownPasswordTypeOrAlgorithm;
    }
    @Override
    public final InvalidKeyException unknownPasswordTypeOrAlgorithm(final String algorithm) {
        final InvalidKeyException result = new InvalidKeyException(String.format(unknownPasswordTypeOrAlgorithm$str(), algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String passwordBasedCredentialsMustBeCharsOrClearPassword = "ELY01047: Password-based credentials must be either a char[] or ClearPassword";
    protected String passwordBasedCredentialsMustBeCharsOrClearPassword$str() {
        return passwordBasedCredentialsMustBeCharsOrClearPassword;
    }
    @Override
    public final RuntimeException passwordBasedCredentialsMustBeCharsOrClearPassword() {
        final RuntimeException result = new RuntimeException(String.format(passwordBasedCredentialsMustBeCharsOrClearPassword$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPasswordKeyForAlgorithm = "ELY01048: Invalid password key for algorithm \"%s\"";
    protected String invalidPasswordKeyForAlgorithm$str() {
        return invalidPasswordKeyForAlgorithm;
    }
    @Override
    public final RuntimeException invalidPasswordKeyForAlgorithm(final String algorithm, final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(invalidPasswordKeyForAlgorithm$str(), algorithm), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotOpenConnection = "ELY01049: Could not open connection";
    protected String couldNotOpenConnection$str() {
        return couldNotOpenConnection;
    }
    @Override
    public final RuntimeException couldNotOpenConnection(final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(couldNotOpenConnection$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotExecuteQuery = "ELY01050: Could not execute query \"%s\"";
    protected String couldNotExecuteQuery$str() {
        return couldNotExecuteQuery;
    }
    @Override
    public final RuntimeException couldNotExecuteQuery(final String sql, final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(couldNotExecuteQuery$str(), sql), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotResolveAlgorithmByCredentialName = "ELY01051: Could not resolve password algorithm for credential name \"%s\"";
    protected String couldNotResolveAlgorithmByCredentialName$str() {
        return couldNotResolveAlgorithmByCredentialName;
    }
    @Override
    public final InvalidKeyException couldNotResolveAlgorithmByCredentialName(final String credentialName) {
        final InvalidKeyException result = new InvalidKeyException(String.format(couldNotResolveAlgorithmByCredentialName$str(), credentialName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedErrorWhenProcessingAuthenticationQuery = "ELY01052: Unexpected error when processing authentication query \"%s\"";
    protected String unexpectedErrorWhenProcessingAuthenticationQuery$str() {
        return unexpectedErrorWhenProcessingAuthenticationQuery;
    }
    @Override
    public final RuntimeException unexpectedErrorWhenProcessingAuthenticationQuery(final String sql, final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(unexpectedErrorWhenProcessingAuthenticationQuery$str(), sql), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String insufficientDataToFormDigestAndSalt = "ELY01053: Insufficient data to form a digest and a salt";
    protected String insufficientDataToFormDigestAndSalt$str() {
        return insufficientDataToFormDigestAndSalt;
    }
    @Override
    public final InvalidKeySpecException insufficientDataToFormDigestAndSalt() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(insufficientDataToFormDigestAndSalt$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidSalt2 = "ELY01054: Invalid salt \"%s%s\"";
    protected String invalidSalt2$str() {
        return invalidSalt2;
    }
    @Override
    public final IllegalArgumentException invalidSalt(final char lo, final char hi) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidSalt2$str(), lo, hi));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidRounds = "ELY01055: Invalid rounds \"%s%s%s%s\"";
    protected String invalidRounds$str() {
        return invalidRounds;
    }
    @Override
    public final IllegalArgumentException invalidRounds(final char b0, final char b1, final char b2, final char b3) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidRounds$str(), b0, b1, b2, b3));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidSalt4 = "ELY01056: Invalid salt \"%s%s%s%s\"";
    protected String invalidSalt4$str() {
        return invalidSalt4;
    }
    @Override
    public final IllegalArgumentException invalidSalt(final char b0, final char b1, final char b2, final char b3) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidSalt4$str(), b0, b1, b2, b3));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noDirContextSupplierSet = "ELY01057: No DirContext supplier set";
    protected String noDirContextSupplierSet$str() {
        return noDirContextSupplierSet;
    }
    @Override
    public final IllegalStateException noDirContextSupplierSet() {
        final IllegalStateException result = new IllegalStateException(String.format(noDirContextSupplierSet$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noPrincipalMappingDefinition = "ELY01058: No principal mapping definition";
    protected String noPrincipalMappingDefinition$str() {
        return noPrincipalMappingDefinition;
    }
    @Override
    public final IllegalStateException noPrincipalMappingDefinition() {
        final IllegalStateException result = new IllegalStateException(String.format(noPrincipalMappingDefinition$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mismatchedPublicPrivateKeyAlgorithms = "ELY01059: Public and private key algorithm names are mismatched";
    protected String mismatchedPublicPrivateKeyAlgorithms$str() {
        return mismatchedPublicPrivateKeyAlgorithms;
    }
    @Override
    public final IllegalArgumentException mismatchedPublicPrivateKeyAlgorithms() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(mismatchedPublicPrivateKeyAlgorithms$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotObtainPrincipal = "ELY01060: Could not obtain principal";
    protected String couldNotObtainPrincipal$str() {
        return couldNotObtainPrincipal;
    }
    @Override
    public final RuntimeException couldNotObtainPrincipal() {
        final RuntimeException result = new RuntimeException(String.format(couldNotObtainPrincipal$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String publicKeyIsNull = "ELY01061: Public key is null";
    protected String publicKeyIsNull$str() {
        return publicKeyIsNull;
    }
    @Override
    public final IllegalArgumentException publicKeyIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(publicKeyIsNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noProviderUrlSet = "ELY01062: No provider URL has been set";
    protected String noProviderUrlSet$str() {
        return noProviderUrlSet;
    }
    @Override
    public final IllegalStateException noProviderUrlSet() {
        final IllegalStateException result = new IllegalStateException(String.format(noProviderUrlSet$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String privateKeyIsNull = "ELY01063: Private key is null";
    protected String privateKeyIsNull$str() {
        return privateKeyIsNull;
    }
    @Override
    public final IllegalArgumentException privateKeyIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(privateKeyIsNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidName = "ELY01064: Invalid identity name";
    protected String invalidName$str() {
        return invalidName;
    }
    @Override
    public final IllegalArgumentException invalidName() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patternRequiresCaptureGroup = "ELY01065: Pattern requires a capture group";
    protected String patternRequiresCaptureGroup$str() {
        return patternRequiresCaptureGroup;
    }
    @Override
    public final IllegalArgumentException patternRequiresCaptureGroup() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(patternRequiresCaptureGroup$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void warnInvalidStringCountForMechanismDatabaseEntry(final String name) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, warnInvalidStringCountForMechanismDatabaseEntry$str(), name);
    }
    private static final String warnInvalidStringCountForMechanismDatabaseEntry = "ELY01066: Invalid string count for mechanism database entry \"%s\"";
    protected String warnInvalidStringCountForMechanismDatabaseEntry$str() {
        return warnInvalidStringCountForMechanismDatabaseEntry;
    }
    @Override
    public final void warnInvalidKeyExchangeForMechanismDatabaseEntry(final String value, final String name) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, warnInvalidKeyExchangeForMechanismDatabaseEntry$str(), value, name);
    }
    private static final String warnInvalidKeyExchangeForMechanismDatabaseEntry = "ELY01067: Invalid key exchange \"%s\" for mechanism database entry \"%s\"";
    protected String warnInvalidKeyExchangeForMechanismDatabaseEntry$str() {
        return warnInvalidKeyExchangeForMechanismDatabaseEntry;
    }
    @Override
    public final void warnInvalidAuthenticationForMechanismDatabaseEntry(final String value, final String name) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, warnInvalidAuthenticationForMechanismDatabaseEntry$str(), value, name);
    }
    private static final String warnInvalidAuthenticationForMechanismDatabaseEntry = "ELY01068: Invalid authentication \"%s\" for mechanism database entry \"%s\"";
    protected String warnInvalidAuthenticationForMechanismDatabaseEntry$str() {
        return warnInvalidAuthenticationForMechanismDatabaseEntry;
    }
    @Override
    public final void warnInvalidEncryptionForMechanismDatabaseEntry(final String value, final String name) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, warnInvalidEncryptionForMechanismDatabaseEntry$str(), value, name);
    }
    private static final String warnInvalidEncryptionForMechanismDatabaseEntry = "ELY01069: Invalid encryption \"%s\" for mechanism database entry \"%s\"";
    protected String warnInvalidEncryptionForMechanismDatabaseEntry$str() {
        return warnInvalidEncryptionForMechanismDatabaseEntry;
    }
    @Override
    public final void warnInvalidDigestForMechanismDatabaseEntry(final String value, final String name) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, warnInvalidDigestForMechanismDatabaseEntry$str(), value, name);
    }
    private static final String warnInvalidDigestForMechanismDatabaseEntry = "ELY01070: Invalid digest \"%s\" for mechanism database entry \"%s\"";
    protected String warnInvalidDigestForMechanismDatabaseEntry$str() {
        return warnInvalidDigestForMechanismDatabaseEntry;
    }
    @Override
    public final void warnInvalidProtocolForMechanismDatabaseEntry(final String value, final String name) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, warnInvalidProtocolForMechanismDatabaseEntry$str(), value, name);
    }
    private static final String warnInvalidProtocolForMechanismDatabaseEntry = "ELY01071: Invalid protocol \"%s\" for mechanism database entry \"%s\"";
    protected String warnInvalidProtocolForMechanismDatabaseEntry$str() {
        return warnInvalidProtocolForMechanismDatabaseEntry;
    }
    @Override
    public final void warnInvalidLevelForMechanismDatabaseEntry(final String value, final String name) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, warnInvalidLevelForMechanismDatabaseEntry$str(), value, name);
    }
    private static final String warnInvalidLevelForMechanismDatabaseEntry = "ELY01072: Invalid level \"%s\" for mechanism database entry \"%s\"";
    protected String warnInvalidLevelForMechanismDatabaseEntry$str() {
        return warnInvalidLevelForMechanismDatabaseEntry;
    }
    @Override
    public final void warnInvalidStrengthBitsForMechanismDatabaseEntry(final String value, final String name) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, warnInvalidStrengthBitsForMechanismDatabaseEntry$str(), value, name);
    }
    private static final String warnInvalidStrengthBitsForMechanismDatabaseEntry = "ELY01073: Invalid strength bits \"%s\" for mechanism database entry \"%s\"";
    protected String warnInvalidStrengthBitsForMechanismDatabaseEntry$str() {
        return warnInvalidStrengthBitsForMechanismDatabaseEntry;
    }
    @Override
    public final void warnInvalidAlgorithmBitsForMechanismDatabaseEntry(final String value, final String name) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, warnInvalidAlgorithmBitsForMechanismDatabaseEntry$str(), value, name);
    }
    private static final String warnInvalidAlgorithmBitsForMechanismDatabaseEntry = "ELY01074: Invalid algorithm bits \"%s\" for mechanism database entry \"%s\"";
    protected String warnInvalidAlgorithmBitsForMechanismDatabaseEntry$str() {
        return warnInvalidAlgorithmBitsForMechanismDatabaseEntry;
    }
    @Override
    public final void warnInvalidDuplicateMechanismDatabaseEntry(final String name) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, warnInvalidDuplicateMechanismDatabaseEntry$str(), name);
    }
    private static final String warnInvalidDuplicateMechanismDatabaseEntry = "ELY01075: Invalid duplicate mechanism database entry \"%s\"";
    protected String warnInvalidDuplicateMechanismDatabaseEntry$str() {
        return warnInvalidDuplicateMechanismDatabaseEntry;
    }
    @Override
    public final void warnInvalidDuplicateOpenSslStyleAliasForMechanismDatabaseEntry(final String alias, final String name, final String originalName) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, warnInvalidDuplicateOpenSslStyleAliasForMechanismDatabaseEntry$str(), alias, name, originalName);
    }
    private static final String warnInvalidDuplicateOpenSslStyleAliasForMechanismDatabaseEntry = "ELY01076: Invalid duplicate OpenSSL-style alias \"%s\" for mechanism database entry \"%s\" (original is \"%s\")";
    protected String warnInvalidDuplicateOpenSslStyleAliasForMechanismDatabaseEntry$str() {
        return warnInvalidDuplicateOpenSslStyleAliasForMechanismDatabaseEntry;
    }
    @Override
    public final void warnInvalidAliasForMissingMechanismDatabaseEntry(final String value, final String name) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, warnInvalidAliasForMissingMechanismDatabaseEntry$str(), value, name);
    }
    private static final String warnInvalidAliasForMissingMechanismDatabaseEntry = "ELY01077: Invalid alias \"%s\" for missing mechanism database entry \"%s\"";
    protected String warnInvalidAliasForMissingMechanismDatabaseEntry$str() {
        return warnInvalidAliasForMissingMechanismDatabaseEntry;
    }
    private static final String ldapRealmFailedObtainIdentityFromServer = "ELY01078: Ldap-backed realm failed to obtain identity \"%s\" from server";
    protected String ldapRealmFailedObtainIdentityFromServer$str() {
        return ldapRealmFailedObtainIdentityFromServer;
    }
    @Override
    public final RealmUnavailableException ldapRealmFailedObtainIdentityFromServer(final String identity, final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(ldapRealmFailedObtainIdentityFromServer$str(), identity), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapRealmFailedObtainAttributes = "ELY01079: Ldap-backed realm failed to obtain attributes for entry [%s]";
    protected String ldapRealmFailedObtainAttributes$str() {
        return ldapRealmFailedObtainAttributes;
    }
    @Override
    public final RuntimeException ldapRealmFailedObtainAttributes(final String dn, final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(ldapRealmFailedObtainAttributes$str(), dn), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapRealmInvalidRdnForAttribute = "ELY01080: Attribute [%s] value [%s] must be in X.500 format in order to obtain RDN [%s].";
    protected String ldapRealmInvalidRdnForAttribute$str() {
        return ldapRealmInvalidRdnForAttribute;
    }
    @Override
    public final RuntimeException ldapRealmInvalidRdnForAttribute(final String attributeName, final String value, final String rdn, final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(ldapRealmInvalidRdnForAttribute$str(), attributeName, value, rdn), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemRealmInvalidOtpDefinition = "ELY01081: Filesystem-backed realm encountered invalid OTP definition in path \"%s\" line %d for identity name \"%s\"";
    protected String fileSystemRealmInvalidOtpDefinition$str() {
        return fileSystemRealmInvalidOtpDefinition;
    }
    @Override
    public final RealmUnavailableException fileSystemRealmInvalidOtpDefinition(final Path path, final int lineNumber, final String name, final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(fileSystemRealmInvalidOtpDefinition$str(), path, lineNumber, name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemRealmInvalidOtpAlgorithm = "ELY01082: Filesystem-backed realm encountered invalid OTP algorithm \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    protected String fileSystemRealmInvalidOtpAlgorithm$str() {
        return fileSystemRealmInvalidOtpAlgorithm;
    }
    @Override
    public final RealmUnavailableException fileSystemRealmInvalidOtpAlgorithm(final String algorithm, final Path path, final int lineNumber, final String name, final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(fileSystemRealmInvalidOtpAlgorithm$str(), algorithm, path, lineNumber, name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapRealmIdentityNotExists = "ELY01083: Ldap-backed realm cannot to obtain not existing identity \"%s\"";
    protected String ldapRealmIdentityNotExists$str() {
        return ldapRealmIdentityNotExists;
    }
    @Override
    public final RealmUnavailableException ldapRealmIdentityNotExists(final String identity) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(ldapRealmIdentityNotExists$str(), identity));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapRealmErrorWhileConsumingResultsFromSearch = "ELY01084: Error while consuming results from search. SearchDn [%s], Filter [%s], Filter Args [%s].";
    protected String ldapRealmErrorWhileConsumingResultsFromSearch$str() {
        return ldapRealmErrorWhileConsumingResultsFromSearch;
    }
    @Override
    public final RuntimeException ldapRealmErrorWhileConsumingResultsFromSearch(final String searchDn, final String filter, final String filterArgs, final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(ldapRealmErrorWhileConsumingResultsFromSearch$str(), searchDn, filter, filterArgs), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapRealmsPersisterNotSupported = "ELY01085: LDAP realm persister does not support given credential type";
    protected String ldapRealmsPersisterNotSupported$str() {
        return ldapRealmsPersisterNotSupported;
    }
    @Override
    public final RealmUnavailableException ldapRealmsPersisterNotSupported() {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(ldapRealmsPersisterNotSupported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapRealmCredentialPersistingFailed = "ELY01086: Persisting credential %s into Ldap-backed realm failed. Identity dn: \"%s\"";
    protected String ldapRealmCredentialPersistingFailed$str() {
        return ldapRealmCredentialPersistingFailed;
    }
    @Override
    public final RealmUnavailableException ldapRealmCredentialPersistingFailed(final String credential, final String dn, final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(ldapRealmCredentialPersistingFailed$str(), credential, dn), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapRealmCredentialClearingFailed = "ELY01087: Clearing credentials from Ldap-backed realm failed. Identity dn: \"%s\"";
    protected String ldapRealmCredentialClearingFailed$str() {
        return ldapRealmCredentialClearingFailed;
    }
    @Override
    public final RealmUnavailableException ldapRealmCredentialClearingFailed(final String dn, final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(ldapRealmCredentialClearingFailed$str(), dn), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String runAsAuthorizationFailed = "ELY01088: Attempting to run as \"%s\" authorization operation failed";
    protected String runAsAuthorizationFailed$str() {
        return runAsAuthorizationFailed;
    }
    @Override
    public final AuthorizationFailureException runAsAuthorizationFailed(final Principal principal, final Principal targetPrincipal, final Throwable cause) {
        final AuthorizationFailureException result = new AuthorizationFailureException(String.format(runAsAuthorizationFailed$str(), targetPrincipal), cause, principal);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unauthorizedRunAs = "ELY01089: Attempting to run as \"%s\" authorization check failed (permission denied)";
    protected String unauthorizedRunAs$str() {
        return unauthorizedRunAs;
    }
    @Override
    public final AuthorizationCheckException unauthorizedRunAs(final Principal principal, final Principal runAsPrincipal, final RunAsPrincipalPermission permission) {
        final AuthorizationCheckException result = new AuthorizationCheckException(String.format(unauthorizedRunAs$str(), runAsPrincipal), principal, permission);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownLdapPasswordScheme = "ELY01090: Unknown LDAP password scheme";
    protected String unknownLdapPasswordScheme$str() {
        return unknownLdapPasswordScheme;
    }
    @Override
    public final InvalidKeySpecException unknownLdapPasswordScheme() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(unknownLdapPasswordScheme$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void postAssociationFailed(final Throwable cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, cause, postAssociationFailed$str());
    }
    private static final String postAssociationFailed = "ELY01091: Post-association peer context action failed";
    protected String postAssociationFailed$str() {
        return postAssociationFailed;
    }
    private static final String invalidMechRealmSelection = "ELY01092: Invalid mechanism realm selection \"%s\"";
    protected String invalidMechRealmSelection$str() {
        return invalidMechRealmSelection;
    }
    @Override
    public final IllegalArgumentException invalidMechRealmSelection(final String realmName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidMechRealmSelection$str(), realmName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechRealmAlreadySelected = "ELY01093: Mechanism realm was already selected";
    protected String mechRealmAlreadySelected$str() {
        return mechRealmAlreadySelected;
    }
    @Override
    public final IllegalStateException mechRealmAlreadySelected() {
        final IllegalStateException result = new IllegalStateException(String.format(mechRealmAlreadySelected$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void eventHandlerFailed(final Throwable cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, cause, eventHandlerFailed$str());
    }
    private static final String eventHandlerFailed = "ELY01094: An event handler threw an exception";
    protected String eventHandlerFailed$str() {
        return eventHandlerFailed;
    }
    private static final String unableToCreateIdentity = "ELY01095: Unable to create identity";
    protected String unableToCreateIdentity$str() {
        return unableToCreateIdentity;
    }
    @Override
    public final RealmUnavailableException unableToCreateIdentity() {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(unableToCreateIdentity$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSuchIdentity = "ELY01096: No such identity";
    protected String noSuchIdentity$str() {
        return noSuchIdentity;
    }
    @Override
    public final RealmUnavailableException noSuchIdentity() {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(noSuchIdentity$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapRealmFailedDeleteIdentityFromServer = "ELY01097: Ldap-backed realm failed to delete identity from server";
    protected String ldapRealmFailedDeleteIdentityFromServer$str() {
        return ldapRealmFailedDeleteIdentityFromServer;
    }
    @Override
    public final RealmUnavailableException ldapRealmFailedDeleteIdentityFromServer(final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(ldapRealmFailedDeleteIdentityFromServer$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapRealmFailedCreateIdentityOnServer = "ELY01098: Ldap-backed realm failed to create identity on server";
    protected String ldapRealmFailedCreateIdentityOnServer$str() {
        return ldapRealmFailedCreateIdentityOnServer;
    }
    @Override
    public final RealmUnavailableException ldapRealmFailedCreateIdentityOnServer(final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(ldapRealmFailedCreateIdentityOnServer$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapRealmNotConfiguredToSupportCreatingIdentities = "ELY01099: Ldap-backed realm is not configured to allow create new identities (new identity parent and attributes has to be set)";
    protected String ldapRealmNotConfiguredToSupportCreatingIdentities$str() {
        return ldapRealmNotConfiguredToSupportCreatingIdentities;
    }
    @Override
    public final RealmUnavailableException ldapRealmNotConfiguredToSupportCreatingIdentities() {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(ldapRealmNotConfiguredToSupportCreatingIdentities$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapRealmCannotSetAttributeWithoutMapping = "ELY01100: Ldap-backed realm does not contain mapping to set Elytron attribute \"%s\" of identity \"%s\"";
    protected String ldapRealmCannotSetAttributeWithoutMapping$str() {
        return ldapRealmCannotSetAttributeWithoutMapping;
    }
    @Override
    public final RealmUnavailableException ldapRealmCannotSetAttributeWithoutMapping(final String attribute, final String identity) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(ldapRealmCannotSetAttributeWithoutMapping$str(), attribute, identity));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void ldapRealmDoesNotSupportSettingFilteredAttribute(final String attribute, final String identity) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, ldapRealmDoesNotSupportSettingFilteredAttribute$str(), attribute, identity);
    }
    private static final String ldapRealmDoesNotSupportSettingFilteredAttribute = "ELY01101: Ldap-backed realm does not support setting of filtered attribute \"%s\" (identity \"%s\")";
    protected String ldapRealmDoesNotSupportSettingFilteredAttribute$str() {
        return ldapRealmDoesNotSupportSettingFilteredAttribute;
    }
    private static final String ldapRealmRequiresExactlyOneRdnAttribute = "ELY01102: Ldap-backed realm requires exactly one value of attribute \"%s\" mapped to RDN (identity \"%s\")";
    protected String ldapRealmRequiresExactlyOneRdnAttribute$str() {
        return ldapRealmRequiresExactlyOneRdnAttribute;
    }
    @Override
    public final RealmUnavailableException ldapRealmRequiresExactlyOneRdnAttribute(final String attribute, final String identity) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(ldapRealmRequiresExactlyOneRdnAttribute$str(), attribute, identity));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapRealmAttributesSettingFailed = "ELY01103: Ldap-backed realm failed to set attributes of identity \"%s\"";
    protected String ldapRealmAttributesSettingFailed$str() {
        return ldapRealmAttributesSettingFailed;
    }
    @Override
    public final RealmUnavailableException ldapRealmAttributesSettingFailed(final String identity, final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(ldapRealmAttributesSettingFailed$str(), identity), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tokenRealmFailedToObtainPrincipal = "ELY01104: OAuth2-based realm failed to obtain principal";
    protected String tokenRealmFailedToObtainPrincipal$str() {
        return tokenRealmFailedToObtainPrincipal;
    }
    @Override
    public final RuntimeException tokenRealmFailedToObtainPrincipal(final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(tokenRealmFailedToObtainPrincipal$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tokenRealmOAuth2TokenIntrospectionFailed = "ELY01105: OAuth2-based realm failed to introspect token";
    protected String tokenRealmOAuth2TokenIntrospectionFailed$str() {
        return tokenRealmOAuth2TokenIntrospectionFailed;
    }
    @Override
    public final RealmUnavailableException tokenRealmOAuth2TokenIntrospectionFailed(final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(tokenRealmOAuth2TokenIntrospectionFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToObtainSSLContext = "ELY01106: Could not obtain SSLContext";
    protected String failedToObtainSSLContext$str() {
        return failedToObtainSSLContext;
    }
    @Override
    public final IllegalStateException failedToObtainSSLContext(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(failedToObtainSSLContext$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapRealmIdentitySearchFailed = "ELY01108: Ldap-backed realm identity search failed";
    protected String ldapRealmIdentitySearchFailed$str() {
        return ldapRealmIdentitySearchFailed;
    }
    @Override
    public final RealmUnavailableException ldapRealmIdentitySearchFailed(final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(ldapRealmIdentitySearchFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapRealmNotConfiguredToSupportIteratingOverIdentities = "ELY01109: Ldap-backed realm is not configured to allow iterate over identities (iterator filter has to be set)";
    protected String ldapRealmNotConfiguredToSupportIteratingOverIdentities$str() {
        return ldapRealmNotConfiguredToSupportIteratingOverIdentities;
    }
    @Override
    public final RealmUnavailableException ldapRealmNotConfiguredToSupportIteratingOverIdentities() {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(ldapRealmNotConfiguredToSupportIteratingOverIdentities$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String peerIdentitiesAlreadySet = "ELY01110: Peer identities were already set on this context";
    protected String peerIdentitiesAlreadySet$str() {
        return peerIdentitiesAlreadySet;
    }
    @Override
    public final IllegalStateException peerIdentitiesAlreadySet() {
        final IllegalStateException result = new IllegalStateException(String.format(peerIdentitiesAlreadySet$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapRealmPagedControlNotProvidedByLdapContext = "ELY01111: Ldap-backed realm paged iteration unsupported: PagedResultsResponseControl not provided by LdapContext in response control";
    protected String ldapRealmPagedControlNotProvidedByLdapContext$str() {
        return ldapRealmPagedControlNotProvidedByLdapContext;
    }
    @Override
    public final NamingException ldapRealmPagedControlNotProvidedByLdapContext() {
        final NamingException result = new NamingException(String.format(ldapRealmPagedControlNotProvidedByLdapContext$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotSucceedNotAuthorized = "ELY01112: Authentication cannot succeed; not authorized";
    protected String cannotSucceedNotAuthorized$str() {
        return cannotSucceedNotAuthorized;
    }
    @Override
    public final IllegalStateException cannotSucceedNotAuthorized() {
        final IllegalStateException result = new IllegalStateException(String.format(cannotSucceedNotAuthorized$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tokenRealmFailedToObtainPrincipalWithClaim = "ELY01113: Token-based realm failed to obtain principal from token using claim [%s]";
    protected String tokenRealmFailedToObtainPrincipalWithClaim$str() {
        return tokenRealmFailedToObtainPrincipalWithClaim;
    }
    @Override
    public final RealmUnavailableException tokenRealmFailedToObtainPrincipalWithClaim(final String claimName) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(tokenRealmFailedToObtainPrincipalWithClaim$str(), claimName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tokenRealmJwtInvalidFormat = "ELY01114: Invalid token format. Tokens must have a signature part accordingly with JWS specification";
    protected String tokenRealmJwtInvalidFormat$str() {
        return tokenRealmJwtInvalidFormat;
    }
    @Override
    public final RealmUnavailableException tokenRealmJwtInvalidFormat() {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(tokenRealmJwtInvalidFormat$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tokenRealmJwtParseFailed = "ELY01115: Failed to parse token";
    protected String tokenRealmJwtParseFailed$str() {
        return tokenRealmJwtParseFailed;
    }
    @Override
    public final RealmUnavailableException tokenRealmJwtParseFailed(final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(tokenRealmJwtParseFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tokenRealmJwtSignatureCheckFailed = "ELY01116: Signature verification failed";
    protected String tokenRealmJwtSignatureCheckFailed$str() {
        return tokenRealmJwtSignatureCheckFailed;
    }
    @Override
    public final RealmUnavailableException tokenRealmJwtSignatureCheckFailed(final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(tokenRealmJwtSignatureCheckFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tokenRealmJwtSignatureInvalidAlgorithm = "ELY01117: Invalid signature algorithm [%s]";
    protected String tokenRealmJwtSignatureInvalidAlgorithm$str() {
        return tokenRealmJwtSignatureInvalidAlgorithm;
    }
    @Override
    public final RealmUnavailableException tokenRealmJwtSignatureInvalidAlgorithm(final String algorithm) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(tokenRealmJwtSignatureInvalidAlgorithm$str(), algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tokenRealmJwtInvalidPublicKeyPem = "ELY01118: Public key could not be obtained. Probably due to an invalid PEM format.";
    protected String tokenRealmJwtInvalidPublicKeyPem$str() {
        return tokenRealmJwtInvalidPublicKeyPem;
    }
    @Override
    public final IllegalArgumentException tokenRealmJwtInvalidPublicKeyPem() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(tokenRealmJwtInvalidPublicKeyPem$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToSelectMechanismConfiguration = "ELY01119: Unable to resolve MechanismConfiguration for mechanismType='%s', mechanismName='%s', hostName='%s', protocol='%s'.";
    protected String unableToSelectMechanismConfiguration$str() {
        return unableToSelectMechanismConfiguration;
    }
    @Override
    public final IllegalStateException unableToSelectMechanismConfiguration(final String mechanismType, final String mechanismName, final String hostName, final String protocol) {
        final IllegalStateException result = new IllegalStateException(String.format(unableToSelectMechanismConfiguration$str(), mechanismType, mechanismName, hostName, protocol));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tooLateToSetMechanismInformation = "ELY01120: Too late to set mechanism information as authentication has already begun.";
    protected String tooLateToSetMechanismInformation$str() {
        return tooLateToSetMechanismInformation;
    }
    @Override
    public final IllegalStateException tooLateToSetMechanismInformation() {
        final IllegalStateException result = new IllegalStateException(String.format(tooLateToSetMechanismInformation$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToPerformInitialLogin = "ELY01121: Unable to perform initial JAAS login.";
    protected String unableToPerformInitialLogin$str() {
        return unableToPerformInitialLogin;
    }
    @Override
    public final GeneralSecurityException unableToPerformInitialLogin(final LoginException cause) {
        final GeneralSecurityException result = new GeneralSecurityException(String.format(unableToPerformInitialLogin$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noKerberosPrincipalsFound = "ELY01122: No Kerberos principals found.";
    protected String noKerberosPrincipalsFound$str() {
        return noKerberosPrincipalsFound;
    }
    @Override
    public final GeneralSecurityException noKerberosPrincipalsFound() {
        final GeneralSecurityException result = new GeneralSecurityException(String.format(noKerberosPrincipalsFound$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tooManyKerberosPrincipalsFound = "ELY01123: Too many Kerberos principals found.";
    protected String tooManyKerberosPrincipalsFound$str() {
        return tooManyKerberosPrincipalsFound;
    }
    @Override
    public final GeneralSecurityException tooManyKerberosPrincipalsFound() {
        final GeneralSecurityException result = new GeneralSecurityException(String.format(tooManyKerberosPrincipalsFound$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String credentialUpdateNotSupportedByRealm = "ELY01124: The security realm does not support updating a credential";
    protected String credentialUpdateNotSupportedByRealm$str() {
        return credentialUpdateNotSupportedByRealm;
    }
    @Override
    public final UnsupportedOperationException credentialUpdateNotSupportedByRealm() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(credentialUpdateNotSupportedByRealm$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapRealmFailedToObtainContext = "ELY01125: Ldap-backed realm failed to obtain context";
    protected String ldapRealmFailedToObtainContext$str() {
        return ldapRealmFailedToObtainContext;
    }
    @Override
    public final RealmUnavailableException ldapRealmFailedToObtainContext(final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(ldapRealmFailedToObtainContext$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void tokenRealmJwtWarnNoIssuerIgnoringIssuerCheck() {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, tokenRealmJwtWarnNoIssuerIgnoringIssuerCheck$str());
    }
    private static final String tokenRealmJwtWarnNoIssuerIgnoringIssuerCheck = "ELY01126: Jwt-based token realm not configured with a list of valid issuers. Ignoring issuer verification.";
    protected String tokenRealmJwtWarnNoIssuerIgnoringIssuerCheck$str() {
        return tokenRealmJwtWarnNoIssuerIgnoringIssuerCheck;
    }
    @Override
    public final void tokenRealmJwtWarnNoAudienceIgnoringAudienceCheck() {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, tokenRealmJwtWarnNoAudienceIgnoringAudienceCheck$str());
    }
    private static final String tokenRealmJwtWarnNoAudienceIgnoringAudienceCheck = "ELY01127: Jwt-based token not configured with a list of valid audiences. Ignoring audience verification.";
    protected String tokenRealmJwtWarnNoAudienceIgnoringAudienceCheck$str() {
        return tokenRealmJwtWarnNoAudienceIgnoringAudienceCheck;
    }
    @Override
    public final void tokenRealmJwtWarnNoPublicKeyIgnoringSignatureCheck() {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, tokenRealmJwtWarnNoPublicKeyIgnoringSignatureCheck$str());
    }
    private static final String tokenRealmJwtWarnNoPublicKeyIgnoringSignatureCheck = "ELY01128: Jwt-based token not configured with a public key. Ignoring signature verification.";
    protected String tokenRealmJwtWarnNoPublicKeyIgnoringSignatureCheck$str() {
        return tokenRealmJwtWarnNoPublicKeyIgnoringSignatureCheck;
    }
    private static final String xmlUnknownSslContextSpecified = "ELY01129: Unknown SSL context \"%s\" specified";
    protected String xmlUnknownSslContextSpecified$str() {
        return xmlUnknownSslContextSpecified;
    }
    @Override
    public final ConfigXMLParseException xmlUnknownSslContextSpecified(final Location location, final String name) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(xmlUnknownSslContextSpecified$str(), name), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlDuplicateSslContextName = "ELY01130: Duplicate SSL context name \"%s\"";
    protected String xmlDuplicateSslContextName$str() {
        return xmlDuplicateSslContextName;
    }
    @Override
    public final ConfigXMLParseException xmlDuplicateSslContextName(final String name, final ConfigurationXMLStreamReader reader) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(xmlDuplicateSslContextName$str(), name), reader);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlUnknownAuthenticationConfigurationSpecified = "ELY01132: Unknown authentication configuration \"%s\" specified";
    protected String xmlUnknownAuthenticationConfigurationSpecified$str() {
        return xmlUnknownAuthenticationConfigurationSpecified;
    }
    @Override
    public final ConfigXMLParseException xmlUnknownAuthenticationConfigurationSpecified(final Location location, final String name) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(xmlUnknownAuthenticationConfigurationSpecified$str(), name), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlFailedToCreateCredential = "ELY01133: Failed to create credential";
    protected String xmlFailedToCreateCredential$str() {
        return xmlFailedToCreateCredential;
    }
    @Override
    public final ConfigXMLParseException xmlFailedToCreateCredential(final Location location, final Throwable cause) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(xmlFailedToCreateCredential$str()), location, cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlDuplicateAuthenticationConfigurationName = "ELY01134: Duplicate authentication configuration name \"%s\"";
    protected String xmlDuplicateAuthenticationConfigurationName$str() {
        return xmlDuplicateAuthenticationConfigurationName;
    }
    @Override
    public final ConfigXMLParseException xmlDuplicateAuthenticationConfigurationName(final String name, final ConfigurationXMLStreamReader reader) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(xmlDuplicateAuthenticationConfigurationName$str(), name), reader);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlFailedToLoadKeyStoreData = "ELY01135: Failed to load keystore data";
    protected String xmlFailedToLoadKeyStoreData$str() {
        return xmlFailedToLoadKeyStoreData;
    }
    @Override
    public final ConfigXMLParseException xmlFailedToLoadKeyStoreData(final Location location, final Throwable cause) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(xmlFailedToLoadKeyStoreData$str()), location, cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlFailedToCreateKeyStore = "ELY01136: Failed to create keystore";
    protected String xmlFailedToCreateKeyStore$str() {
        return xmlFailedToCreateKeyStore;
    }
    @Override
    public final ConfigXMLParseException xmlFailedToCreateKeyStore(final Location location, final Throwable cause) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(xmlFailedToCreateKeyStore$str()), location, cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlInvalidKeyStoreEntryType = "ELY01137: Invalid key store entry type for alias \"%s\" (expected %s, got %s)";
    protected String xmlInvalidKeyStoreEntryType$str() {
        return xmlInvalidKeyStoreEntryType;
    }
    @Override
    public final ConfigXMLParseException xmlInvalidKeyStoreEntryType(final Location location, final String alias, final Class<? extends Object> expectedClass, final Class<? extends Object> actualClass) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(xmlInvalidKeyStoreEntryType$str(), alias, expectedClass, actualClass), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String decodingHashedPasswordFromPropertiesRealmFailed = "ELY01138: Decoding hashed password from users property file failed - should not be set as plain-text property file?";
    protected String decodingHashedPasswordFromPropertiesRealmFailed$str() {
        return decodingHashedPasswordFromPropertiesRealmFailed;
    }
    @Override
    public final RealmUnavailableException decodingHashedPasswordFromPropertiesRealmFailed(final Exception e) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(decodingHashedPasswordFromPropertiesRealmFailed$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlFailedToCreateCredentialStore = "ELY01139: Failed to create credential store";
    protected String xmlFailedToCreateCredentialStore$str() {
        return xmlFailedToCreateCredentialStore;
    }
    @Override
    public final ConfigXMLParseException xmlFailedToCreateCredentialStore(final Location location, final Throwable cause) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(xmlFailedToCreateCredentialStore$str()), location, cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlWrongPemType = "ELY01140: Wrong PEM content type; expected %s, actually was %s";
    protected String xmlWrongPemType$str() {
        return xmlWrongPemType;
    }
    @Override
    public final ConfigXMLParseException xmlWrongPemType(final ConfigurationXMLStreamReader reader, final Class<? extends Object> expected, final Class<? extends Object> actual) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(xmlWrongPemType$str(), expected, actual), reader);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlNoPemContent = "ELY01141: No PEM content found";
    protected String xmlNoPemContent$str() {
        return xmlNoPemContent;
    }
    @Override
    public final ConfigXMLParseException xmlNoPemContent(final ConfigurationXMLStreamReader reader) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(xmlNoPemContent$str()), reader);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlInvalidIterationCount = "ELY01142: Invalid iteration count %d (must be at least 1)";
    protected String xmlInvalidIterationCount$str() {
        return xmlInvalidIterationCount;
    }
    @Override
    public final ConfigXMLParseException xmlInvalidIterationCount(final ConfigurationXMLStreamReader reader, final int wrongCount) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(xmlInvalidIterationCount$str(), wrongCount), reader);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlInvalidUrl = "ELY01143: Invalid URL [%s]";
    protected String xmlInvalidUrl$str() {
        return xmlInvalidUrl;
    }
    @Override
    public final ConfigXMLParseException xmlInvalidUrl(final String url) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(xmlInvalidUrl$str(), url));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String realmCacheFailedObtainIdentityFromCache = "ELY01144: Realm failed to obtain identity from cache";
    protected String realmCacheFailedObtainIdentityFromCache$str() {
        return realmCacheFailedObtainIdentityFromCache;
    }
    @Override
    public final RuntimeException realmCacheFailedObtainIdentityFromCache(final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(realmCacheFailedObtainIdentityFromCache$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String realmCacheUnexpectedType = "ELY01145: Security realm [%s] must implement [%s]";
    protected String realmCacheUnexpectedType$str() {
        return realmCacheUnexpectedType;
    }
    @Override
    public final IllegalArgumentException realmCacheUnexpectedType(final SecurityRealm realm, final Class<? extends org.wildfly.security.auth.realm.CacheableSecurityRealm> expectedType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(realmCacheUnexpectedType$str(), realm, expectedType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void ldapRealmDeferRegistration() {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, ldapRealmDeferRegistration$str());
    }
    private static final String ldapRealmDeferRegistration = "ELY01146: LDAP Realm unable to register listener, defering action.";
    protected String ldapRealmDeferRegistration$str() {
        return ldapRealmDeferRegistration;
    }
    private static final String ldapInvalidLdapName = "ELY01147: Invalid LDAP name [%s]";
    protected String ldapInvalidLdapName$str() {
        return ldapInvalidLdapName;
    }
    @Override
    public final RuntimeException ldapInvalidLdapName(final String name, final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(ldapInvalidLdapName$str(), name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String classLoaderSecurityDomainExists = "ELY01148: A SecurityDomain has already been associated with the specified ClassLoader";
    protected String classLoaderSecurityDomainExists$str() {
        return classLoaderSecurityDomainExists;
    }
    @Override
    public final IllegalStateException classLoaderSecurityDomainExists() {
        final IllegalStateException result = new IllegalStateException(String.format(classLoaderSecurityDomainExists$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cantWithSameSecurityDomainDomain = "ELY01149: Can not use SecurityIdentity with SecurityIdentity from same SecurityDomain";
    protected String cantWithSameSecurityDomainDomain$str() {
        return cantWithSameSecurityDomainDomain;
    }
    @Override
    public final IllegalArgumentException cantWithSameSecurityDomainDomain() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(cantWithSameSecurityDomainDomain$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String obtainingDirContextCredentialFromAuthenticationContextFailed = "ELY01150: Obtaining DirContext credentials from AuthenticationContext failed.";
    protected String obtainingDirContextCredentialFromAuthenticationContextFailed$str() {
        return obtainingDirContextCredentialFromAuthenticationContextFailed;
    }
    @Override
    public final NamingException obtainingDirContextCredentialFromAuthenticationContextFailed(final Throwable cause) {
        final NamingException result = new NamingException(String.format(obtainingDirContextCredentialFromAuthenticationContextFailed$str()));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String authenticationFailedEvidenceVerification = "ELY01151: Evidence Verification Failed.";
    protected String authenticationFailedEvidenceVerification$str() {
        return authenticationFailedEvidenceVerification;
    }
    @Override
    public final SecurityException authenticationFailedEvidenceVerification() {
        final SecurityException result = new SecurityException(String.format(authenticationFailedEvidenceVerification$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String authenticationFailedAuthorization = "ELY01152: Authorization Check Failed.";
    protected String authenticationFailedAuthorization$str() {
        return authenticationFailedAuthorization;
    }
    @Override
    public final SecurityException authenticationFailedAuthorization() {
        final SecurityException result = new SecurityException(String.format(authenticationFailedAuthorization$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String directLdapVerificationFailed = "ELY01153: Direct LDAP verification failed with DN [%s] and absolute DN [%s]";
    protected String directLdapVerificationFailed$str() {
        return directLdapVerificationFailed;
    }
    @Override
    public final RealmUnavailableException directLdapVerificationFailed(final String distinguishedName, final String absoluteName, final Exception e) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(directLdapVerificationFailed$str(), distinguishedName, absoluteName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToReadKeyStore = "ELY01154: Failed to read key store";
    protected String failedToReadKeyStore$str() {
        return failedToReadKeyStore;
    }
    @Override
    public final RealmUnavailableException failedToReadKeyStore(final KeyStoreException e) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(failedToReadKeyStore$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String securityDomainMismatch = "ELY01155: Security domain mismatch";
    protected String securityDomainMismatch$str() {
        return securityDomainMismatch;
    }
    @Override
    public final IllegalArgumentException securityDomainMismatch() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(securityDomainMismatch$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotObtainCredentialFromFactory = "ELY01156: Cannot obtain a credential from a security factory";
    protected String cannotObtainCredentialFromFactory$str() {
        return cannotObtainCredentialFromFactory;
    }
    @Override
    public final IOException cannotObtainCredentialFromFactory(final GeneralSecurityException e) {
        final IOException result = new IOException(String.format(cannotObtainCredentialFromFactory$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void unableToResolveMechanismConfiguration(final Throwable e) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, e, unableToResolveMechanismConfiguration$str());
    }
    private static final String unableToResolveMechanismConfiguration = "ELY01157: Unable to resolve MechanismConfiguration for MechanismInformation";
    protected String unableToResolveMechanismConfiguration$str() {
        return unableToResolveMechanismConfiguration;
    }
    private static final String unableToCreateKerberosCredential = "ELY01158: Unable to create kerberos GSS credential";
    protected String unableToCreateKerberosCredential$str() {
        return unableToCreateKerberosCredential;
    }
    @Override
    public final SecurityException unableToCreateKerberosCredential(final Exception e) {
        final SecurityException result = new SecurityException(String.format(unableToCreateKerberosCredential$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyStoreEntryMissing = "ELY01159: Key store entry for alias \"%s\" is missing.";
    protected String keyStoreEntryMissing$str() {
        return keyStoreEntryMissing;
    }
    @Override
    public final ConfigXMLParseException keyStoreEntryMissing(final Location location, final String alias) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(keyStoreEntryMissing$str(), alias), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyTabDoesNotExists = "ELY01160: KeyTab [%s] does not exists.";
    protected String keyTabDoesNotExists$str() {
        return keyTabDoesNotExists;
    }
    @Override
    public final IOException keyTabDoesNotExists(final String keyTab) {
        final IOException result = new IOException(String.format(keyTabDoesNotExists$str(), keyTab));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noKeysForPrincipalInKeyTab = "ELY01161: No keys for Kerberos principal [%s] was found in KeyTab [%s].";
    protected String noKeysForPrincipalInKeyTab$str() {
        return noKeysForPrincipalInKeyTab;
    }
    @Override
    public final IOException noKeysForPrincipalInKeyTab(final String principal, final String keyTab) {
        final IOException result = new IOException(String.format(noKeysForPrincipalInKeyTab$str(), principal, keyTab));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeyStoreEntryPassword = "ELY02001: Invalid key store entry password for alias \"%s\"";
    protected String invalidKeyStoreEntryPassword$str() {
        return invalidKeyStoreEntryPassword;
    }
    @Override
    public final UnrecoverableKeyException invalidKeyStoreEntryPassword(final String alias) {
        final UnrecoverableKeyException result = new UnrecoverableKeyException(String.format(invalidKeyStoreEntryPassword$str(), alias));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeyStoreEntryType = "ELY02002: Invalid key store entry type for alias \"%s\" (expected %s, got %s)";
    protected String invalidKeyStoreEntryType$str() {
        return invalidKeyStoreEntryType;
    }
    @Override
    public final KeyStoreException invalidKeyStoreEntryType(final String alias, final Class<? extends Object> expectedClass, final Class<? extends Object> actualClass) {
        final KeyStoreException result = new KeyStoreException(String.format(invalidKeyStoreEntryType$str(), alias, expectedClass, actualClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyCannotBeProtected = "ELY02003: Key store key for alias \"%s\" cannot be protected";
    protected String keyCannotBeProtected$str() {
        return keyCannotBeProtected;
    }
    @Override
    public final KeyStoreException keyCannotBeProtected(final String alias) {
        final KeyStoreException result = new KeyStoreException(String.format(keyCannotBeProtected$str(), alias));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyStoreFailedToTranslate = "ELY02004: Key store failed to translate password for alias \"%s\"";
    protected String keyStoreFailedToTranslate$str() {
        return keyStoreFailedToTranslate;
    }
    @Override
    public final IOException keyStoreFailedToTranslate(final String alias, final Throwable cause) {
        final IOException result = new IOException(String.format(keyStoreFailedToTranslate$str(), alias), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noAlgorithmForPassword = "ELY02005: Key store failed to identify a suitable algorithm for alias \"%s\"";
    protected String noAlgorithmForPassword$str() {
        return noAlgorithmForPassword;
    }
    @Override
    public final NoSuchAlgorithmException noAlgorithmForPassword(final String alias) {
        final NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(noAlgorithmForPassword$str(), alias));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedWhitespaceInPasswordFile = "ELY02006: Unexpected whitespace in password file";
    protected String unexpectedWhitespaceInPasswordFile$str() {
        return unexpectedWhitespaceInPasswordFile;
    }
    @Override
    public final IOException unexpectedWhitespaceInPasswordFile() {
        final IOException result = new IOException(String.format(unexpectedWhitespaceInPasswordFile$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedEof = "ELY02007: Unexpected end of file";
    protected String unexpectedEof$str() {
        return unexpectedEof;
    }
    @Override
    public final EOFException unexpectedEof() {
        final EOFException result = new EOFException(String.format(unexpectedEof$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String reversibleLoadNotPossible = "ELY02008: A reversible load is not possible until the KeyStore has first been initialized";
    protected String reversibleLoadNotPossible$str() {
        return reversibleLoadNotPossible;
    }
    @Override
    public final IllegalStateException reversibleLoadNotPossible() {
        final IllegalStateException result = new IllegalStateException(String.format(reversibleLoadNotPossible$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToCreateKeyStore = "ELY02009: Unable to create a new KeyStore instance";
    protected String unableToCreateKeyStore$str() {
        return unableToCreateKeyStore;
    }
    @Override
    public final IOException unableToCreateKeyStore(final Exception cause) {
        final IOException result = new IOException(String.format(unableToCreateKeyStore$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlUnknownKeyStoreSpecified = "ELY02010: Unknown key store specified";
    protected String xmlUnknownKeyStoreSpecified$str() {
        return xmlUnknownKeyStoreSpecified;
    }
    @Override
    public final ConfigXMLParseException xmlUnknownKeyStoreSpecified(final Location location) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(xmlUnknownKeyStoreSpecified$str()), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String emptyFilter = "ELY02012: An empty alias filter was supplied";
    protected String emptyFilter$str() {
        return emptyFilter;
    }
    @Override
    public final IllegalArgumentException emptyFilter() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(emptyFilter$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingPlusMinusAt = "ELY02013: Filter is missing '+' or '-' at offest %d";
    protected String missingPlusMinusAt$str() {
        return missingPlusMinusAt;
    }
    @Override
    public final IllegalArgumentException missingPlusMinusAt(final int position) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(missingPlusMinusAt$str(), position));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidFirstWord = "ELY02014: Invalid first word '%s', must be one of ALL/NONE";
    protected String invalidFirstWord$str() {
        return invalidFirstWord;
    }
    @Override
    public final IllegalArgumentException invalidFirstWord(final String firstWord) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidFirstWord$str(), firstWord));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToObtainDirContext = "ELY02015: Failed to obtain DirContext";
    protected String failedToObtainDirContext$str() {
        return failedToObtainDirContext;
    }
    @Override
    public final IllegalStateException failedToObtainDirContext(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(failedToObtainDirContext$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToReturnDirContext = "ELY02016: Failed to return DirContext";
    protected String failedToReturnDirContext$str() {
        return failedToReturnDirContext;
    }
    @Override
    public final IllegalStateException failedToReturnDirContext(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(failedToReturnDirContext$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapKeyStoreFailedToObtainAlias = "ELY02017: LdapKeyStore failed to obtain alias [%s]";
    protected String ldapKeyStoreFailedToObtainAlias$str() {
        return ldapKeyStoreFailedToObtainAlias;
    }
    @Override
    public final IllegalStateException ldapKeyStoreFailedToObtainAlias(final String alias, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(ldapKeyStoreFailedToObtainAlias$str(), alias), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapKeyStoreFailedToObtainCertificate = "ELY02018: LdapKeyStore failed to obtain certificate [%s]";
    protected String ldapKeyStoreFailedToObtainCertificate$str() {
        return ldapKeyStoreFailedToObtainCertificate;
    }
    @Override
    public final IllegalStateException ldapKeyStoreFailedToObtainCertificate(final String alias, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(ldapKeyStoreFailedToObtainCertificate$str(), alias), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapKeyStoreFailedToObtainCertificateChain = "ELY02019: LdapKeyStore failed to obtain certificate chain [%s]";
    protected String ldapKeyStoreFailedToObtainCertificateChain$str() {
        return ldapKeyStoreFailedToObtainCertificateChain;
    }
    @Override
    public final IllegalStateException ldapKeyStoreFailedToObtainCertificateChain(final String alias, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(ldapKeyStoreFailedToObtainCertificateChain$str(), alias), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapKeyStoreFailedToObtainKey = "ELY02020: LdapKeyStore failed to recover key of alias [%s]";
    protected String ldapKeyStoreFailedToObtainKey$str() {
        return ldapKeyStoreFailedToObtainKey;
    }
    @Override
    public final IllegalStateException ldapKeyStoreFailedToObtainKey(final String alias, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(ldapKeyStoreFailedToObtainKey$str(), alias), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapKeyStoreFailedToObtainAliasByCertificate = "ELY02021: LdapKeyStore failed to obtain alias by certificate";
    protected String ldapKeyStoreFailedToObtainAliasByCertificate$str() {
        return ldapKeyStoreFailedToObtainAliasByCertificate;
    }
    @Override
    public final IllegalStateException ldapKeyStoreFailedToObtainAliasByCertificate(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(ldapKeyStoreFailedToObtainAliasByCertificate$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapKeyStoreFailedToRecoverKey = "ELY02022: LdapKeyStore failed to recover key of alias [%s]";
    protected String ldapKeyStoreFailedToRecoverKey$str() {
        return ldapKeyStoreFailedToRecoverKey;
    }
    @Override
    public final UnrecoverableKeyException ldapKeyStoreFailedToRecoverKey(final String alias, final Throwable cause) {
        final UnrecoverableKeyException result = new UnrecoverableKeyException(String.format(ldapKeyStoreFailedToRecoverKey$str(), alias));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapKeyStoreFailedToObtainCreationDate = "ELY02023: LdapKeyStore failed to obtain creation date of alias [%s]";
    protected String ldapKeyStoreFailedToObtainCreationDate$str() {
        return ldapKeyStoreFailedToObtainCreationDate;
    }
    @Override
    public final IllegalStateException ldapKeyStoreFailedToObtainCreationDate(final String alias, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(ldapKeyStoreFailedToObtainCreationDate$str(), alias), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String creationNotConfigured = "ELY02024: Alias [%s] does not exist in LdapKeyStore and not configured for creation";
    protected String creationNotConfigured$str() {
        return creationNotConfigured;
    }
    @Override
    public final KeyStoreException creationNotConfigured(final String alias) {
        final KeyStoreException result = new KeyStoreException(String.format(creationNotConfigured$str(), alias));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapKeyStoreFailedToStore = "ELY02025: LdapKeyStore failed store alias [%s]";
    protected String ldapKeyStoreFailedToStore$str() {
        return ldapKeyStoreFailedToStore;
    }
    @Override
    public final KeyStoreException ldapKeyStoreFailedToStore(final String alias, final Throwable cause) {
        final KeyStoreException result = new KeyStoreException(String.format(ldapKeyStoreFailedToStore$str(), alias), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapKeyStoreFailedToSerializeCertificate = "ELY02026: LdapKeyStore failed to serialize certificate of alias [%s]";
    protected String ldapKeyStoreFailedToSerializeCertificate$str() {
        return ldapKeyStoreFailedToSerializeCertificate;
    }
    @Override
    public final KeyStoreException ldapKeyStoreFailedToSerializeCertificate(final String alias, final Throwable cause) {
        final KeyStoreException result = new KeyStoreException(String.format(ldapKeyStoreFailedToSerializeCertificate$str(), alias), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapKeyStoreFailedToSerializeKey = "ELY02027: LdapKeyStore failed to protect (pack into keystore) key of alias [%s]";
    protected String ldapKeyStoreFailedToSerializeKey$str() {
        return ldapKeyStoreFailedToSerializeKey;
    }
    @Override
    public final KeyStoreException ldapKeyStoreFailedToSerializeKey(final String alias, final Throwable cause) {
        final KeyStoreException result = new KeyStoreException(String.format(ldapKeyStoreFailedToSerializeKey$str(), alias), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapKeyStoreFailedToDelete = "ELY02028: LdapKeyStore failed to delete alias [%s]";
    protected String ldapKeyStoreFailedToDelete$str() {
        return ldapKeyStoreFailedToDelete;
    }
    @Override
    public final KeyStoreException ldapKeyStoreFailedToDelete(final String alias, final Throwable cause) {
        final KeyStoreException result = new KeyStoreException(String.format(ldapKeyStoreFailedToDelete$str(), alias), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapKeyStoreFailedToDeleteNonExisting = "ELY02029: LdapKeyStore failed to delete alias [%s] - alias not found";
    protected String ldapKeyStoreFailedToDeleteNonExisting$str() {
        return ldapKeyStoreFailedToDeleteNonExisting;
    }
    @Override
    public final KeyStoreException ldapKeyStoreFailedToDeleteNonExisting(final String alias) {
        final KeyStoreException result = new KeyStoreException(String.format(ldapKeyStoreFailedToDeleteNonExisting$str(), alias));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapKeyStoreFailedToTestAliasExistence = "ELY02030: LdapKeyStore failed to test alias [%s] existence";
    protected String ldapKeyStoreFailedToTestAliasExistence$str() {
        return ldapKeyStoreFailedToTestAliasExistence;
    }
    @Override
    public final IllegalStateException ldapKeyStoreFailedToTestAliasExistence(final String alias, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(ldapKeyStoreFailedToTestAliasExistence$str(), alias), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapKeyStoreFailedToIterateAliases = "ELY02031: LdapKeyStore failed to iterate aliases";
    protected String ldapKeyStoreFailedToIterateAliases$str() {
        return ldapKeyStoreFailedToIterateAliases;
    }
    @Override
    public final IllegalStateException ldapKeyStoreFailedToIterateAliases(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(ldapKeyStoreFailedToIterateAliases$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keySpecMustBeSecretKeySpec = "ELY02032: keySpec must be SecretKeySpect, given: [%s]";
    protected String keySpecMustBeSecretKeySpec$str() {
        return keySpecMustBeSecretKeySpec;
    }
    @Override
    public final InvalidKeySpecException keySpecMustBeSecretKeySpec(final String type) {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(keySpecMustBeSecretKeySpec$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyMustImplementSecretKeySpecAndKeySpecMustBeSecretKeySpec = "ELY02033: key must implement SecretKeySpec and keySpec must be SecretKeySpec, given key, keySpec: [%s]";
    protected String keyMustImplementSecretKeySpecAndKeySpecMustBeSecretKeySpec$str() {
        return keyMustImplementSecretKeySpecAndKeySpecMustBeSecretKeySpec;
    }
    @Override
    public final InvalidKeySpecException keyMustImplementSecretKeySpecAndKeySpecMustBeSecretKeySpec(final String keyAndKeySpec) {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(keyMustImplementSecretKeySpecAndKeySpecMustBeSecretKeySpec$str(), keyAndKeySpec));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingAlias = "ELY02034: Alias must be specified if more than one entry exist in keystore";
    protected String missingAlias$str() {
        return missingAlias;
    }
    @Override
    public final ConfigXMLParseException missingAlias(final Location location) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(missingAlias$str()), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedPadding = "ELY03001: Unexpected padding";
    protected String unexpectedPadding$str() {
        return unexpectedPadding;
    }
    @Override
    public final DecodeException unexpectedPadding() {
        final DecodeException result = new DecodeException(String.format(unexpectedPadding$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expectedPadding = "ELY03002: Expected padding";
    protected String expectedPadding$str() {
        return expectedPadding;
    }
    @Override
    public final DecodeException expectedPadding() {
        final DecodeException result = new DecodeException(String.format(expectedPadding$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String incompleteDecode = "ELY03003: Incomplete decode";
    protected String incompleteDecode$str() {
        return incompleteDecode;
    }
    @Override
    public final DecodeException incompleteDecode() {
        final DecodeException result = new DecodeException(String.format(incompleteDecode$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expectedPaddingCharacters = "ELY03004: Expected %d padding characters";
    protected String expectedPaddingCharacters$str() {
        return expectedPaddingCharacters;
    }
    @Override
    public final DecodeException expectedPaddingCharacters(final int numExpected) {
        final DecodeException result = new DecodeException(String.format(expectedPaddingCharacters$str(), numExpected));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidBase32Character = "ELY03005: Invalid base 32 character";
    protected String invalidBase32Character$str() {
        return invalidBase32Character;
    }
    @Override
    public final DecodeException invalidBase32Character() {
        final DecodeException result = new DecodeException(String.format(invalidBase32Character$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expectedEvenNumberOfHexCharacters = "ELY03006: Expected an even number of hex characters";
    protected String expectedEvenNumberOfHexCharacters$str() {
        return expectedEvenNumberOfHexCharacters;
    }
    @Override
    public final DecodeException expectedEvenNumberOfHexCharacters() {
        final DecodeException result = new DecodeException(String.format(expectedEvenNumberOfHexCharacters$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidHexCharacter = "ELY03007: Invalid hex character";
    protected String invalidHexCharacter$str() {
        return invalidHexCharacter;
    }
    @Override
    public final DecodeException invalidHexCharacter() {
        final DecodeException result = new DecodeException(String.format(invalidHexCharacter$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expectedTwoPaddingCharacters = "ELY03008: Expected two padding characters";
    protected String expectedTwoPaddingCharacters$str() {
        return expectedTwoPaddingCharacters;
    }
    @Override
    public final DecodeException expectedTwoPaddingCharacters() {
        final DecodeException result = new DecodeException(String.format(expectedTwoPaddingCharacters$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidBase64Character = "ELY03009: Invalid base 64 character";
    protected String invalidBase64Character$str() {
        return invalidBase64Character;
    }
    @Override
    public final DecodeException invalidBase64Character() {
        final DecodeException result = new DecodeException(String.format(invalidBase64Character$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String malformedPemContent = "ELY03010: Malformed PEM content at offset %d";
    protected String malformedPemContent$str() {
        return malformedPemContent;
    }
    @Override
    public final IllegalArgumentException malformedPemContent(final int offset) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(malformedPemContent$str(), offset));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPemType = "ELY03011: Invalid PEM type (expected \"%s\", got \"%s\"";
    protected String invalidPemType$str() {
        return invalidPemType;
    }
    @Override
    public final IllegalArgumentException invalidPemType(final String expected, final String actual) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidPemType$str(), expected, actual));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String certificateParseError = "ELY03012: Certificate parse error";
    protected String certificateParseError$str() {
        return certificateParseError;
    }
    @Override
    public final IllegalArgumentException certificateParseError(final CertificateException cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(certificateParseError$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String permissionCollectionMustBeReadOnly = "ELY03013: Permission collection must be read-only";
    protected String permissionCollectionMustBeReadOnly$str() {
        return permissionCollectionMustBeReadOnly;
    }
    @Override
    public final SecurityException permissionCollectionMustBeReadOnly() {
        final SecurityException result = new SecurityException(String.format(permissionCollectionMustBeReadOnly$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPermissionName = "ELY03014: Invalid character found in name \"%s\" at offset %d";
    protected String invalidPermissionName$str() {
        return invalidPermissionName;
    }
    @Override
    public final IllegalArgumentException invalidPermissionName(final String name, final int offset) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidPermissionName$str(), name, offset));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String permissionClassMissing = "ELY03015: Could not load permission class \"%s\"";
    protected String permissionClassMissing$str() {
        return permissionClassMissing;
    }
    @Override
    public final InvalidPermissionClassException permissionClassMissing(final String className, final ClassNotFoundException cause) {
        final InvalidPermissionClassException result = new InvalidPermissionClassException(String.format(permissionClassMissing$str(), className), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String permissionInstantiation = "ELY03016: Could not instantiate permission class \"%s\"";
    protected String permissionInstantiation$str() {
        return permissionInstantiation;
    }
    @Override
    public final InvalidPermissionClassException permissionInstantiation(final String className, final Throwable cause) {
        final InvalidPermissionClassException result = new InvalidPermissionClassException(String.format(permissionInstantiation$str(), className), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noPermissionConstructor = "ELY03017: No valid permission constructor found on class \"%s\"";
    protected String noPermissionConstructor$str() {
        return noPermissionConstructor;
    }
    @Override
    public final InvalidPermissionClassException noPermissionConstructor(final String className) {
        final InvalidPermissionClassException result = new InvalidPermissionClassException(String.format(noPermissionConstructor$str(), className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String readOnlyPermissionCollection = "ELY03018: Cannot add permissions to a read-only permission collection";
    protected String readOnlyPermissionCollection$str() {
        return readOnlyPermissionCollection;
    }
    @Override
    public final SecurityException readOnlyPermissionCollection() {
        final SecurityException result = new SecurityException(String.format(readOnlyPermissionCollection$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidObjectNull = "ELY03019: Failure to deserialize object: field \"%s\" is null";
    protected String invalidObjectNull$str() {
        return invalidObjectNull;
    }
    @Override
    public final InvalidObjectException invalidObjectNull(final String fieldName) {
        final InvalidObjectException result = new InvalidObjectException(String.format(invalidObjectNull$str(), fieldName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expectedEmptyActions = "ELY03020: Expected empty actions string, got \"%s\"";
    protected String expectedEmptyActions$str() {
        return expectedEmptyActions;
    }
    @Override
    public final IllegalArgumentException expectedEmptyActions(final String actions) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(expectedEmptyActions$str(), actions));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPermissionType = "ELY03021: Invalid permission type; expected %s, got %s";
    protected String invalidPermissionType$str() {
        return invalidPermissionType;
    }
    @Override
    public final IllegalArgumentException invalidPermissionType(final Class<? extends Permission> expected, final Permission actual) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidPermissionType$str(), expected, actual));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String permissionCheckFailed = "ELY03022: Permission check failed: %s is not implied by %s";
    protected String permissionCheckFailed$str() {
        return permissionCheckFailed;
    }
    @Override
    public final SecurityException permissionCheckFailed(final Permission permission, final PermissionVerifier permissionVerifier) {
        final SecurityException result = new SecurityException(String.format(permissionCheckFailed$str(), permission, permissionVerifier));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String publicKeyParseError = "ELY03023: PublicKey parse error";
    protected String publicKeyParseError$str() {
        return publicKeyParseError;
    }
    @Override
    public final IllegalArgumentException publicKeyParseError(final Throwable cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(publicKeyParseError$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String publicKeyUnsupportedEncodingFormat = "ELY03024: Unsupported key encoding format [%s]";
    protected String publicKeyUnsupportedEncodingFormat$str() {
        return publicKeyUnsupportedEncodingFormat;
    }
    @Override
    public final IllegalArgumentException publicKeyUnsupportedEncodingFormat(final String format) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(publicKeyUnsupportedEncodingFormat$str(), format));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String iterationCountNotSpecified = "ELY03025: Iteration count not specified for password based encryption";
    protected String iterationCountNotSpecified$str() {
        return iterationCountNotSpecified;
    }
    @Override
    public final IllegalArgumentException iterationCountNotSpecified() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(iterationCountNotSpecified$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String saltNotSpecified = "ELY03026: Salt not specified for password based encryption";
    protected String saltNotSpecified$str() {
        return saltNotSpecified;
    }
    @Override
    public final IllegalArgumentException saltNotSpecified() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(saltNotSpecified$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String initialKeyNotSpecified = "ELY03027: Initial key not specified for password based encryption";
    protected String initialKeyNotSpecified$str() {
        return initialKeyNotSpecified;
    }
    @Override
    public final IllegalArgumentException initialKeyNotSpecified() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(initialKeyNotSpecified$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String securityProviderDoesnExist = "ELY03028: Security provider \"%s\" doesn't exist";
    protected String securityProviderDoesnExist$str() {
        return securityProviderDoesnExist;
    }
    @Override
    public final IllegalArgumentException securityProviderDoesnExist(final String providerName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(securityProviderDoesnExist$str(), providerName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSuchKeyAlgorithm = "ELY03029: No such key algorithm \"%s\"";
    protected String noSuchKeyAlgorithm$str() {
        return noSuchKeyAlgorithm;
    }
    @Override
    public final IllegalArgumentException noSuchKeyAlgorithm(final String algorithmName, final GeneralSecurityException cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(noSuchKeyAlgorithm$str(), algorithmName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String closed = "ELY03030: I/O operation failed: closed";
    protected String closed$str() {
        return closed;
    }
    @Override
    public final IOException closed() {
        final IOException result = new IOException(String.format(closed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tooManyKerberosTicketsFound = "ELY03031: Too many KerberosTicket instances in private credentials";
    protected String tooManyKerberosTicketsFound$str() {
        return tooManyKerberosTicketsFound;
    }
    @Override
    public final GeneralSecurityException tooManyKerberosTicketsFound() {
        final GeneralSecurityException result = new GeneralSecurityException(String.format(tooManyKerberosTicketsFound$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String wrongBase64InPBCompatibleMode = "ELY03032: Base64 string created with unsupported PicketBox version \"%s\"";
    protected String wrongBase64InPBCompatibleMode$str() {
        return wrongBase64InPBCompatibleMode;
    }
    @Override
    public final IllegalArgumentException wrongBase64InPBCompatibleMode(final String base64) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(wrongBase64InPBCompatibleMode$str(), base64));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noAlgorithmForSslProtocol = "ELY04001: No algorithm found matching TLS/SSL protocol selection criteria";
    protected String noAlgorithmForSslProtocol$str() {
        return noAlgorithmForSslProtocol;
    }
    @Override
    public final NoSuchAlgorithmException noAlgorithmForSslProtocol() {
        final NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(noAlgorithmForSslProtocol$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String emptyChainNotTrusted = "ELY04002: Empty certificate chain is not trusted";
    protected String emptyChainNotTrusted$str() {
        return emptyChainNotTrusted;
    }
    @Override
    public final CertificateException emptyChainNotTrusted() {
        final CertificateException result = new CertificateException(String.format(emptyChainNotTrusted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notTrustedRealmProblem = "ELY04003: Certificate not trusted due to realm failure for principal [%s]";
    protected String notTrustedRealmProblem$str() {
        return notTrustedRealmProblem;
    }
    @Override
    public final CertificateException notTrustedRealmProblem(final RealmUnavailableException e, final Principal principal) {
        final CertificateException result = new CertificateException(String.format(notTrustedRealmProblem$str(), principal), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notTrusted = "ELY04004: Credential validation failed: certificate is not trusted for principal [%s]";
    protected String notTrusted$str() {
        return notTrusted;
    }
    @Override
    public final CertificateException notTrusted(final Principal principal) {
        final CertificateException result = new CertificateException(String.format(notTrusted$str(), principal));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noDefaultTrustManager = "ELY04005: No default trust manager available";
    protected String noDefaultTrustManager$str() {
        return noDefaultTrustManager;
    }
    @Override
    public final NoSuchAlgorithmException noDefaultTrustManager() {
        final NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(noDefaultTrustManager$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noContextForSslConnection = "ELY04006: No context for SSL connection";
    protected String noContextForSslConnection$str() {
        return noContextForSslConnection;
    }
    @Override
    public final SSLHandshakeException noContextForSslConnection() {
        final SSLHandshakeException result = new SSLHandshakeException(String.format(noContextForSslConnection$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String sslClosed = "ELY04007: SSL channel is closed";
    protected String sslClosed$str() {
        return sslClosed;
    }
    @Override
    public final SSLException sslClosed() {
        final SSLException result = new SSLException(String.format(sslClosed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notHandshakeRecord = "ELY04008: Initial SSL/TLS data is not a handshake record";
    protected String notHandshakeRecord$str() {
        return notHandshakeRecord;
    }
    @Override
    public final SSLHandshakeException notHandshakeRecord() {
        final SSLHandshakeException result = new SSLHandshakeException(String.format(notHandshakeRecord$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidHandshakeRecord = "ELY04009: Initial SSL/TLS handshake record is invalid";
    protected String invalidHandshakeRecord$str() {
        return invalidHandshakeRecord;
    }
    @Override
    public final SSLHandshakeException invalidHandshakeRecord() {
        final SSLHandshakeException result = new SSLHandshakeException(String.format(invalidHandshakeRecord$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multiRecordSSLHandshake = "ELY04010: Initial SSL/TLS handshake spans multiple records";
    protected String multiRecordSSLHandshake$str() {
        return multiRecordSSLHandshake;
    }
    @Override
    public final SSLHandshakeException multiRecordSSLHandshake() {
        final SSLHandshakeException result = new SSLHandshakeException(String.format(multiRecordSSLHandshake$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expectedClientHello = "ELY04011: Expected \"client hello\" record";
    protected String expectedClientHello$str() {
        return expectedClientHello;
    }
    @Override
    public final SSLHandshakeException expectedClientHello() {
        final SSLHandshakeException result = new SSLHandshakeException(String.format(expectedClientHello$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedSslRecord = "ELY04012: Unsupported SSL/TLS record";
    protected String unsupportedSslRecord$str() {
        return unsupportedSslRecord;
    }
    @Override
    public final SSLHandshakeException unsupportedSslRecord() {
        final SSLHandshakeException result = new SSLHandshakeException(String.format(unsupportedSslRecord$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidTlsExt = "ELY04013: Invalid TLS extension data";
    protected String invalidTlsExt$str() {
        return invalidTlsExt;
    }
    @Override
    public final SSLProtocolException invalidTlsExt() {
        final SSLProtocolException result = new SSLProtocolException(String.format(invalidTlsExt$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notEnoughData = "ELY04014: Not enough data in record to fill declared item size";
    protected String notEnoughData$str() {
        return notEnoughData;
    }
    @Override
    public final SSLProtocolException notEnoughData() {
        final SSLProtocolException result = new SSLProtocolException(String.format(notEnoughData$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String emptyHostNameSni = "ELY04015: Empty host name in SNI record data";
    protected String emptyHostNameSni$str() {
        return emptyHostNameSni;
    }
    @Override
    public final SSLProtocolException emptyHostNameSni() {
        final SSLProtocolException result = new SSLProtocolException(String.format(emptyHostNameSni$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicatedSniServerName = "ELY04016: Duplicated SNI server name of type %d";
    protected String duplicatedSniServerName$str() {
        return duplicatedSniServerName;
    }
    @Override
    public final SSLProtocolException duplicatedSniServerName(final int type) {
        final SSLProtocolException result = new SSLProtocolException(String.format(duplicatedSniServerName$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownAuthenticationName = "ELY04017: Unknown authentication name \"%s\"";
    protected String unknownAuthenticationName$str() {
        return unknownAuthenticationName;
    }
    @Override
    public final IllegalArgumentException unknownAuthenticationName(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(unknownAuthenticationName$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownEncryptionName = "ELY04018: Unknown encryption name \"%s\"";
    protected String unknownEncryptionName$str() {
        return unknownEncryptionName;
    }
    @Override
    public final IllegalArgumentException unknownEncryptionName(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(unknownEncryptionName$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownKeyExchangeName = "ELY04019: Unknown key exchange name \"%s\"";
    protected String unknownKeyExchangeName$str() {
        return unknownKeyExchangeName;
    }
    @Override
    public final IllegalArgumentException unknownKeyExchangeName(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(unknownKeyExchangeName$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechanismNotSupported = "ELY04020: Mechanism \"%s\" not supported by transformation mapper";
    protected String mechanismNotSupported$str() {
        return mechanismNotSupported;
    }
    @Override
    public final IllegalArgumentException mechanismNotSupported(final String mechanism) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(mechanismNotSupported$str(), mechanism));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidIndex = "ELY04021: Invalid index %d";
    protected String invalidIndex$str() {
        return invalidIndex;
    }
    @Override
    public final IndexOutOfBoundsException invalidIndex(final int index) {
        final IndexOutOfBoundsException result = new IndexOutOfBoundsException(String.format(invalidIndex$str(), index));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidSocketAddressTypeForUri = "ELY04022: Invalid socket address type for URI";
    protected String invalidSocketAddressTypeForUri$str() {
        return invalidSocketAddressTypeForUri;
    }
    @Override
    public final IllegalArgumentException invalidSocketAddressTypeForUri() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidSocketAddressTypeForUri$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tooLarge = "ELY04023: Too large";
    protected String tooLarge$str() {
        return tooLarge;
    }
    @Override
    public final IllegalStateException tooLarge() {
        final IllegalStateException result = new IllegalStateException(String.format(tooLarge$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidClientMode = "ELY04024: Invalid client mode, expected %s, got %s";
    protected String invalidClientMode$str() {
        return invalidClientMode;
    }
    @Override
    public final IllegalArgumentException invalidClientMode(final boolean expectedMode, final boolean givenMode) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidClientMode$str(), expectedMode, givenMode));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String threadLocalSslSocketFactoryThreadLocalNotSet = "ELY04025: DirContext tries to connect without ThreadLocalSSLSocketFactory thread local setting";
    protected String threadLocalSslSocketFactoryThreadLocalNotSet$str() {
        return threadLocalSslSocketFactoryThreadLocalNotSet;
    }
    @Override
    public final IllegalStateException threadLocalSslSocketFactoryThreadLocalNotSet() {
        final IllegalStateException result = new IllegalStateException(String.format(threadLocalSslSocketFactoryThreadLocalNotSet$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String sslErrorCreatingTrustManager = "ELY04026: Could not create trust manager [%s]";
    protected String sslErrorCreatingTrustManager$str() {
        return sslErrorCreatingTrustManager;
    }
    @Override
    public final IllegalStateException sslErrorCreatingTrustManager(final String name, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(sslErrorCreatingTrustManager$str(), name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechMessageAfterComplete = "ELY05001: [%s] Authentication mechanism exchange received a message after authentication was already complete";
    protected String mechMessageAfterComplete$str() {
        return mechMessageAfterComplete;
    }
    @Override
    public final AuthenticationMechanismException mechMessageAfterComplete(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechMessageAfterComplete$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUserNameContainsInvalidCharacter = "ELY05002: [%s] Authentication mechanism user name contains an invalid or disallowed character";
    protected String mechUserNameContainsInvalidCharacter$str() {
        return mechUserNameContainsInvalidCharacter;
    }
    @Override
    public final AuthenticationMechanismException mechUserNameContainsInvalidCharacter(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechUserNameContainsInvalidCharacter$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechAuthorizationFailed1 = "ELY05004: [%s] Authentication mechanism authorization failed";
    protected String mechAuthorizationFailed1$str() {
        return mechAuthorizationFailed1;
    }
    @Override
    public final AuthenticationMechanismException mechAuthorizationFailed(final String mechName, final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechAuthorizationFailed1$str(), mechName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechAuthenticationNotComplete = "ELY05005: [%s] Authentication mechanism authentication is not yet complete";
    protected String mechAuthenticationNotComplete$str() {
        return mechAuthenticationNotComplete;
    }
    @Override
    public final IllegalStateException mechAuthenticationNotComplete(final String mechName) {
        final IllegalStateException result = new IllegalStateException(String.format(mechAuthenticationNotComplete$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechNoSecurityLayer = "ELY05006: [%s] Authentication mechanism does not support security layer (wrapping/unwrapping)";
    protected String mechNoSecurityLayer$str() {
        return mechNoSecurityLayer;
    }
    @Override
    public final IllegalStateException mechNoSecurityLayer(final String mechName) {
        final IllegalStateException result = new IllegalStateException(String.format(mechNoSecurityLayer$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidMessageReceived = "ELY05007: [%s] Invalid authentication mechanism negotiation message received";
    protected String mechInvalidMessageReceived$str() {
        return mechInvalidMessageReceived;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidMessageReceived(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechInvalidMessageReceived$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechNoLoginNameGiven = "ELY05008: [%s] No authentication mechanism login name was given";
    protected String mechNoLoginNameGiven$str() {
        return mechNoLoginNameGiven;
    }
    @Override
    public final AuthenticationMechanismException mechNoLoginNameGiven(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechNoLoginNameGiven$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechNoPasswordGiven = "ELY05009: [%s] No authentication mechanism password was given";
    protected String mechNoPasswordGiven$str() {
        return mechNoPasswordGiven;
    }
    @Override
    public final AuthenticationMechanismException mechNoPasswordGiven(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechNoPasswordGiven$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechMalformedFields = "ELY05010: [%s] Authentication mechanism authentication failed due to one or more malformed fields";
    protected String mechMalformedFields$str() {
        return mechMalformedFields;
    }
    @Override
    public final AuthenticationMechanismException mechMalformedFields(final String mechName, final IllegalArgumentException ex) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechMalformedFields$str(), mechName), ex);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechMessageTooLong = "ELY05011: [%s] Authentication mechanism message is too long";
    protected String mechMessageTooLong$str() {
        return mechMessageTooLong;
    }
    @Override
    public final AuthenticationMechanismException mechMessageTooLong(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechMessageTooLong$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechServerSideAuthenticationFailed = "ELY05012: [%s] Authentication mechanism server-side authentication failed";
    protected String mechServerSideAuthenticationFailed$str() {
        return mechServerSideAuthenticationFailed;
    }
    @Override
    public final AuthenticationMechanismException mechServerSideAuthenticationFailed(final String mechName, final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechServerSideAuthenticationFailed$str(), mechName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechPasswordNotVerified = "ELY05013: [%s] Authentication mechanism password not verified";
    protected String mechPasswordNotVerified$str() {
        return mechPasswordNotVerified;
    }
    @Override
    public final AuthenticationMechanismException mechPasswordNotVerified(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechPasswordNotVerified$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechAuthorizationFailed3 = "ELY05014: [%s] Authentication mechanism authorization failed: \"%s\" running as \"%s\"";
    protected String mechAuthorizationFailed3$str() {
        return mechAuthorizationFailed3;
    }
    @Override
    public final AuthenticationMechanismException mechAuthorizationFailed(final String mechName, final String userName, final String authorizationId) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechAuthorizationFailed3$str(), mechName, userName, authorizationId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechSelectorUnexpectedChar = "ELY05015: Unexpected character U+%04x at offset %d of mechanism selection string \"%s\"";
    protected String mechSelectorUnexpectedChar$str() {
        return mechSelectorUnexpectedChar;
    }
    @Override
    public final IllegalArgumentException mechSelectorUnexpectedChar(final int codePoint, final int offset, final String string) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(mechSelectorUnexpectedChar$str(), codePoint, offset, string));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechSelectorUnknownToken = "ELY05016: Unrecognized token \"%s\" in mechanism selection string \"%s\"";
    protected String mechSelectorUnknownToken$str() {
        return mechSelectorUnknownToken;
    }
    @Override
    public final IllegalArgumentException mechSelectorUnknownToken(final String word, final String string) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(mechSelectorUnknownToken$str(), word, string));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechSelectorTokenNotAllowed = "ELY05017: Token \"%s\" not allowed at offset %d of mechanism selection string \"%s\"";
    protected String mechSelectorTokenNotAllowed$str() {
        return mechSelectorTokenNotAllowed;
    }
    @Override
    public final IllegalArgumentException mechSelectorTokenNotAllowed(final String token, final int offset, final String string) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(mechSelectorTokenNotAllowed$str(), token, offset, string));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechChannelBindingChanged = "ELY05018: [%s] Channel binding data changed";
    protected String mechChannelBindingChanged$str() {
        return mechChannelBindingChanged;
    }
    @Override
    public final AuthenticationMechanismException mechChannelBindingChanged(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechChannelBindingChanged$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechNoTokenGiven = "ELY05019: [%s] No token was given";
    protected String mechNoTokenGiven$str() {
        return mechNoTokenGiven;
    }
    @Override
    public final AuthenticationMechanismException mechNoTokenGiven(final String mechanismName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechNoTokenGiven$str(), mechanismName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechSelectorUnexpectedEnd = "ELY05020: Unexpected end of mechanism selection string \"%s\"";
    protected String mechSelectorUnexpectedEnd$str() {
        return mechSelectorUnexpectedEnd;
    }
    @Override
    public final IllegalArgumentException mechSelectorUnexpectedEnd(final String string) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(mechSelectorUnexpectedEnd$str(), string));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInitialChallengeMustBeEmpty = "ELY05022: [%s] Initial challenge must be empty";
    protected String mechInitialChallengeMustBeEmpty$str() {
        return mechInitialChallengeMustBeEmpty;
    }
    @Override
    public final AuthenticationMechanismException mechInitialChallengeMustBeEmpty(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechInitialChallengeMustBeEmpty$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToSetChannelBinding = "ELY05023: [%s] Unable to set channel binding";
    protected String mechUnableToSetChannelBinding$str() {
        return mechUnableToSetChannelBinding;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToSetChannelBinding(final String mechName, final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechUnableToSetChannelBinding$str(), mechName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechFailedToDetermineChannelBindingStatus = "ELY05024: Failed to determine channel binding status";
    protected String mechFailedToDetermineChannelBindingStatus$str() {
        return mechFailedToDetermineChannelBindingStatus;
    }
    @Override
    public final AuthenticationMechanismException mechFailedToDetermineChannelBindingStatus(final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechFailedToDetermineChannelBindingStatus$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechMutualAuthenticationNotEnabled = "ELY05025: [%s] Mutual authentication not enabled";
    protected String mechMutualAuthenticationNotEnabled$str() {
        return mechMutualAuthenticationNotEnabled;
    }
    @Override
    public final AuthenticationMechanismException mechMutualAuthenticationNotEnabled(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechMutualAuthenticationNotEnabled$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechMechanismToOidMappingFailed = "ELY05026: [%s] Unable to map SASL mechanism name to a GSS-API OID";
    protected String mechMechanismToOidMappingFailed$str() {
        return mechMechanismToOidMappingFailed;
    }
    @Override
    public final AuthenticationMechanismException mechMechanismToOidMappingFailed(final String mechName, final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechMechanismToOidMappingFailed$str(), mechName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToDisposeGssContext = "ELY05027: [%s] Unable to dispose of GSSContext";
    protected String mechUnableToDisposeGssContext$str() {
        return mechUnableToDisposeGssContext;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToDisposeGssContext(final String mechName, final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechUnableToDisposeGssContext$str(), mechName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToCreateNameForAcceptor = "ELY05028: [%s] Unable to create name for acceptor";
    protected String mechUnableToCreateNameForAcceptor$str() {
        return mechUnableToCreateNameForAcceptor;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToCreateNameForAcceptor(final String mechName, final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechUnableToCreateNameForAcceptor$str(), mechName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToCreateGssContext = "ELY05029: [%s] Unable to create GSSContext";
    protected String mechUnableToCreateGssContext$str() {
        return mechUnableToCreateGssContext;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToCreateGssContext(final String mechName, final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechUnableToCreateGssContext$str(), mechName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToSetGssContextRequestFlags = "ELY05030: [%s] Unable to set GSSContext request flags";
    protected String mechUnableToSetGssContextRequestFlags$str() {
        return mechUnableToSetGssContextRequestFlags;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToSetGssContextRequestFlags(final String mechName, final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechUnableToSetGssContextRequestFlags$str(), mechName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToAcceptClientMessage = "ELY05031: [%s] Unable to accept SASL client message";
    protected String mechUnableToAcceptClientMessage$str() {
        return mechUnableToAcceptClientMessage;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToAcceptClientMessage(final String mechName, final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechUnableToAcceptClientMessage$str(), mechName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechGssApiMechanismMismatch = "ELY05032: [%s] GSS-API mechanism mismatch between SASL client and server";
    protected String mechGssApiMechanismMismatch$str() {
        return mechGssApiMechanismMismatch;
    }
    @Override
    public final AuthenticationMechanismException mechGssApiMechanismMismatch(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechGssApiMechanismMismatch$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechChannelBindingNotSupported = "ELY05033: [%s] Channel binding not supported for this SASL mechanism";
    protected String mechChannelBindingNotSupported$str() {
        return mechChannelBindingNotSupported;
    }
    @Override
    public final AuthenticationMechanismException mechChannelBindingNotSupported(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechChannelBindingNotSupported$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechChannelBindingTypeMismatch = "ELY05034: [%s] Channel binding type mismatch between SASL client and server";
    protected String mechChannelBindingTypeMismatch$str() {
        return mechChannelBindingTypeMismatch;
    }
    @Override
    public final AuthenticationMechanismException mechChannelBindingTypeMismatch(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechChannelBindingTypeMismatch$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechChannelBindingNotProvided = "ELY05035: [%s] Channel binding not provided by client";
    protected String mechChannelBindingNotProvided$str() {
        return mechChannelBindingNotProvided;
    }
    @Override
    public final AuthenticationMechanismException mechChannelBindingNotProvided(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechChannelBindingNotProvided$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToDeterminePeerName = "ELY05036: [%s] Unable to determine peer name";
    protected String mechUnableToDeterminePeerName$str() {
        return mechUnableToDeterminePeerName;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToDeterminePeerName(final String mechName, final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechUnableToDeterminePeerName$str(), mechName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechClientRefusesToInitiateAuthentication = "ELY05037: [%s] Authentication mechanism client refuses to initiate authentication";
    protected String mechClientRefusesToInitiateAuthentication$str() {
        return mechClientRefusesToInitiateAuthentication;
    }
    @Override
    public final AuthenticationMechanismException mechClientRefusesToInitiateAuthentication(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechClientRefusesToInitiateAuthentication$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechNoncesDoNotMatch = "ELY05038: [%s] Nonces do not match";
    protected String mechNoncesDoNotMatch$str() {
        return mechNoncesDoNotMatch;
    }
    @Override
    public final AuthenticationMechanismException mechNoncesDoNotMatch(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechNoncesDoNotMatch$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidNonceLength = "ELY05039: [%s] Invalid length of nonce received";
    protected String invalidNonceLength$str() {
        return invalidNonceLength;
    }
    @Override
    public final AuthenticationMechanismException invalidNonceLength(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(invalidNonceLength$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechIterationCountIsTooLow = "ELY05040: [%s] Iteration count %d is below the minimum of %d";
    protected String mechIterationCountIsTooLow$str() {
        return mechIterationCountIsTooLow;
    }
    @Override
    public final AuthenticationMechanismException mechIterationCountIsTooLow(final String mechName, final int iterationCount, final int minimumIterationCount) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechIterationCountIsTooLow$str(), mechName, iterationCount, minimumIterationCount));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechIterationCountIsTooHigh = "ELY05041: [%s] Iteration count %d is above the maximum of %d";
    protected String mechIterationCountIsTooHigh$str() {
        return mechIterationCountIsTooHigh;
    }
    @Override
    public final AuthenticationMechanismException mechIterationCountIsTooHigh(final String mechName, final int iterationCount, final int maximumIterationCount) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechIterationCountIsTooHigh$str(), mechName, iterationCount, maximumIterationCount));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechExtensionsUnsupported = "ELY05042: [%s] Extensions unsupported";
    protected String mechExtensionsUnsupported$str() {
        return mechExtensionsUnsupported;
    }
    @Override
    public final AuthenticationMechanismException mechExtensionsUnsupported(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechExtensionsUnsupported$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidServerMessage = "ELY05043: [%s] Invalid server message";
    protected String mechInvalidServerMessage$str() {
        return mechInvalidServerMessage;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidServerMessage(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechInvalidServerMessage$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidServerMessageWithCause = "ELY05044: [%s] Invalid server message";
    protected String mechInvalidServerMessageWithCause$str() {
        return mechInvalidServerMessageWithCause;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidServerMessageWithCause(final String mechName, final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechInvalidServerMessageWithCause$str(), mechName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidClientMessage = "ELY05045: [%s] Invalid client message";
    protected String mechInvalidClientMessage$str() {
        return mechInvalidClientMessage;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidClientMessage(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechInvalidClientMessage$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidClientMessageWithCause = "ELY05046: [%s] Invalid client message";
    protected String mechInvalidClientMessageWithCause$str() {
        return mechInvalidClientMessageWithCause;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidClientMessageWithCause(final String mechName, final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechInvalidClientMessageWithCause$str(), mechName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnmatchedMechanism = "ELY05047: [%s] Authentication mechanism message is for mismatched mechanism \"%s\"";
    protected String mechUnmatchedMechanism$str() {
        return mechUnmatchedMechanism;
    }
    @Override
    public final AuthenticationMechanismException mechUnmatchedMechanism(final String mechName, final String otherMechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechUnmatchedMechanism$str(), mechName, otherMechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechServerRejectedAuthentication = "ELY05048: [%s] Server rejected authentication";
    protected String mechServerRejectedAuthentication$str() {
        return mechServerRejectedAuthentication;
    }
    @Override
    public final AuthenticationMechanismException mechServerRejectedAuthentication(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechServerRejectedAuthentication$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechServerAuthenticityCannotBeVerified = "ELY05049: [%s] Server authenticity cannot be verified";
    protected String mechServerAuthenticityCannotBeVerified$str() {
        return mechServerAuthenticityCannotBeVerified;
    }
    @Override
    public final AuthenticationMechanismException mechServerAuthenticityCannotBeVerified(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechServerAuthenticityCannotBeVerified$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechCallbackHandlerDoesNotSupportUserName = "ELY05050: [%s] Callback handler does not support user name";
    protected String mechCallbackHandlerDoesNotSupportUserName$str() {
        return mechCallbackHandlerDoesNotSupportUserName;
    }
    @Override
    public final AuthenticationMechanismException mechCallbackHandlerDoesNotSupportUserName(final String mechName, final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechCallbackHandlerDoesNotSupportUserName$str(), mechName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechCallbackHandlerDoesNotSupportCredentialAcquisition = "ELY05051: [%s] Callback handler does not support credential acquisition";
    protected String mechCallbackHandlerDoesNotSupportCredentialAcquisition$str() {
        return mechCallbackHandlerDoesNotSupportCredentialAcquisition;
    }
    @Override
    public final AuthenticationMechanismException mechCallbackHandlerDoesNotSupportCredentialAcquisition(final String mechName, final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechCallbackHandlerDoesNotSupportCredentialAcquisition$str(), mechName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechAuthorizationUnsupported = "ELY05052: [%s] Callback handler does not support authorization";
    protected String mechAuthorizationUnsupported$str() {
        return mechAuthorizationUnsupported;
    }
    @Override
    public final AuthenticationMechanismException mechAuthorizationUnsupported(final String mechName, final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechAuthorizationUnsupported$str(), mechName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechCallbackHandlerFailedForUnknownReason = "ELY05053: [%s] Callback handler failed for unknown reason";
    protected String mechCallbackHandlerFailedForUnknownReason$str() {
        return mechCallbackHandlerFailedForUnknownReason;
    }
    @Override
    public final AuthenticationMechanismException mechCallbackHandlerFailedForUnknownReason(final String mechName, final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechCallbackHandlerFailedForUnknownReason$str(), mechName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechSaltMustBeSpecified = "ELY05054: [%s] Salt must be specified";
    protected String mechSaltMustBeSpecified$str() {
        return mechSaltMustBeSpecified;
    }
    @Override
    public final AuthenticationMechanismException mechSaltMustBeSpecified(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechSaltMustBeSpecified$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechAuthenticationRejectedInvalidProof = "ELY05055: [%s] Authentication rejected (invalid proof)";
    protected String mechAuthenticationRejectedInvalidProof$str() {
        return mechAuthenticationRejectedInvalidProof;
    }
    @Override
    public final AuthenticationMechanismException mechAuthenticationRejectedInvalidProof(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechAuthenticationRejectedInvalidProof$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechClientSentExtraMessage = "ELY05056: [%s] Client sent extra message";
    protected String mechClientSentExtraMessage$str() {
        return mechClientSentExtraMessage;
    }
    @Override
    public final AuthenticationMechanismException mechClientSentExtraMessage(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechClientSentExtraMessage$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechServerSentExtraMessage = "ELY05057: [%s] Server sent extra message";
    protected String mechServerSentExtraMessage$str() {
        return mechServerSentExtraMessage;
    }
    @Override
    public final AuthenticationMechanismException mechServerSentExtraMessage(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechServerSentExtraMessage$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechAuthenticationFailed = "ELY05058: [%s] Authentication failed";
    protected String mechAuthenticationFailed$str() {
        return mechAuthenticationFailed;
    }
    @Override
    public final AuthenticationMechanismException mechAuthenticationFailed(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechAuthenticationFailed$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidMacInitializationKey = "ELY05059: [%s] Invalid MAC initialization key";
    protected String mechInvalidMacInitializationKey$str() {
        return mechInvalidMacInitializationKey;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidMacInitializationKey(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechInvalidMacInitializationKey$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String emptyNumber = "ELY05060: Empty number";
    protected String emptyNumber$str() {
        return emptyNumber;
    }
    @Override
    public final NumberFormatException emptyNumber() {
        final NumberFormatException result = new NumberFormatException(String.format(emptyNumber$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidNumericCharacter = "ELY05061: Invalid numeric character";
    protected String invalidNumericCharacter$str() {
        return invalidNumericCharacter;
    }
    @Override
    public final NumberFormatException invalidNumericCharacter() {
        final NumberFormatException result = new NumberFormatException(String.format(invalidNumericCharacter$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tooBigNumber = "ELY05062: Too big number";
    protected String tooBigNumber$str() {
        return tooBigNumber;
    }
    @Override
    public final NumberFormatException tooBigNumber() {
        final NumberFormatException result = new NumberFormatException(String.format(tooBigNumber$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechCannotGetTwoWayPasswordChars = "ELY05063: [%s] Cannot get clear password from two way password";
    protected String mechCannotGetTwoWayPasswordChars$str() {
        return mechCannotGetTwoWayPasswordChars;
    }
    @Override
    public final AuthenticationMechanismException mechCannotGetTwoWayPasswordChars(final String mechName, final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechCannotGetTwoWayPasswordChars$str(), mechName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechMacAlgorithmNotSupported = "ELY05064: [%s] Hashing algorithm not supported";
    protected String mechMacAlgorithmNotSupported$str() {
        return mechMacAlgorithmNotSupported;
    }
    @Override
    public final AuthenticationMechanismException mechMacAlgorithmNotSupported(final String mechName, final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechMacAlgorithmNotSupported$str(), mechName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechKeywordCannotBeEmpty = "ELY05065: [%s] keyword cannot be empty";
    protected String mechKeywordCannotBeEmpty$str() {
        return mechKeywordCannotBeEmpty;
    }
    @Override
    public final AuthenticationMechanismException mechKeywordCannotBeEmpty(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechKeywordCannotBeEmpty$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechNoValueFoundForKeyword = "ELY05066: [%s] No value found for keyword: %s";
    protected String mechNoValueFoundForKeyword$str() {
        return mechNoValueFoundForKeyword;
    }
    @Override
    public final AuthenticationMechanismException mechNoValueFoundForKeyword(final String mechName, final String keyword) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechNoValueFoundForKeyword$str(), mechName, keyword));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechKeywordNotFollowedByEqual = "ELY05067: [%s] '=' expected after keyword: %s";
    protected String mechKeywordNotFollowedByEqual$str() {
        return mechKeywordNotFollowedByEqual;
    }
    @Override
    public final AuthenticationMechanismException mechKeywordNotFollowedByEqual(final String mechName, final String keyword) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechKeywordNotFollowedByEqual$str(), mechName, keyword));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnmatchedQuoteFoundForValue = "ELY05068: [%s] Unmatched quote found for value: %s";
    protected String mechUnmatchedQuoteFoundForValue$str() {
        return mechUnmatchedQuoteFoundForValue;
    }
    @Override
    public final AuthenticationMechanismException mechUnmatchedQuoteFoundForValue(final String mechName, final String value) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechUnmatchedQuoteFoundForValue$str(), mechName, value));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechExpectingCommaOrLinearWhitespaceAfterQuoted = "ELY05069: [%s] Expecting comma or linear whitespace after quoted string: %s";
    protected String mechExpectingCommaOrLinearWhitespaceAfterQuoted$str() {
        return mechExpectingCommaOrLinearWhitespaceAfterQuoted;
    }
    @Override
    public final AuthenticationMechanismException mechExpectingCommaOrLinearWhitespaceAfterQuoted(final String mechName, final String value) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechExpectingCommaOrLinearWhitespaceAfterQuoted$str(), mechName, value));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechMessageTypeMustEqual = "ELY05070: [%s] MessageType must equal to %d, but it is %d";
    protected String mechMessageTypeMustEqual$str() {
        return mechMessageTypeMustEqual;
    }
    @Override
    public final AuthenticationMechanismException mechMessageTypeMustEqual(final String mechName, final int expected, final int actual) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechMessageTypeMustEqual$str(), mechName, expected, actual));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechBadSequenceNumberWhileUnwrapping = "ELY05071: [%s] Bad sequence number while unwrapping: expected %d, but %d received";
    protected String mechBadSequenceNumberWhileUnwrapping$str() {
        return mechBadSequenceNumberWhileUnwrapping;
    }
    @Override
    public final AuthenticationMechanismException mechBadSequenceNumberWhileUnwrapping(final String mechName, final int expected, final int actual) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechBadSequenceNumberWhileUnwrapping$str(), mechName, expected, actual));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechProblemDuringCrypt = "ELY05072: [%s] Problem during crypt";
    protected String mechProblemDuringCrypt$str() {
        return mechProblemDuringCrypt;
    }
    @Override
    public final AuthenticationMechanismException mechProblemDuringCrypt(final String mechName, final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechProblemDuringCrypt$str(), mechName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechProblemDuringDecrypt = "ELY05073: [%s] Problem during decrypt";
    protected String mechProblemDuringDecrypt$str() {
        return mechProblemDuringDecrypt;
    }
    @Override
    public final AuthenticationMechanismException mechProblemDuringDecrypt(final String mechName, final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechProblemDuringDecrypt$str(), mechName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnknownCipher = "ELY05074: [%s] Unknown cipher \"%s\"";
    protected String mechUnknownCipher$str() {
        return mechUnknownCipher;
    }
    @Override
    public final AuthenticationMechanismException mechUnknownCipher(final String mechName, final String cipher) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechUnknownCipher$str(), mechName, cipher));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechAuthorizationIdChanged = "ELY05075: [%s] Authorization ID changed unexpectedly";
    protected String mechAuthorizationIdChanged$str() {
        return mechAuthorizationIdChanged;
    }
    @Override
    public final AuthenticationMechanismException mechAuthorizationIdChanged(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechAuthorizationIdChanged$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechProblemGettingRequiredCipher = "ELY05076: [%s] Problem getting required cipher. Check your transformation mapper settings.";
    protected String mechProblemGettingRequiredCipher$str() {
        return mechProblemGettingRequiredCipher;
    }
    @Override
    public final AuthenticationMechanismException mechProblemGettingRequiredCipher(final String mechName, final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechProblemGettingRequiredCipher$str(), mechName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechNoCommonProtectionLayer = "ELY05077: [%s] No common protection layer between client and server";
    protected String mechNoCommonProtectionLayer$str() {
        return mechNoCommonProtectionLayer;
    }
    @Override
    public final AuthenticationMechanismException mechNoCommonProtectionLayer(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechNoCommonProtectionLayer$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechNoCommonCipher = "ELY05078: [%s] No common cipher between client and server";
    protected String mechNoCommonCipher$str() {
        return mechNoCommonCipher;
    }
    @Override
    public final AuthenticationMechanismException mechNoCommonCipher(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechNoCommonCipher$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechNoCiphersOfferedByServer = "ELY05079: [%s] No ciphers offered by server";
    protected String mechNoCiphersOfferedByServer$str() {
        return mechNoCiphersOfferedByServer;
    }
    @Override
    public final AuthenticationMechanismException mechNoCiphersOfferedByServer(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechNoCiphersOfferedByServer$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechNotProvidedUserName = "ELY05080: [%s] Callback handler not provided user name";
    protected String mechNotProvidedUserName$str() {
        return mechNotProvidedUserName;
    }
    @Override
    public final AuthenticationMechanismException mechNotProvidedUserName(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechNotProvidedUserName$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechNotProvidedPreDigested = "ELY05081: [%s] Callback handler not provided pre-digested password";
    protected String mechNotProvidedPreDigested$str() {
        return mechNotProvidedPreDigested;
    }
    @Override
    public final AuthenticationMechanismException mechNotProvidedPreDigested(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechNotProvidedPreDigested$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechNotProvidedClearPassword = "ELY05082: [%s] Callback handler not provided clear password";
    protected String mechNotProvidedClearPassword$str() {
        return mechNotProvidedClearPassword;
    }
    @Override
    public final AuthenticationMechanismException mechNotProvidedClearPassword(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechNotProvidedClearPassword$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechMissingDirective = "ELY05083: [%s] Missing \"%s\" directive";
    protected String mechMissingDirective$str() {
        return mechMissingDirective;
    }
    @Override
    public final AuthenticationMechanismException mechMissingDirective(final String mechName, final String directive) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechMissingDirective$str(), mechName, directive));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechNonceCountMustEqual = "ELY05084: [%s] nonce-count must equal to %d, but it is %d";
    protected String mechNonceCountMustEqual$str() {
        return mechNonceCountMustEqual;
    }
    @Override
    public final AuthenticationMechanismException mechNonceCountMustEqual(final String mechName, final int expected, final int actual) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechNonceCountMustEqual$str(), mechName, expected, actual));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnsupportedCharset = "ELY05085: [%s] Server is set to not support %s charset";
    protected String mechUnsupportedCharset$str() {
        return mechUnsupportedCharset;
    }
    @Override
    public final AuthenticationMechanismException mechUnsupportedCharset(final String mechName, final String charset) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechUnsupportedCharset$str(), mechName, charset));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnknownCharset = "ELY05086: [%s] Charset can be only \"utf-8\" or unspecified (to use ISO 8859-1)";
    protected String mechUnknownCharset$str() {
        return mechUnknownCharset;
    }
    @Override
    public final AuthenticationMechanismException mechUnknownCharset(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechUnknownCharset$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechDisallowedClientRealm = "ELY05087: [%s] Client selected realm not offered by server (%s)";
    protected String mechDisallowedClientRealm$str() {
        return mechDisallowedClientRealm;
    }
    @Override
    public final AuthenticationMechanismException mechDisallowedClientRealm(final String mechName, final String clientRealm) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechDisallowedClientRealm$str(), mechName, clientRealm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechMismatchedWrongDigestUri = "ELY05088: [%s] digest-uri \"%s\" not accepted";
    protected String mechMismatchedWrongDigestUri$str() {
        return mechMismatchedWrongDigestUri;
    }
    @Override
    public final AuthenticationMechanismException mechMismatchedWrongDigestUri(final String mechName, final String actual) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechMismatchedWrongDigestUri$str(), mechName, actual));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnexpectedQop = "ELY05089: [%s] Unexpected qop value: \"%s\"";
    protected String mechUnexpectedQop$str() {
        return mechUnexpectedQop;
    }
    @Override
    public final AuthenticationMechanismException mechUnexpectedQop(final String mechName, final String qop) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechUnexpectedQop$str(), mechName, qop));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String wrappingNotConfigured = "ELY05090: [%s] Wrapping is not configured";
    protected String wrappingNotConfigured$str() {
        return wrappingNotConfigured;
    }
    @Override
    public final IllegalStateException wrappingNotConfigured(final String mechName) {
        final IllegalStateException result = new IllegalStateException(String.format(wrappingNotConfigured$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechAuthenticationNameTooLong = "ELY05091: [%s] Authentication name string is too long";
    protected String mechAuthenticationNameTooLong$str() {
        return mechAuthenticationNameTooLong;
    }
    @Override
    public final AuthenticationMechanismException mechAuthenticationNameTooLong(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechAuthenticationNameTooLong$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechAuthenticationNameIsEmpty = "ELY05092: [%s] Authentication name is empty";
    protected String mechAuthenticationNameIsEmpty$str() {
        return mechAuthenticationNameIsEmpty;
    }
    @Override
    public final AuthenticationMechanismException mechAuthenticationNameIsEmpty(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechAuthenticationNameIsEmpty$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechAnonymousAuthorizationDenied = "ELY05093: [%s] Authorization for anonymous access is denied";
    protected String mechAnonymousAuthorizationDenied$str() {
        return mechAnonymousAuthorizationDenied;
    }
    @Override
    public final AuthenticationMechanismException mechAnonymousAuthorizationDenied(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechAnonymousAuthorizationDenied$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String requiredNegativePadding = "ELY05094: Required padded length (%d) is less than length of conversion result (%d)";
    protected String requiredNegativePadding$str() {
        return requiredNegativePadding;
    }
    @Override
    public final IllegalArgumentException requiredNegativePadding(final int totalLength, final int hexLength) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(requiredNegativePadding$str(), totalLength, hexLength));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidKeyForDigestHMAC = "ELY05095: Invalid key provided for Digest HMAC computing";
    protected String mechInvalidKeyForDigestHMAC$str() {
        return mechInvalidKeyForDigestHMAC;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidKeyForDigestHMAC() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechInvalidKeyForDigestHMAC$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnUnableToReadCertificateFromUrl = "ELY05096: Unable to read certificate from URL \"%s\"";
    protected String asnUnableToReadCertificateFromUrl$str() {
        return asnUnableToReadCertificateFromUrl;
    }
    @Override
    public final IOException asnUnableToReadCertificateFromUrl(final String url, final Throwable cause) {
        final IOException result = new IOException(String.format(asnUnableToReadCertificateFromUrl$str(), url), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToDetermineSubjectName = "ELY05097: Unable to determine subject name from X.509 certificate";
    protected String unableToDetermineSubjectName$str() {
        return unableToDetermineSubjectName;
    }
    @Override
    public final IllegalStateException unableToDetermineSubjectName(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(unableToDetermineSubjectName$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToVerifyClientSignature = "ELY05098: [%s] Unable to verify client signature";
    protected String mechUnableToVerifyClientSignature$str() {
        return mechUnableToVerifyClientSignature;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToVerifyClientSignature(final String mechName, final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechUnableToVerifyClientSignature$str(), mechName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToVerifyServerSignature = "ELY05099: [%s] Unable to verify server signature";
    protected String mechUnableToVerifyServerSignature$str() {
        return mechUnableToVerifyServerSignature;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToVerifyServerSignature(final String mechName, final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechUnableToVerifyServerSignature$str(), mechName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToObtainServerCertificate = "ELY05100: [%s] Unable to obtain other side certificate from URL \"%s\"";
    protected String mechUnableToObtainServerCertificate$str() {
        return mechUnableToObtainServerCertificate;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToObtainServerCertificate(final String mechName, final String url, final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechUnableToObtainServerCertificate$str(), mechName, url), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechCallbackHandlerNotProvidedServerCertificate = "ELY05101: [%s] Callback handler not provided URL of server certificate";
    protected String mechCallbackHandlerNotProvidedServerCertificate$str() {
        return mechCallbackHandlerNotProvidedServerCertificate;
    }
    @Override
    public final AuthenticationMechanismException mechCallbackHandlerNotProvidedServerCertificate(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechCallbackHandlerNotProvidedServerCertificate$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechCallbackHandlerNotProvidedClientCertificate = "ELY05102: [%s] Callback handler not provided URL of client certificate";
    protected String mechCallbackHandlerNotProvidedClientCertificate$str() {
        return mechCallbackHandlerNotProvidedClientCertificate;
    }
    @Override
    public final AuthenticationMechanismException mechCallbackHandlerNotProvidedClientCertificate(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechCallbackHandlerNotProvidedClientCertificate$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechServerIdentifierMismatch = "ELY05103: [%s] Server identifier mismatch";
    protected String mechServerIdentifierMismatch$str() {
        return mechServerIdentifierMismatch;
    }
    @Override
    public final AuthenticationMechanismException mechServerIdentifierMismatch(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechServerIdentifierMismatch$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechClientIdentifierMismatch = "ELY05104: [%s] Client identifier mismatch";
    protected String mechClientIdentifierMismatch$str() {
        return mechClientIdentifierMismatch;
    }
    @Override
    public final AuthenticationMechanismException mechClientIdentifierMismatch(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechClientIdentifierMismatch$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToDetermineClientName = "ELY05105: [%s] Unable to determine client name";
    protected String mechUnableToDetermineClientName$str() {
        return mechUnableToDetermineClientName;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToDetermineClientName(final String mechName, final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechUnableToDetermineClientName$str(), mechName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechCallbackHandlerNotProvidedPrivateKey = "ELY05106: [%s] Callback handler not provided private key";
    protected String mechCallbackHandlerNotProvidedPrivateKey$str() {
        return mechCallbackHandlerNotProvidedPrivateKey;
    }
    @Override
    public final AuthenticationMechanismException mechCallbackHandlerNotProvidedPrivateKey(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechCallbackHandlerNotProvidedPrivateKey$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToCreateSignature = "ELY05107: [%s] Unable to create signature";
    protected String mechUnableToCreateSignature$str() {
        return mechUnableToCreateSignature;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToCreateSignature(final String mechName, final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechUnableToCreateSignature$str(), mechName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToCreateResponseToken = "ELY05108: [%s] Unable to create response token";
    protected String mechUnableToCreateResponseToken$str() {
        return mechUnableToCreateResponseToken;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToCreateResponseToken(final String mechName, final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechUnableToCreateResponseToken$str(), mechName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToCreateResponseTokenWithCause = "ELY05109: [%s] Unable to create response token";
    protected String mechUnableToCreateResponseTokenWithCause$str() {
        return mechUnableToCreateResponseTokenWithCause;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToCreateResponseTokenWithCause(final String mechName, final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechUnableToCreateResponseTokenWithCause$str(), mechName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidValueForTrustedAuthorityType = "ELY05110: Invalid value for trusted authority type; expected a value between 0 and 4 (inclusive)";
    protected String invalidValueForTrustedAuthorityType$str() {
        return invalidValueForTrustedAuthorityType;
    }
    @Override
    public final IllegalArgumentException invalidValueForTrustedAuthorityType() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidValueForTrustedAuthorityType$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidValueForGeneralNameType = "ELY05111: Invalid value for a general name type; expected a value between 0 and 8 (inclusive)";
    protected String invalidValueForGeneralNameType$str() {
        return invalidValueForGeneralNameType;
    }
    @Override
    public final IllegalArgumentException invalidValueForGeneralNameType() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidValueForGeneralNameType$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechGettingSupportedMechanismsFailed = "ELY05112: Getting authentication mechanisms supported by GSS-API failed";
    protected String mechGettingSupportedMechanismsFailed$str() {
        return mechGettingSupportedMechanismsFailed;
    }
    @Override
    public final AuthenticationMechanismException mechGettingSupportedMechanismsFailed(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechGettingSupportedMechanismsFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToInitialiseOid = "ELY05113: Unable to initialize OID of Kerberos V5";
    protected String unableToInitialiseOid$str() {
        return unableToInitialiseOid;
    }
    @Override
    public final RuntimeException unableToInitialiseOid(final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(unableToInitialiseOid$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechReceiveBufferIsGreaterThanMaximum = "ELY05114: [%s] Receive buffer requested '%d' is greater than supported maximum '%d'";
    protected String mechReceiveBufferIsGreaterThanMaximum$str() {
        return mechReceiveBufferIsGreaterThanMaximum;
    }
    @Override
    public final AuthenticationMechanismException mechReceiveBufferIsGreaterThanMaximum(final String mechName, final int requested, final int maximum) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechReceiveBufferIsGreaterThanMaximum$str(), mechName, requested, maximum));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToWrapMessage = "ELY05115: [%s] Unable to wrap message";
    protected String mechUnableToWrapMessage$str() {
        return mechUnableToWrapMessage;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToWrapMessage(final String mechName, final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechUnableToWrapMessage$str(), mechName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToUnwrapMessage = "ELY05116: [%s] Unable to unwrap message";
    protected String mechUnableToUnwrapMessage$str() {
        return mechUnableToUnwrapMessage;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToUnwrapMessage(final String mechName, final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechUnableToUnwrapMessage$str(), mechName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToUnwrapSecurityLayerNegotiationMessage = "ELY05117: [%s] Unable to unwrap security layer negotiation message";
    protected String mechUnableToUnwrapSecurityLayerNegotiationMessage$str() {
        return mechUnableToUnwrapSecurityLayerNegotiationMessage;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToUnwrapSecurityLayerNegotiationMessage(final String mechName, final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechUnableToUnwrapSecurityLayerNegotiationMessage$str(), mechName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidMessageOnUnwrapping = "ELY05118: [%s] Invalid message of length %d on unwrapping";
    protected String mechInvalidMessageOnUnwrapping$str() {
        return mechInvalidMessageOnUnwrapping;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidMessageOnUnwrapping(final String mechName, final int length) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechInvalidMessageOnUnwrapping$str(), mechName, length));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechNegotiatedMechanismWasNotKerberosV5 = "ELY05119: [%s] Negotiated mechanism was not Kerberos V5";
    protected String mechNegotiatedMechanismWasNotKerberosV5$str() {
        return mechNegotiatedMechanismWasNotKerberosV5;
    }
    @Override
    public final AuthenticationMechanismException mechNegotiatedMechanismWasNotKerberosV5(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechNegotiatedMechanismWasNotKerberosV5$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInsufficientQopsAvailable = "ELY05120: [%s] Insufficient levels of protection available for supported security layers";
    protected String mechInsufficientQopsAvailable$str() {
        return mechInsufficientQopsAvailable;
    }
    @Override
    public final AuthenticationMechanismException mechInsufficientQopsAvailable(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechInsufficientQopsAvailable$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToGenerateChallenge = "ELY05121: [%s] Unable to generate security layer challenge";
    protected String mechUnableToGenerateChallenge$str() {
        return mechUnableToGenerateChallenge;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToGenerateChallenge(final String mechName, final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechUnableToGenerateChallenge$str(), mechName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechSelectedUnofferedQop = "ELY05122: [%s] Client selected a security layer that was not offered by server";
    protected String mechSelectedUnofferedQop$str() {
        return mechSelectedUnofferedQop;
    }
    @Override
    public final AuthenticationMechanismException mechSelectedUnofferedQop(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechSelectedUnofferedQop$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechNoSecurityLayerButLengthReceived = "ELY05123: [%s] No security layer selected but message length received";
    protected String mechNoSecurityLayerButLengthReceived$str() {
        return mechNoSecurityLayerButLengthReceived;
    }
    @Override
    public final AuthenticationMechanismException mechNoSecurityLayerButLengthReceived(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechNoSecurityLayerButLengthReceived$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToGetMaximumSizeOfMessage = "ELY05124: [%s] Unable to get maximum size of message before wrap";
    protected String mechUnableToGetMaximumSizeOfMessage$str() {
        return mechUnableToGetMaximumSizeOfMessage;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToGetMaximumSizeOfMessage(final String mechName, final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechUnableToGetMaximumSizeOfMessage$str(), mechName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToHandleResponseFromServer = "ELY05125: [%s] Unable to handle response from server";
    protected String mechUnableToHandleResponseFromServer$str() {
        return mechUnableToHandleResponseFromServer;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToHandleResponseFromServer(final String mechName, final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechUnableToHandleResponseFromServer$str(), mechName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechBadLengthOfMessageForNegotiatingSecurityLayer = "ELY05126: [%s] Bad length of message for negotiating security layer";
    protected String mechBadLengthOfMessageForNegotiatingSecurityLayer$str() {
        return mechBadLengthOfMessageForNegotiatingSecurityLayer;
    }
    @Override
    public final AuthenticationMechanismException mechBadLengthOfMessageForNegotiatingSecurityLayer(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechBadLengthOfMessageForNegotiatingSecurityLayer$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechReceivedMaxMessageSizeWhenNoSecurityLayer = "ELY05127: [%s] No security layer supported by server but maximum message size received: \"%d\"";
    protected String mechReceivedMaxMessageSizeWhenNoSecurityLayer$str() {
        return mechReceivedMaxMessageSizeWhenNoSecurityLayer;
    }
    @Override
    public final AuthenticationMechanismException mechReceivedMaxMessageSizeWhenNoSecurityLayer(final String mechName, final int length) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechReceivedMaxMessageSizeWhenNoSecurityLayer$str(), mechName, length));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechFailedToReadChallengeFile = "ELY05128: [%s] Failed to read challenge file";
    protected String mechFailedToReadChallengeFile$str() {
        return mechFailedToReadChallengeFile;
    }
    @Override
    public final AuthenticationMechanismException mechFailedToReadChallengeFile(final String mechName, final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechFailedToReadChallengeFile$str(), mechName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechFailedToCreateChallengeFile = "ELY05129: [%s] Failed to create challenge file";
    protected String mechFailedToCreateChallengeFile$str() {
        return mechFailedToCreateChallengeFile;
    }
    @Override
    public final AuthenticationMechanismException mechFailedToCreateChallengeFile(final String mechName, final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechFailedToCreateChallengeFile$str(), mechName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidNonAsciiSpace = "ELY05130: Invalid non-ASCII space \"0x%X\"";
    protected String invalidNonAsciiSpace$str() {
        return invalidNonAsciiSpace;
    }
    @Override
    public final IllegalArgumentException invalidNonAsciiSpace(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidNonAsciiSpace$str(), input));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidAsciiControl = "ELY05131: Invalid ASCII control \"0x%X\"";
    protected String invalidAsciiControl$str() {
        return invalidAsciiControl;
    }
    @Override
    public final IllegalArgumentException invalidAsciiControl(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidAsciiControl$str(), input));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidNonAsciiControl = "ELY05132: Invalid non-ASCII control \"0x%X\"";
    protected String invalidNonAsciiControl$str() {
        return invalidNonAsciiControl;
    }
    @Override
    public final IllegalArgumentException invalidNonAsciiControl(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidNonAsciiControl$str(), input));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPrivateUseCharacter = "ELY05133: Invalid private use character \"0x%X\"";
    protected String invalidPrivateUseCharacter$str() {
        return invalidPrivateUseCharacter;
    }
    @Override
    public final IllegalArgumentException invalidPrivateUseCharacter(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidPrivateUseCharacter$str(), input));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidNonCharacterCodePoint = "ELY05134: Invalid non-character code point \"0x%X\"";
    protected String invalidNonCharacterCodePoint$str() {
        return invalidNonCharacterCodePoint;
    }
    @Override
    public final IllegalArgumentException invalidNonCharacterCodePoint(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidNonCharacterCodePoint$str(), input));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidSurrogateCodePoint = "ELY05135: Invalid surrogate code point \"0x%X\"";
    protected String invalidSurrogateCodePoint$str() {
        return invalidSurrogateCodePoint;
    }
    @Override
    public final IllegalArgumentException invalidSurrogateCodePoint(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidSurrogateCodePoint$str(), input));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPlainTextCodePoint = "ELY05136: Invalid plain text code point \"0x%X\"";
    protected String invalidPlainTextCodePoint$str() {
        return invalidPlainTextCodePoint;
    }
    @Override
    public final IllegalArgumentException invalidPlainTextCodePoint(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidPlainTextCodePoint$str(), input));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidNonCanonicalCodePoint = "ELY05137: Invalid non-canonical code point \"0x%X\"";
    protected String invalidNonCanonicalCodePoint$str() {
        return invalidNonCanonicalCodePoint;
    }
    @Override
    public final IllegalArgumentException invalidNonCanonicalCodePoint(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidNonCanonicalCodePoint$str(), input));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidControlCharacter = "ELY05138: Invalid control character \"0x%X\"";
    protected String invalidControlCharacter$str() {
        return invalidControlCharacter;
    }
    @Override
    public final IllegalArgumentException invalidControlCharacter(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidControlCharacter$str(), input));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidTaggingCharacter = "ELY05139: Invalid tagging character \"0x%X\"";
    protected String invalidTaggingCharacter$str() {
        return invalidTaggingCharacter;
    }
    @Override
    public final IllegalArgumentException invalidTaggingCharacter(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidTaggingCharacter$str(), input));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unassignedCodePoint = "ELY05140: Unassigned code point \"0x%X\"";
    protected String unassignedCodePoint$str() {
        return unassignedCodePoint;
    }
    @Override
    public final IllegalArgumentException unassignedCodePoint(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(unassignedCodePoint$str(), input));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidSurrogatePairHightAtEnd = "ELY05141: Invalid surrogate pair (high at end of string) \"0x%X\"";
    protected String invalidSurrogatePairHightAtEnd$str() {
        return invalidSurrogatePairHightAtEnd;
    }
    @Override
    public final IllegalArgumentException invalidSurrogatePairHightAtEnd(final char input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidSurrogatePairHightAtEnd$str(), input));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidSurrogatePairSecondIsNotLow = "ELY05142: Invalid surrogate pair (second is not low) \"0x%X 0x%X\"";
    protected String invalidSurrogatePairSecondIsNotLow$str() {
        return invalidSurrogatePairSecondIsNotLow;
    }
    @Override
    public final IllegalArgumentException invalidSurrogatePairSecondIsNotLow(final char high, final char low) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidSurrogatePairSecondIsNotLow$str(), high, low));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidSurrogatePairLowWithoutHigh = "ELY05143: Invalid surrogate pair (low without high) \"0x%X\"";
    protected String invalidSurrogatePairLowWithoutHigh$str() {
        return invalidSurrogatePairLowWithoutHigh;
    }
    @Override
    public final IllegalArgumentException invalidSurrogatePairLowWithoutHigh(final char low) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidSurrogatePairLowWithoutHigh$str(), low));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidCodePoint = "ELY05144: Invalid code point \"0x%X\"";
    protected String invalidCodePoint$str() {
        return invalidCodePoint;
    }
    @Override
    public final IllegalArgumentException invalidCodePoint(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidCodePoint$str(), input));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String disallowedRalDirectionalityInL = "ELY05145: Disallowed R/AL directionality character in L string";
    protected String disallowedRalDirectionalityInL$str() {
        return disallowedRalDirectionalityInL;
    }
    @Override
    public final IllegalArgumentException disallowedRalDirectionalityInL() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(disallowedRalDirectionalityInL$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String disallowedLDirectionalityInRal = "ELY05146: Disallowed L directionality character in R/AL string";
    protected String disallowedLDirectionalityInRal$str() {
        return disallowedLDirectionalityInRal;
    }
    @Override
    public final IllegalArgumentException disallowedLDirectionalityInRal() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(disallowedLDirectionalityInRal$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingTrailingRal = "ELY05147: Missing trailing R/AL directionality character";
    protected String missingTrailingRal$str() {
        return missingTrailingRal;
    }
    @Override
    public final IllegalArgumentException missingTrailingRal() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(missingTrailingRal$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidEscapeSequence = "ELY05148: Invalid escape sequence";
    protected String invalidEscapeSequence$str() {
        return invalidEscapeSequence;
    }
    @Override
    public final IllegalArgumentException invalidEscapeSequence() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidEscapeSequence$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechAuthenticationNameChanged = "ELY05149: [%s] Authentication name changed unexpectedly";
    protected String mechAuthenticationNameChanged$str() {
        return mechAuthenticationNameChanged;
    }
    @Override
    public final AuthenticationMechanismException mechAuthenticationNameChanged(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechAuthenticationNameChanged$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechAuthorizationIdTooLong = "ELY05150: [%s] Authentication mechanism authorization ID is too long";
    protected String mechAuthorizationIdTooLong$str() {
        return mechAuthorizationIdTooLong;
    }
    @Override
    public final AuthenticationMechanismException mechAuthorizationIdTooLong(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechAuthorizationIdTooLong$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidOTPAlgorithm = "ELY05151: Invalid OTP algorithm \"%s\"";
    protected String mechInvalidOTPAlgorithm$str() {
        return mechInvalidOTPAlgorithm;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidOTPAlgorithm(final String algorithm) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechInvalidOTPAlgorithm$str(), algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidOTPResponseType = "ELY05152: Invalid OTP response type";
    protected String mechInvalidOTPResponseType$str() {
        return mechInvalidOTPResponseType;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidOTPResponseType() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechInvalidOTPResponseType$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechIncorrectParity = "ELY05153: [%s] Incorrect parity in SASL client message";
    protected String mechIncorrectParity$str() {
        return mechIncorrectParity;
    }
    @Override
    public final AuthenticationMechanismException mechIncorrectParity(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechIncorrectParity$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidCharacterInSeed = "ELY05154: [%s] Invalid character in seed";
    protected String mechInvalidCharacterInSeed$str() {
        return mechInvalidCharacterInSeed;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidCharacterInSeed(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechInvalidCharacterInSeed$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidOTPSeed = "ELY05155: Invalid OTP seed, must be between 1 and 16 characters long";
    protected String mechInvalidOTPSeed$str() {
        return mechInvalidOTPSeed;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidOTPSeed() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechInvalidOTPSeed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidOTPPassPhrase = "ELY05156: Invalid OTP pass phrase, must be between 10 and 63 characters long";
    protected String mechInvalidOTPPassPhrase$str() {
        return mechInvalidOTPPassPhrase;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidOTPPassPhrase() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechInvalidOTPPassPhrase$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidOTPSequenceNumber = "ELY05157: Invalid OTP sequence number";
    protected String mechInvalidOTPSequenceNumber$str() {
        return mechInvalidOTPSequenceNumber;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidOTPSequenceNumber() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechInvalidOTPSequenceNumber$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidOTP = "ELY05158: Invalid OTP";
    protected String mechInvalidOTP$str() {
        return mechInvalidOTP;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidOTP() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechInvalidOTP$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechOTPPassPhraseAndSeedMustNotMatch = "ELY05159: OTP pass phrase and seed must not match";
    protected String mechOTPPassPhraseAndSeedMustNotMatch$str() {
        return mechOTPPassPhraseAndSeedMustNotMatch;
    }
    @Override
    public final AuthenticationMechanismException mechOTPPassPhraseAndSeedMustNotMatch() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechOTPPassPhraseAndSeedMustNotMatch$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidOTPAlternateDictionary = "ELY05160: Invalid OTP alternate dictionary";
    protected String mechInvalidOTPAlternateDictionary$str() {
        return mechInvalidOTPAlternateDictionary;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidOTPAlternateDictionary() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechInvalidOTPAlternateDictionary$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToRetrievePassword = "ELY05161: [%s] Unable to retrieve password for \"%s\"";
    protected String mechUnableToRetrievePassword$str() {
        return mechUnableToRetrievePassword;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToRetrievePassword(final String mechName, final String userName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechUnableToRetrievePassword$str(), mechName, userName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToUpdatePassword = "ELY05162: [%s] Unable to update password for \"%s\"";
    protected String mechUnableToUpdatePassword$str() {
        return mechUnableToUpdatePassword;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToUpdatePassword(final String mechName, final String userName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechUnableToUpdatePassword$str(), mechName, userName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechServerTimedOut = "ELY05163: [%s] Authentication mechanism server timed out";
    protected String mechServerTimedOut$str() {
        return mechServerTimedOut;
    }
    @Override
    public final AuthenticationMechanismException mechServerTimedOut(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechServerTimedOut$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToObtainExclusiveAccess = "ELY05164: [%s] Unable to obtain exclusive access for \"%s\"";
    protected String mechUnableToObtainExclusiveAccess$str() {
        return mechUnableToObtainExclusiveAccess;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToObtainExclusiveAccess(final String mechName, final String userName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechUnableToObtainExclusiveAccess$str(), mechName, userName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechOTPReinitializationFailed = "ELY05165: OTP re-initialization failed";
    protected String mechOTPReinitializationFailed$str() {
        return mechOTPReinitializationFailed;
    }
    @Override
    public final AuthenticationMechanismException mechOTPReinitializationFailed(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechOTPReinitializationFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String scramServerRejectedAuthentication = "ELY05166: [%s] Server rejected authentication";
    protected String scramServerRejectedAuthentication$str() {
        return scramServerRejectedAuthentication;
    }
    @Override
    public final ScramServerException scramServerRejectedAuthentication(final String mechName, final ScramServerErrorCode errorCode) {
        final ScramServerException result = new ScramServerException(String.format(scramServerRejectedAuthentication$str(), mechName), errorCode);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidOTPPasswordFormatType = "ELY05167: Invalid OTP password format type";
    protected String mechInvalidOTPPasswordFormatType$str() {
        return mechInvalidOTPPasswordFormatType;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidOTPPasswordFormatType() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechInvalidOTPPasswordFormatType$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnsupportedAlgorithm = "ELY05168: [%s] Unsupported algorithm selected \"%s\"";
    protected String mechUnsupportedAlgorithm$str() {
        return mechUnsupportedAlgorithm;
    }
    @Override
    public final AuthenticationMechanismException mechUnsupportedAlgorithm(final String mechName, final String algorithm) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechUnsupportedAlgorithm$str(), mechName, algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechResponseTokenMismatch = "ELY05169: [%s] Clients response token does not match expected token";
    protected String mechResponseTokenMismatch$str() {
        return mechResponseTokenMismatch;
    }
    @Override
    public final String mechResponseTokenMismatch(final String mechName) {
        return String.format(mechResponseTokenMismatch$str(), mechName);
    }
    private static final String mechProblemDuringCryptResultIsNull = "ELY05170: [%s] Problem during crypt: The encrypted result is null. The input data has a length of zero or too short to result in a new block.";
    protected String mechProblemDuringCryptResultIsNull$str() {
        return mechProblemDuringCryptResultIsNull;
    }
    @Override
    public final AuthenticationMechanismException mechProblemDuringCryptResultIsNull(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechProblemDuringCryptResultIsNull$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechProblemDuringDecryptResultIsNull = "ELY05171: [%s] Problem during decrypt: The decrypted result is null. The input data has a length of zero or too short to result in a new block.";
    protected String mechProblemDuringDecryptResultIsNull$str() {
        return mechProblemDuringDecryptResultIsNull;
    }
    @Override
    public final AuthenticationMechanismException mechProblemDuringDecryptResultIsNull(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(mechProblemDuringDecryptResultIsNull$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToLocateMechanismConfiguration = "ELY05172: Unable to locate MechanismConfiguration for mechanism.";
    protected String unableToLocateMechanismConfiguration$str() {
        return unableToLocateMechanismConfiguration;
    }
    @Override
    public final AuthenticationMechanismException unableToLocateMechanismConfiguration(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(unableToLocateMechanismConfiguration$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToObtainServerCredential = "ELY05173: [%s] Unable to obtain server credential.";
    protected String unableToObtainServerCredential$str() {
        return unableToObtainServerCredential;
    }
    @Override
    public final AuthenticationMechanismException unableToObtainServerCredential(final String mechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(unableToObtainServerCredential$str(), mechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String statusCodeNotNow = "ELY06000: Status code can not be set at this time.";
    protected String statusCodeNotNow$str() {
        return statusCodeNotNow;
    }
    @Override
    public final IllegalStateException statusCodeNotNow() {
        final IllegalStateException result = new IllegalStateException(String.format(statusCodeNotNow$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String incorrectlyFormattedHeader = "ELY06001: An incorrectly formatted '%s'header was encountered.";
    protected String incorrectlyFormattedHeader$str() {
        return incorrectlyFormattedHeader;
    }
    @Override
    public final String incorrectlyFormattedHeader(final String headerName) {
        return String.format(incorrectlyFormattedHeader$str(), headerName);
    }
    private static final String authenticationFailed2 = "ELY06002: An authentication attempt for user '%s' failed validation using mechanism '%s'.";
    protected String authenticationFailed2$str() {
        return authenticationFailed2;
    }
    @Override
    public final String authenticationFailed(final String username, final String mechanismName) {
        return String.format(authenticationFailed2$str(), username, mechanismName);
    }
    private static final String authenticationFailed1 = "ELY06003: An authentication attempt failed validation using mechanism '%s'.";
    protected String authenticationFailed1$str() {
        return authenticationFailed1;
    }
    @Override
    public final String authenticationFailed(final String mechanismName) {
        return String.format(authenticationFailed1$str(), mechanismName);
    }
    private static final String httpSessionNotSupported = "ELY06004: Session management not supported. This is probably because no HttpSessionSpi was implemented for the underlying container.";
    protected String httpSessionNotSupported$str() {
        return httpSessionNotSupported;
    }
    @Override
    public final IllegalStateException httpSessionNotSupported() {
        final IllegalStateException result = new IllegalStateException(String.format(httpSessionNotSupported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noAttachmentSupport = "ELY06005: Attachments are not supported on this scope.";
    protected String noAttachmentSupport$str() {
        return noAttachmentSupport;
    }
    @Override
    public final UnsupportedOperationException noAttachmentSupport() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(noAttachmentSupport$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String authorizationFailed = "ELY06006: An authorization check for user '%s' failed using mechanism '%s'.";
    protected String authorizationFailed$str() {
        return authorizationFailed;
    }
    @Override
    public final String authorizationFailed(final String username, final String mechanismName) {
        return String.format(authorizationFailed$str(), username, mechanismName);
    }
    private static final String usernameOrPasswordMissing = "ELY06007: Username or password missing from authentication attempt.";
    protected String usernameOrPasswordMissing$str() {
        return usernameOrPasswordMissing;
    }
    @Override
    public final String usernameOrPasswordMissing() {
        return String.format(usernameOrPasswordMissing$str());
    }
    @Override
    public final void warnHttpMechSsoFailedLogoutParticipant(final String url, final Throwable cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, cause, warnHttpMechSsoFailedLogoutParticipant$str(), url);
    }
    private static final String warnHttpMechSsoFailedLogoutParticipant = "ELY06008: Failed to logout participant [%s]. Participant will be removed from list of participants but its local session may still be active.";
    protected String warnHttpMechSsoFailedLogoutParticipant$str() {
        return warnHttpMechSsoFailedLogoutParticipant;
    }
    private static final String httpMechSsoInvalidLogoutMessage = "ELY06012: Invalid logout message received for local session [%s]";
    protected String httpMechSsoInvalidLogoutMessage$str() {
        return httpMechSsoInvalidLogoutMessage;
    }
    @Override
    public final IllegalStateException httpMechSsoInvalidLogoutMessage(final String localSessionId) {
        final IllegalStateException result = new IllegalStateException(String.format(httpMechSsoInvalidLogoutMessage$str(), localSessionId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void errorHttpMechSsoFailedInvalidateLocalSession(final Throwable cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, cause, errorHttpMechSsoFailedInvalidateLocalSession$str());
    }
    private static final String errorHttpMechSsoFailedInvalidateLocalSession = "ELY06013: Failed to invalidate local session";
    protected String errorHttpMechSsoFailedInvalidateLocalSession$str() {
        return errorHttpMechSsoFailedInvalidateLocalSession;
    }
    private static final String httpServerAuthenticationMechanismNotFound = "ELY06014: Authentication mechanism '%s' cannot be found";
    protected String httpServerAuthenticationMechanismNotFound$str() {
        return httpServerAuthenticationMechanismNotFound;
    }
    @Override
    public final HttpAuthenticationException httpServerAuthenticationMechanismNotFound(final String mechanismName) {
        final HttpAuthenticationException result = new HttpAuthenticationException(String.format(httpServerAuthenticationMechanismNotFound$str(), mechanismName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String digestMechanismRequireRealm = "ELY06015: Unable to authenticate using DIGEST mechanism - realm name needs to be specified";
    protected String digestMechanismRequireRealm$str() {
        return digestMechanismRequireRealm;
    }
    @Override
    public final HttpAuthenticationException digestMechanismRequireRealm() {
        final HttpAuthenticationException result = new HttpAuthenticationException(String.format(digestMechanismRequireRealm$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String httpAuthenticationFailedEvaluatingRequest = "ELY06016: HTTP authentication failed validating request, no mechanisms remain to continue authentication.";
    protected String httpAuthenticationFailedEvaluatingRequest$str() {
        return httpAuthenticationFailedEvaluatingRequest;
    }
    @Override
    public final HttpAuthenticationException httpAuthenticationFailedEvaluatingRequest() {
        final HttpAuthenticationException result = new HttpAuthenticationException(String.format(httpAuthenticationFailedEvaluatingRequest$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String httpAuthenticationNoMechanisms = "ELY06017: HTTP authentication is required but no authentication mechansims are available.";
    protected String httpAuthenticationNoMechanisms$str() {
        return httpAuthenticationNoMechanisms;
    }
    @Override
    public final HttpAuthenticationException httpAuthenticationNoMechanisms() {
        final HttpAuthenticationException result = new HttpAuthenticationException(String.format(httpAuthenticationNoMechanisms$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String httpAuthenticationNoSuccessfulResponder = "ELY06018: HTTP authentication none of the responders successfuly sent a response.";
    protected String httpAuthenticationNoSuccessfulResponder$str() {
        return httpAuthenticationNoSuccessfulResponder;
    }
    @Override
    public final HttpAuthenticationException httpAuthenticationNoSuccessfulResponder() {
        final HttpAuthenticationException result = new HttpAuthenticationException(String.format(httpAuthenticationNoSuccessfulResponder$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String digestMechanismInvalidRealm = "ELY06019: Unable to authenticate using DIGEST mechanism - mechanism realm name (%s) is not valid";
    protected String digestMechanismInvalidRealm$str() {
        return digestMechanismInvalidRealm;
    }
    @Override
    public final HttpAuthenticationException digestMechanismInvalidRealm(final String realm) {
        final HttpAuthenticationException result = new HttpAuthenticationException(String.format(digestMechanismInvalidRealm$str(), realm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnUnrecognisedAlgorithm = "ELY07001: Unrecognized encoding algorithm [%s]";
    protected String asnUnrecognisedAlgorithm$str() {
        return asnUnrecognisedAlgorithm;
    }
    @Override
    public final ASN1Exception asnUnrecognisedAlgorithm(final String algorithm) {
        final ASN1Exception result = new ASN1Exception(String.format(asnUnrecognisedAlgorithm$str(), algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnInvalidGeneralNameType = "ELY07002: Invalid general name type";
    protected String asnInvalidGeneralNameType$str() {
        return asnInvalidGeneralNameType;
    }
    @Override
    public final ASN1Exception asnInvalidGeneralNameType() {
        final ASN1Exception result = new ASN1Exception(String.format(asnInvalidGeneralNameType$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnInvalidTrustedAuthorityType = "ELY07003: Invalid trusted authority type";
    protected String asnInvalidTrustedAuthorityType$str() {
        return asnInvalidTrustedAuthorityType;
    }
    @Override
    public final ASN1Exception asnInvalidTrustedAuthorityType() {
        final ASN1Exception result = new ASN1Exception(String.format(asnInvalidTrustedAuthorityType$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnUnexpectedTag = "ELY07004: Unexpected ASN.1 tag encountered";
    protected String asnUnexpectedTag$str() {
        return asnUnexpectedTag;
    }
    @Override
    public final ASN1Exception asnUnexpectedTag() {
        final ASN1Exception result = new ASN1Exception(String.format(asnUnexpectedTag$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnUnableToReadCertificateData = "ELY07005: Unable to read X.509 certificate data";
    protected String asnUnableToReadCertificateData$str() {
        return asnUnableToReadCertificateData;
    }
    @Override
    public final ASN1Exception asnUnableToReadCertificateData(final Throwable cause) {
        final ASN1Exception result = new ASN1Exception(String.format(asnUnableToReadCertificateData$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnInvalidGeneralNameForUriType = "ELY07006: Invalid general name for URI type";
    protected String asnInvalidGeneralNameForUriType$str() {
        return asnInvalidGeneralNameForUriType;
    }
    @Override
    public final ASN1Exception asnInvalidGeneralNameForUriType(final Throwable cause) {
        final ASN1Exception result = new ASN1Exception(String.format(asnInvalidGeneralNameForUriType$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnInvalidGeneralNameForIpAddressType = "ELY07007: Invalid general name for IP address type";
    protected String asnInvalidGeneralNameForIpAddressType$str() {
        return asnInvalidGeneralNameForIpAddressType;
    }
    @Override
    public final ASN1Exception asnInvalidGeneralNameForIpAddressType() {
        final ASN1Exception result = new ASN1Exception(String.format(asnInvalidGeneralNameForIpAddressType$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnIpAddressGeneralNameCannotBeResolved = "ELY07008: IP address general name cannot be resolved";
    protected String asnIpAddressGeneralNameCannotBeResolved$str() {
        return asnIpAddressGeneralNameCannotBeResolved;
    }
    @Override
    public final ASN1Exception asnIpAddressGeneralNameCannotBeResolved(final Throwable cause) {
        final ASN1Exception result = new ASN1Exception(String.format(asnIpAddressGeneralNameCannotBeResolved$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSequenceToEnd = "ELY07009: No sequence to end";
    protected String noSequenceToEnd$str() {
        return noSequenceToEnd;
    }
    @Override
    public final IllegalStateException noSequenceToEnd() {
        final IllegalStateException result = new IllegalStateException(String.format(noSequenceToEnd$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSetToEnd = "ELY07010: No set to end";
    protected String noSetToEnd$str() {
        return noSetToEnd;
    }
    @Override
    public final IllegalStateException noSetToEnd() {
        final IllegalStateException result = new IllegalStateException(String.format(noSetToEnd$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noExplicitlyTaggedElementToEnd = "ELY07011: No explicitly tagged element to end";
    protected String noExplicitlyTaggedElementToEnd$str() {
        return noExplicitlyTaggedElementToEnd;
    }
    @Override
    public final IllegalStateException noExplicitlyTaggedElementToEnd() {
        final IllegalStateException result = new IllegalStateException(String.format(noExplicitlyTaggedElementToEnd$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnUnexpectedEndOfInput = "ELY07012: Unexpected end of input";
    protected String asnUnexpectedEndOfInput$str() {
        return asnUnexpectedEndOfInput;
    }
    @Override
    public final ASN1Exception asnUnexpectedEndOfInput() {
        final ASN1Exception result = new ASN1Exception(String.format(asnUnexpectedEndOfInput$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnInvalidNumberOfUnusedBits = "ELY07013: Invalid number of unused bits";
    protected String asnInvalidNumberOfUnusedBits$str() {
        return asnInvalidNumberOfUnusedBits;
    }
    @Override
    public final ASN1Exception asnInvalidNumberOfUnusedBits() {
        final ASN1Exception result = new ASN1Exception(String.format(asnInvalidNumberOfUnusedBits$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnNonZeroLengthForNullTypeTag = "ELY07014: Non-zero length encountered for null type tag";
    protected String asnNonZeroLengthForNullTypeTag$str() {
        return asnNonZeroLengthForNullTypeTag;
    }
    @Override
    public final ASN1Exception asnNonZeroLengthForNullTypeTag() {
        final ASN1Exception result = new ASN1Exception(String.format(asnNonZeroLengthForNullTypeTag$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnInvalidHighTagNumberForm = "ELY07015: Invalid high-tag-number form";
    protected String asnInvalidHighTagNumberForm$str() {
        return asnInvalidHighTagNumberForm;
    }
    @Override
    public final ASN1Exception asnInvalidHighTagNumberForm() {
        final ASN1Exception result = new ASN1Exception(String.format(asnInvalidHighTagNumberForm$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnLengthEncodingExceeds4bytes = "ELY07016: Length encoding exceeds 4 bytes";
    protected String asnLengthEncodingExceeds4bytes$str() {
        return asnLengthEncodingExceeds4bytes;
    }
    @Override
    public final ASN1Exception asnLengthEncodingExceeds4bytes() {
        final ASN1Exception result = new ASN1Exception(String.format(asnLengthEncodingExceeds4bytes$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnInvalidOidCharacter = "ELY07017: Invalid OID character";
    protected String asnInvalidOidCharacter$str() {
        return asnInvalidOidCharacter;
    }
    @Override
    public final ASN1Exception asnInvalidOidCharacter() {
        final ASN1Exception result = new ASN1Exception(String.format(asnInvalidOidCharacter$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnOidMustHaveAtLeast2Components = "ELY07018: OID must have at least 2 components";
    protected String asnOidMustHaveAtLeast2Components$str() {
        return asnOidMustHaveAtLeast2Components;
    }
    @Override
    public final ASN1Exception asnOidMustHaveAtLeast2Components() {
        final ASN1Exception result = new ASN1Exception(String.format(asnOidMustHaveAtLeast2Components$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnInvalidValueForFirstOidComponent = "ELY07019: Invalid value for first OID component; expected 0, 1, or 2";
    protected String asnInvalidValueForFirstOidComponent$str() {
        return asnInvalidValueForFirstOidComponent;
    }
    @Override
    public final ASN1Exception asnInvalidValueForFirstOidComponent() {
        final ASN1Exception result = new ASN1Exception(String.format(asnInvalidValueForFirstOidComponent$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnInvalidValueForSecondOidComponent = "ELY07020: Invalid value for second OID component; expected a value between 0 and 39 (inclusive)";
    protected String asnInvalidValueForSecondOidComponent$str() {
        return asnInvalidValueForSecondOidComponent;
    }
    @Override
    public final ASN1Exception asnInvalidValueForSecondOidComponent() {
        final ASN1Exception result = new ASN1Exception(String.format(asnInvalidValueForSecondOidComponent$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnInvalidLength = "ELY07021: Invalid length";
    protected String asnInvalidLength$str() {
        return asnInvalidLength;
    }
    @Override
    public final ASN1Exception asnInvalidLength() {
        final ASN1Exception result = new ASN1Exception(String.format(asnInvalidLength$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnUnknownTagType = "ELY07022: Unknown tag type: %d";
    protected String asnUnknownTagType$str() {
        return asnUnknownTagType;
    }
    @Override
    public final ASN1Exception asnUnknownTagType(final int type) {
        final ASN1Exception result = new ASN1Exception(String.format(asnUnknownTagType$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnUnexpectedCharacterByteForPrintableString = "ELY07023: Unexpected character byte for printable string";
    protected String asnUnexpectedCharacterByteForPrintableString$str() {
        return asnUnexpectedCharacterByteForPrintableString;
    }
    @Override
    public final ASN1Exception asnUnexpectedCharacterByteForPrintableString() {
        final ASN1Exception result = new ASN1Exception(String.format(asnUnexpectedCharacterByteForPrintableString$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecUnrecognizedKeySpecAlgorithm = "ELY08001: Unrecognized key spec algorithm";
    protected String invalidKeySpecUnrecognizedKeySpecAlgorithm$str() {
        return invalidKeySpecUnrecognizedKeySpecAlgorithm;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecUnrecognizedKeySpecAlgorithm() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(invalidKeySpecUnrecognizedKeySpecAlgorithm$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecPasswordSpecCannotBeRenderedAsString = "ELY08002: Password spec cannot be rendered as a string";
    protected String invalidKeySpecPasswordSpecCannotBeRenderedAsString$str() {
        return invalidKeySpecPasswordSpecCannotBeRenderedAsString;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecPasswordSpecCannotBeRenderedAsString() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(invalidKeySpecPasswordSpecCannotBeRenderedAsString$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecUnknownCryptStringAlgorithm = "ELY08003: Unknown crypt string algorithm";
    protected String invalidKeySpecUnknownCryptStringAlgorithm$str() {
        return invalidKeySpecUnknownCryptStringAlgorithm;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecUnknownCryptStringAlgorithm() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(invalidKeySpecUnknownCryptStringAlgorithm$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecInvalidCharacterEncountered = "ELY08004: Invalid character encountered";
    protected String invalidKeySpecInvalidCharacterEncountered$str() {
        return invalidKeySpecInvalidCharacterEncountered;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecInvalidCharacterEncountered() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(invalidKeySpecInvalidCharacterEncountered$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecNoIterationCountTerminatorGiven = "ELY08005: No iteration count terminator given";
    protected String invalidKeySpecNoIterationCountTerminatorGiven$str() {
        return invalidKeySpecNoIterationCountTerminatorGiven;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecNoIterationCountTerminatorGiven() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(invalidKeySpecNoIterationCountTerminatorGiven$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecUnexpectedEndOfInputString = "ELY08006: Unexpected end of input string";
    protected String invalidKeySpecUnexpectedEndOfInputString$str() {
        return invalidKeySpecUnexpectedEndOfInputString;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecUnexpectedEndOfInputString() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(invalidKeySpecUnexpectedEndOfInputString$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecNoSaltTerminatorGiven = "ELY08007: No salt terminator given";
    protected String invalidKeySpecNoSaltTerminatorGiven$str() {
        return invalidKeySpecNoSaltTerminatorGiven;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecNoSaltTerminatorGiven() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(invalidKeySpecNoSaltTerminatorGiven$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidHashLength = "ELY08008: Invalid hash length";
    protected String invalidHashLength$str() {
        return invalidHashLength;
    }
    @Override
    public final IllegalArgumentException invalidHashLength() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidHashLength$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecUnexpectedEndOfPasswordString = "ELY08009: Unexpected end of password string";
    protected String invalidKeySpecUnexpectedEndOfPasswordString$str() {
        return invalidKeySpecUnexpectedEndOfPasswordString;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecUnexpectedEndOfPasswordString() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(invalidKeySpecUnexpectedEndOfPasswordString$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecUnexpectedEndOfPasswordStringWithCause = "ELY08010: Unexpected end of password string";
    protected String invalidKeySpecUnexpectedEndOfPasswordStringWithCause$str() {
        return invalidKeySpecUnexpectedEndOfPasswordStringWithCause;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecUnexpectedEndOfPasswordStringWithCause(final Throwable cause) {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(invalidKeySpecUnexpectedEndOfPasswordStringWithCause$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecInvalidMinorVersion = "ELY08011: Invalid minor version";
    protected String invalidKeySpecInvalidMinorVersion$str() {
        return invalidKeySpecInvalidMinorVersion;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecInvalidMinorVersion() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(invalidKeySpecInvalidMinorVersion$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecCostMustBeTwoDigitInteger = "ELY08012: Invalid cost: must be a two digit integer";
    protected String invalidKeySpecCostMustBeTwoDigitInteger$str() {
        return invalidKeySpecCostMustBeTwoDigitInteger;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecCostMustBeTwoDigitInteger() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(invalidKeySpecCostMustBeTwoDigitInteger$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecNoSuchMessageDigestAlgorithm = "ELY08013: No such MessageDigest algorithm for \"%s\"";
    protected String invalidKeySpecNoSuchMessageDigestAlgorithm$str() {
        return invalidKeySpecNoSuchMessageDigestAlgorithm;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecNoSuchMessageDigestAlgorithm(final String algorithm) {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(invalidKeySpecNoSuchMessageDigestAlgorithm$str(), algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeyNoSuchMessageDigestAlgorithm = "ELY08014: No such MessageDigest algorithm for \"%s\"";
    protected String invalidKeyNoSuchMessageDigestAlgorithm$str() {
        return invalidKeyNoSuchMessageDigestAlgorithm;
    }
    @Override
    public final InvalidKeyException invalidKeyNoSuchMessageDigestAlgorithm(final String algorithm) {
        final InvalidKeyException result = new InvalidKeyException(String.format(invalidKeyNoSuchMessageDigestAlgorithm$str(), algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeyCannotVerifyPassword = "ELY08015: Cannot verify password";
    protected String invalidKeyCannotVerifyPassword$str() {
        return invalidKeyCannotVerifyPassword;
    }
    @Override
    public final InvalidKeyException invalidKeyCannotVerifyPassword(final Throwable cause) {
        final InvalidKeyException result = new InvalidKeyException(String.format(invalidKeyCannotVerifyPassword$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecDesCryptPasswordHashMustBeBytes = "ELY08016: DES crypt password hash must be %d bytes";
    protected String invalidKeySpecDesCryptPasswordHashMustBeBytes$str() {
        return invalidKeySpecDesCryptPasswordHashMustBeBytes;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecDesCryptPasswordHashMustBeBytes(final int bytes) {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(invalidKeySpecDesCryptPasswordHashMustBeBytes$str(), bytes));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeyDesCryptPasswordHashMustBeBytes = "ELY08017: DES crypt password hash must be %d bytes";
    protected String invalidKeyDesCryptPasswordHashMustBeBytes$str() {
        return invalidKeyDesCryptPasswordHashMustBeBytes;
    }
    @Override
    public final InvalidKeyException invalidKeyDesCryptPasswordHashMustBeBytes(final int bytes) {
        final InvalidKeyException result = new InvalidKeyException(String.format(invalidKeyDesCryptPasswordHashMustBeBytes$str(), bytes));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidParameterSpecSaltMustBeBytesBits = "ELY08018: Salt must be %d bytes (%d bits)";
    protected String invalidParameterSpecSaltMustBeBytesBits$str() {
        return invalidParameterSpecSaltMustBeBytesBits;
    }
    @Override
    public final InvalidParameterSpecException invalidParameterSpecSaltMustBeBytesBits(final int bytes, final int bits) {
        final InvalidParameterSpecException result = new InvalidParameterSpecException(String.format(invalidParameterSpecSaltMustBeBytesBits$str(), bytes, bits));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidParameterSpecUnsupportedParameterSpec = "ELY08019: Unsupported parameter spec";
    protected String invalidParameterSpecUnsupportedParameterSpec$str() {
        return invalidParameterSpecUnsupportedParameterSpec;
    }
    @Override
    public final InvalidParameterSpecException invalidParameterSpecUnsupportedParameterSpec() {
        final InvalidParameterSpecException result = new InvalidParameterSpecException(String.format(invalidParameterSpecUnsupportedParameterSpec$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidNumberOfRoundsMustBeIntBetween = "ELY08020: Invalid number of rounds. Must be an integer between %d and %d, inclusive";
    protected String invalidNumberOfRoundsMustBeIntBetween$str() {
        return invalidNumberOfRoundsMustBeIntBetween;
    }
    @Override
    public final IllegalArgumentException invalidNumberOfRoundsMustBeIntBetween(final int min, final int max) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidNumberOfRoundsMustBeIntBetween$str(), min, max));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidSaltMustBeBytesLong = "ELY08021: Invalid salt: must be %d bytes long";
    protected String invalidSaltMustBeBytesLong$str() {
        return invalidSaltMustBeBytesLong;
    }
    @Override
    public final IllegalArgumentException invalidSaltMustBeBytesLong(final int length) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidSaltMustBeBytesLong$str(), length));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecBsdDesCryptPasswordHashMustBeBytes = "ELY08022: BSD DES crypt password hash must be %d bytes";
    protected String invalidKeySpecBsdDesCryptPasswordHashMustBeBytes$str() {
        return invalidKeySpecBsdDesCryptPasswordHashMustBeBytes;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecBsdDesCryptPasswordHashMustBeBytes(final int bytes) {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(invalidKeySpecBsdDesCryptPasswordHashMustBeBytes$str(), bytes));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidParameterSpecSaltMustBeBytes = "ELY08023: Salt must be %d bytes";
    protected String invalidParameterSpecSaltMustBeBytes$str() {
        return invalidParameterSpecSaltMustBeBytes;
    }
    @Override
    public final InvalidParameterSpecException invalidParameterSpecSaltMustBeBytes(final int bytes) {
        final InvalidParameterSpecException result = new InvalidParameterSpecException(String.format(invalidParameterSpecSaltMustBeBytes$str(), bytes));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeyBsdDesCryptPasswordHashMustBeBytes = "ELY08024: BSD DES crypt password hash must be %d bytes";
    protected String invalidKeyBsdDesCryptPasswordHashMustBeBytes$str() {
        return invalidKeyBsdDesCryptPasswordHashMustBeBytes;
    }
    @Override
    public final InvalidKeyException invalidKeyBsdDesCryptPasswordHashMustBeBytes(final int bytes) {
        final InvalidKeyException result = new InvalidKeyException(String.format(invalidKeyBsdDesCryptPasswordHashMustBeBytes$str(), bytes));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecExpectedSpecGotSpec = "ELY08025: Expected to get a \"%s\" as spec, got \"%s\"";
    protected String invalidKeySpecExpectedSpecGotSpec$str() {
        return invalidKeySpecExpectedSpecGotSpec;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecExpectedSpecGotSpec(final String expected, final String got) {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(invalidKeySpecExpectedSpecGotSpec$str(), expected, got));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec = "ELY08026: Unknown algorithm or incompatible PasswordSpec";
    protected String invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec$str() {
        return invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeyUnknownUnknownPasswordTypeOrAlgorithm = "ELY08027: Unknown password type or algorithm";
    protected String invalidKeyUnknownUnknownPasswordTypeOrAlgorithm$str() {
        return invalidKeyUnknownUnknownPasswordTypeOrAlgorithm;
    }
    @Override
    public final InvalidKeyException invalidKeyUnknownUnknownPasswordTypeOrAlgorithm() {
        final InvalidKeyException result = new InvalidKeyException(String.format(invalidKeyUnknownUnknownPasswordTypeOrAlgorithm$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSuchAlgorithmInvalidAlgorithm = "ELY08028: Invalid algorithm \"%s\"";
    protected String noSuchAlgorithmInvalidAlgorithm$str() {
        return noSuchAlgorithmInvalidAlgorithm;
    }
    @Override
    public final NoSuchAlgorithmException noSuchAlgorithmInvalidAlgorithm(final String algorithm) {
        final NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(noSuchAlgorithmInvalidAlgorithm$str(), algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotObtainKeySpecEncodingIdentifier = "ELY08029: Could not obtain key spec encoding identifier.";
    protected String couldNotObtainKeySpecEncodingIdentifier$str() {
        return couldNotObtainKeySpecEncodingIdentifier;
    }
    @Override
    public final IllegalArgumentException couldNotObtainKeySpecEncodingIdentifier() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(couldNotObtainKeySpecEncodingIdentifier$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToEncode = "ELY08030: Failed to encode parameter specification";
    protected String failedToEncode$str() {
        return failedToEncode;
    }
    @Override
    public final InvalidParameterSpecException failedToEncode(final Throwable cause) {
        final InvalidParameterSpecException result = new InvalidParameterSpecException(String.format(failedToEncode$str()));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToDecode = "ELY08031: Failed to decode parameter specification";
    protected String failedToDecode$str() {
        return failedToDecode;
    }
    @Override
    public final IOException failedToDecode(final Throwable cause) {
        final IOException result = new IOException(String.format(failedToDecode$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidParameterSpec = "ELY08032: Invalid parameter specification type (expected %s, got %s)";
    protected String invalidParameterSpec$str() {
        return invalidParameterSpec;
    }
    @Override
    public final InvalidParameterSpecException invalidParameterSpec(final Class<? extends Object> expected, final Class<? extends Object> actual) {
        final InvalidParameterSpecException result = new InvalidParameterSpecException(String.format(invalidParameterSpec$str(), expected, actual));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidFormat = "ELY08033: Invalid format given (expected %s, got %s)";
    protected String invalidFormat$str() {
        return invalidFormat;
    }
    @Override
    public final IOException invalidFormat(final String expected, final String actual) {
        final IOException result = new IOException(String.format(invalidFormat$str(), expected, actual));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String algorithmParametersNotInitialized = "ELY08034: Algorithm parameters instance not initialized";
    protected String algorithmParametersNotInitialized$str() {
        return algorithmParametersNotInitialized;
    }
    @Override
    public final IllegalStateException algorithmParametersNotInitialized() {
        final IllegalStateException result = new IllegalStateException(String.format(algorithmParametersNotInitialized$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void authzFailedToCheckPermission(final ProtectionDomain domain, final Permission permission, final Throwable cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, cause, authzFailedToCheckPermission$str(), domain, permission);
    }
    private static final String authzFailedToCheckPermission = "ELY08500: Failed to check permissions for protection domain [%s] and permission [%s].";
    protected String authzFailedToCheckPermission$str() {
        return authzFailedToCheckPermission;
    }
    private static final String authzInvalidStateForOperation = "ELY08501: Invalid state [%s] for operation.";
    protected String authzInvalidStateForOperation$str() {
        return authzInvalidStateForOperation;
    }
    @Override
    public final UnsupportedOperationException authzInvalidStateForOperation(final String actualState) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(authzInvalidStateForOperation$str(), actualState));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String authzLinkSamePolicyConfiguration = "ELY08502: Can't link policy configuration [%s] to itself.";
    protected String authzLinkSamePolicyConfiguration$str() {
        return authzLinkSamePolicyConfiguration;
    }
    @Override
    public final IllegalArgumentException authzLinkSamePolicyConfiguration(final String contextID) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(authzLinkSamePolicyConfiguration$str(), contextID));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String authzContextIdentifierNotSet = "ELY08503: ContextID not set. Check if the context id was set using PolicyContext.setContextID.";
    protected String authzContextIdentifierNotSet$str() {
        return authzContextIdentifierNotSet;
    }
    @Override
    public final IllegalStateException authzContextIdentifierNotSet() {
        final IllegalStateException result = new IllegalStateException(String.format(authzContextIdentifierNotSet$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String authzInvalidPolicyContextIdentifier = "ELY08504: Invalid policy context identifier [%s].";
    protected String authzInvalidPolicyContextIdentifier$str() {
        return authzInvalidPolicyContextIdentifier;
    }
    @Override
    public final IllegalArgumentException authzInvalidPolicyContextIdentifier(final String contextID) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(authzInvalidPolicyContextIdentifier$str(), contextID));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String authzUnableToObtainPolicyConfiguration = "ELY08505: Could not obtain PolicyConfiguration for contextID [%s].";
    protected String authzUnableToObtainPolicyConfiguration$str() {
        return authzUnableToObtainPolicyConfiguration;
    }
    @Override
    public final PolicyContextException authzUnableToObtainPolicyConfiguration(final String contextId, final Throwable cause) {
        final PolicyContextException result = new PolicyContextException(String.format(authzUnableToObtainPolicyConfiguration$str(), contextId), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String authzPolicyConfigurationNotInService = "ELY08506: Policy configuration with contextID [%s] is not in service state.";
    protected String authzPolicyConfigurationNotInService$str() {
        return authzPolicyConfigurationNotInService;
    }
    @Override
    public final IllegalStateException authzPolicyConfigurationNotInService(final String contextID) {
        final IllegalStateException result = new IllegalStateException(String.format(authzPolicyConfigurationNotInService$str(), contextID));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void authzFailedGetDynamicPermissions(final Throwable cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, cause, authzFailedGetDynamicPermissions$str());
    }
    private static final String authzFailedGetDynamicPermissions = "ELY08507: Could not obtain dynamic permissions.";
    protected String authzFailedGetDynamicPermissions$str() {
        return authzFailedGetDynamicPermissions;
    }
    @Override
    public final void authzCouldNotObtainSecurityIdentity(final Throwable cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.DEBUG, cause, authzCouldNotObtainSecurityIdentity$str());
    }
    private static final String authzCouldNotObtainSecurityIdentity = "ELY08508: Could not obtain authorized identity.";
    protected String authzCouldNotObtainSecurityIdentity$str() {
        return authzCouldNotObtainSecurityIdentity;
    }
    @Override
    public final void getPermissionsNotSupported() {
        if (super.log.isEnabled(org.jboss.logging.Logger.Level.WARN) && getPermissionsNotSupported_$Once.compareAndSet(false, true)) {
            super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, getPermissionsNotSupported$str());
        }
    }
    private static final String getPermissionsNotSupported = "ELY08509: Calling any of the Policy.getPermissions() methods is not supported; please see the Java Authorization Contract for Containers (JACC) specification (section \"1.4 Requirements\", item 1) and the Java SE API specification for the Policy.getPermissions() methods for more information.  Instead, use the Policy.implies() method for authorization checking.";
    protected String getPermissionsNotSupported$str() {
        return getPermissionsNotSupported;
    }
    private static final AtomicBoolean getPermissionsNotSupported_$Once = new AtomicBoolean(false);
    private static final String mismatchedPublicPrivateKeyParameters = "ELY09000: Public and private key parameters are mismatched";
    protected String mismatchedPublicPrivateKeyParameters$str() {
        return mismatchedPublicPrivateKeyParameters;
    }
    @Override
    public final IllegalArgumentException mismatchedPublicPrivateKeyParameters() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(mismatchedPublicPrivateKeyParameters$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String oauth2ClientCredentialsNotProvided = "ELY09001: Client credentials not provided";
    protected String oauth2ClientCredentialsNotProvided$str() {
        return oauth2ClientCredentialsNotProvided;
    }
    @Override
    public final IllegalStateException oauth2ClientCredentialsNotProvided() {
        final IllegalStateException result = new IllegalStateException(String.format(oauth2ClientCredentialsNotProvided$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String wrongTypeOfExternalStorageKey = "ELY09500: External storage key under alias \"%s\" has to be a SecretKey";
    protected String wrongTypeOfExternalStorageKey$str() {
        return wrongTypeOfExternalStorageKey;
    }
    @Override
    public final CredentialStoreException wrongTypeOfExternalStorageKey(final String keyAlias) {
        final CredentialStoreException result = new CredentialStoreException(String.format(wrongTypeOfExternalStorageKey$str(), keyAlias));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateAttributeFound = "ELY09501: Duplicate attribute (\"%s\") found in configuration.";
    protected String duplicateAttributeFound$str() {
        return duplicateAttributeFound;
    }
    @Override
    public final ConfigXMLParseException duplicateAttributeFound(final XMLStreamReader reader, final String attribute) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(duplicateAttributeFound$str(), attribute), reader);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateCredentialStoreName = "ELY09502: Duplicate credential store name found in configuration \"%s\"";
    protected String duplicateCredentialStoreName$str() {
        return duplicateCredentialStoreName;
    }
    @Override
    public final ConfigXMLParseException duplicateCredentialStoreName(final XMLStreamReader reader, final String storeName) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(duplicateCredentialStoreName$str(), storeName), reader);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlCredentialStoreNameNotDefined = "ELY09503: Credential store name \"%s\" not defined";
    protected String xmlCredentialStoreNameNotDefined$str() {
        return xmlCredentialStoreNameNotDefined;
    }
    @Override
    public final ConfigXMLParseException xmlCredentialStoreNameNotDefined(final Location location, final String storeName) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(xmlCredentialStoreNameNotDefined$str(), storeName), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAcquireCredentialFromStore = "ELY09504: Cannot acquire a credential from the credential store";
    protected String cannotAcquireCredentialFromStore$str() {
        return cannotAcquireCredentialFromStore;
    }
    @Override
    public final CredentialStoreException cannotAcquireCredentialFromStore(final Throwable cause) {
        final CredentialStoreException result = new CredentialStoreException(String.format(cannotAcquireCredentialFromStore$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nonModifiableCredentialStore = "ELY09505: Cannot perform operation '%s': Credential store is set non modifiable";
    protected String nonModifiableCredentialStore$str() {
        return nonModifiableCredentialStore;
    }
    @Override
    public final CredentialStoreException nonModifiableCredentialStore(final String operation) {
        final CredentialStoreException result = new CredentialStoreException(String.format(nonModifiableCredentialStore$str(), operation));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String credentialCommandInterrupted = "ELY09506: Credential store command interrupted";
    protected String credentialCommandInterrupted$str() {
        return credentialCommandInterrupted;
    }
    @Override
    public final InterruptedIOException credentialCommandInterrupted() {
        final InterruptedIOException result = new InterruptedIOException(String.format(credentialCommandInterrupted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidProtectionParameter = "ELY09507: Invalid protection parameter given: %s";
    protected String invalidProtectionParameter$str() {
        return invalidProtectionParameter;
    }
    @Override
    public final CredentialStoreException invalidProtectionParameter(final ProtectionParameter protectionParameter) {
        final CredentialStoreException result = new CredentialStoreException(String.format(invalidProtectionParameter$str(), protectionParameter));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotWriteCredentialToStore = "ELY09508: Cannot write credential to store";
    protected String cannotWriteCredentialToStore$str() {
        return cannotWriteCredentialToStore;
    }
    @Override
    public final CredentialStoreException cannotWriteCredentialToStore(final Throwable cause) {
        final CredentialStoreException result = new CredentialStoreException(String.format(cannotWriteCredentialToStore$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedCredentialType = "ELY09509: Unsupported credential type %s";
    protected String unsupportedCredentialType$str() {
        return unsupportedCredentialType;
    }
    @Override
    public final UnsupportedCredentialTypeException unsupportedCredentialType(final Class<? extends Object> type) {
        final UnsupportedCredentialTypeException result = new UnsupportedCredentialTypeException(String.format(unsupportedCredentialType$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidCredentialStoreEntryType = "ELY09510: Invalid credential store keystore entry %s: expected %s";
    protected String invalidCredentialStoreEntryType$str() {
        return invalidCredentialStoreEntryType;
    }
    @Override
    public final CredentialStoreException invalidCredentialStoreEntryType(final Class<? extends java.security.KeyStore.Entry> entryType, final Class<? extends java.security.KeyStore.Entry> expectedType) {
        final CredentialStoreException result = new CredentialStoreException(String.format(invalidCredentialStoreEntryType$str(), entryType, expectedType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToReadCredentialTypeFromStore = "ELY09511: Unable to read credential %s from store";
    protected String unableToReadCredentialTypeFromStore$str() {
        return unableToReadCredentialTypeFromStore;
    }
    @Override
    public final CredentialStoreException unableToReadCredentialTypeFromStore(final Class<? extends org.wildfly.security.credential.Credential> credentialType) {
        final CredentialStoreException result = new CredentialStoreException(String.format(unableToReadCredentialTypeFromStore$str(), credentialType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRemoveCredentialFromStore = "ELY09512: Unable to remove credential from store";
    protected String cannotRemoveCredentialFromStore$str() {
        return cannotRemoveCredentialFromStore;
    }
    @Override
    public final CredentialStoreException cannotRemoveCredentialFromStore(final Throwable cause) {
        final CredentialStoreException result = new CredentialStoreException(String.format(cannotRemoveCredentialFromStore$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotFlushCredentialStore = "ELY09513: Unable to flush credential store to storage";
    protected String cannotFlushCredentialStore$str() {
        return cannotFlushCredentialStore;
    }
    @Override
    public final CredentialStoreException cannotFlushCredentialStore(final Throwable cause) {
        final CredentialStoreException result = new CredentialStoreException(String.format(cannotFlushCredentialStore$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotInitializeCredentialStore = "ELY09514: Unable to initialize credential store";
    protected String cannotInitializeCredentialStore$str() {
        return cannotInitializeCredentialStore;
    }
    @Override
    public final CredentialStoreException cannotInitializeCredentialStore(final Throwable cause) {
        final CredentialStoreException result = new CredentialStoreException(String.format(cannotInitializeCredentialStore$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void logIgnoredUnrecognizedKeyStoreEntry(final String alias) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, logIgnoredUnrecognizedKeyStoreEntry$str(), alias);
    }
    private static final String logIgnoredUnrecognizedKeyStoreEntry = "ELY09515: Ignored unrecognized key store entry \"%s\"";
    protected String logIgnoredUnrecognizedKeyStoreEntry$str() {
        return logIgnoredUnrecognizedKeyStoreEntry;
    }
    @Override
    public final void logFailedToReadKeyFromKeyStore(final Throwable cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, cause, logFailedToReadKeyFromKeyStore$str());
    }
    private static final String logFailedToReadKeyFromKeyStore = "ELY09516: Failed to read a credential entry from the key store";
    protected String logFailedToReadKeyFromKeyStore$str() {
        return logFailedToReadKeyFromKeyStore;
    }
    private static final String protectionParameterRequired = "ELY09517: This credential store type requires a store-wide protection parameter";
    protected String protectionParameterRequired$str() {
        return protectionParameterRequired;
    }
    @Override
    public final CredentialStoreException protectionParameterRequired() {
        final CredentialStoreException result = new CredentialStoreException(String.format(protectionParameterRequired$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String automaticStorageCreationDisabled = "ELY09518: Automatic storage creation for the Credential Store is disabled \"%s\"";
    protected String automaticStorageCreationDisabled$str() {
        return automaticStorageCreationDisabled;
    }
    @Override
    public final CredentialStoreException automaticStorageCreationDisabled(final String location) {
        final CredentialStoreException result = new CredentialStoreException(String.format(automaticStorageCreationDisabled$str(), location));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedFileVersion = "ELY09519: Unexpected credential store external storage file version \"%s\"";
    protected String unexpectedFileVersion$str() {
        return unexpectedFileVersion;
    }
    @Override
    public final IOException unexpectedFileVersion(final String version) {
        final IOException result = new IOException(String.format(unexpectedFileVersion$str(), version));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unrecognizedEntryType = "ELY09520: Unrecognized entry type \"%s\"";
    protected String unrecognizedEntryType$str() {
        return unrecognizedEntryType;
    }
    @Override
    public final IOException unrecognizedEntryType(final String entryType) {
        final IOException result = new IOException(String.format(unrecognizedEntryType$str(), entryType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String internalEncryptionProblem = "ELY09521: Internal encryption problem while reading \"%s\"";
    protected String internalEncryptionProblem$str() {
        return internalEncryptionProblem;
    }
    @Override
    public final IOException internalEncryptionProblem(final Exception e, final String location) {
        final IOException result = new IOException(String.format(internalEncryptionProblem$str(), location), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String algorithmNotBlockBased = "ELY09522: \"%s\" is not a block based algorithm";
    protected String algorithmNotBlockBased$str() {
        return algorithmNotBlockBased;
    }
    @Override
    public final CredentialStoreException algorithmNotBlockBased(final String algorithm) {
        final CredentialStoreException result = new CredentialStoreException(String.format(algorithmNotBlockBased$str(), algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String algorithmNotIV = "ELY09523: Algorithm \"%s\" does not use an initialization vector (IV)";
    protected String algorithmNotIV$str() {
        return algorithmNotIV;
    }
    @Override
    public final CredentialStoreException algorithmNotIV(final String algorithm) {
        final CredentialStoreException result = new CredentialStoreException(String.format(algorithmNotIV$str(), algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String readBytesMismatch = "ELY09524: The actual number of bytes read %d is different from the expected number of bytes %d to be read";
    protected String readBytesMismatch$str() {
        return readBytesMismatch;
    }
    @Override
    public final IOException readBytesMismatch(final int actual, final int expected) {
        final IOException result = new IOException(String.format(readBytesMismatch$str(), actual, expected));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String locationAndExternalPathAreIdentical = "ELY09525: location and externalPath initial attributes are the same. [location=%s, externalPath=%s]";
    protected String locationAndExternalPathAreIdentical$str() {
        return locationAndExternalPathAreIdentical;
    }
    @Override
    public final CredentialStoreException locationAndExternalPathAreIdentical(final String location, final String externalPath) {
        final CredentialStoreException result = new CredentialStoreException(String.format(locationAndExternalPathAreIdentical$str(), location, externalPath));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedAttribute = "ELY09526: Unable to initialize credential store as attribute %s is unsupported in %s";
    protected String unsupportedAttribute$str() {
        return unsupportedAttribute;
    }
    @Override
    public final CredentialStoreException unsupportedAttribute(final String attribute, final List<String> validAttribute) {
        final CredentialStoreException result = new CredentialStoreException(String.format(unsupportedAttribute$str(), attribute, validAttribute));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String extensionAlreadyExists = "ELY10000: X.509 certificate extension with OID %s already exists";
    protected String extensionAlreadyExists$str() {
        return extensionAlreadyExists;
    }
    @Override
    public final IllegalArgumentException extensionAlreadyExists(final String oid) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(extensionAlreadyExists$str(), oid));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSignatureAlgorithmNameGiven = "ELY10001: No signature algorithm name given";
    protected String noSignatureAlgorithmNameGiven$str() {
        return noSignatureAlgorithmNameGiven;
    }
    @Override
    public final IllegalArgumentException noSignatureAlgorithmNameGiven() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(noSignatureAlgorithmNameGiven$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownSignatureAlgorithmName = "ELY10002: Signature algorithm name \"%s\" is not recognized";
    protected String unknownSignatureAlgorithmName$str() {
        return unknownSignatureAlgorithmName;
    }
    @Override
    public final IllegalArgumentException unknownSignatureAlgorithmName(final String signatureAlgorithmName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(unknownSignatureAlgorithmName$str(), signatureAlgorithmName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSigningKeyGiven = "ELY10003: No signing key given";
    protected String noSigningKeyGiven$str() {
        return noSigningKeyGiven;
    }
    @Override
    public final IllegalArgumentException noSigningKeyGiven() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(noSigningKeyGiven$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String signingKeyNotCompatWithSig = "ELY10004: Signing key algorithm name \"%s\" is not compatible with signature algorithm name \"%s\"";
    protected String signingKeyNotCompatWithSig$str() {
        return signingKeyNotCompatWithSig;
    }
    @Override
    public final IllegalArgumentException signingKeyNotCompatWithSig(final String signingKeyAlgorithm, final String signatureAlgorithmName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(signingKeyNotCompatWithSig$str(), signingKeyAlgorithm, signatureAlgorithmName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String validAfterBeforeValidBefore = "ELY10005: Not-valid-before date of %s is after not-valid-after date of %s";
    protected String validAfterBeforeValidBefore$str() {
        return validAfterBeforeValidBefore;
    }
    @Override
    public final IllegalArgumentException validAfterBeforeValidBefore(final ZonedDateTime notValidBefore, final ZonedDateTime notValidAfter) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(validAfterBeforeValidBefore$str(), notValidBefore, notValidAfter));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noIssuerDnGiven = "ELY10006: No issuer DN given";
    protected String noIssuerDnGiven$str() {
        return noIssuerDnGiven;
    }
    @Override
    public final IllegalArgumentException noIssuerDnGiven() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(noIssuerDnGiven$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noPublicKeyGiven = "ELY10007: No public key given";
    protected String noPublicKeyGiven$str() {
        return noPublicKeyGiven;
    }
    @Override
    public final IllegalArgumentException noPublicKeyGiven() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(noPublicKeyGiven$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String uniqueIdNotAllowed = "ELY10008: Issuer and subject unique ID are only allowed in certificates with version 2 or higher";
    protected String uniqueIdNotAllowed$str() {
        return uniqueIdNotAllowed;
    }
    @Override
    public final IllegalArgumentException uniqueIdNotAllowed() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(uniqueIdNotAllowed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String extensionsNotAllowed = "ELY10009: Extensions are only allowed in certificates with version 3 or higher";
    protected String extensionsNotAllowed$str() {
        return extensionsNotAllowed;
    }
    @Override
    public final IllegalArgumentException extensionsNotAllowed() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(extensionsNotAllowed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeyForCert = "ELY10010: X.509 encoding of public key with algorithm \"%s\" failed";
    protected String invalidKeyForCert$str() {
        return invalidKeyForCert;
    }
    @Override
    public final IllegalArgumentException invalidKeyForCert(final String publicKeyAlgorithm, final Exception cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidKeyForCert$str(), publicKeyAlgorithm), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String certSigningFailed = "ELY10011: Failed to sign certificate";
    protected String certSigningFailed$str() {
        return certSigningFailed;
    }
    @Override
    public final IllegalArgumentException certSigningFailed(final Exception cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(certSigningFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serialNumberTooSmall = "ELY10012: Certificate serial number must be positive";
    protected String serialNumberTooSmall$str() {
        return serialNumberTooSmall;
    }
    @Override
    public final IllegalArgumentException serialNumberTooSmall() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(serialNumberTooSmall$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serialNumberTooLarge = "ELY10013: Certificate serial number too large (cannot exceed 20 octets)";
    protected String serialNumberTooLarge$str() {
        return serialNumberTooLarge;
    }
    @Override
    public final IllegalArgumentException serialNumberTooLarge() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(serialNumberTooLarge$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String partialSecurityEventWritten = "ELY11000: Partial SecurityEvent written.";
    protected String partialSecurityEventWritten$str() {
        return partialSecurityEventWritten;
    }
    @Override
    public final IOException partialSecurityEventWritten(final IOException cause) {
        final IOException result = new IOException(String.format(partialSecurityEventWritten$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void endpointUnavaiable(final String priority, final String message, final Throwable cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.FATAL, cause, endpointUnavaiable$str(), priority, message);
    }
    private static final String endpointUnavaiable = "ELY11001: Endpoint unable to handle SecurityEvent priority=%s, message=%s";
    protected String endpointUnavaiable$str() {
        return endpointUnavaiable;
    }
    private static final String invalidEventPriority = "ELY11002: Invalid EventPriority '%s' passed to AuditEndpoint.";
    protected String invalidEventPriority$str() {
        return invalidEventPriority;
    }
    @Override
    public final IllegalArgumentException invalidEventPriority(final EventPriority eventPriority) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidEventPriority$str(), eventPriority));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void unableToRotateLogFile(final Throwable cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, cause, unableToRotateLogFile$str());
    }
    private static final String unableToRotateLogFile = "ELY11003: Unable to rotate log file";
    protected String unableToRotateLogFile$str() {
        return unableToRotateLogFile;
    }
    private static final String rotatingBySecondUnsupported = "ELY11004: Invalid suffix \"%s\" - rotating by second or millisecond is not supported";
    protected String rotatingBySecondUnsupported$str() {
        return rotatingBySecondUnsupported;
    }
    @Override
    public final IllegalArgumentException rotatingBySecondUnsupported(final String suffix) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(rotatingBySecondUnsupported$str(), suffix));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidUnicodeSequence = "ELY11005: Invalid unicode endoding, offending sequence: %s.";
    protected String invalidUnicodeSequence$str() {
        return invalidUnicodeSequence;
    }
    @Override
    public final IOException invalidUnicodeSequence(final String s, final NoSuchElementException nsee) {
        final IOException result = new IOException(String.format(invalidUnicodeSequence$str(), s), nsee);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String externalStorageKeyDoesNotExist = "ELY11006: External storage key under alias \"%s\" does not exist";
    protected String externalStorageKeyDoesNotExist$str() {
        return externalStorageKeyDoesNotExist;
    }
    @Override
    public final CredentialStoreException externalStorageKeyDoesNotExist(final String keyAlias) {
        final CredentialStoreException result = new CredentialStoreException(String.format(externalStorageKeyDoesNotExist$str(), keyAlias));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void unableToAcceptEvent(final Throwable cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.FATAL, cause, unableToAcceptEvent$str());
    }
    private static final String unableToAcceptEvent = "ELY11007: Endpoint unable to accept SecurityEvent.";
    protected String unableToAcceptEvent$str() {
        return unableToAcceptEvent;
    }
}
