/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.EvidenceVerifyCallback;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.X509PeerCertificateChainEvidence;

class SetTrustManagerAuthenticationConfiguration
extends AuthenticationConfiguration {
    private final SecurityFactory<X509TrustManager> trustManagerFactory;

    SetTrustManagerAuthenticationConfiguration(AuthenticationConfiguration parent, SecurityFactory<X509TrustManager> trustManagerFactory) {
        super(parent);
        this.trustManagerFactory = trustManagerFactory;
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetTrustManagerAuthenticationConfiguration(newParent, this.trustManagerFactory);
    }

    @Override
    SecurityFactory<X509TrustManager> getX509TrustManagerFactory() {
        return this.trustManagerFactory;
    }

    @Override
    void handleCallback(Callback[] callbacks, int index) throws IOException, UnsupportedCallbackException {
        EvidenceVerifyCallback evidenceVerifyCallback;
        Evidence evidence;
        Callback callback = callbacks[index];
        if (callback instanceof EvidenceVerifyCallback && (evidence = (evidenceVerifyCallback = (EvidenceVerifyCallback)callback).getEvidence()) instanceof X509PeerCertificateChainEvidence) {
            X509TrustManager trustManager;
            X509PeerCertificateChainEvidence peerCertificateChainEvidence = (X509PeerCertificateChainEvidence)evidence;
            try {
                trustManager = this.trustManagerFactory.create();
            }
            catch (GeneralSecurityException e) {
                throw ElytronMessages.log.unableToCreateTrustManager(e);
            }
            try {
                trustManager.checkServerTrusted(peerCertificateChainEvidence.getPeerCertificateChain(), peerCertificateChainEvidence.getAlgorithm());
                evidenceVerifyCallback.setVerified(true);
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
            return;
        }
        super.handleCallback(callbacks, index);
    }
}

