/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.oauth2;

import java.net.URL;
import java.security.Principal;
import javax.json.JsonObject;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.oauth2.OAuth2Util;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.SupportLevel;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.BearerTokenEvidence;
import org.wildfly.security.evidence.Evidence;

public class OAuth2SecurityRealm
implements SecurityRealm {
    private final URL tokenIntrospectionUrl;
    private final String clientId;
    private final String clientSecret;
    private final String principalClaimName;
    private final SSLContext sslContext;
    private final HostnameVerifier hostnameVerifier;

    public static Builder builder() {
        return new Builder();
    }

    OAuth2SecurityRealm(Builder configuration) {
        Assert.checkNotNullParam((String)"configuration", (Object)configuration);
        this.tokenIntrospectionUrl = (URL)Assert.checkNotNullParam((String)"tokenIntrospectionUrl", (Object)configuration.tokenIntrospectionUrl);
        this.clientId = (String)Assert.checkNotNullParam((String)"clientId", (Object)configuration.clientId);
        this.clientSecret = (String)Assert.checkNotNullParam((String)"clientSecret", (Object)configuration.clientSecret);
        this.principalClaimName = configuration.principalClaimName == null ? "username" : configuration.principalClaimName;
        if (this.tokenIntrospectionUrl.getProtocol().equalsIgnoreCase("https")) {
            if (configuration.sslContext == null) {
                throw ElytronMessages.log.oauth2RealmSSLContextNotSpecified(this.tokenIntrospectionUrl);
            }
            if (configuration.hostnameVerifier == null) {
                throw ElytronMessages.log.oauth2RealmHostnameVerifierNotSpecified(this.tokenIntrospectionUrl);
            }
        }
        this.sslContext = configuration.sslContext;
        this.hostnameVerifier = configuration.hostnameVerifier;
    }

    @Override
    public RealmIdentity getRealmIdentity(String name, Principal principal, Evidence evidence) throws RealmUnavailableException {
        return new OAuth2RealmIdentity(evidence);
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
        return SupportLevel.UNSUPPORTED;
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        if (this.isBearerTokenEvidence(evidenceType)) {
            return SupportLevel.POSSIBLY_SUPPORTED;
        }
        return SupportLevel.UNSUPPORTED;
    }

    private boolean isBearerTokenEvidence(Class<?> evidenceType) {
        return evidenceType != null && evidenceType.equals(BearerTokenEvidence.class);
    }

    public static class Builder {
        private String clientId;
        private String clientSecret;
        private URL tokenIntrospectionUrl;
        private String principalClaimName = "username";
        private SSLContext sslContext;
        private HostnameVerifier hostnameVerifier;

        private Builder() {
        }

        public Builder tokenIntrospectionUrl(URL url) {
            this.tokenIntrospectionUrl = url;
            return this;
        }

        public Builder principalClaimName(String name) {
            this.principalClaimName = name;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder useSslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder useSslHostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public OAuth2SecurityRealm build() {
            return new OAuth2SecurityRealm(this);
        }
    }

    final class OAuth2RealmIdentity
    implements RealmIdentity {
        private final BearerTokenEvidence evidence;
        private JsonObject claims;

        OAuth2RealmIdentity(Evidence evidence) {
            this.evidence = evidence != null && OAuth2SecurityRealm.this.isBearerTokenEvidence(evidence.getClass()) ? (BearerTokenEvidence)evidence : null;
        }

        @Override
        public Principal getRealmIdentityPrincipal() {
            try {
                if (this.exists()) {
                    return new NamePrincipal(this.getClaims().getString(OAuth2SecurityRealm.this.principalClaimName));
                }
            }
            catch (Exception e) {
                throw ElytronMessages.log.oauth2RealmFailedToObtainPrincipal(e);
            }
            return null;
        }

        @Override
        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            return this.isValidToken(this.introspectToken());
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return this.getClaims() != null;
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            if (this.exists()) {
                return new AuthorizationIdentity(){
                    private Attributes attributes;

                    @Override
                    public Attributes getAttributes() {
                        if (this.attributes == null) {
                            this.attributes = OAuth2Util.toAttributes(OAuth2RealmIdentity.this.claims);
                        }
                        return this.attributes;
                    }
                };
            }
            return null;
        }

        @Override
        public boolean createdBySecurityRealm(SecurityRealm securityRealm) {
            return OAuth2SecurityRealm.this == securityRealm;
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            return null;
        }

        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            if (OAuth2SecurityRealm.this.isBearerTokenEvidence(evidenceType)) {
                return SupportLevel.SUPPORTED;
            }
            return SupportLevel.UNSUPPORTED;
        }

        private JsonObject getClaims() throws RealmUnavailableException {
            JsonObject claims;
            if (this.claims == null && this.isValidToken(claims = this.introspectToken())) {
                this.claims = claims;
            }
            return this.claims;
        }

        private boolean isValidToken(JsonObject claims) {
            return claims != null && claims.getBoolean("active", false);
        }

        private JsonObject introspectToken() throws RealmUnavailableException {
            if (this.evidence != null) {
                try {
                    return OAuth2Util.introspectAccessToken(OAuth2SecurityRealm.this.tokenIntrospectionUrl, OAuth2SecurityRealm.this.clientId, OAuth2SecurityRealm.this.clientSecret, this.evidence.getToken(), OAuth2SecurityRealm.this.sslContext, OAuth2SecurityRealm.this.hostnameVerifier);
                }
                catch (Exception e) {
                    throw ElytronMessages.log.oauth2RealmTokenIntrospectionFailed(e);
                }
            }
            return null;
        }
    }
}

