/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.impl;

import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import org.wildfly.security.auth.callback.AuthenticationCompleteCallback;
import org.wildfly.security.auth.callback.EvidenceVerifyCallback;
import org.wildfly.security.evidence.BearerTokenEvidence;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerRequest;

class BearerTokenAuthenticationMechanism
implements HttpServerAuthenticationMechanism {
    private static final Pattern BEARER_TOKEN_PATTERN = Pattern.compile("^Bearer *([^ ]+) *$", 2);
    private final CallbackHandler callbackHandler;

    BearerTokenAuthenticationMechanism(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    @Override
    public String getMechanismName() {
        return "BEARER_TOKEN";
    }

    @Override
    public void evaluateRequest(HttpServerRequest request) throws HttpAuthenticationException {
        List<String> authorizationValues = request.getRequestHeaderValues("Authorization");
        if (authorizationValues == null || authorizationValues.isEmpty()) {
            request.authenticationFailed("Bearer token required", response -> response.setStatusCode(401));
            return;
        }
        if (authorizationValues.size() > 1) {
            request.authenticationFailed("Multiple Authorization headers found", response -> response.setStatusCode(400));
            return;
        }
        String authorizationValue = authorizationValues.get(0);
        Matcher matcher = BEARER_TOKEN_PATTERN.matcher(authorizationValue);
        if (!matcher.matches()) {
            request.authenticationFailed("Authorization is not Bearer", response -> response.setStatusCode(400));
            return;
        }
        BearerTokenEvidence tokenEvidence = new BearerTokenEvidence(matcher.group(1));
        try {
            EvidenceVerifyCallback verifyCallback = new EvidenceVerifyCallback(tokenEvidence);
            this.callbackHandler.handle(new Callback[]{verifyCallback});
            if (verifyCallback.isVerified()) {
                AuthorizeCallback authorizeCallback = new AuthorizeCallback(null, null);
                this.callbackHandler.handle(new Callback[]{authorizeCallback});
                if (authorizeCallback.isAuthorized()) {
                    this.callbackHandler.handle(new Callback[]{AuthenticationCompleteCallback.SUCCEEDED});
                    request.authenticationComplete();
                    return;
                }
            }
            this.invalidBearerToken(request);
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw new HttpAuthenticationException(e);
        }
    }

    private void invalidBearerToken(HttpServerRequest request) {
        request.authenticationFailed("Invalid bearer token", response -> response.setStatusCode(403));
    }
}

