/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.wildfly.security.ssl.Protocol;

public abstract class ProtocolSelector {
    final ProtocolSelector prev;
    private static final ProtocolSelector EMPTY = new ProtocolSelector(null){

        @Override
        void applyFilter(Set<Protocol> enabled, EnumMap<Protocol, String> supported) {
        }

        @Override
        void toString(StringBuilder b) {
            b.append("(empty)");
        }
    };
    static final ProtocolSelector DEFAULT_SELECTOR = ProtocolSelector.empty().add(Protocol.TLSv1, Protocol.TLSv1_1, Protocol.TLSv1_2, Protocol.TLSv1_3);

    ProtocolSelector(ProtocolSelector prev) {
        this.prev = prev;
    }

    public final String toString() {
        StringBuilder b = new StringBuilder();
        this.toString(b);
        return b.toString();
    }

    abstract void toString(StringBuilder var1);

    public static ProtocolSelector empty() {
        return EMPTY;
    }

    public static ProtocolSelector defaultProtocols() {
        return DEFAULT_SELECTOR;
    }

    public ProtocolSelector deleteFully(String protocolName) {
        return this.deleteFully(Protocol.forName(protocolName));
    }

    public ProtocolSelector deleteFully(Protocol protocol) {
        return protocol == null ? this : new FullyDeletingProtocolSelector(this, EnumSet.of(protocol));
    }

    public ProtocolSelector deleteFully(Protocol ... protocols) {
        return protocols == null || protocols.length == 0 ? this : new FullyDeletingProtocolSelector(this, EnumSet.of(protocols[0], protocols));
    }

    public ProtocolSelector deleteFully(EnumSet<Protocol> protocols) {
        return protocols == null || protocols.isEmpty() ? this : new FullyDeletingProtocolSelector(this, protocols);
    }

    public ProtocolSelector remove(String protocolName) {
        return this.remove(Protocol.forName(protocolName));
    }

    public ProtocolSelector remove(Protocol protocol) {
        return protocol == null ? this : new RemovingProtocolSelector(this, EnumSet.of(protocol));
    }

    public ProtocolSelector remove(Protocol ... protocols) {
        return protocols == null || protocols.length == 0 ? this : new RemovingProtocolSelector(this, EnumSet.of(protocols[0], protocols));
    }

    public ProtocolSelector remove(EnumSet<Protocol> protocols) {
        return protocols == null || protocols.isEmpty() ? this : new RemovingProtocolSelector(this, protocols);
    }

    public ProtocolSelector add(String protocolName) {
        return this.add(Protocol.forName(protocolName));
    }

    public ProtocolSelector add(Protocol protocol) {
        return protocol == null ? this : new AddingProtocolSelector(this, EnumSet.of(protocol));
    }

    public ProtocolSelector add(Protocol ... protocols) {
        return protocols == null || protocols.length == 0 ? this : new AddingProtocolSelector(this, EnumSet.of(protocols[0], protocols));
    }

    public ProtocolSelector add(EnumSet<Protocol> protocols) {
        return protocols == null || protocols.isEmpty() ? this : new AddingProtocolSelector(this, protocols);
    }

    abstract void applyFilter(Set<Protocol> var1, EnumMap<Protocol, String> var2);

    private void doEvaluate(Set<Protocol> enabled, EnumMap<Protocol, String> supported) {
        if (this.prev != null) {
            this.prev.doEvaluate(enabled, supported);
        }
        this.applyFilter(enabled, supported);
    }

    public final String[] evaluate(String[] supportedProtocols) {
        EnumMap<Protocol, String> supported = new EnumMap<Protocol, String>(Protocol.class);
        for (String protocolName : supportedProtocols) {
            Protocol protocol = Protocol.forName(protocolName);
            if (protocol == null) continue;
            supported.put(protocol, protocolName);
        }
        LinkedHashSet<Protocol> enabledSet = new LinkedHashSet<Protocol>(supported.size());
        this.doEvaluate(enabledSet, supported);
        ArrayList<String> list = new ArrayList<String>(enabledSet.size());
        for (Protocol protocol : enabledSet) {
            list.add(supported.get((Object)protocol));
        }
        return list.toArray(new String[enabledSet.size()]);
    }

    static class FullyDeletingProtocolSelector
    extends ProtocolSelector {
        private final EnumSet<Protocol> protocols;

        FullyDeletingProtocolSelector(ProtocolSelector prev, EnumSet<Protocol> protocols) {
            super(prev);
            this.protocols = protocols;
        }

        @Override
        void toString(StringBuilder b) {
            if (this.prev != null && this.prev != EMPTY) {
                this.prev.toString(b);
                b.append(", then ");
            }
            b.append("fully remove protocols (");
            Iterator iterator = this.protocols.iterator();
            if (iterator.hasNext()) {
                Protocol protocol = (Protocol)((Object)iterator.next());
                b.append((Object)protocol);
                while (iterator.hasNext()) {
                    protocol = (Protocol)((Object)iterator.next());
                    b.append(", ");
                    b.append((Object)protocol);
                }
            }
            b.append(")");
        }

        @Override
        void applyFilter(Set<Protocol> enabled, EnumMap<Protocol, String> supported) {
            enabled.removeAll(this.protocols);
            for (Protocol protocol : this.protocols) {
                supported.remove((Object)protocol);
            }
        }
    }

    static final class RemovingProtocolSelector
    extends ProtocolSelector {
        private final EnumSet<Protocol> protocols;

        RemovingProtocolSelector(ProtocolSelector prev, EnumSet<Protocol> protocols) {
            super(prev);
            this.protocols = protocols;
        }

        @Override
        void toString(StringBuilder b) {
            if (this.prev != null && this.prev != EMPTY) {
                this.prev.toString(b);
                b.append(", then ");
            }
            b.append("remove protocols (");
            Iterator iterator = this.protocols.iterator();
            if (iterator.hasNext()) {
                Protocol protocol = (Protocol)((Object)iterator.next());
                b.append((Object)protocol);
                while (iterator.hasNext()) {
                    protocol = (Protocol)((Object)iterator.next());
                    b.append(", ");
                    b.append((Object)protocol);
                }
            }
            b.append(")");
        }

        @Override
        void applyFilter(Set<Protocol> enabled, EnumMap<Protocol, String> supported) {
            enabled.remove(this.protocols);
        }
    }

    static final class AddingProtocolSelector
    extends ProtocolSelector {
        private final EnumSet<Protocol> protocols;

        AddingProtocolSelector(ProtocolSelector prev, EnumSet<Protocol> protocols) {
            super(prev);
            this.protocols = protocols;
        }

        @Override
        void toString(StringBuilder b) {
            if (this.prev != null && this.prev != EMPTY) {
                this.prev.toString(b);
                b.append(", then ");
            }
            b.append("add protocols (");
            Iterator iterator = this.protocols.iterator();
            if (iterator.hasNext()) {
                Protocol protocol = (Protocol)((Object)iterator.next());
                b.append((Object)protocol);
                while (iterator.hasNext()) {
                    protocol = (Protocol)((Object)iterator.next());
                    b.append(", ");
                    b.append((Object)protocol);
                }
            }
            b.append(")");
        }

        @Override
        void applyFilter(Set<Protocol> enabled, EnumMap<Protocol, String> supported) {
            ArrayList<Protocol> clone = new ArrayList<Protocol>(supported.keySet());
            clone.retainAll(this.protocols);
            Collections.reverse(clone);
            enabled.addAll(clone);
        }
    }
}

