/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.permission;

import java.security.Permission;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import org.wildfly.security.permission.AbstractPermission;
import org.wildfly.security.permission.AbstractPermissionCollection;

public final class BooleanPermissionCollection
extends AbstractPermissionCollection {
    private volatile boolean added;

    public BooleanPermissionCollection(AbstractPermission<?> sourcePermission) {
        super(sourcePermission);
    }

    @Override
    public int size() {
        return this.added ? 1 : 0;
    }

    @Override
    public Iterator<Permission> iterator() {
        return this.added ? Collections.singleton(this.getSourcePermission()).iterator() : Collections.emptyIterator();
    }

    @Override
    public Enumeration<Permission> elements() {
        return this.added ? Collections.enumeration(Collections.singleton(this.getSourcePermission())) : Collections.emptyEnumeration();
    }

    @Override
    protected void doAdd(AbstractPermission<?> permission) {
        this.added = true;
    }

    @Override
    public boolean implies(Permission permission) {
        return this.added && permission.getClass() == this.getSourcePermission().getClass();
    }
}

