package org.wildfly.security.credential.store._private;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.wildfly.security.credential.store.UnsupportedCredentialTypeException;
import java.io.IOException;
import org.wildfly.security.credential.store.CredentialStoreException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Class;
import java.util.List;
import java.util.Arrays;
import org.wildfly.security.credential.store.CredentialStore.ProtectionParameter;


import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-06-24T13:53:26-0400")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String unableToCreateKeyStore$str() {
        return "ELY02009: Unable to create a new KeyStore instance";
    }
    @Override
    public final IOException unableToCreateKeyStore(final Exception cause) {
        final IOException result = new IOException(String.format(getLoggingLocale(), unableToCreateKeyStore$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String wrongTypeOfExternalStorageKey$str() {
        return "ELY09500: External storage key under alias \"%s\" has to be a SecretKey";
    }
    @Override
    public final CredentialStoreException wrongTypeOfExternalStorageKey(final String keyAlias) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), wrongTypeOfExternalStorageKey$str(), keyAlias));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotAcquireCredentialFromStore$str() {
        return "ELY09504: Cannot acquire a credential from the credential store";
    }
    @Override
    public final CredentialStoreException cannotAcquireCredentialFromStore(final Throwable cause) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), cannotAcquireCredentialFromStore$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonModifiableCredentialStore$str() {
        return "ELY09505: Cannot perform operation '%s': Credential store is set non modifiable";
    }
    @Override
    public final CredentialStoreException nonModifiableCredentialStore(final String operation) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), nonModifiableCredentialStore$str(), operation));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidProtectionParameter$str() {
        return "ELY09507: Invalid protection parameter given: %s";
    }
    @Override
    public final CredentialStoreException invalidProtectionParameter(final ProtectionParameter protectionParameter) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), invalidProtectionParameter$str(), protectionParameter));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotWriteCredentialToStore$str() {
        return "ELY09508: Cannot write credential to store";
    }
    @Override
    public final CredentialStoreException cannotWriteCredentialToStore(final Throwable cause) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), cannotWriteCredentialToStore$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedCredentialType$str() {
        return "ELY09509: Unsupported credential type %s";
    }
    @Override
    public final UnsupportedCredentialTypeException unsupportedCredentialType(final Class<?> type) {
        final UnsupportedCredentialTypeException result = new UnsupportedCredentialTypeException(String.format(getLoggingLocale(), unsupportedCredentialType$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidCredentialStoreEntryType$str() {
        return "ELY09510: Invalid credential store keystore entry %s: expected %s";
    }
    @Override
    public final CredentialStoreException invalidCredentialStoreEntryType(final Class<? extends java.security.KeyStore.Entry> entryType, final Class<? extends java.security.KeyStore.Entry> expectedType) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), invalidCredentialStoreEntryType$str(), entryType, expectedType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToReadCredentialTypeFromStore$str() {
        return "ELY09511: Unable to read credential %s from store";
    }
    @Override
    public final CredentialStoreException unableToReadCredentialTypeFromStore(final Class<? extends org.wildfly.security.credential.Credential> credentialType) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), unableToReadCredentialTypeFromStore$str(), credentialType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotRemoveCredentialFromStore$str() {
        return "ELY09512: Unable to remove credential from store";
    }
    @Override
    public final CredentialStoreException cannotRemoveCredentialFromStore(final Throwable cause) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), cannotRemoveCredentialFromStore$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotFlushCredentialStore$str() {
        return "ELY09513: Unable to flush credential store to storage";
    }
    @Override
    public final CredentialStoreException cannotFlushCredentialStore(final Throwable cause) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), cannotFlushCredentialStore$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotInitializeCredentialStore$str() {
        return "ELY09514: Unable to initialize credential store";
    }
    @Override
    public final CredentialStoreException cannotInitializeCredentialStore(final Throwable cause) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), cannotInitializeCredentialStore$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void logIgnoredUnrecognizedKeyStoreEntry(final String alias) {
        super.log.logf(FQCN, DEBUG, null, logIgnoredUnrecognizedKeyStoreEntry$str(), alias);
    }
    protected String logIgnoredUnrecognizedKeyStoreEntry$str() {
        return "ELY09515: Ignored unrecognized key store entry \"%s\"";
    }
    @Override
    public final void logFailedToReadKeyFromKeyStore(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, logFailedToReadKeyFromKeyStore$str());
    }
    protected String logFailedToReadKeyFromKeyStore$str() {
        return "ELY09516: Failed to read a credential entry from the key store";
    }
    protected String protectionParameterRequired$str() {
        return "ELY09517: This credential store type requires a store-wide protection parameter";
    }
    @Override
    public final CredentialStoreException protectionParameterRequired() {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), protectionParameterRequired$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String automaticStorageCreationDisabled$str() {
        return "ELY09518: Automatic storage creation for the Credential Store is disabled \"%s\"";
    }
    @Override
    public final CredentialStoreException automaticStorageCreationDisabled(final String location) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), automaticStorageCreationDisabled$str(), location));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedFileVersion$str() {
        return "ELY09519: Unexpected credential store external storage file version \"%s\"";
    }
    @Override
    public final IOException unexpectedFileVersion(final String version) {
        final IOException result = new IOException(String.format(getLoggingLocale(), unexpectedFileVersion$str(), version));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unrecognizedEntryType$str() {
        return "ELY09520: Unrecognized entry type \"%s\"";
    }
    @Override
    public final IOException unrecognizedEntryType(final String entryType) {
        final IOException result = new IOException(String.format(getLoggingLocale(), unrecognizedEntryType$str(), entryType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String internalEncryptionProblem$str() {
        return "ELY09521: Internal encryption problem while reading \"%s\"";
    }
    @Override
    public final IOException internalEncryptionProblem(final Exception e, final String location) {
        final IOException result = new IOException(String.format(getLoggingLocale(), internalEncryptionProblem$str(), location), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String algorithmNotBlockBased$str() {
        return "ELY09522: \"%s\" is not a block based algorithm";
    }
    @Override
    public final CredentialStoreException algorithmNotBlockBased(final String algorithm) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), algorithmNotBlockBased$str(), algorithm));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String algorithmNotIV$str() {
        return "ELY09523: Algorithm \"%s\" does not use an initialization vector (IV)";
    }
    @Override
    public final CredentialStoreException algorithmNotIV(final String algorithm) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), algorithmNotIV$str(), algorithm));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String readBytesMismatch$str() {
        return "ELY09524: The actual number of bytes read %d is different from the expected number of bytes %d to be read";
    }
    @Override
    public final IOException readBytesMismatch(final int actual, final int expected) {
        final IOException result = new IOException(String.format(getLoggingLocale(), readBytesMismatch$str(), actual, expected));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String locationAndExternalPathAreIdentical$str() {
        return "ELY09525: location and externalPath initial attributes are the same. [location=%s, externalPath=%s]";
    }
    @Override
    public final CredentialStoreException locationAndExternalPathAreIdentical(final String location, final String externalPath) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), locationAndExternalPathAreIdentical$str(), location, externalPath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedAttribute$str() {
        return "ELY09526: Unable to initialize credential store as attribute %s is unsupported in %s";
    }
    @Override
    public final CredentialStoreException unsupportedAttribute(final String attribute, final List<String> validAttribute) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), unsupportedAttribute$str(), attribute, validAttribute));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String externalPathMissing$str() {
        return "ELY09528: The externalPath attribute for key store type %s is missing.";
    }
    @Override
    public final CredentialStoreException externalPathMissing(final String keyStoreType) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), externalPathMissing$str(), keyStoreType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String externalStorageKeyDoesNotExist$str() {
        return "ELY11006: External storage key under alias \"%s\" does not exist";
    }
    @Override
    public final CredentialStoreException externalStorageKeyDoesNotExist(final String keyAlias) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), externalStorageKeyDoesNotExist$str(), keyAlias));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
