/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.digest;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.function.Supplier;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;
import org.wildfly.common.bytes.ByteStringBuilder;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.mechanism._private.ElytronMessages;
import org.wildfly.security.mechanism.digest.DigestQuote;
import org.wildfly.security.sasl.digest.AbstractDigestMechanism;
import org.wildfly.security.sasl.digest._private.DigestUtil;
import org.wildfly.security.util.DefaultTransformationMapper;
import org.wildfly.security.util.TransformationSpec;

final class DigestSaslClient
extends AbstractDigestMechanism
implements SaslClient {
    private static final byte STEP_TWO = 2;
    private static final byte STEP_FOUR = 4;
    private String[] realms;
    private String[] clientQops;
    private boolean stale = false;
    private int maxbuf = 65536;
    private String cipher_opts;
    private byte[] digest_urp;
    private final boolean hasInitialResponse;
    private final String[] demandedCiphers;

    DigestSaslClient(String mechanism, String protocol, String serverName, CallbackHandler callbackHandler, String authorizationId, boolean hasInitialResponse, Charset charset, String[] qops, String[] ciphers, Supplier<Provider[]> providers) throws SaslException {
        super(mechanism, protocol, serverName, callbackHandler, AbstractDigestMechanism.FORMAT.CLIENT, charset, ciphers, providers);
        this.hasInitialResponse = hasInitialResponse;
        this.authorizationId = authorizationId;
        this.clientQops = qops == null ? DigestUtil.QOP_VALUES : qops;
        this.demandedCiphers = ciphers == null ? new String[]{} : ciphers;
    }

    private void noteChallengeData(HashMap<String, byte[]> parsedChallenge) throws SaslException {
        this.stale = false;
        LinkedList<String> realmList = new LinkedList<String>();
        for (String keyWord : parsedChallenge.keySet()) {
            if (keyWord.startsWith("realm")) {
                realmList.add(new String(parsedChallenge.get(keyWord), StandardCharsets.UTF_8));
                continue;
            }
            if (keyWord.equals("qop")) {
                String serverQops = new String(parsedChallenge.get(keyWord), StandardCharsets.UTF_8);
                this.qop = this.selectQop(serverQops.split(String.valueOf(',')), this.clientQops);
                continue;
            }
            if (keyWord.equals("stale")) {
                this.stale = Boolean.parseBoolean(new String(parsedChallenge.get(keyWord), StandardCharsets.UTF_8));
                continue;
            }
            if (keyWord.equals("maxbuf")) {
                int maxbuf = Integer.parseInt(new String(parsedChallenge.get(keyWord), StandardCharsets.UTF_8));
                if (maxbuf <= 0) continue;
                this.maxbuf = maxbuf;
                continue;
            }
            if (keyWord.equals("nonce")) {
                this.nonce = parsedChallenge.get(keyWord);
                continue;
            }
            if (!keyWord.equals("cipher")) continue;
            this.cipher_opts = new String(parsedChallenge.get(keyWord), StandardCharsets.UTF_8);
            this.cipher = this.selectCipher(this.cipher_opts);
        }
        if (this.qop != null && !this.qop.equals("auth")) {
            this.setWrapper(new AbstractDigestMechanism.DigestWrapper(this, this.qop.equals("auth-conf")));
        }
        this.realms = new String[realmList.size()];
        realmList.toArray(this.realms);
    }

    private String selectQop(String[] serverQops, String[] clientQops) throws SaslException {
        for (String clientQop : clientQops) {
            if (!this.arrayContains(serverQops, clientQop)) continue;
            return clientQop;
        }
        throw ElytronMessages.saslDigest.mechNoCommonProtectionLayer().toSaslException();
    }

    private String selectCipher(String ciphersFromServer) throws SaslException {
        if (ciphersFromServer == null) {
            throw ElytronMessages.saslDigest.mechNoCiphersOfferedByServer().toSaslException();
        }
        DefaultTransformationMapper trans = new DefaultTransformationMapper();
        String[] tokensToChooseFrom = ciphersFromServer.split(String.valueOf(','));
        for (TransformationSpec ts : trans.getTransformationSpecByStrength("DIGEST-MD5", tokensToChooseFrom)) {
            for (String c : this.demandedCiphers) {
                if (!c.equals(ts.getToken())) continue;
                return ts.getToken();
            }
        }
        throw ElytronMessages.saslDigest.mechNoCommonCipher().toSaslException();
    }

    private byte[] createResponse(HashMap<String, byte[]> parsedChallenge) throws SaslException {
        String chs;
        ByteStringBuilder digestResponse = new ByteStringBuilder();
        byte[] chb = parsedChallenge.get("charset");
        Charset serverHashedURPUsingcharset = chb != null ? ("utf-8".equals(chs = new String(chb, StandardCharsets.UTF_8)) ? StandardCharsets.UTF_8 : StandardCharsets.ISO_8859_1) : StandardCharsets.ISO_8859_1;
        if (StandardCharsets.UTF_8.equals(serverHashedURPUsingcharset)) {
            digestResponse.append("charset=");
            digestResponse.append("utf-8");
            digestResponse.append(',');
        }
        if (!this.stale || this.username == null) {
            this.username = this.authorizationId;
            if (this.realms != null && this.realms.length >= 1) {
                this.realm = this.realms[0];
            }
            this.digest_urp = this.handleUserRealmPasswordCallbacks(this.realms, false, false);
        } else {
            ElytronMessages.saslDigest.trace("Stale nonce - re-authenticating using same credential");
        }
        digestResponse.append("username=\"");
        digestResponse.append(DigestQuote.quote(this.username).getBytes(serverHashedURPUsingcharset));
        digestResponse.append("\"").append(',');
        if (this.realm != null) {
            digestResponse.append("realm=\"");
            digestResponse.append(DigestQuote.quote(this.realm).getBytes(serverHashedURPUsingcharset));
            digestResponse.append("\"").append(',');
        }
        if (this.nonce == null) {
            throw ElytronMessages.saslDigest.mechMissingDirective("nonce").toSaslException();
        }
        digestResponse.append("nonce=\"");
        digestResponse.append(this.nonce);
        digestResponse.append("\"").append(',');
        digestResponse.append("nc=");
        int nonceCount = this.getNonceCount();
        digestResponse.append(DigestUtil.convertToHexBytesWithLeftPadding(nonceCount, 8));
        digestResponse.append(',');
        digestResponse.append("cnonce=\"");
        this.cnonce = DigestSaslClient.generateNonce();
        digestResponse.append(this.cnonce);
        digestResponse.append("\"").append(',');
        digestResponse.append("digest-uri=\"");
        digestResponse.append(this.digestURI);
        digestResponse.append("\"").append(',');
        digestResponse.append("maxbuf=");
        digestResponse.append(String.valueOf(this.maxbuf));
        digestResponse.append(',');
        this.hA1 = DigestUtil.H_A1(this.messageDigest, this.digest_urp, this.nonce, this.cnonce, this.authorizationId, serverHashedURPUsingcharset);
        byte[] response_value = DigestUtil.digestResponse(this.messageDigest, this.hA1, this.nonce, nonceCount, this.cnonce, this.authorizationId, this.qop, this.digestURI, true);
        digestResponse.append("response=");
        digestResponse.append(response_value);
        digestResponse.append(',');
        digestResponse.append("qop=");
        digestResponse.append(this.qop != null ? this.qop : "auth");
        if (this.cipher != null && this.cipher.length() != 0) {
            digestResponse.append(',');
            digestResponse.append("cipher=\"");
            digestResponse.append(this.cipher);
            digestResponse.append("\"");
        }
        if (this.authorizationId != null) {
            digestResponse.append(',');
            digestResponse.append("authzid=\"");
            digestResponse.append(DigestQuote.quote(this.authorizationId).getBytes(serverHashedURPUsingcharset));
            digestResponse.append("\"");
        }
        this.createCiphersAndKeys();
        return digestResponse.toArray();
    }

    private int getNonceCount() {
        return 1;
    }

    private void checkResponseAuth(HashMap<String, byte[]> parsedChallenge) throws SaslException {
        byte[] expected = DigestUtil.digestResponse(this.messageDigest, this.hA1, this.nonce, this.getNonceCount(), this.cnonce, this.authorizationId, this.qop, this.digestURI, false);
        if (!Arrays.equals(expected, parsedChallenge.get("rspauth"))) {
            throw ElytronMessages.saslDigest.mechServerAuthenticityCannotBeVerified().toSaslException();
        }
    }

    @Override
    public void init() {
        this.setNegotiationState(2);
    }

    @Override
    public boolean hasInitialResponse() {
        return this.hasInitialResponse;
    }

    @Override
    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        return this.evaluateMessage(challenge);
    }

    @Override
    protected byte[] evaluateMessage(int state, byte[] message) throws SaslException {
        HashMap<String, byte[]> parsedChallenge;
        try {
            parsedChallenge = org.wildfly.security.mechanism.digest.DigestUtil.parseResponse(message, this.charset, true, ElytronMessages.saslDigest);
        }
        catch (AuthenticationMechanismException e) {
            throw e.toSaslException();
        }
        block6: while (true) {
            switch (state) {
                case 2: {
                    this.noteChallengeData(parsedChallenge);
                    this.setNegotiationState(4);
                    return this.createResponse(parsedChallenge);
                }
                case 4: {
                    if (parsedChallenge.containsKey("nonce")) {
                        ElytronMessages.saslDigest.trace("Server requested re-authentication");
                        state = 2;
                        continue block6;
                    }
                    this.checkResponseAuth(parsedChallenge);
                    this.negotiationComplete();
                    return null;
                }
            }
            break;
        }
        throw Assert.impossibleSwitchCase((int)state);
    }
}

