package org.wildfly.security.http.util.sso;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.wildfly.security.http.HttpAuthenticationException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2021-02-24T15:09:54-0500")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void warnHttpMechSsoFailedLogoutParticipant(final String url, final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, warnHttpMechSsoFailedLogoutParticipant$str(), url);
    }
    protected String warnHttpMechSsoFailedLogoutParticipant$str() {
        return "ELY06008: Failed to logout participant [%s]. Participant will be removed from list of participants but its local session may still be active.";
    }
    protected String httpMechSsoInvalidLogoutMessage$str() {
        return "ELY06012: Invalid logout message received for local session [%s]";
    }
    @Override
    public final IllegalStateException httpMechSsoInvalidLogoutMessage(final String localSessionId) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), httpMechSsoInvalidLogoutMessage$str(), localSessionId));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void errorHttpMechSsoFailedInvalidateLocalSession(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, errorHttpMechSsoFailedInvalidateLocalSession$str());
    }
    protected String errorHttpMechSsoFailedInvalidateLocalSession$str() {
        return "ELY06013: Failed to invalidate local session";
    }
    protected String httpServerAuthenticationMechanismNotFound$str() {
        return "ELY06014: Authentication mechanism '%s' cannot be found";
    }
    @Override
    public final HttpAuthenticationException httpServerAuthenticationMechanismNotFound(final String mechanismName) {
        final HttpAuthenticationException result = new HttpAuthenticationException(String.format(getLoggingLocale(), httpServerAuthenticationMechanismNotFound$str(), mechanismName));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
