/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.http.oidc.AccessToken;
import org.wildfly.security.http.oidc.ElytronMessages;
import org.wildfly.security.http.oidc.OidcPrincipal;
import org.wildfly.security.http.oidc.RealmAccessClaim;
import org.wildfly.security.http.oidc.RefreshableOidcSecurityContext;

public class OidcSecurityRealm
implements SecurityRealm {
    @Override
    public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
        if (principal instanceof OidcPrincipal) {
            return this.createRealmIdentity((OidcPrincipal)principal);
        }
        return RealmIdentity.NON_EXISTENT;
    }

    private RealmIdentity createRealmIdentity(final OidcPrincipal principal) {
        return new RealmIdentity(){

            @Override
            public Principal getRealmIdentityPrincipal() {
                return principal;
            }

            @Override
            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
                return SupportLevel.UNSUPPORTED;
            }

            @Override
            public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
                return null;
            }

            @Override
            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
                return SupportLevel.SUPPORTED;
            }

            @Override
            public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
                return principal != null;
            }

            @Override
            public boolean exists() throws RealmUnavailableException {
                return principal != null;
            }

            @Override
            public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
                RefreshableOidcSecurityContext securityContext = (RefreshableOidcSecurityContext)principal.getOidcSecurityContext();
                MapAttributes attributes = new MapAttributes();
                Set roles = OidcSecurityRealm.getRolesFromSecurityContext(securityContext);
                attributes.addAll("Roles", roles);
                return AuthorizationIdentity.basicIdentity(attributes);
            }
        };
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
        return SupportLevel.UNSUPPORTED;
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        return SupportLevel.POSSIBLY_SUPPORTED;
    }

    private static Set<String> getRolesFromSecurityContext(RefreshableOidcSecurityContext session) {
        Set<String> roles = null;
        AccessToken accessToken = session.getToken();
        if (session.getOidcClientConfiguration().isUseResourceRoleMappings()) {
            RealmAccessClaim resourceAccessClaim;
            if (ElytronMessages.log.isTraceEnabled()) {
                ElytronMessages.log.trace("useResourceRoleMappings");
            }
            if ((resourceAccessClaim = accessToken.getResourceAccessClaim(session.getOidcClientConfiguration().getResourceName())) != null) {
                roles = resourceAccessClaim.getRoles().stream().collect(Collectors.toSet());
            }
        }
        if (session.getOidcClientConfiguration().isUseRealmRoleMappings()) {
            RealmAccessClaim realmAccessClaim;
            if (ElytronMessages.log.isTraceEnabled()) {
                ElytronMessages.log.trace("use realm role mappings");
            }
            if ((realmAccessClaim = accessToken.getRealmAccessClaim()) != null) {
                roles = realmAccessClaim.getRoles().stream().collect(Collectors.toSet());
            }
        }
        if (roles == null) {
            roles = Collections.emptySet();
        }
        if (ElytronMessages.log.isTraceEnabled()) {
            ElytronMessages.log.trace("Setting roles: ");
            for (String role : roles) {
                ElytronMessages.log.trace("   role: " + role);
            }
        }
        return roles;
    }
}

