package org.wildfly.security.credential._private;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import java.security.NoSuchAlgorithmException;
import org.jboss.logging.Logger;
import javax.security.sasl.SaslException;
import java.security.InvalidKeyException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2024-02-14T16:08:49-0500")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String emptyParameter$str() {
        return "ELY00002: Parameter %s is empty";
    }
    @Override
    public final IllegalArgumentException emptyParameter(final String parameter) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), emptyParameter$str(), parameter));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String unrecognizedAlgorithm$str() {
        return "ELY00004: Unrecognized algorithm \"%s\"";
    }
    @Override
    public final IllegalArgumentException unrecognizedAlgorithm(final String algorithm) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unrecognizedAlgorithm$str(), algorithm));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String certificateChainIsEmpty$str() {
        return "ELY01037: Certificate chain is empty";
    }
    @Override
    public final IllegalArgumentException certificateChainIsEmpty() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), certificateChainIsEmpty$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String insufficientDataToFormDigestAndSalt$str() {
        return "ELY01053: Insufficient data to form a digest and a salt";
    }
    @Override
    public final InvalidKeySpecException insufficientDataToFormDigestAndSalt() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), insufficientDataToFormDigestAndSalt$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSalt2$str() {
        return "ELY01054: Invalid salt \"%s%s\"";
    }
    @Override
    public final IllegalArgumentException invalidSalt(final char lo, final char hi) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidSalt2$str(), lo, hi));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidRounds$str() {
        return "ELY01055: Invalid rounds \"%s%s%s%s\"";
    }
    @Override
    public final IllegalArgumentException invalidRounds(final char b0, final char b1, final char b2, final char b3) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidRounds$str(), b0, b1, b2, b3));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSalt4$str() {
        return "ELY01056: Invalid salt \"%s%s%s%s\"";
    }
    @Override
    public final IllegalArgumentException invalidSalt(final char b0, final char b1, final char b2, final char b3) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidSalt4$str(), b0, b1, b2, b3));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mismatchedPublicPrivateKeyAlgorithms$str() {
        return "ELY01059: Public and private key algorithm names are mismatched";
    }
    @Override
    public final IllegalArgumentException mismatchedPublicPrivateKeyAlgorithms() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), mismatchedPublicPrivateKeyAlgorithms$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String publicKeyIsNull$str() {
        return "ELY01061: Public key is null";
    }
    @Override
    public final IllegalArgumentException publicKeyIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), publicKeyIsNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String privateKeyIsNull$str() {
        return "ELY01063: Private key is null";
    }
    @Override
    public final IllegalArgumentException privateKeyIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), privateKeyIsNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String keySpecMustBeSecretKeySpec$str() {
        return "ELY02032: keySpec must be SecretKeySpect, given: [%s]";
    }
    @Override
    public final InvalidKeySpecException keySpecMustBeSecretKeySpec(final String type) {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), keySpecMustBeSecretKeySpec$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String keyMustImplementSecretKeySpecAndKeySpecMustBeSecretKeySpec$str() {
        return "ELY02033: key must implement SecretKeySpec and keySpec must be SecretKeySpec, given key, keySpec: [%s]";
    }
    @Override
    public final InvalidKeySpecException keyMustImplementSecretKeySpecAndKeySpecMustBeSecretKeySpec(final String keyAndKeySpec) {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), keyMustImplementSecretKeySpecAndKeySpecMustBeSecretKeySpec$str(), keyAndKeySpec));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechInvalidOTPAlgorithm$str() {
        return "ELY05151: Invalid OTP algorithm \"%s\"";
    }
    @Override
    public final SaslException mechInvalidOTPAlgorithm(final String algorithm) {
        final SaslException result = new SaslException(String.format(getLoggingLocale(), mechInvalidOTPAlgorithm$str(), algorithm));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeySpecUnrecognizedKeySpecAlgorithm$str() {
        return "ELY08001: Unrecognized key spec algorithm";
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecUnrecognizedKeySpecAlgorithm() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecUnrecognizedKeySpecAlgorithm$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeySpecPasswordSpecCannotBeRenderedAsString$str() {
        return "ELY08002: Password spec cannot be rendered as a string";
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecPasswordSpecCannotBeRenderedAsString() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecPasswordSpecCannotBeRenderedAsString$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeySpecUnknownCryptStringAlgorithm$str() {
        return "ELY08003: Unknown crypt string algorithm";
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecUnknownCryptStringAlgorithm() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecUnknownCryptStringAlgorithm$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeySpecInvalidCharacterEncountered$str() {
        return "ELY08004: Invalid character encountered";
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecInvalidCharacterEncountered() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecInvalidCharacterEncountered$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeySpecNoIterationCountTerminatorGiven$str() {
        return "ELY08005: No iteration count terminator given";
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecNoIterationCountTerminatorGiven() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecNoIterationCountTerminatorGiven$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeySpecUnexpectedEndOfInputString$str() {
        return "ELY08006: Unexpected end of input string";
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecUnexpectedEndOfInputString() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecUnexpectedEndOfInputString$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeySpecNoSaltTerminatorGiven$str() {
        return "ELY08007: No salt terminator given";
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecNoSaltTerminatorGiven() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecNoSaltTerminatorGiven$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidHashLength$str() {
        return "ELY08008: Invalid hash length";
    }
    @Override
    public final IllegalArgumentException invalidHashLength() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidHashLength$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeySpecUnexpectedEndOfPasswordString$str() {
        return "ELY08009: Unexpected end of password string";
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecUnexpectedEndOfPasswordString() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecUnexpectedEndOfPasswordString$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeySpecUnexpectedEndOfPasswordStringWithCause$str() {
        return "ELY08010: Unexpected end of password string";
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecUnexpectedEndOfPasswordStringWithCause(final Throwable cause) {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecUnexpectedEndOfPasswordStringWithCause$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeySpecInvalidMinorVersion$str() {
        return "ELY08011: Invalid minor version";
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecInvalidMinorVersion() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecInvalidMinorVersion$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeySpecCostMustBeTwoDigitInteger$str() {
        return "ELY08012: Invalid cost: must be a two digit integer";
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecCostMustBeTwoDigitInteger() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecCostMustBeTwoDigitInteger$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeySpecNoSuchMessageDigestAlgorithm$str() {
        return "ELY08013: No such MessageDigest algorithm for \"%s\"";
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecNoSuchMessageDigestAlgorithm(final String algorithm) {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecNoSuchMessageDigestAlgorithm$str(), algorithm));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeyNoSuchMessageDigestAlgorithm$str() {
        return "ELY08014: No such MessageDigest algorithm for \"%s\"";
    }
    @Override
    public final InvalidKeyException invalidKeyNoSuchMessageDigestAlgorithm(final String algorithm) {
        final InvalidKeyException result = new InvalidKeyException(String.format(getLoggingLocale(), invalidKeyNoSuchMessageDigestAlgorithm$str(), algorithm));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeyCannotVerifyPassword$str() {
        return "ELY08015: Cannot verify password";
    }
    @Override
    public final InvalidKeyException invalidKeyCannotVerifyPassword(final Throwable cause) {
        final InvalidKeyException result = new InvalidKeyException(String.format(getLoggingLocale(), invalidKeyCannotVerifyPassword$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeyDesCryptPasswordHashMustBeBytes$str() {
        return "ELY08017: DES crypt password hash must be %d bytes";
    }
    @Override
    public final InvalidKeyException invalidKeyDesCryptPasswordHashMustBeBytes(final int bytes) {
        final InvalidKeyException result = new InvalidKeyException(String.format(getLoggingLocale(), invalidKeyDesCryptPasswordHashMustBeBytes$str(), bytes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidParameterSpecSaltMustBeBytesBits$str() {
        return "ELY08018: Salt must be %d bytes (%d bits)";
    }
    @Override
    public final InvalidParameterSpecException invalidParameterSpecSaltMustBeBytesBits(final int bytes, final int bits) {
        final InvalidParameterSpecException result = new InvalidParameterSpecException(String.format(getLoggingLocale(), invalidParameterSpecSaltMustBeBytesBits$str(), bytes, bits));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidNumberOfRoundsMustBeIntBetween$str() {
        return "ELY08020: Invalid number of rounds. Must be an integer between %d and %d, inclusive";
    }
    @Override
    public final IllegalArgumentException invalidNumberOfRoundsMustBeIntBetween(final int min, final int max) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidNumberOfRoundsMustBeIntBetween$str(), min, max));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSaltMustBeBytesLong$str() {
        return "ELY08021: Invalid salt: must be %d bytes long";
    }
    @Override
    public final IllegalArgumentException invalidSaltMustBeBytesLong(final int length) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidSaltMustBeBytesLong$str(), length));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeySpecBsdDesCryptPasswordHashMustBeBytes$str() {
        return "ELY08022: BSD DES crypt password hash must be %d bytes";
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecBsdDesCryptPasswordHashMustBeBytes(final int bytes) {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecBsdDesCryptPasswordHashMustBeBytes$str(), bytes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidParameterSpecSaltMustBeBytes$str() {
        return "ELY08023: Salt must be %d bytes";
    }
    @Override
    public final InvalidParameterSpecException invalidParameterSpecSaltMustBeBytes(final int bytes) {
        final InvalidParameterSpecException result = new InvalidParameterSpecException(String.format(getLoggingLocale(), invalidParameterSpecSaltMustBeBytes$str(), bytes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeyBsdDesCryptPasswordHashMustBeBytes$str() {
        return "ELY08024: BSD DES crypt password hash must be %d bytes";
    }
    @Override
    public final InvalidKeyException invalidKeyBsdDesCryptPasswordHashMustBeBytes(final int bytes) {
        final InvalidKeyException result = new InvalidKeyException(String.format(getLoggingLocale(), invalidKeyBsdDesCryptPasswordHashMustBeBytes$str(), bytes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeySpecExpectedSpecGotSpec$str() {
        return "ELY08025: Expected to get a \"%s\" as spec, got \"%s\"";
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecExpectedSpecGotSpec(final String expected, final String got) {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecExpectedSpecGotSpec$str(), expected, got));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec$str() {
        return "ELY08026: Unknown algorithm or incompatible PasswordSpec";
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeyUnknownUnknownPasswordTypeOrAlgorithm$str() {
        return "ELY08027: Unknown password type or algorithm";
    }
    @Override
    public final InvalidKeyException invalidKeyUnknownUnknownPasswordTypeOrAlgorithm() {
        final InvalidKeyException result = new InvalidKeyException(String.format(getLoggingLocale(), invalidKeyUnknownUnknownPasswordTypeOrAlgorithm$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noSuchAlgorithmInvalidAlgorithm$str() {
        return "ELY08028: Invalid algorithm \"%s\"";
    }
    @Override
    public final NoSuchAlgorithmException noSuchAlgorithmInvalidAlgorithm(final String algorithm) {
        final NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(getLoggingLocale(), noSuchAlgorithmInvalidAlgorithm$str(), algorithm));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotObtainKeySpecEncodingIdentifier$str() {
        return "ELY08029: Could not obtain key spec encoding identifier.";
    }
    @Override
    public final IllegalArgumentException couldNotObtainKeySpecEncodingIdentifier() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), couldNotObtainKeySpecEncodingIdentifier$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mismatchedPublicPrivateKeyParameters$str() {
        return "ELY09000: Public and private key parameters are mismatched";
    }
    @Override
    public final IllegalArgumentException mismatchedPublicPrivateKeyParameters() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), mismatchedPublicPrivateKeyParameters$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
