package org.wildfly.security.x500.cert._private;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.wildfly.security.asn1.ASN1Exception;
import java.security.cert.CertificateException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import java.time.ZonedDateTime;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2024-02-14T16:08:27-0500")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String malformedPemContent$str() {
        return "ELY03010: Malformed PEM content at offset %d";
    }
    @Override
    public final IllegalArgumentException malformedPemContent(final long offset) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), malformedPemContent$str(), offset));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String invalidPemType$str() {
        return "ELY03011: Invalid PEM type (expected \"%s\", got \"%s\"";
    }
    @Override
    public final IllegalArgumentException invalidPemType(final String expected, final String actual) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidPemType$str(), expected, actual));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String certificateParseError$str() {
        return "ELY03012: Certificate parse error";
    }
    @Override
    public final IllegalArgumentException certificateParseError(final CertificateException cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), certificateParseError$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String publicKeyParseError$str() {
        return "ELY03023: PublicKey parse error";
    }
    @Override
    public final IllegalArgumentException publicKeyParseError(final Throwable cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), publicKeyParseError$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String privateKeyParseError$str() {
        return "ELY03033: PrivateKey parse error";
    }
    @Override
    public final IllegalArgumentException privateKeyParseError(final Throwable cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), privateKeyParseError$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String asnUnrecognisedAlgorithm$str() {
        return "ELY07001: Unrecognized encoding algorithm [%s]";
    }
    @Override
    public final ASN1Exception asnUnrecognisedAlgorithm(final String algorithm) {
        final ASN1Exception result = new ASN1Exception(String.format(getLoggingLocale(), asnUnrecognisedAlgorithm$str(), algorithm));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String asnUnexpectedTag$str() {
        return "ELY07004: Unexpected ASN.1 tag encountered";
    }
    @Override
    public final ASN1Exception asnUnexpectedTag() {
        final ASN1Exception result = new ASN1Exception(String.format(getLoggingLocale(), asnUnexpectedTag$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String extensionAlreadyExists$str() {
        return "ELY10000: X.509 certificate extension with OID %s already exists";
    }
    @Override
    public final IllegalArgumentException extensionAlreadyExists(final String oid) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), extensionAlreadyExists$str(), oid));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noSignatureAlgorithmNameGiven$str() {
        return "ELY10001: No signature algorithm name given";
    }
    @Override
    public final IllegalArgumentException noSignatureAlgorithmNameGiven() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noSignatureAlgorithmNameGiven$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownSignatureAlgorithmName$str() {
        return "ELY10002: Signature algorithm name \"%s\" is not recognized";
    }
    @Override
    public final IllegalArgumentException unknownSignatureAlgorithmName(final String signatureAlgorithmName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownSignatureAlgorithmName$str(), signatureAlgorithmName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noSigningKeyGiven$str() {
        return "ELY10003: No signing key given";
    }
    @Override
    public final IllegalArgumentException noSigningKeyGiven() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noSigningKeyGiven$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String signingKeyNotCompatWithSig$str() {
        return "ELY10004: Signing key algorithm name \"%s\" is not compatible with signature algorithm name \"%s\"";
    }
    @Override
    public final IllegalArgumentException signingKeyNotCompatWithSig(final String signingKeyAlgorithm, final String signatureAlgorithmName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), signingKeyNotCompatWithSig$str(), signingKeyAlgorithm, signatureAlgorithmName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String validAfterBeforeValidBefore$str() {
        return "ELY10005: Not-valid-before date of %s is after not-valid-after date of %s";
    }
    @Override
    public final IllegalArgumentException validAfterBeforeValidBefore(final ZonedDateTime notValidBefore, final ZonedDateTime notValidAfter) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), validAfterBeforeValidBefore$str(), notValidBefore, notValidAfter));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noIssuerDnGiven$str() {
        return "ELY10006: No issuer DN given";
    }
    @Override
    public final IllegalArgumentException noIssuerDnGiven() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noIssuerDnGiven$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noPublicKeyGiven$str() {
        return "ELY10007: No public key given";
    }
    @Override
    public final IllegalArgumentException noPublicKeyGiven() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noPublicKeyGiven$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String uniqueIdNotAllowed$str() {
        return "ELY10008: Issuer and subject unique ID are only allowed in certificates with version 2 or higher";
    }
    @Override
    public final IllegalArgumentException uniqueIdNotAllowed() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), uniqueIdNotAllowed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String extensionsNotAllowed$str() {
        return "ELY10009: Extensions are only allowed in certificates with version 3 or higher";
    }
    @Override
    public final IllegalArgumentException extensionsNotAllowed() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), extensionsNotAllowed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeyForCert$str() {
        return "ELY10010: X.509 encoding of public key with algorithm \"%s\" failed";
    }
    @Override
    public final IllegalArgumentException invalidKeyForCert(final String publicKeyAlgorithm, final Exception cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidKeyForCert$str(), publicKeyAlgorithm), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String certSigningFailed$str() {
        return "ELY10011: Failed to sign certificate";
    }
    @Override
    public final IllegalArgumentException certSigningFailed(final Exception cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), certSigningFailed$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String serialNumberTooSmall$str() {
        return "ELY10012: Certificate serial number must be positive";
    }
    @Override
    public final IllegalArgumentException serialNumberTooSmall() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), serialNumberTooSmall$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String serialNumberTooLarge$str() {
        return "ELY10013: Certificate serial number too large (cannot exceed 20 octets)";
    }
    @Override
    public final IllegalArgumentException serialNumberTooLarge() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), serialNumberTooLarge$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String certRequestInfoSigningFailed$str() {
        return "ELY10014: Failed to sign certification request info";
    }
    @Override
    public final IllegalArgumentException certRequestInfoSigningFailed(final Exception cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), certRequestInfoSigningFailed$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noCertificateGiven$str() {
        return "ELY10015: No certificate given";
    }
    @Override
    public final IllegalArgumentException noCertificateGiven() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noCertificateGiven$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noDnGiven$str() {
        return "ELY10017: No DN given";
    }
    @Override
    public final IllegalArgumentException noDnGiven() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noDnGiven$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String selfSignedCertificateGenerationFailed$str() {
        return "ELY10018: Failed to generate self-signed X.509 certificate";
    }
    @Override
    public final IllegalArgumentException selfSignedCertificateGenerationFailed(final Exception cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), selfSignedCertificateGenerationFailed$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToDetermineDefaultCompatibleSignatureAlgorithmName$str() {
        return "ELY10019: Unable to determine default compatible signature algorithm name for key algorithm name \"%s\"";
    }
    @Override
    public final IllegalArgumentException unableToDetermineDefaultCompatibleSignatureAlgorithmName(final String keyAlgorithmName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unableToDetermineDefaultCompatibleSignatureAlgorithmName$str(), keyAlgorithmName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String certificateExtensionCreationFromStringNotSupported$str() {
        return "ELY10020: Creating an X.509 certificate extension from a string value is not supported for extension name \"%s\"";
    }
    @Override
    public final IllegalArgumentException certificateExtensionCreationFromStringNotSupported(final String extensionName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), certificateExtensionCreationFromStringNotSupported$str(), extensionName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidCertificateExtensionStringValue1$str() {
        return "ELY10021: Invalid X.509 certificate extension string value \"%s\"";
    }
    @Override
    public final IllegalArgumentException invalidCertificateExtensionStringValue(final String extensionValue) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidCertificateExtensionStringValue1$str(), extensionValue));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String certificateExtensionCreationFromStringFailed$str() {
        return "ELY10022: Failed to create X.509 certificate extension from string value";
    }
    @Override
    public final IllegalArgumentException certificateExtensionCreationFromStringFailed(final Exception cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), certificateExtensionCreationFromStringFailed$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String certificateExtensionMustBeNonCritical$str() {
        return "ELY10023: X.509 certificate extension \"%s\" must be non-critical";
    }
    @Override
    public final IllegalArgumentException certificateExtensionMustBeNonCritical(final String extensionName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), certificateExtensionMustBeNonCritical$str(), extensionName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidCertificateExtensionStringValue0$str() {
        return "ELY10024: Invalid X.509 certificate extension string value";
    }
    @Override
    public final IllegalArgumentException invalidCertificateExtensionStringValue() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidCertificateExtensionStringValue0$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String openSshParseError$str() {
        return "ELY18000: Malformed OpenSSH Private Key: %s";
    }
    @Override
    public final IllegalArgumentException openSshParseError(final String e) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), openSshParseError$str(), e));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String openSshGeneratingError$str() {
        return "ELY18001: Unable to Generate Key: %s";
    }
    @Override
    public final IllegalArgumentException openSshGeneratingError(final String e) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), openSshGeneratingError$str(), e));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
