/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.digest;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import org.wildfly.common.array.Arrays2;
import org.wildfly.common.bytes.ByteStringBuilder;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.mechanism._private.ElytronMessages;
import org.wildfly.security.mechanism.digest.PasswordDigestObtainer;
import org.wildfly.security.sasl.digest._private.DigestUtil;
import org.wildfly.security.sasl.util.AbstractSaslParticipant;
import org.wildfly.security.sasl.util.SaslWrapper;
import org.wildfly.security.util.DefaultTransformationMapper;
import org.wildfly.security.util.TransformationSpec;

abstract class AbstractDigestMechanism
extends AbstractSaslParticipant {
    private static int NONCE_SIZE = 36;
    public static final int DEFAULT_MAXBUF = 65536;
    public static final char DELIMITER = ',';
    public static final String[] CIPHER_OPTS = new String[]{"des", "3des", "rc4", "rc4-40", "rc4-56"};
    private FORMAT format;
    protected final String digestURI;
    protected Charset charset = StandardCharsets.ISO_8859_1;
    protected MessageDigest digest;
    protected String cipher;
    protected String qop;
    protected int wrapSeqNum;
    protected int unwrapSeqNum;
    protected byte[] nonce;
    protected byte[] cnonce;
    protected String username;
    protected String realm;
    protected String authorizationId;
    protected byte[] hA1;
    protected SecureRandom secureRandomGenerator = new SecureRandom();
    protected Mac hmacMD5 = this.getHmac();
    protected Cipher wrapCipher = null;
    protected Cipher unwrapCipher = null;
    protected byte[] wrapHmacKeyIntegrity;
    protected byte[] unwrapHmacKeyIntegrity;
    protected final MessageDigest messageDigest;
    private final Supplier<Provider[]> providers;
    private static final String CLIENT_MAGIC_INTEGRITY = "Digest session key to client-to-server signing key magic constant";
    private static final String SERVER_MAGIC_INTEGRITY = "Digest session key to server-to-client signing key magic constant";
    private static final String CLIENT_MAGIC_CONFIDENTIALITY = "Digest H(A1) to client-to-server sealing key magic constant";
    private static final String SERVER_MAGIC_CONFIDENTIALITY = "Digest H(A1) to server-to-client sealing key magic constant";

    public AbstractDigestMechanism(String mechanismName, String protocol, String serverName, CallbackHandler callbackHandler, FORMAT format, Charset charset, String[] ciphers, Supplier<Provider[]> providers) throws SaslException {
        super(mechanismName, protocol, serverName, callbackHandler, ElytronMessages.saslDigest);
        String algorithm = DigestUtil.messageDigestAlgorithm(mechanismName);
        if (algorithm == null) {
            throw ElytronMessages.saslDigest.mechMacAlgorithmNotSupported(null).toSaslException();
        }
        try {
            this.messageDigest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw ElytronMessages.saslDigest.mechMacAlgorithmNotSupported(e).toSaslException();
        }
        try {
            this.digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw ElytronMessages.saslDigest.mechMacAlgorithmNotSupported(e).toSaslException();
        }
        this.format = format;
        this.digestURI = this.getProtocol() + "/" + this.getServerName();
        this.charset = charset != null ? charset : StandardCharsets.ISO_8859_1;
        this.providers = providers;
    }

    static String getSupportedCiphers(String[] demandedCiphers) {
        DefaultTransformationMapper trans = new DefaultTransformationMapper();
        if (demandedCiphers == null) {
            demandedCiphers = CIPHER_OPTS;
        }
        StringBuilder ciphers = new StringBuilder();
        for (TransformationSpec ts : trans.getTransformationSpecByStrength("DIGEST-MD5", demandedCiphers)) {
            if (ciphers.length() > 0) {
                ciphers.append(',');
            }
            ciphers.append(ts.getToken());
        }
        return ciphers.toString();
    }

    static byte[] generateNonce() {
        SecureRandom random = new SecureRandom();
        byte[] nonceData = new byte[NONCE_SIZE];
        random.nextBytes(nonceData);
        return ByteIterator.ofBytes((byte[])nonceData).base64Encode().drainToString().getBytes(StandardCharsets.US_ASCII);
    }

    protected boolean arrayContains(String[] array, String searched) {
        for (String item : array) {
            if (!searched.equals(item)) continue;
            return true;
        }
        return false;
    }

    public Charset getCharset() {
        return this.charset;
    }

    byte[] handleUserRealmPasswordCallbacks(String[] realms, boolean readOnlyRealmUsername, boolean skipRealmCallbacks) throws SaslException {
        try {
            PasswordDigestObtainer obtainer = new PasswordDigestObtainer(this.getCallbackHandler(), this.username, this.realm, ElytronMessages.saslDigest, DigestUtil.passwordAlgorithm(this.getMechanismName()), this.messageDigest, this.providers, realms, readOnlyRealmUsername, skipRealmCallbacks);
            byte[] digest = obtainer.handleUserRealmPasswordCallbacks();
            this.username = obtainer.getUsername();
            this.realm = obtainer.getRealm();
            return digest;
        }
        catch (AuthenticationMechanismException e) {
            throw e.toSaslException();
        }
    }

    private byte[] wrapIntegrityProtectedMessage(byte[] message, int offset, int len) throws SaslException {
        byte[] messageMac = DigestUtil.computeHMAC(this.wrapHmacKeyIntegrity, this.wrapSeqNum, this.hmacMD5, message, offset, len);
        byte[] result = new byte[len + 16];
        System.arraycopy(message, offset, result, 0, len);
        System.arraycopy(messageMac, 0, result, len, 10);
        DigestUtil.integerByteOrdered(1, result, len + 10, 2);
        DigestUtil.integerByteOrdered(this.wrapSeqNum, result, len + 12, 4);
        ++this.wrapSeqNum;
        return result;
    }

    private byte[] unwrapIntegrityProtectedMessage(byte[] message, int offset, int len) throws SaslException {
        int messageType = DigestUtil.decodeByteOrderedInteger(message, offset + len - 6, 2);
        int extractedSeqNum = DigestUtil.decodeByteOrderedInteger(message, offset + len - 4, 4);
        if (messageType != 1) {
            throw ElytronMessages.saslDigest.mechMessageTypeMustEqual(1, messageType).toSaslException();
        }
        if (extractedSeqNum != this.unwrapSeqNum) {
            throw ElytronMessages.saslDigest.mechBadSequenceNumberWhileUnwrapping(this.unwrapSeqNum, extractedSeqNum).toSaslException();
        }
        byte[] extractedMessageMac = new byte[10];
        byte[] extractedMessage = new byte[len - 16];
        System.arraycopy(message, offset, extractedMessage, 0, len - 16);
        System.arraycopy(message, offset + len - 16, extractedMessageMac, 0, 10);
        byte[] expectedHmac = DigestUtil.computeHMAC(this.unwrapHmacKeyIntegrity, extractedSeqNum, this.hmacMD5, extractedMessage, 0, extractedMessage.length);
        if (!Arrays2.equals((byte[])expectedHmac, (int)0, (byte[])extractedMessageMac, (int)0, (int)10)) {
            return NO_BYTES;
        }
        ++this.unwrapSeqNum;
        return extractedMessage;
    }

    private byte[] wrapConfidentialityProtectedMessage(byte[] message, int offset, int len) throws SaslException {
        byte[] messageMac = DigestUtil.computeHMAC(this.wrapHmacKeyIntegrity, this.wrapSeqNum, this.hmacMD5, message, offset, len);
        int paddingLength = 0;
        byte[] pad = null;
        int blockSize = this.wrapCipher.getBlockSize();
        if (blockSize > 0) {
            paddingLength = blockSize - (len + 10) % blockSize;
            pad = new byte[paddingLength];
            Arrays.fill(pad, (byte)paddingLength);
        }
        byte[] toCipher = new byte[len + paddingLength + 10];
        System.arraycopy(message, offset, toCipher, 0, len);
        if (paddingLength > 0) {
            System.arraycopy(pad, 0, toCipher, len, paddingLength);
        }
        System.arraycopy(messageMac, 0, toCipher, len + paddingLength, 10);
        byte[] cipheredPart = null;
        try {
            cipheredPart = this.wrapCipher.update(toCipher);
        }
        catch (Exception e) {
            throw ElytronMessages.saslDigest.mechProblemDuringCrypt(e).toSaslException();
        }
        if (cipheredPart == null) {
            throw ElytronMessages.saslDigest.mechProblemDuringCryptResultIsNull().toSaslException();
        }
        byte[] result = new byte[cipheredPart.length + 6];
        System.arraycopy(cipheredPart, 0, result, 0, cipheredPart.length);
        DigestUtil.integerByteOrdered(1, result, cipheredPart.length, 2);
        DigestUtil.integerByteOrdered(this.wrapSeqNum, result, cipheredPart.length + 2, 4);
        ++this.wrapSeqNum;
        return result;
    }

    private byte[] unwrapConfidentialityProtectedMessage(byte[] message, int offset, int len) throws SaslException {
        int messageType = DigestUtil.decodeByteOrderedInteger(message, offset + len - 6, 2);
        int extractedSeqNum = DigestUtil.decodeByteOrderedInteger(message, offset + len - 4, 4);
        if (messageType != 1) {
            throw ElytronMessages.saslDigest.mechMessageTypeMustEqual(1, messageType).toSaslException();
        }
        if (extractedSeqNum != this.unwrapSeqNum) {
            throw ElytronMessages.saslDigest.mechBadSequenceNumberWhileUnwrapping(this.unwrapSeqNum, extractedSeqNum).toSaslException();
        }
        byte[] clearText = null;
        try {
            clearText = this.unwrapCipher.update(message, offset, len - 6);
        }
        catch (Exception e) {
            throw ElytronMessages.saslDigest.mechProblemDuringDecrypt(e).toSaslException();
        }
        if (clearText == null) {
            throw ElytronMessages.saslDigest.mechProblemDuringDecryptResultIsNull().toSaslException();
        }
        byte[] hmac = new byte[10];
        System.arraycopy(clearText, clearText.length - 10, hmac, 0, 10);
        byte[] decryptedMessage = null;
        if (this.unwrapCipher.getBlockSize() > 0) {
            byte padSize = clearText[clearText.length - 10 - 1];
            int decryptedMessageSize = clearText.length - 10;
            if (padSize < 8) {
                int i = clearText.length - 10 - 1;
                while (clearText[i] == padSize) {
                    --i;
                }
                decryptedMessageSize = i + 1;
            }
            decryptedMessage = new byte[decryptedMessageSize];
            System.arraycopy(clearText, 0, decryptedMessage, 0, decryptedMessageSize);
        } else {
            decryptedMessage = new byte[clearText.length - 10];
            System.arraycopy(clearText, 0, decryptedMessage, 0, clearText.length - 10);
        }
        byte[] expectedHmac = DigestUtil.computeHMAC(this.unwrapHmacKeyIntegrity, extractedSeqNum, this.hmacMD5, decryptedMessage, 0, decryptedMessage.length);
        if (!Arrays2.equals((byte[])expectedHmac, (int)0, (byte[])hmac, (int)0, (int)10)) {
            return NO_BYTES;
        }
        ++this.unwrapSeqNum;
        return decryptedMessage;
    }

    protected void createCiphersAndKeys() throws SaslException {
        this.wrapHmacKeyIntegrity = this.createIntegrityKey(true);
        this.unwrapHmacKeyIntegrity = this.createIntegrityKey(false);
        if (this.cipher == null || this.cipher.length() == 0) {
            return;
        }
        this.wrapCipher = this.createCipher(true);
        this.unwrapCipher = this.createCipher(false);
    }

    protected byte[] createIntegrityKey(boolean wrap) {
        ByteStringBuilder key = new ByteStringBuilder(this.hA1);
        if (wrap) {
            key.append(this.format == FORMAT.CLIENT ? CLIENT_MAGIC_INTEGRITY : SERVER_MAGIC_INTEGRITY);
        } else {
            key.append(this.format == FORMAT.CLIENT ? SERVER_MAGIC_INTEGRITY : CLIENT_MAGIC_INTEGRITY);
        }
        this.digest.reset();
        return this.digest.digest(key.toArray());
    }

    protected Cipher createCipher(boolean wrap) throws SaslException {
        Cipher ciph;
        byte[] hmacKey;
        int n = this.gethA1PrefixLength(this.cipher);
        ByteStringBuilder key = new ByteStringBuilder();
        key.append(this.hA1, 0, n);
        if (wrap) {
            key.append(this.format == FORMAT.CLIENT ? CLIENT_MAGIC_CONFIDENTIALITY : SERVER_MAGIC_CONFIDENTIALITY);
            hmacKey = this.digest.digest(key.toArray());
        } else {
            key.append(this.format == FORMAT.CLIENT ? SERVER_MAGIC_CONFIDENTIALITY : CLIENT_MAGIC_CONFIDENTIALITY);
            hmacKey = this.digest.digest(key.toArray());
        }
        DefaultTransformationMapper trans = new DefaultTransformationMapper();
        byte[] IV = null;
        try {
            SecretKey cipherKey;
            String alg;
            TransformationSpec transformationSpec = trans.getTransformationSpec("DIGEST-MD5", this.cipher);
            if (transformationSpec == null) {
                throw ElytronMessages.saslDigest.mechUnknownCipher(this.cipher).toSaslException();
            }
            ciph = Cipher.getInstance(transformationSpec.getTransformation());
            int slash = ciph.getAlgorithm().indexOf(47);
            String string = alg = slash > -1 ? ciph.getAlgorithm().substring(0, slash) : ciph.getAlgorithm();
            if (this.cipher.startsWith("rc")) {
                byte[] cipherKeyBytes = (byte[])hmacKey.clone();
                cipherKey = new SecretKeySpec(cipherKeyBytes, alg);
            } else if (this.cipher.equals("des")) {
                byte[] cipherKeyBytes = Arrays.copyOf(hmacKey, 7);
                IV = Arrays.copyOfRange(hmacKey, 8, 16);
                cipherKey = DigestUtil.createDesSecretKey(cipherKeyBytes);
            } else if (this.cipher.equals("3des")) {
                byte[] cipherKeyBytes = Arrays.copyOf(hmacKey, 14);
                IV = Arrays.copyOfRange(hmacKey, 8, 16);
                cipherKey = DigestUtil.create3desSecretKey(cipherKeyBytes);
            } else {
                throw ElytronMessages.saslDigest.mechUnknownCipher(this.cipher).toSaslException();
            }
            if (IV != null) {
                ciph.init(wrap ? 1 : 2, (Key)cipherKey, new IvParameterSpec(IV), this.secureRandomGenerator);
            } else {
                ciph.init(wrap ? 1 : 2, (Key)cipherKey, this.secureRandomGenerator);
            }
        }
        catch (Exception e) {
            throw ElytronMessages.saslDigest.mechProblemGettingRequiredCipher(e).toSaslException();
        }
        return ciph;
    }

    private int gethA1PrefixLength(String cipher) {
        if (cipher.equals("rc4-40")) {
            return 5;
        }
        if (cipher.equals("rc4-56")) {
            return 7;
        }
        return 16;
    }

    private Mac getHmac() throws SaslException {
        try {
            return Mac.getInstance("HmacMD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw ElytronMessages.saslDigest.mechMacAlgorithmNotSupported(e).toSaslException();
        }
    }

    protected class DigestWrapper
    implements SaslWrapper {
        private boolean confidential;

        protected DigestWrapper(boolean confidential) {
            this.confidential = confidential;
        }

        @Override
        public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
            if (this.confidential) {
                return AbstractDigestMechanism.this.wrapConfidentialityProtectedMessage(outgoing, offset, len);
            }
            return AbstractDigestMechanism.this.wrapIntegrityProtectedMessage(outgoing, offset, len);
        }

        @Override
        public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
            if (this.confidential) {
                return AbstractDigestMechanism.this.unwrapConfidentialityProtectedMessage(incoming, offset, len);
            }
            return AbstractDigestMechanism.this.unwrapIntegrityProtectedMessage(incoming, offset, len);
        }
    }

    public static enum FORMAT {
        CLIENT,
        SERVER;

    }
}

