/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;

public final class ServiceLoaderSaslClientFactory
implements SaslClientFactory {
    private final ServiceLoader<SaslClientFactory> loader;

    public ServiceLoaderSaslClientFactory(ServiceLoader<SaslClientFactory> loader) {
        this.loader = loader;
    }

    public ServiceLoaderSaslClientFactory(ClassLoader classLoader) {
        this(ServiceLoader.load(SaslClientFactory.class, classLoader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        ArrayList<SaslClientFactory> factoryList = new ArrayList<SaslClientFactory>();
        ServiceLoader<SaslClientFactory> serviceLoader = this.loader;
        synchronized (serviceLoader) {
            Iterator<SaslClientFactory> iterator = this.loader.iterator();
            while (true) {
                try {
                    while (iterator.hasNext()) {
                        factoryList.add(iterator.next());
                    }
                }
                catch (ServiceConfigurationError serviceConfigurationError) {
                    continue;
                }
                break;
            }
        }
        String[] mechArray = new String[1];
        String[] stringArray = mechanisms;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String mechanism;
            mechArray[0] = mechanism = stringArray[i];
            for (SaslClientFactory clientFactory : factoryList) {
                SaslClient saslClient = clientFactory.createSaslClient(mechArray, authorizationId, protocol, serverName, props, cbh);
                if (saslClient == null) continue;
                return saslClient;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        ServiceLoader<SaslClientFactory> serviceLoader = this.loader;
        synchronized (serviceLoader) {
            LinkedHashSet set = new LinkedHashSet();
            Iterator<SaslClientFactory> iterator = this.loader.iterator();
            while (true) {
                try {
                    while (iterator.hasNext()) {
                        SaslClientFactory clientFactory = iterator.next();
                        Collections.addAll(set, clientFactory.getMechanismNames(props));
                    }
                }
                catch (ServiceConfigurationError serviceConfigurationError) {
                    continue;
                }
                break;
            }
            return set.toArray(new String[set.size()]);
        }
    }
}

