package org.wildfly.security.util;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.security.GeneralSecurityException;
import java.lang.String;
import java.io.IOException;
import org.jboss.logging.Logger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Class;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-01-12T15:08:26-0500")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String generalInvalidName$str() {
        return "ELY00009: Invalid name \"%s\"";
    }
    @Override
    public final IllegalArgumentException generalInvalidName(final String str) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), generalInvalidName$str(), str));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String iterationCountNotSpecified$str() {
        return "ELY03025: Iteration count not specified for password based encryption";
    }
    @Override
    public final IllegalArgumentException iterationCountNotSpecified() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), iterationCountNotSpecified$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String saltNotSpecified$str() {
        return "ELY03026: Salt not specified for password based encryption";
    }
    @Override
    public final IllegalArgumentException saltNotSpecified() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), saltNotSpecified$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String initialKeyNotSpecified$str() {
        return "ELY03027: Initial key not specified for password based encryption";
    }
    @Override
    public final IllegalArgumentException initialKeyNotSpecified() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), initialKeyNotSpecified$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String securityProviderDoesnExist$str() {
        return "ELY03028: Security provider \"%s\" doesn't exist";
    }
    @Override
    public final IllegalArgumentException securityProviderDoesnExist(final String providerName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), securityProviderDoesnExist$str(), providerName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noSuchKeyAlgorithm$str() {
        return "ELY03029: No such key algorithm \"%s\"";
    }
    @Override
    public final IllegalArgumentException noSuchKeyAlgorithm(final String algorithmName, final GeneralSecurityException cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noSuchKeyAlgorithm$str(), algorithmName), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String closed$str() {
        return "ELY03030: I/O operation failed: closed";
    }
    @Override
    public final IOException closed() {
        final IOException result = new IOException(String.format(getLoggingLocale(), closed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String wrongBase64InPBCompatibleMode$str() {
        return "ELY03032: Base64 string created with unsupported PicketBox version \"%s\"";
    }
    @Override
    public final IllegalArgumentException wrongBase64InPBCompatibleMode(final String base64) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), wrongBase64InPBCompatibleMode$str(), base64));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechanismNotSupported$str() {
        return "ELY04020: Mechanism \"%s\" not supported by transformation mapper";
    }
    @Override
    public final IllegalArgumentException mechanismNotSupported(final String mechanism) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), mechanismNotSupported$str(), mechanism));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToEncode$str() {
        return "ELY08030: Failed to encode parameter specification";
    }
    @Override
    public final InvalidParameterSpecException failedToEncode(final Throwable cause) {
        final InvalidParameterSpecException result = new InvalidParameterSpecException(String.format(getLoggingLocale(), failedToEncode$str()));
        result.initCause(cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToDecode$str() {
        return "ELY08031: Failed to decode parameter specification";
    }
    @Override
    public final IOException failedToDecode(final Throwable cause) {
        final IOException result = new IOException(String.format(getLoggingLocale(), failedToDecode$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidParameterSpec$str() {
        return "ELY08032: Invalid parameter specification type (expected %s, got %s)";
    }
    @Override
    public final InvalidParameterSpecException invalidParameterSpec(final Class<?> expected, final Class<?> actual) {
        final InvalidParameterSpecException result = new InvalidParameterSpecException(String.format(getLoggingLocale(), invalidParameterSpec$str(), expected, actual));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFormat$str() {
        return "ELY08033: Invalid format given (expected %s, got %s)";
    }
    @Override
    public final IOException invalidFormat(final String expected, final String actual) {
        final IOException result = new IOException(String.format(getLoggingLocale(), invalidFormat$str(), expected, actual));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String algorithmParametersNotInitialized$str() {
        return "ELY08034: Algorithm parameters instance not initialized";
    }
    @Override
    public final IllegalStateException algorithmParametersNotInitialized() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), algorithmParametersNotInitialized$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
