/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.security.Principal;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.wildfly.common.Assert;
import org.wildfly.security.evidence.Evidence;

@FunctionalInterface
public interface RealmMapper {
    public static final RealmMapper DEFAULT_REALM_MAPPER = RealmMapper.single(null);

    public String getRealmMapping(Principal var1, Evidence var2);

    public static RealmMapper single(String realmName) {
        return (principal, evidence) -> realmName;
    }

    public static RealmMapper matching(BiPredicate<? super Principal, ? super Evidence> matchRule, String realmName) {
        Assert.checkNotNullParam((String)"matchRule", matchRule);
        return (p, e) -> matchRule.test(p, e) ? realmName : null;
    }

    public static RealmMapper matchingPrincipal(Predicate<? super Principal> matchRule, String realmName) {
        Assert.checkNotNullParam((String)"matchRule", matchRule);
        return RealmMapper.matching((p, e) -> matchRule.test((Principal)p), realmName);
    }

    public static RealmMapper matchingPrincipalType(Class<? extends Principal> principalType, String realmName) {
        Assert.checkNotNullParam((String)"principalType", principalType);
        return RealmMapper.matchingPrincipal(principalType::isInstance, realmName);
    }

    public static RealmMapper matchingEvidence(Predicate<? super Evidence> matchRule, String realmName) {
        Assert.checkNotNullParam((String)"matchRule", matchRule);
        return RealmMapper.matching((p, e) -> matchRule.test((Evidence)e), realmName);
    }

    public static RealmMapper matchingEvidenceType(Class<? extends Evidence> evidenceType, String realmName) {
        Assert.checkNotNullParam((String)"evidenceType", evidenceType);
        return RealmMapper.matchingEvidence(evidenceType::isInstance, realmName);
    }

    public static RealmMapper aggregate(RealmMapper mapper1, RealmMapper mapper2) {
        Assert.checkNotNullParam((String)"mapper1", (Object)mapper1);
        Assert.checkNotNullParam((String)"mapper2", (Object)mapper2);
        return (principal, evidence) -> {
            String mapping = mapper1.getRealmMapping(principal, evidence);
            if (mapping == null) {
                mapping = mapper2.getRealmMapping(principal, evidence);
            }
            return mapping;
        };
    }

    public static RealmMapper aggregate(RealmMapper ... mappers) {
        Assert.checkNotNullParam((String)"mappers", (Object)mappers);
        return (principal, evidence) -> {
            for (RealmMapper mapper : mappers) {
                String mapping;
                if (mapper == null || (mapping = mapper.getRealmMapping(principal, evidence)) == null) continue;
                return mapping;
            }
            return null;
        };
    }
}

