/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerCookie;
import org.wildfly.security.http.HttpServerScopes;

public interface HttpExchangeSpi
extends HttpServerScopes {
    public List<String> getRequestHeaderValues(String var1);

    public void addResponseHeader(String var1, String var2);

    default public String getFirstRequestHeaderValue(String headerName) {
        List<String> headerValues = this.getRequestHeaderValues(headerName);
        return headerValues != null && headerValues.size() > 0 ? headerValues.get(0) : null;
    }

    default public SSLSession getSSLSession() {
        return null;
    }

    default public Certificate[] getPeerCertificates(boolean renegotiate) {
        SSLSession sslSession = this.getSSLSession();
        if (sslSession != null) {
            try {
                return sslSession.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException e) {
                ElytronMessages.log.trace("CLIENT-CERT Peer Unverified", e);
            }
        }
        return null;
    }

    public void setStatusCode(int var1);

    public void authenticationComplete(SecurityIdentity var1, String var2);

    public void authenticationFailed(String var1, String var2);

    public void badRequest(HttpAuthenticationException var1, String var2);

    public String getRequestMethod();

    public URI getRequestURI();

    public String getRequestPath();

    public Map<String, List<String>> getRequestParameters();

    default public Set<String> getRequestParameterNames() {
        return this.getRequestParameters().keySet();
    }

    default public List<String> getRequestParameterValues(String name) {
        Map<String, List<String>> parameters = this.getRequestParameters();
        if (parameters != null) {
            return parameters.get(name);
        }
        return null;
    }

    default public String getFirstRequestParameterValue(String name) {
        List<String> values = this.getRequestParameterValues(name);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    public List<HttpServerCookie> getCookies();

    public InputStream getRequestInputStream();

    public InetSocketAddress getSourceAddress();

    public void setResponseCookie(HttpServerCookie var1);

    public OutputStream getResponseOutputStream();

    default public int forward(String path) {
        return -1;
    }

    default public boolean suspendRequest() {
        return false;
    }

    default public boolean resumeRequest() {
        return false;
    }
}

