/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.permission;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Iterator;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.permission.AbstractPermission;
import org.wildfly.security.permission.PermissionVerifier;
import org.wildfly.security.permission.SerializedPermissionCollection;

public abstract class AbstractPermissionCollection
extends PermissionCollection
implements Iterable<Permission>,
PermissionVerifier {
    private static final long serialVersionUID = -7532778883140764647L;
    private final AbstractPermission<?> sourcePermission;

    protected AbstractPermissionCollection(AbstractPermission<?> sourcePermission) {
        Assert.checkNotNullParam((String)"sourcePermission", sourcePermission);
        this.sourcePermission = sourcePermission;
    }

    public abstract int size();

    @Override
    public abstract Iterator<Permission> iterator();

    @Override
    public abstract Enumeration<Permission> elements();

    @Override
    public final void add(Permission permission) {
        Assert.checkNotNullParam((String)"permission", (Object)permission);
        if (this.isReadOnly()) {
            throw ElytronMessages.log.readOnlyPermissionCollection();
        }
        Class<AbstractPermission> expected = this.sourcePermission.getClass().asSubclass(AbstractPermission.class);
        if (expected != permission.getClass()) {
            throw ElytronMessages.log.invalidPermissionType(expected, permission);
        }
        this.doAdd(expected.cast(permission));
    }

    protected abstract void doAdd(AbstractPermission<?> var1);

    final AbstractPermission<?> getSourcePermission() {
        return this.sourcePermission;
    }

    final Object writeReplace() {
        return new SerializedPermissionCollection(this);
    }
}

