/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.util._private;

import java.util.AbstractList;
import org.wildfly.security._private.ElytronMessages;

public final class UnmodifiableArrayList<T>
extends AbstractList<T> {
    private final T[] items;

    @SafeVarargs
    public UnmodifiableArrayList(T ... items) {
        this.items = items;
    }

    @Override
    public T get(int index) {
        try {
            return this.items[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw ElytronMessages.log.invalidIndex(index);
        }
    }

    @Override
    public int size() {
        return this.items.length;
    }
}

