package org.wildfly.security.manager._private;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import java.security.Permission;
import java.lang.ClassLoader;
import java.security.AccessControlException;
import java.lang.SecurityException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.security.CodeSource;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-02-13T14:19:44-0500")
public class SecurityMessages_$logger implements SecurityMessages, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = SecurityMessages_$logger.class.getName();
    public SecurityMessages_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void accessCheckFailed(final Permission permission, final CodeSource codeSource, final ClassLoader classLoader, final String principals) {
        log.logf(FQCN, DEBUG, null, accessCheckFailed4$str(), permission, codeSource, classLoader, principals);
    }
    private static final String accessCheckFailed4 = "Permission check failed (permission \"%s\" in code source \"%s\" of \"%s\", principals \"%s\")";
    protected String accessCheckFailed4$str() {
        return accessCheckFailed4;
    }
    @Override
    public final void accessCheckFailed(final Permission permission, final CodeSource codeSource, final ClassLoader classLoader) {
        log.logf(FQCN, DEBUG, null, accessCheckFailed3$str(), permission, codeSource, classLoader);
    }
    private static final String accessCheckFailed3 = "Permission check failed (permission \"%s\" in code source \"%s\" of \"%s\")";
    protected String accessCheckFailed3$str() {
        return accessCheckFailed3;
    }
    private static final String accessControlException = "WFSM000001: Permission check failed (permission \"%s\" in code source \"%s\" of \"%s\")";
    protected String accessControlException$str() {
        return accessControlException;
    }
    @Override
    public final AccessControlException accessControlException(final Permission permission, final Permission permission_, final CodeSource codeSource, final ClassLoader classLoader) {
        final AccessControlException result = new AccessControlException(String.format(getLoggingLocale(), accessControlException$str(), permission_, codeSource, classLoader), permission);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String secMgrChange = "WFSM000002: Security manager may not be changed";
    protected String secMgrChange$str() {
        return secMgrChange;
    }
    @Override
    public final SecurityException secMgrChange() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), secMgrChange$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownContext = "WFSM000003: Unknown security context type";
    protected String unknownContext$str() {
        return unknownContext;
    }
    @Override
    public final SecurityException unknownContext() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), unknownContext$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedActionCharacter = "WFSM000004: Unexpected character '%s' at offset %d of '%s'";
    protected String unexpectedActionCharacter$str() {
        return unexpectedActionCharacter;
    }
    @Override
    public final IllegalArgumentException unexpectedActionCharacter(final char ch, final int offset, final String actionString) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unexpectedActionCharacter$str(), ch, offset, actionString));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidAction = "WFSM000005: Invalid action '%s' at offset %d of '%s'";
    protected String invalidAction$str() {
        return invalidAction;
    }
    @Override
    public final IllegalArgumentException invalidAction(final String action, final int offset, final String actionString) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidAction$str(), action, offset, actionString));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidName = "WFSM000006: Invalid permission name '%s'";
    protected String invalidName$str() {
        return invalidName;
    }
    @Override
    public final IllegalArgumentException invalidName(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidName$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String readOnlyPermCollection = "WFSM000007: Permission collection is read-only";
    protected String readOnlyPermCollection$str() {
        return readOnlyPermCollection;
    }
    @Override
    public final SecurityException readOnlyPermCollection() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), readOnlyPermCollection$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String wrongPermType = "WFSM000008: Invalid permission (expected an instance of %s, but got %s)";
    protected String wrongPermType$str() {
        return wrongPermType;
    }
    @Override
    public final IllegalArgumentException wrongPermType(final Class<? extends Permission> expectedType, final Permission permission) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), wrongPermType$str(), expectedType, permission));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
