package org.wildfly.security.auth.client;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import javax.xml.stream.XMLStreamReader;
import org.wildfly.client.config.XMLLocation;
import org.jboss.logging.DelegatingBasicLogger;
import javax.xml.namespace.QName;
import java.lang.String;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.jboss.logging.Logger;
import java.lang.Exception;
import java.lang.RuntimeException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Arrays;
import org.wildfly.client.config.ConfigurationXMLStreamReader;
import org.wildfly.client.config.ConfigXMLParseException;
import java.lang.IllegalArgumentException;
import javax.xml.stream.Location;


import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-03-20T14:29:31+0000")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String xmlNoModuleFound = "ELY01001: No module found for identifier \"%s\"";
    protected String xmlNoModuleFound$str() {
        return xmlNoModuleFound;
    }
    @Override
    public final ConfigXMLParseException xmlNoModuleFound(final XMLStreamReader reader, final Exception e, final String moduleIdentifier) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlNoModuleFound$str(), moduleIdentifier), reader, e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlInvalidPortNumber = "ELY01002: Invalid port number \"%s\" specified for attribute \"%s\" of element \"%s\"; expected a numerical value between 1 and 65535 (inclusive)";
    protected String xmlInvalidPortNumber$str() {
        return xmlInvalidPortNumber;
    }
    @Override
    public final ConfigXMLParseException xmlInvalidPortNumber(final XMLStreamReader reader, final String attributeValue, final String attributeName, final QName elementName) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlInvalidPortNumber$str(), attributeValue, attributeName, elementName), reader);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPortNumber = "ELY01028: Invalid port number \"%d\"";
    protected String invalidPortNumber$str() {
        return invalidPortNumber;
    }
    @Override
    public final IllegalArgumentException invalidPortNumber(final int port) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidPortNumber$str(), port));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidHostSpec = "ELY01029: Invalid host specification \"%s\"";
    protected String invalidHostSpec$str() {
        return invalidHostSpec;
    }
    @Override
    public final IllegalArgumentException invalidHostSpec(final String hostSpec) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidHostSpec$str(), hostSpec));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToCreateKeyManager = "ELY01035: Unable to create key manager";
    protected String unableToCreateKeyManager$str() {
        return unableToCreateKeyManager;
    }
    @Override
    public final IOException unableToCreateKeyManager(final Exception e) {
        final IOException result = new IOException(String.format(getLoggingLocale(), unableToCreateKeyManager$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToCreateTrustManager = "ELY01036: Unable to create trust manager";
    protected String unableToCreateTrustManager$str() {
        return unableToCreateTrustManager;
    }
    @Override
    public final IOException unableToCreateTrustManager(final Exception e) {
        final IOException result = new IOException(String.format(getLoggingLocale(), unableToCreateTrustManager$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotObtainCredential = "ELY01041: Could not obtain credential";
    protected String couldNotObtainCredential$str() {
        return couldNotObtainCredential;
    }
    @Override
    public final RuntimeException couldNotObtainCredential() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), couldNotObtainCredential$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidName = "ELY01064: Invalid identity name";
    protected String invalidName$str() {
        return invalidName;
    }
    @Override
    public final IllegalArgumentException invalidName() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void postAssociationFailed(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, postAssociationFailed$str());
    }
    private static final String postAssociationFailed = "ELY01091: Post-association peer context action failed";
    protected String postAssociationFailed$str() {
        return postAssociationFailed;
    }
    private static final String xmlUnknownSslContextSpecified = "ELY01129: Unknown SSL context \"%s\" specified";
    protected String xmlUnknownSslContextSpecified$str() {
        return xmlUnknownSslContextSpecified;
    }
    @Override
    public final ConfigXMLParseException xmlUnknownSslContextSpecified(final Location location, final String name) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlUnknownSslContextSpecified$str(), name), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlDuplicateSslContextName = "ELY01130: Duplicate SSL context name \"%s\"";
    protected String xmlDuplicateSslContextName$str() {
        return xmlDuplicateSslContextName;
    }
    @Override
    public final ConfigXMLParseException xmlDuplicateSslContextName(final String name, final ConfigurationXMLStreamReader reader) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlDuplicateSslContextName$str(), name), reader);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlUnknownAuthenticationConfigurationSpecified = "ELY01132: Unknown authentication configuration \"%s\" specified";
    protected String xmlUnknownAuthenticationConfigurationSpecified$str() {
        return xmlUnknownAuthenticationConfigurationSpecified;
    }
    @Override
    public final ConfigXMLParseException xmlUnknownAuthenticationConfigurationSpecified(final Location location, final String name) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlUnknownAuthenticationConfigurationSpecified$str(), name), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlFailedToCreateCredential = "ELY01133: Failed to create credential";
    protected String xmlFailedToCreateCredential$str() {
        return xmlFailedToCreateCredential;
    }
    @Override
    public final ConfigXMLParseException xmlFailedToCreateCredential(final Location location, final Throwable cause) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlFailedToCreateCredential$str()), location, cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlDuplicateAuthenticationConfigurationName = "ELY01134: Duplicate authentication configuration name \"%s\"";
    protected String xmlDuplicateAuthenticationConfigurationName$str() {
        return xmlDuplicateAuthenticationConfigurationName;
    }
    @Override
    public final ConfigXMLParseException xmlDuplicateAuthenticationConfigurationName(final String name, final ConfigurationXMLStreamReader reader) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlDuplicateAuthenticationConfigurationName$str(), name), reader);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlFailedToLoadKeyStoreData = "ELY01135: Failed to load keystore data";
    protected String xmlFailedToLoadKeyStoreData$str() {
        return xmlFailedToLoadKeyStoreData;
    }
    @Override
    public final ConfigXMLParseException xmlFailedToLoadKeyStoreData(final Location location, final Throwable cause) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlFailedToLoadKeyStoreData$str()), location, cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlFailedToCreateKeyStore = "ELY01136: Failed to create keystore";
    protected String xmlFailedToCreateKeyStore$str() {
        return xmlFailedToCreateKeyStore;
    }
    @Override
    public final ConfigXMLParseException xmlFailedToCreateKeyStore(final Location location, final Throwable cause) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlFailedToCreateKeyStore$str()), location, cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlInvalidKeyStoreEntryType = "ELY01137: Invalid key store entry type for alias \"%s\" (expected %s, got %s)";
    protected String xmlInvalidKeyStoreEntryType$str() {
        return xmlInvalidKeyStoreEntryType;
    }
    @Override
    public final ConfigXMLParseException xmlInvalidKeyStoreEntryType(final Location location, final String alias, final Class<?> expectedClass, final Class<?> actualClass) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlInvalidKeyStoreEntryType$str(), alias, expectedClass, actualClass), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlFailedToCreateCredentialStore = "ELY01139: Failed to create credential store";
    protected String xmlFailedToCreateCredentialStore$str() {
        return xmlFailedToCreateCredentialStore;
    }
    @Override
    public final ConfigXMLParseException xmlFailedToCreateCredentialStore(final Location location, final Throwable cause) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlFailedToCreateCredentialStore$str()), location, cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlWrongPemType = "ELY01140: Wrong PEM content type; expected %s, actually was %s";
    protected String xmlWrongPemType$str() {
        return xmlWrongPemType;
    }
    @Override
    public final ConfigXMLParseException xmlWrongPemType(final ConfigurationXMLStreamReader reader, final Class<?> expected, final Class<?> actual) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlWrongPemType$str(), expected, actual), reader);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlNoPemContent = "ELY01141: No PEM content found";
    protected String xmlNoPemContent$str() {
        return xmlNoPemContent;
    }
    @Override
    public final ConfigXMLParseException xmlNoPemContent(final ConfigurationXMLStreamReader reader) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlNoPemContent$str()), reader);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlInvalidUrl = "ELY01143: Invalid URL [%s]";
    protected String xmlInvalidUrl$str() {
        return xmlInvalidUrl;
    }
    @Override
    public final ConfigXMLParseException xmlInvalidUrl(final String url) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlInvalidUrl$str(), url));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyStoreEntryMissing = "ELY01159: Key store entry for alias \"%s\" is missing.";
    protected String keyStoreEntryMissing$str() {
        return keyStoreEntryMissing;
    }
    @Override
    public final ConfigXMLParseException keyStoreEntryMissing(final Location location, final String alias) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), keyStoreEntryMissing$str(), alias), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlInvalidGssMechanismName = "ELY01162: Invalid GSS mechanism name \"%s\" - unable to convert to mechanism OID";
    protected String xmlInvalidGssMechanismName$str() {
        return xmlInvalidGssMechanismName;
    }
    @Override
    public final ConfigXMLParseException xmlInvalidGssMechanismName(final XMLStreamReader reader, final String mechanismName) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlInvalidGssMechanismName$str(), mechanismName), reader);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlGssMechanismOidConversionFailed = "ELY01163: Mechanism OID conversion from string \"%s\" failed";
    protected String xmlGssMechanismOidConversionFailed$str() {
        return xmlGssMechanismOidConversionFailed;
    }
    @Override
    public final ConfigXMLParseException xmlGssMechanismOidConversionFailed(final XMLStreamReader reader, final String mechanismOid, final Throwable cause) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlGssMechanismOidConversionFailed$str(), mechanismOid), reader, cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlUnableToIdentifyProvider = "ELY01164: Unable to identify provider name=%s, for service type=%s, algorithm=%s";
    protected String xmlUnableToIdentifyProvider$str() {
        return xmlUnableToIdentifyProvider;
    }
    @Override
    public final ConfigXMLParseException xmlUnableToIdentifyProvider(final Location location, final String providerName, final String serviceType, final String algorithm) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlUnableToIdentifyProvider$str(), providerName, serviceType, algorithm), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void xmlDeprecatedElement(final String name, final XMLLocation location) {
        super.log.logf(FQCN, WARN, null, xmlDeprecatedElement$str(), name, location);
    }
    private static final String xmlDeprecatedElement = "ELY01166: %2$s: Element \"%1$s\" is deprecated";
    protected String xmlDeprecatedElement$str() {
        return xmlDeprecatedElement;
    }
    private static final String missingAlias = "ELY02034: Alias must be specified if more than one entry exist in keystore";
    protected String missingAlias$str() {
        return missingAlias;
    }
    @Override
    public final ConfigXMLParseException missingAlias(final Location location) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), missingAlias$str()), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlUnknownKeyStoreSpecified = "ELY02010: Unknown key store specified";
    protected String xmlUnknownKeyStoreSpecified$str() {
        return xmlUnknownKeyStoreSpecified;
    }
    @Override
    public final ConfigXMLParseException xmlUnknownKeyStoreSpecified(final Location location) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlUnknownKeyStoreSpecified$str()), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noDefaultTrustManager = "ELY04005: No default trust manager available";
    protected String noDefaultTrustManager$str() {
        return noDefaultTrustManager;
    }
    @Override
    public final NoSuchAlgorithmException noDefaultTrustManager() {
        final NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(getLoggingLocale(), noDefaultTrustManager$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noDefaultKeyManager = "ELY04028: No default key manager available";
    protected String noDefaultKeyManager$str() {
        return noDefaultKeyManager;
    }
    @Override
    public final NoSuchAlgorithmException noDefaultKeyManager() {
        final NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(getLoggingLocale(), noDefaultKeyManager$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateAttributeFound = "ELY09501: Duplicate attribute (\"%s\") found in configuration.";
    protected String duplicateAttributeFound$str() {
        return duplicateAttributeFound;
    }
    @Override
    public final ConfigXMLParseException duplicateAttributeFound(final XMLStreamReader reader, final String attribute) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), duplicateAttributeFound$str(), attribute), reader);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateCredentialStoreName = "ELY09502: Duplicate credential store name found in configuration \"%s\"";
    protected String duplicateCredentialStoreName$str() {
        return duplicateCredentialStoreName;
    }
    @Override
    public final ConfigXMLParseException duplicateCredentialStoreName(final XMLStreamReader reader, final String storeName) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), duplicateCredentialStoreName$str(), storeName), reader);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlCredentialStoreNameNotDefined = "ELY09503: Credential store name \"%s\" not defined";
    protected String xmlCredentialStoreNameNotDefined$str() {
        return xmlCredentialStoreNameNotDefined;
    }
    @Override
    public final ConfigXMLParseException xmlCredentialStoreNameNotDefined(final Location location, final String storeName) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlCredentialStoreNameNotDefined$str(), storeName), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlInvalidCredentialStoreRef = "ELY09527: Invalid credential store reference";
    protected String xmlInvalidCredentialStoreRef$str() {
        return xmlInvalidCredentialStoreRef;
    }
    @Override
    public final ConfigXMLParseException xmlInvalidCredentialStoreRef(final Location location) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlInvalidCredentialStoreRef$str()), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
