package org.wildfly.security.credential.source;

import java.util.Locale;
import java.io.InterruptedIOException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.io.IOException;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.jboss.logging.Logger;
import javax.security.sasl.SaslException;
import java.lang.Exception;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Arrays;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-03-20T14:28:50+0000")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String unableToReadCredential = "ELY01030: Unable to read credential";
    protected String unableToReadCredential$str() {
        return unableToReadCredential;
    }
    @Override
    public final IOException unableToReadCredential(final Exception e) {
        final IOException result = new IOException(String.format(getLoggingLocale(), unableToReadCredential$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechCallbackHandlerFailedForUnknownReason = "ELY05053: Callback handler failed for unknown reason";
    protected String mechCallbackHandlerFailedForUnknownReason$str() {
        return mechCallbackHandlerFailedForUnknownReason;
    }
    @Override
    public final SaslException mechCallbackHandlerFailedForUnknownReason(final Throwable cause) {
        final SaslException result = new SaslException(String.format(getLoggingLocale(), mechCallbackHandlerFailedForUnknownReason$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToHandleResponseFromServer = "ELY05125: Unable to handle response from server";
    protected String mechUnableToHandleResponseFromServer$str() {
        return mechUnableToHandleResponseFromServer;
    }
    @Override
    public final SaslException mechUnableToHandleResponseFromServer(final Throwable cause) {
        final SaslException result = new SaslException(String.format(getLoggingLocale(), mechUnableToHandleResponseFromServer$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String credentialCommandInterrupted = "ELY09506: Credential store command interrupted";
    protected String credentialCommandInterrupted$str() {
        return credentialCommandInterrupted;
    }
    @Override
    public final InterruptedIOException credentialCommandInterrupted() {
        final InterruptedIOException result = new InterruptedIOException(String.format(getLoggingLocale(), credentialCommandInterrupted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToReadCredentialTypeFromStore = "ELY09511: Unable to read credential %s from store";
    protected String unableToReadCredentialTypeFromStore$str() {
        return unableToReadCredentialTypeFromStore;
    }
    @Override
    public final CredentialStoreException unableToReadCredentialTypeFromStore(final Class<? extends org.wildfly.security.credential.Credential> credentialType) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), unableToReadCredentialTypeFromStore$str(), credentialType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
