package org.wildfly.security.http.util.sso;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.wildfly.security.http.HttpAuthenticationException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-03-20T14:31:32+0000")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void warnHttpMechSsoFailedLogoutParticipant(final String url, final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, warnHttpMechSsoFailedLogoutParticipant$str(), url);
    }
    private static final String warnHttpMechSsoFailedLogoutParticipant = "ELY06008: Failed to logout participant [%s]. Participant will be removed from list of participants but its local session may still be active.";
    protected String warnHttpMechSsoFailedLogoutParticipant$str() {
        return warnHttpMechSsoFailedLogoutParticipant;
    }
    private static final String httpMechSsoInvalidLogoutMessage = "ELY06012: Invalid logout message received for local session [%s]";
    protected String httpMechSsoInvalidLogoutMessage$str() {
        return httpMechSsoInvalidLogoutMessage;
    }
    @Override
    public final IllegalStateException httpMechSsoInvalidLogoutMessage(final String localSessionId) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), httpMechSsoInvalidLogoutMessage$str(), localSessionId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void errorHttpMechSsoFailedInvalidateLocalSession(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, errorHttpMechSsoFailedInvalidateLocalSession$str());
    }
    private static final String errorHttpMechSsoFailedInvalidateLocalSession = "ELY06013: Failed to invalidate local session";
    protected String errorHttpMechSsoFailedInvalidateLocalSession$str() {
        return errorHttpMechSsoFailedInvalidateLocalSession;
    }
    private static final String httpServerAuthenticationMechanismNotFound = "ELY06014: Authentication mechanism '%s' cannot be found";
    protected String httpServerAuthenticationMechanismNotFound$str() {
        return httpServerAuthenticationMechanismNotFound;
    }
    @Override
    public final HttpAuthenticationException httpServerAuthenticationMechanismNotFound(final String mechanismName) {
        final HttpAuthenticationException result = new HttpAuthenticationException(String.format(getLoggingLocale(), httpServerAuthenticationMechanismNotFound$str(), mechanismName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
