package org.wildfly.security.pem;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.wildfly.security.asn1.ASN1Exception;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.security.cert.CertificateException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-03-20T14:26:56+0000")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String malformedPemContent = "ELY03010: Malformed PEM content at offset %d";
    protected String malformedPemContent$str() {
        return malformedPemContent;
    }
    @Override
    public final IllegalArgumentException malformedPemContent(final long offset) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), malformedPemContent$str(), offset));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPemType = "ELY03011: Invalid PEM type (expected \"%s\", got \"%s\"";
    protected String invalidPemType$str() {
        return invalidPemType;
    }
    @Override
    public final IllegalArgumentException invalidPemType(final String expected, final String actual) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidPemType$str(), expected, actual));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String certificateParseError = "ELY03012: Certificate parse error";
    protected String certificateParseError$str() {
        return certificateParseError;
    }
    @Override
    public final IllegalArgumentException certificateParseError(final CertificateException cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), certificateParseError$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String publicKeyParseError = "ELY03023: PublicKey parse error";
    protected String publicKeyParseError$str() {
        return publicKeyParseError;
    }
    @Override
    public final IllegalArgumentException publicKeyParseError(final Throwable cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), publicKeyParseError$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String privateKeyParseError = "ELY03033: PrivateKey parse error";
    protected String privateKeyParseError$str() {
        return privateKeyParseError;
    }
    @Override
    public final IllegalArgumentException privateKeyParseError(final Throwable cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), privateKeyParseError$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnUnrecognisedAlgorithm = "ELY07001: Unrecognized encoding algorithm [%s]";
    protected String asnUnrecognisedAlgorithm$str() {
        return asnUnrecognisedAlgorithm;
    }
    @Override
    public final ASN1Exception asnUnrecognisedAlgorithm(final String algorithm) {
        final ASN1Exception result = new ASN1Exception(String.format(getLoggingLocale(), asnUnrecognisedAlgorithm$str(), algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnUnexpectedTag = "ELY07004: Unexpected ASN.1 tag encountered";
    protected String asnUnexpectedTag$str() {
        return asnUnexpectedTag;
    }
    @Override
    public final ASN1Exception asnUnexpectedTag() {
        final ASN1Exception result = new ASN1Exception(String.format(getLoggingLocale(), asnUnexpectedTag$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
