package org.wildfly.security.ssl;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.security.cert.CertificateException;
import org.wildfly.security.auth.server.RealmUnavailableException;
import java.lang.String;
import java.security.NoSuchAlgorithmException;
import org.jboss.logging.Logger;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Arrays;
import java.security.Principal;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-03-20T14:29:07+0000")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void warnInvalidStringCountForMechanismDatabaseEntry(final String name) {
        super.log.logf(FQCN, WARN, null, warnInvalidStringCountForMechanismDatabaseEntry$str(), name);
    }
    private static final String warnInvalidStringCountForMechanismDatabaseEntry = "ELY01066: Invalid string count for mechanism database entry \"%s\"";
    protected String warnInvalidStringCountForMechanismDatabaseEntry$str() {
        return warnInvalidStringCountForMechanismDatabaseEntry;
    }
    @Override
    public final void warnInvalidKeyExchangeForMechanismDatabaseEntry(final String value, final String name) {
        super.log.logf(FQCN, WARN, null, warnInvalidKeyExchangeForMechanismDatabaseEntry$str(), value, name);
    }
    private static final String warnInvalidKeyExchangeForMechanismDatabaseEntry = "ELY01067: Invalid key exchange \"%s\" for mechanism database entry \"%s\"";
    protected String warnInvalidKeyExchangeForMechanismDatabaseEntry$str() {
        return warnInvalidKeyExchangeForMechanismDatabaseEntry;
    }
    @Override
    public final void warnInvalidAuthenticationForMechanismDatabaseEntry(final String value, final String name) {
        super.log.logf(FQCN, WARN, null, warnInvalidAuthenticationForMechanismDatabaseEntry$str(), value, name);
    }
    private static final String warnInvalidAuthenticationForMechanismDatabaseEntry = "ELY01068: Invalid authentication \"%s\" for mechanism database entry \"%s\"";
    protected String warnInvalidAuthenticationForMechanismDatabaseEntry$str() {
        return warnInvalidAuthenticationForMechanismDatabaseEntry;
    }
    @Override
    public final void warnInvalidEncryptionForMechanismDatabaseEntry(final String value, final String name) {
        super.log.logf(FQCN, WARN, null, warnInvalidEncryptionForMechanismDatabaseEntry$str(), value, name);
    }
    private static final String warnInvalidEncryptionForMechanismDatabaseEntry = "ELY01069: Invalid encryption \"%s\" for mechanism database entry \"%s\"";
    protected String warnInvalidEncryptionForMechanismDatabaseEntry$str() {
        return warnInvalidEncryptionForMechanismDatabaseEntry;
    }
    @Override
    public final void warnInvalidDigestForMechanismDatabaseEntry(final String value, final String name) {
        super.log.logf(FQCN, WARN, null, warnInvalidDigestForMechanismDatabaseEntry$str(), value, name);
    }
    private static final String warnInvalidDigestForMechanismDatabaseEntry = "ELY01070: Invalid digest \"%s\" for mechanism database entry \"%s\"";
    protected String warnInvalidDigestForMechanismDatabaseEntry$str() {
        return warnInvalidDigestForMechanismDatabaseEntry;
    }
    @Override
    public final void warnInvalidProtocolForMechanismDatabaseEntry(final String value, final String name) {
        super.log.logf(FQCN, WARN, null, warnInvalidProtocolForMechanismDatabaseEntry$str(), value, name);
    }
    private static final String warnInvalidProtocolForMechanismDatabaseEntry = "ELY01071: Invalid protocol \"%s\" for mechanism database entry \"%s\"";
    protected String warnInvalidProtocolForMechanismDatabaseEntry$str() {
        return warnInvalidProtocolForMechanismDatabaseEntry;
    }
    @Override
    public final void warnInvalidLevelForMechanismDatabaseEntry(final String value, final String name) {
        super.log.logf(FQCN, WARN, null, warnInvalidLevelForMechanismDatabaseEntry$str(), value, name);
    }
    private static final String warnInvalidLevelForMechanismDatabaseEntry = "ELY01072: Invalid level \"%s\" for mechanism database entry \"%s\"";
    protected String warnInvalidLevelForMechanismDatabaseEntry$str() {
        return warnInvalidLevelForMechanismDatabaseEntry;
    }
    @Override
    public final void warnInvalidStrengthBitsForMechanismDatabaseEntry(final String value, final String name) {
        super.log.logf(FQCN, WARN, null, warnInvalidStrengthBitsForMechanismDatabaseEntry$str(), value, name);
    }
    private static final String warnInvalidStrengthBitsForMechanismDatabaseEntry = "ELY01073: Invalid strength bits \"%s\" for mechanism database entry \"%s\"";
    protected String warnInvalidStrengthBitsForMechanismDatabaseEntry$str() {
        return warnInvalidStrengthBitsForMechanismDatabaseEntry;
    }
    @Override
    public final void warnInvalidAlgorithmBitsForMechanismDatabaseEntry(final String value, final String name) {
        super.log.logf(FQCN, WARN, null, warnInvalidAlgorithmBitsForMechanismDatabaseEntry$str(), value, name);
    }
    private static final String warnInvalidAlgorithmBitsForMechanismDatabaseEntry = "ELY01074: Invalid algorithm bits \"%s\" for mechanism database entry \"%s\"";
    protected String warnInvalidAlgorithmBitsForMechanismDatabaseEntry$str() {
        return warnInvalidAlgorithmBitsForMechanismDatabaseEntry;
    }
    @Override
    public final void warnInvalidDuplicateMechanismDatabaseEntry(final String name) {
        super.log.logf(FQCN, WARN, null, warnInvalidDuplicateMechanismDatabaseEntry$str(), name);
    }
    private static final String warnInvalidDuplicateMechanismDatabaseEntry = "ELY01075: Invalid duplicate mechanism database entry \"%s\"";
    protected String warnInvalidDuplicateMechanismDatabaseEntry$str() {
        return warnInvalidDuplicateMechanismDatabaseEntry;
    }
    @Override
    public final void warnInvalidDuplicateOpenSslStyleAliasForMechanismDatabaseEntry(final String alias, final String name, final String originalName) {
        super.log.logf(FQCN, WARN, null, warnInvalidDuplicateOpenSslStyleAliasForMechanismDatabaseEntry$str(), alias, name, originalName);
    }
    private static final String warnInvalidDuplicateOpenSslStyleAliasForMechanismDatabaseEntry = "ELY01076: Invalid duplicate OpenSSL-style alias \"%s\" for mechanism database entry \"%s\" (original is \"%s\")";
    protected String warnInvalidDuplicateOpenSslStyleAliasForMechanismDatabaseEntry$str() {
        return warnInvalidDuplicateOpenSslStyleAliasForMechanismDatabaseEntry;
    }
    @Override
    public final void warnInvalidAliasForMissingMechanismDatabaseEntry(final String value, final String name) {
        super.log.logf(FQCN, WARN, null, warnInvalidAliasForMissingMechanismDatabaseEntry$str(), value, name);
    }
    private static final String warnInvalidAliasForMissingMechanismDatabaseEntry = "ELY01077: Invalid alias \"%s\" for missing mechanism database entry \"%s\"";
    protected String warnInvalidAliasForMissingMechanismDatabaseEntry$str() {
        return warnInvalidAliasForMissingMechanismDatabaseEntry;
    }
    private static final String noAlgorithmForSslProtocol = "ELY04001: No algorithm found matching TLS/SSL protocol selection criteria";
    protected String noAlgorithmForSslProtocol$str() {
        return noAlgorithmForSslProtocol;
    }
    @Override
    public final NoSuchAlgorithmException noAlgorithmForSslProtocol() {
        final NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(getLoggingLocale(), noAlgorithmForSslProtocol$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String emptyChainNotTrusted = "ELY04002: Empty certificate chain is not trusted";
    protected String emptyChainNotTrusted$str() {
        return emptyChainNotTrusted;
    }
    @Override
    public final CertificateException emptyChainNotTrusted() {
        final CertificateException result = new CertificateException(String.format(getLoggingLocale(), emptyChainNotTrusted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notTrustedRealmProblem = "ELY04003: Certificate not trusted due to realm failure for principal [%s]";
    protected String notTrustedRealmProblem$str() {
        return notTrustedRealmProblem;
    }
    @Override
    public final CertificateException notTrustedRealmProblem(final RealmUnavailableException e, final Principal principal) {
        final CertificateException result = new CertificateException(String.format(getLoggingLocale(), notTrustedRealmProblem$str(), principal), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notTrusted = "ELY04004: Credential validation failed: certificate is not trusted for principal [%s]";
    protected String notTrusted$str() {
        return notTrusted;
    }
    @Override
    public final CertificateException notTrusted(final Principal principal) {
        final CertificateException result = new CertificateException(String.format(getLoggingLocale(), notTrusted$str(), principal));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noDefaultTrustManager = "ELY04005: No default trust manager available";
    protected String noDefaultTrustManager$str() {
        return noDefaultTrustManager;
    }
    @Override
    public final NoSuchAlgorithmException noDefaultTrustManager() {
        final NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(getLoggingLocale(), noDefaultTrustManager$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noContextForSslConnection = "ELY04006: No context for SSL connection";
    protected String noContextForSslConnection$str() {
        return noContextForSslConnection;
    }
    @Override
    public final SSLHandshakeException noContextForSslConnection() {
        final SSLHandshakeException result = new SSLHandshakeException(String.format(getLoggingLocale(), noContextForSslConnection$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String sslClosed = "ELY04007: SSL channel is closed";
    protected String sslClosed$str() {
        return sslClosed;
    }
    @Override
    public final SSLException sslClosed() {
        final SSLException result = new SSLException(String.format(getLoggingLocale(), sslClosed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notHandshakeRecord = "ELY04008: Initial SSL/TLS data is not a handshake record";
    protected String notHandshakeRecord$str() {
        return notHandshakeRecord;
    }
    @Override
    public final SSLHandshakeException notHandshakeRecord() {
        final SSLHandshakeException result = new SSLHandshakeException(String.format(getLoggingLocale(), notHandshakeRecord$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidHandshakeRecord = "ELY04009: Initial SSL/TLS handshake record is invalid";
    protected String invalidHandshakeRecord$str() {
        return invalidHandshakeRecord;
    }
    @Override
    public final SSLHandshakeException invalidHandshakeRecord() {
        final SSLHandshakeException result = new SSLHandshakeException(String.format(getLoggingLocale(), invalidHandshakeRecord$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multiRecordSSLHandshake = "ELY04010: Initial SSL/TLS handshake spans multiple records";
    protected String multiRecordSSLHandshake$str() {
        return multiRecordSSLHandshake;
    }
    @Override
    public final SSLHandshakeException multiRecordSSLHandshake() {
        final SSLHandshakeException result = new SSLHandshakeException(String.format(getLoggingLocale(), multiRecordSSLHandshake$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expectedClientHello = "ELY04011: Expected \"client hello\" record";
    protected String expectedClientHello$str() {
        return expectedClientHello;
    }
    @Override
    public final SSLHandshakeException expectedClientHello() {
        final SSLHandshakeException result = new SSLHandshakeException(String.format(getLoggingLocale(), expectedClientHello$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedSslRecord = "ELY04012: Unsupported SSL/TLS record";
    protected String unsupportedSslRecord$str() {
        return unsupportedSslRecord;
    }
    @Override
    public final SSLHandshakeException unsupportedSslRecord() {
        final SSLHandshakeException result = new SSLHandshakeException(String.format(getLoggingLocale(), unsupportedSslRecord$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidTlsExt = "ELY04013: Invalid TLS extension data";
    protected String invalidTlsExt$str() {
        return invalidTlsExt;
    }
    @Override
    public final SSLProtocolException invalidTlsExt() {
        final SSLProtocolException result = new SSLProtocolException(String.format(getLoggingLocale(), invalidTlsExt$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notEnoughData = "ELY04014: Not enough data in record to fill declared item size";
    protected String notEnoughData$str() {
        return notEnoughData;
    }
    @Override
    public final SSLProtocolException notEnoughData() {
        final SSLProtocolException result = new SSLProtocolException(String.format(getLoggingLocale(), notEnoughData$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String emptyHostNameSni = "ELY04015: Empty host name in SNI record data";
    protected String emptyHostNameSni$str() {
        return emptyHostNameSni;
    }
    @Override
    public final SSLProtocolException emptyHostNameSni() {
        final SSLProtocolException result = new SSLProtocolException(String.format(getLoggingLocale(), emptyHostNameSni$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicatedSniServerName = "ELY04016: Duplicated SNI server name of type %d";
    protected String duplicatedSniServerName$str() {
        return duplicatedSniServerName;
    }
    @Override
    public final SSLProtocolException duplicatedSniServerName(final int type) {
        final SSLProtocolException result = new SSLProtocolException(String.format(getLoggingLocale(), duplicatedSniServerName$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownAuthenticationName = "ELY04017: Unknown authentication name \"%s\"";
    protected String unknownAuthenticationName$str() {
        return unknownAuthenticationName;
    }
    @Override
    public final IllegalArgumentException unknownAuthenticationName(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownAuthenticationName$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownEncryptionName = "ELY04018: Unknown encryption name \"%s\"";
    protected String unknownEncryptionName$str() {
        return unknownEncryptionName;
    }
    @Override
    public final IllegalArgumentException unknownEncryptionName(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownEncryptionName$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownKeyExchangeName = "ELY04019: Unknown key exchange name \"%s\"";
    protected String unknownKeyExchangeName$str() {
        return unknownKeyExchangeName;
    }
    @Override
    public final IllegalArgumentException unknownKeyExchangeName(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownKeyExchangeName$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidClientMode = "ELY04024: Invalid client mode, expected %s, got %s";
    protected String invalidClientMode$str() {
        return invalidClientMode;
    }
    @Override
    public final IllegalArgumentException invalidClientMode(final boolean expectedMode, final boolean givenMode) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidClientMode$str(), expectedMode, givenMode));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String sslErrorCreatingTrustManager = "ELY04026: Could not create trust manager [%s]";
    protected String sslErrorCreatingTrustManager$str() {
        return sslErrorCreatingTrustManager;
    }
    @Override
    public final IllegalStateException sslErrorCreatingTrustManager(final String name, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), sslErrorCreatingTrustManager$str(), name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String securityDomainOfSSLContextDoesNotSupportX509 = "ELY04027: SecurityDomain of SSLContext does not support X509PeerCertificateChainEvidence verification";
    protected String securityDomainOfSSLContextDoesNotSupportX509$str() {
        return securityDomainOfSSLContextDoesNotSupportX509;
    }
    @Override
    public final IllegalArgumentException securityDomainOfSSLContextDoesNotSupportX509() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), securityDomainOfSSLContextDoesNotSupportX509$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String defaultContextCannotBeNull = "ELY04029: Default context cannot be null";
    protected String defaultContextCannotBeNull$str() {
        return defaultContextCannotBeNull;
    }
    @Override
    public final IllegalStateException defaultContextCannotBeNull() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), defaultContextCannotBeNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSNIContextForSslConnection = "ELY04030: No context for SSL connection";
    protected String noSNIContextForSslConnection$str() {
        return noSNIContextForSslConnection;
    }
    @Override
    public final SSLException noSNIContextForSslConnection() {
        final SSLException result = new SSLException(String.format(getLoggingLocale(), noSNIContextForSslConnection$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechSelectorUnexpectedChar = "ELY05015: Unexpected character U+%04x at offset %d of mechanism selection string \"%s\"";
    protected String mechSelectorUnexpectedChar$str() {
        return mechSelectorUnexpectedChar;
    }
    @Override
    public final IllegalArgumentException mechSelectorUnexpectedChar(final int codePoint, final long offset, final String string) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), mechSelectorUnexpectedChar$str(), codePoint, offset, string));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechSelectorUnknownToken = "ELY05016: Unrecognized token \"%s\" in mechanism selection string \"%s\"";
    protected String mechSelectorUnknownToken$str() {
        return mechSelectorUnknownToken;
    }
    @Override
    public final IllegalArgumentException mechSelectorUnknownToken(final String word, final String string) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), mechSelectorUnknownToken$str(), word, string));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechSelectorTokenNotAllowed = "ELY05017: Token \"%s\" not allowed at offset %d of mechanism selection string \"%s\"";
    protected String mechSelectorTokenNotAllowed$str() {
        return mechSelectorTokenNotAllowed;
    }
    @Override
    public final IllegalArgumentException mechSelectorTokenNotAllowed(final String token, final long offset, final String string) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), mechSelectorTokenNotAllowed$str(), token, offset, string));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
