package org.wildfly.security.credential._private;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import java.security.NoSuchAlgorithmException;
import org.jboss.logging.Logger;
import javax.security.sasl.SaslException;
import java.security.InvalidKeyException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-04-12T16:02:05+0100")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String emptyParameter = "ELY00002: Parameter %s is empty";
    protected String emptyParameter$str() {
        return emptyParameter;
    }
    @Override
    public final IllegalArgumentException emptyParameter(final String parameter) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), emptyParameter$str(), parameter));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unrecognizedAlgorithm = "ELY00004: Unrecognized algorithm \"%s\"";
    protected String unrecognizedAlgorithm$str() {
        return unrecognizedAlgorithm;
    }
    @Override
    public final IllegalArgumentException unrecognizedAlgorithm(final String algorithm) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unrecognizedAlgorithm$str(), algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String certificateChainIsEmpty = "ELY01037: Certificate chain is empty";
    protected String certificateChainIsEmpty$str() {
        return certificateChainIsEmpty;
    }
    @Override
    public final IllegalArgumentException certificateChainIsEmpty() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), certificateChainIsEmpty$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String insufficientDataToFormDigestAndSalt = "ELY01053: Insufficient data to form a digest and a salt";
    protected String insufficientDataToFormDigestAndSalt$str() {
        return insufficientDataToFormDigestAndSalt;
    }
    @Override
    public final InvalidKeySpecException insufficientDataToFormDigestAndSalt() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), insufficientDataToFormDigestAndSalt$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidSalt2 = "ELY01054: Invalid salt \"%s%s\"";
    protected String invalidSalt2$str() {
        return invalidSalt2;
    }
    @Override
    public final IllegalArgumentException invalidSalt(final char lo, final char hi) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidSalt2$str(), lo, hi));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidRounds = "ELY01055: Invalid rounds \"%s%s%s%s\"";
    protected String invalidRounds$str() {
        return invalidRounds;
    }
    @Override
    public final IllegalArgumentException invalidRounds(final char b0, final char b1, final char b2, final char b3) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidRounds$str(), b0, b1, b2, b3));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidSalt4 = "ELY01056: Invalid salt \"%s%s%s%s\"";
    protected String invalidSalt4$str() {
        return invalidSalt4;
    }
    @Override
    public final IllegalArgumentException invalidSalt(final char b0, final char b1, final char b2, final char b3) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidSalt4$str(), b0, b1, b2, b3));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mismatchedPublicPrivateKeyAlgorithms = "ELY01059: Public and private key algorithm names are mismatched";
    protected String mismatchedPublicPrivateKeyAlgorithms$str() {
        return mismatchedPublicPrivateKeyAlgorithms;
    }
    @Override
    public final IllegalArgumentException mismatchedPublicPrivateKeyAlgorithms() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), mismatchedPublicPrivateKeyAlgorithms$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String publicKeyIsNull = "ELY01061: Public key is null";
    protected String publicKeyIsNull$str() {
        return publicKeyIsNull;
    }
    @Override
    public final IllegalArgumentException publicKeyIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), publicKeyIsNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String privateKeyIsNull = "ELY01063: Private key is null";
    protected String privateKeyIsNull$str() {
        return privateKeyIsNull;
    }
    @Override
    public final IllegalArgumentException privateKeyIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), privateKeyIsNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keySpecMustBeSecretKeySpec = "ELY02032: keySpec must be SecretKeySpect, given: [%s]";
    protected String keySpecMustBeSecretKeySpec$str() {
        return keySpecMustBeSecretKeySpec;
    }
    @Override
    public final InvalidKeySpecException keySpecMustBeSecretKeySpec(final String type) {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), keySpecMustBeSecretKeySpec$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyMustImplementSecretKeySpecAndKeySpecMustBeSecretKeySpec = "ELY02033: key must implement SecretKeySpec and keySpec must be SecretKeySpec, given key, keySpec: [%s]";
    protected String keyMustImplementSecretKeySpecAndKeySpecMustBeSecretKeySpec$str() {
        return keyMustImplementSecretKeySpecAndKeySpecMustBeSecretKeySpec;
    }
    @Override
    public final InvalidKeySpecException keyMustImplementSecretKeySpecAndKeySpecMustBeSecretKeySpec(final String keyAndKeySpec) {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), keyMustImplementSecretKeySpecAndKeySpecMustBeSecretKeySpec$str(), keyAndKeySpec));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidOTPAlgorithm = "ELY05151: Invalid OTP algorithm \"%s\"";
    protected String mechInvalidOTPAlgorithm$str() {
        return mechInvalidOTPAlgorithm;
    }
    @Override
    public final SaslException mechInvalidOTPAlgorithm(final String algorithm) {
        final SaslException result = new SaslException(String.format(getLoggingLocale(), mechInvalidOTPAlgorithm$str(), algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecUnrecognizedKeySpecAlgorithm = "ELY08001: Unrecognized key spec algorithm";
    protected String invalidKeySpecUnrecognizedKeySpecAlgorithm$str() {
        return invalidKeySpecUnrecognizedKeySpecAlgorithm;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecUnrecognizedKeySpecAlgorithm() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecUnrecognizedKeySpecAlgorithm$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecPasswordSpecCannotBeRenderedAsString = "ELY08002: Password spec cannot be rendered as a string";
    protected String invalidKeySpecPasswordSpecCannotBeRenderedAsString$str() {
        return invalidKeySpecPasswordSpecCannotBeRenderedAsString;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecPasswordSpecCannotBeRenderedAsString() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecPasswordSpecCannotBeRenderedAsString$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecUnknownCryptStringAlgorithm = "ELY08003: Unknown crypt string algorithm";
    protected String invalidKeySpecUnknownCryptStringAlgorithm$str() {
        return invalidKeySpecUnknownCryptStringAlgorithm;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecUnknownCryptStringAlgorithm() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecUnknownCryptStringAlgorithm$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecInvalidCharacterEncountered = "ELY08004: Invalid character encountered";
    protected String invalidKeySpecInvalidCharacterEncountered$str() {
        return invalidKeySpecInvalidCharacterEncountered;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecInvalidCharacterEncountered() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecInvalidCharacterEncountered$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecNoIterationCountTerminatorGiven = "ELY08005: No iteration count terminator given";
    protected String invalidKeySpecNoIterationCountTerminatorGiven$str() {
        return invalidKeySpecNoIterationCountTerminatorGiven;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecNoIterationCountTerminatorGiven() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecNoIterationCountTerminatorGiven$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecUnexpectedEndOfInputString = "ELY08006: Unexpected end of input string";
    protected String invalidKeySpecUnexpectedEndOfInputString$str() {
        return invalidKeySpecUnexpectedEndOfInputString;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecUnexpectedEndOfInputString() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecUnexpectedEndOfInputString$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecNoSaltTerminatorGiven = "ELY08007: No salt terminator given";
    protected String invalidKeySpecNoSaltTerminatorGiven$str() {
        return invalidKeySpecNoSaltTerminatorGiven;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecNoSaltTerminatorGiven() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecNoSaltTerminatorGiven$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidHashLength = "ELY08008: Invalid hash length";
    protected String invalidHashLength$str() {
        return invalidHashLength;
    }
    @Override
    public final IllegalArgumentException invalidHashLength() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidHashLength$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecUnexpectedEndOfPasswordString = "ELY08009: Unexpected end of password string";
    protected String invalidKeySpecUnexpectedEndOfPasswordString$str() {
        return invalidKeySpecUnexpectedEndOfPasswordString;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecUnexpectedEndOfPasswordString() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecUnexpectedEndOfPasswordString$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecUnexpectedEndOfPasswordStringWithCause = "ELY08010: Unexpected end of password string";
    protected String invalidKeySpecUnexpectedEndOfPasswordStringWithCause$str() {
        return invalidKeySpecUnexpectedEndOfPasswordStringWithCause;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecUnexpectedEndOfPasswordStringWithCause(final Throwable cause) {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecUnexpectedEndOfPasswordStringWithCause$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecInvalidMinorVersion = "ELY08011: Invalid minor version";
    protected String invalidKeySpecInvalidMinorVersion$str() {
        return invalidKeySpecInvalidMinorVersion;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecInvalidMinorVersion() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecInvalidMinorVersion$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecCostMustBeTwoDigitInteger = "ELY08012: Invalid cost: must be a two digit integer";
    protected String invalidKeySpecCostMustBeTwoDigitInteger$str() {
        return invalidKeySpecCostMustBeTwoDigitInteger;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecCostMustBeTwoDigitInteger() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecCostMustBeTwoDigitInteger$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecNoSuchMessageDigestAlgorithm = "ELY08013: No such MessageDigest algorithm for \"%s\"";
    protected String invalidKeySpecNoSuchMessageDigestAlgorithm$str() {
        return invalidKeySpecNoSuchMessageDigestAlgorithm;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecNoSuchMessageDigestAlgorithm(final String algorithm) {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecNoSuchMessageDigestAlgorithm$str(), algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeyNoSuchMessageDigestAlgorithm = "ELY08014: No such MessageDigest algorithm for \"%s\"";
    protected String invalidKeyNoSuchMessageDigestAlgorithm$str() {
        return invalidKeyNoSuchMessageDigestAlgorithm;
    }
    @Override
    public final InvalidKeyException invalidKeyNoSuchMessageDigestAlgorithm(final String algorithm) {
        final InvalidKeyException result = new InvalidKeyException(String.format(getLoggingLocale(), invalidKeyNoSuchMessageDigestAlgorithm$str(), algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeyCannotVerifyPassword = "ELY08015: Cannot verify password";
    protected String invalidKeyCannotVerifyPassword$str() {
        return invalidKeyCannotVerifyPassword;
    }
    @Override
    public final InvalidKeyException invalidKeyCannotVerifyPassword(final Throwable cause) {
        final InvalidKeyException result = new InvalidKeyException(String.format(getLoggingLocale(), invalidKeyCannotVerifyPassword$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeyDesCryptPasswordHashMustBeBytes = "ELY08017: DES crypt password hash must be %d bytes";
    protected String invalidKeyDesCryptPasswordHashMustBeBytes$str() {
        return invalidKeyDesCryptPasswordHashMustBeBytes;
    }
    @Override
    public final InvalidKeyException invalidKeyDesCryptPasswordHashMustBeBytes(final int bytes) {
        final InvalidKeyException result = new InvalidKeyException(String.format(getLoggingLocale(), invalidKeyDesCryptPasswordHashMustBeBytes$str(), bytes));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidParameterSpecSaltMustBeBytesBits = "ELY08018: Salt must be %d bytes (%d bits)";
    protected String invalidParameterSpecSaltMustBeBytesBits$str() {
        return invalidParameterSpecSaltMustBeBytesBits;
    }
    @Override
    public final InvalidParameterSpecException invalidParameterSpecSaltMustBeBytesBits(final int bytes, final int bits) {
        final InvalidParameterSpecException result = new InvalidParameterSpecException(String.format(getLoggingLocale(), invalidParameterSpecSaltMustBeBytesBits$str(), bytes, bits));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidNumberOfRoundsMustBeIntBetween = "ELY08020: Invalid number of rounds. Must be an integer between %d and %d, inclusive";
    protected String invalidNumberOfRoundsMustBeIntBetween$str() {
        return invalidNumberOfRoundsMustBeIntBetween;
    }
    @Override
    public final IllegalArgumentException invalidNumberOfRoundsMustBeIntBetween(final int min, final int max) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidNumberOfRoundsMustBeIntBetween$str(), min, max));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidSaltMustBeBytesLong = "ELY08021: Invalid salt: must be %d bytes long";
    protected String invalidSaltMustBeBytesLong$str() {
        return invalidSaltMustBeBytesLong;
    }
    @Override
    public final IllegalArgumentException invalidSaltMustBeBytesLong(final int length) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidSaltMustBeBytesLong$str(), length));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecBsdDesCryptPasswordHashMustBeBytes = "ELY08022: BSD DES crypt password hash must be %d bytes";
    protected String invalidKeySpecBsdDesCryptPasswordHashMustBeBytes$str() {
        return invalidKeySpecBsdDesCryptPasswordHashMustBeBytes;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecBsdDesCryptPasswordHashMustBeBytes(final int bytes) {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecBsdDesCryptPasswordHashMustBeBytes$str(), bytes));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidParameterSpecSaltMustBeBytes = "ELY08023: Salt must be %d bytes";
    protected String invalidParameterSpecSaltMustBeBytes$str() {
        return invalidParameterSpecSaltMustBeBytes;
    }
    @Override
    public final InvalidParameterSpecException invalidParameterSpecSaltMustBeBytes(final int bytes) {
        final InvalidParameterSpecException result = new InvalidParameterSpecException(String.format(getLoggingLocale(), invalidParameterSpecSaltMustBeBytes$str(), bytes));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeyBsdDesCryptPasswordHashMustBeBytes = "ELY08024: BSD DES crypt password hash must be %d bytes";
    protected String invalidKeyBsdDesCryptPasswordHashMustBeBytes$str() {
        return invalidKeyBsdDesCryptPasswordHashMustBeBytes;
    }
    @Override
    public final InvalidKeyException invalidKeyBsdDesCryptPasswordHashMustBeBytes(final int bytes) {
        final InvalidKeyException result = new InvalidKeyException(String.format(getLoggingLocale(), invalidKeyBsdDesCryptPasswordHashMustBeBytes$str(), bytes));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecExpectedSpecGotSpec = "ELY08025: Expected to get a \"%s\" as spec, got \"%s\"";
    protected String invalidKeySpecExpectedSpecGotSpec$str() {
        return invalidKeySpecExpectedSpecGotSpec;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecExpectedSpecGotSpec(final String expected, final String got) {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecExpectedSpecGotSpec$str(), expected, got));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec = "ELY08026: Unknown algorithm or incompatible PasswordSpec";
    protected String invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec$str() {
        return invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeyUnknownUnknownPasswordTypeOrAlgorithm = "ELY08027: Unknown password type or algorithm";
    protected String invalidKeyUnknownUnknownPasswordTypeOrAlgorithm$str() {
        return invalidKeyUnknownUnknownPasswordTypeOrAlgorithm;
    }
    @Override
    public final InvalidKeyException invalidKeyUnknownUnknownPasswordTypeOrAlgorithm() {
        final InvalidKeyException result = new InvalidKeyException(String.format(getLoggingLocale(), invalidKeyUnknownUnknownPasswordTypeOrAlgorithm$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSuchAlgorithmInvalidAlgorithm = "ELY08028: Invalid algorithm \"%s\"";
    protected String noSuchAlgorithmInvalidAlgorithm$str() {
        return noSuchAlgorithmInvalidAlgorithm;
    }
    @Override
    public final NoSuchAlgorithmException noSuchAlgorithmInvalidAlgorithm(final String algorithm) {
        final NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(getLoggingLocale(), noSuchAlgorithmInvalidAlgorithm$str(), algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotObtainKeySpecEncodingIdentifier = "ELY08029: Could not obtain key spec encoding identifier.";
    protected String couldNotObtainKeySpecEncodingIdentifier$str() {
        return couldNotObtainKeySpecEncodingIdentifier;
    }
    @Override
    public final IllegalArgumentException couldNotObtainKeySpecEncodingIdentifier() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), couldNotObtainKeySpecEncodingIdentifier$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mismatchedPublicPrivateKeyParameters = "ELY09000: Public and private key parameters are mismatched";
    protected String mismatchedPublicPrivateKeyParameters$str() {
        return mismatchedPublicPrivateKeyParameters;
    }
    @Override
    public final IllegalArgumentException mismatchedPublicPrivateKeyParameters() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), mismatchedPublicPrivateKeyParameters$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
