package org.wildfly.security.credential.store._private;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.wildfly.security.credential.store.UnsupportedCredentialTypeException;
import java.io.IOException;
import org.wildfly.security.credential.store.CredentialStoreException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Arrays;
import org.wildfly.security.credential.store.CredentialStore.ProtectionParameter;


import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-04-12T16:03:32+0100")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String unableToCreateKeyStore = "ELY02009: Unable to create a new KeyStore instance";
    protected String unableToCreateKeyStore$str() {
        return unableToCreateKeyStore;
    }
    @Override
    public final IOException unableToCreateKeyStore(final Exception cause) {
        final IOException result = new IOException(String.format(getLoggingLocale(), unableToCreateKeyStore$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String wrongTypeOfExternalStorageKey = "ELY09500: External storage key under alias \"%s\" has to be a SecretKey";
    protected String wrongTypeOfExternalStorageKey$str() {
        return wrongTypeOfExternalStorageKey;
    }
    @Override
    public final CredentialStoreException wrongTypeOfExternalStorageKey(final String keyAlias) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), wrongTypeOfExternalStorageKey$str(), keyAlias));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAcquireCredentialFromStore = "ELY09504: Cannot acquire a credential from the credential store";
    protected String cannotAcquireCredentialFromStore$str() {
        return cannotAcquireCredentialFromStore;
    }
    @Override
    public final CredentialStoreException cannotAcquireCredentialFromStore(final Throwable cause) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), cannotAcquireCredentialFromStore$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nonModifiableCredentialStore = "ELY09505: Cannot perform operation '%s': Credential store is set non modifiable";
    protected String nonModifiableCredentialStore$str() {
        return nonModifiableCredentialStore;
    }
    @Override
    public final CredentialStoreException nonModifiableCredentialStore(final String operation) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), nonModifiableCredentialStore$str(), operation));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidProtectionParameter = "ELY09507: Invalid protection parameter given: %s";
    protected String invalidProtectionParameter$str() {
        return invalidProtectionParameter;
    }
    @Override
    public final CredentialStoreException invalidProtectionParameter(final ProtectionParameter protectionParameter) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), invalidProtectionParameter$str(), protectionParameter));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotWriteCredentialToStore = "ELY09508: Cannot write credential to store";
    protected String cannotWriteCredentialToStore$str() {
        return cannotWriteCredentialToStore;
    }
    @Override
    public final CredentialStoreException cannotWriteCredentialToStore(final Throwable cause) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), cannotWriteCredentialToStore$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedCredentialType = "ELY09509: Unsupported credential type %s";
    protected String unsupportedCredentialType$str() {
        return unsupportedCredentialType;
    }
    @Override
    public final UnsupportedCredentialTypeException unsupportedCredentialType(final Class<?> type) {
        final UnsupportedCredentialTypeException result = new UnsupportedCredentialTypeException(String.format(getLoggingLocale(), unsupportedCredentialType$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidCredentialStoreEntryType = "ELY09510: Invalid credential store keystore entry %s: expected %s";
    protected String invalidCredentialStoreEntryType$str() {
        return invalidCredentialStoreEntryType;
    }
    @Override
    public final CredentialStoreException invalidCredentialStoreEntryType(final Class<? extends java.security.KeyStore.Entry> entryType, final Class<? extends java.security.KeyStore.Entry> expectedType) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), invalidCredentialStoreEntryType$str(), entryType, expectedType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToReadCredentialTypeFromStore = "ELY09511: Unable to read credential %s from store";
    protected String unableToReadCredentialTypeFromStore$str() {
        return unableToReadCredentialTypeFromStore;
    }
    @Override
    public final CredentialStoreException unableToReadCredentialTypeFromStore(final Class<? extends org.wildfly.security.credential.Credential> credentialType) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), unableToReadCredentialTypeFromStore$str(), credentialType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRemoveCredentialFromStore = "ELY09512: Unable to remove credential from store";
    protected String cannotRemoveCredentialFromStore$str() {
        return cannotRemoveCredentialFromStore;
    }
    @Override
    public final CredentialStoreException cannotRemoveCredentialFromStore(final Throwable cause) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), cannotRemoveCredentialFromStore$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotFlushCredentialStore = "ELY09513: Unable to flush credential store to storage";
    protected String cannotFlushCredentialStore$str() {
        return cannotFlushCredentialStore;
    }
    @Override
    public final CredentialStoreException cannotFlushCredentialStore(final Throwable cause) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), cannotFlushCredentialStore$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotInitializeCredentialStore = "ELY09514: Unable to initialize credential store";
    protected String cannotInitializeCredentialStore$str() {
        return cannotInitializeCredentialStore;
    }
    @Override
    public final CredentialStoreException cannotInitializeCredentialStore(final Throwable cause) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), cannotInitializeCredentialStore$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void logIgnoredUnrecognizedKeyStoreEntry(final String alias) {
        super.log.logf(FQCN, DEBUG, null, logIgnoredUnrecognizedKeyStoreEntry$str(), alias);
    }
    private static final String logIgnoredUnrecognizedKeyStoreEntry = "ELY09515: Ignored unrecognized key store entry \"%s\"";
    protected String logIgnoredUnrecognizedKeyStoreEntry$str() {
        return logIgnoredUnrecognizedKeyStoreEntry;
    }
    @Override
    public final void logFailedToReadKeyFromKeyStore(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, logFailedToReadKeyFromKeyStore$str());
    }
    private static final String logFailedToReadKeyFromKeyStore = "ELY09516: Failed to read a credential entry from the key store";
    protected String logFailedToReadKeyFromKeyStore$str() {
        return logFailedToReadKeyFromKeyStore;
    }
    private static final String protectionParameterRequired = "ELY09517: This credential store type requires a store-wide protection parameter";
    protected String protectionParameterRequired$str() {
        return protectionParameterRequired;
    }
    @Override
    public final CredentialStoreException protectionParameterRequired() {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), protectionParameterRequired$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String automaticStorageCreationDisabled = "ELY09518: Automatic storage creation for the Credential Store is disabled \"%s\"";
    protected String automaticStorageCreationDisabled$str() {
        return automaticStorageCreationDisabled;
    }
    @Override
    public final CredentialStoreException automaticStorageCreationDisabled(final String location) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), automaticStorageCreationDisabled$str(), location));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedFileVersion = "ELY09519: Unexpected credential store external storage file version \"%s\"";
    protected String unexpectedFileVersion$str() {
        return unexpectedFileVersion;
    }
    @Override
    public final IOException unexpectedFileVersion(final String version) {
        final IOException result = new IOException(String.format(getLoggingLocale(), unexpectedFileVersion$str(), version));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unrecognizedEntryType = "ELY09520: Unrecognized entry type \"%s\"";
    protected String unrecognizedEntryType$str() {
        return unrecognizedEntryType;
    }
    @Override
    public final IOException unrecognizedEntryType(final String entryType) {
        final IOException result = new IOException(String.format(getLoggingLocale(), unrecognizedEntryType$str(), entryType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String internalEncryptionProblem = "ELY09521: Internal encryption problem while reading \"%s\"";
    protected String internalEncryptionProblem$str() {
        return internalEncryptionProblem;
    }
    @Override
    public final IOException internalEncryptionProblem(final Exception e, final String location) {
        final IOException result = new IOException(String.format(getLoggingLocale(), internalEncryptionProblem$str(), location), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String algorithmNotBlockBased = "ELY09522: \"%s\" is not a block based algorithm";
    protected String algorithmNotBlockBased$str() {
        return algorithmNotBlockBased;
    }
    @Override
    public final CredentialStoreException algorithmNotBlockBased(final String algorithm) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), algorithmNotBlockBased$str(), algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String algorithmNotIV = "ELY09523: Algorithm \"%s\" does not use an initialization vector (IV)";
    protected String algorithmNotIV$str() {
        return algorithmNotIV;
    }
    @Override
    public final CredentialStoreException algorithmNotIV(final String algorithm) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), algorithmNotIV$str(), algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String readBytesMismatch = "ELY09524: The actual number of bytes read %d is different from the expected number of bytes %d to be read";
    protected String readBytesMismatch$str() {
        return readBytesMismatch;
    }
    @Override
    public final IOException readBytesMismatch(final int actual, final int expected) {
        final IOException result = new IOException(String.format(getLoggingLocale(), readBytesMismatch$str(), actual, expected));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String locationAndExternalPathAreIdentical = "ELY09525: location and externalPath initial attributes are the same. [location=%s, externalPath=%s]";
    protected String locationAndExternalPathAreIdentical$str() {
        return locationAndExternalPathAreIdentical;
    }
    @Override
    public final CredentialStoreException locationAndExternalPathAreIdentical(final String location, final String externalPath) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), locationAndExternalPathAreIdentical$str(), location, externalPath));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedAttribute = "ELY09526: Unable to initialize credential store as attribute %s is unsupported in %s";
    protected String unsupportedAttribute$str() {
        return unsupportedAttribute;
    }
    @Override
    public final CredentialStoreException unsupportedAttribute(final String attribute, final java.util.List<String> validAttribute) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), unsupportedAttribute$str(), attribute, validAttribute));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String externalPathMissing = "ELY09528: The externalPath attribute for key store type %s is missing.";
    protected String externalPathMissing$str() {
        return externalPathMissing;
    }
    @Override
    public final CredentialStoreException externalPathMissing(final String keyStoreType) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), externalPathMissing$str(), keyStoreType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String externalStorageKeyDoesNotExist = "ELY11006: External storage key under alias \"%s\" does not exist";
    protected String externalStorageKeyDoesNotExist$str() {
        return externalStorageKeyDoesNotExist;
    }
    @Override
    public final CredentialStoreException externalStorageKeyDoesNotExist(final String keyAlias) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), externalStorageKeyDoesNotExist$str(), keyAlias));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
