package org.wildfly.security.x500.cert;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.wildfly.security.asn1.ASN1Exception;
import java.security.cert.CertificateException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import java.time.ZonedDateTime;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-04-12T16:01:32+0100")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String malformedPemContent = "ELY03010: Malformed PEM content at offset %d";
    protected String malformedPemContent$str() {
        return malformedPemContent;
    }
    @Override
    public final IllegalArgumentException malformedPemContent(final long offset) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), malformedPemContent$str(), offset));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPemType = "ELY03011: Invalid PEM type (expected \"%s\", got \"%s\"";
    protected String invalidPemType$str() {
        return invalidPemType;
    }
    @Override
    public final IllegalArgumentException invalidPemType(final String expected, final String actual) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidPemType$str(), expected, actual));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String certificateParseError = "ELY03012: Certificate parse error";
    protected String certificateParseError$str() {
        return certificateParseError;
    }
    @Override
    public final IllegalArgumentException certificateParseError(final CertificateException cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), certificateParseError$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String publicKeyParseError = "ELY03023: PublicKey parse error";
    protected String publicKeyParseError$str() {
        return publicKeyParseError;
    }
    @Override
    public final IllegalArgumentException publicKeyParseError(final Throwable cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), publicKeyParseError$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String privateKeyParseError = "ELY03033: PrivateKey parse error";
    protected String privateKeyParseError$str() {
        return privateKeyParseError;
    }
    @Override
    public final IllegalArgumentException privateKeyParseError(final Throwable cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), privateKeyParseError$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnUnrecognisedAlgorithm = "ELY07001: Unrecognized encoding algorithm [%s]";
    protected String asnUnrecognisedAlgorithm$str() {
        return asnUnrecognisedAlgorithm;
    }
    @Override
    public final ASN1Exception asnUnrecognisedAlgorithm(final String algorithm) {
        final ASN1Exception result = new ASN1Exception(String.format(getLoggingLocale(), asnUnrecognisedAlgorithm$str(), algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnUnexpectedTag = "ELY07004: Unexpected ASN.1 tag encountered";
    protected String asnUnexpectedTag$str() {
        return asnUnexpectedTag;
    }
    @Override
    public final ASN1Exception asnUnexpectedTag() {
        final ASN1Exception result = new ASN1Exception(String.format(getLoggingLocale(), asnUnexpectedTag$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String extensionAlreadyExists = "ELY10000: X.509 certificate extension with OID %s already exists";
    protected String extensionAlreadyExists$str() {
        return extensionAlreadyExists;
    }
    @Override
    public final IllegalArgumentException extensionAlreadyExists(final String oid) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), extensionAlreadyExists$str(), oid));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSignatureAlgorithmNameGiven = "ELY10001: No signature algorithm name given";
    protected String noSignatureAlgorithmNameGiven$str() {
        return noSignatureAlgorithmNameGiven;
    }
    @Override
    public final IllegalArgumentException noSignatureAlgorithmNameGiven() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noSignatureAlgorithmNameGiven$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownSignatureAlgorithmName = "ELY10002: Signature algorithm name \"%s\" is not recognized";
    protected String unknownSignatureAlgorithmName$str() {
        return unknownSignatureAlgorithmName;
    }
    @Override
    public final IllegalArgumentException unknownSignatureAlgorithmName(final String signatureAlgorithmName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownSignatureAlgorithmName$str(), signatureAlgorithmName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSigningKeyGiven = "ELY10003: No signing key given";
    protected String noSigningKeyGiven$str() {
        return noSigningKeyGiven;
    }
    @Override
    public final IllegalArgumentException noSigningKeyGiven() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noSigningKeyGiven$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String signingKeyNotCompatWithSig = "ELY10004: Signing key algorithm name \"%s\" is not compatible with signature algorithm name \"%s\"";
    protected String signingKeyNotCompatWithSig$str() {
        return signingKeyNotCompatWithSig;
    }
    @Override
    public final IllegalArgumentException signingKeyNotCompatWithSig(final String signingKeyAlgorithm, final String signatureAlgorithmName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), signingKeyNotCompatWithSig$str(), signingKeyAlgorithm, signatureAlgorithmName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String validAfterBeforeValidBefore = "ELY10005: Not-valid-before date of %s is after not-valid-after date of %s";
    protected String validAfterBeforeValidBefore$str() {
        return validAfterBeforeValidBefore;
    }
    @Override
    public final IllegalArgumentException validAfterBeforeValidBefore(final ZonedDateTime notValidBefore, final ZonedDateTime notValidAfter) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), validAfterBeforeValidBefore$str(), notValidBefore, notValidAfter));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noIssuerDnGiven = "ELY10006: No issuer DN given";
    protected String noIssuerDnGiven$str() {
        return noIssuerDnGiven;
    }
    @Override
    public final IllegalArgumentException noIssuerDnGiven() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noIssuerDnGiven$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noPublicKeyGiven = "ELY10007: No public key given";
    protected String noPublicKeyGiven$str() {
        return noPublicKeyGiven;
    }
    @Override
    public final IllegalArgumentException noPublicKeyGiven() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noPublicKeyGiven$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String uniqueIdNotAllowed = "ELY10008: Issuer and subject unique ID are only allowed in certificates with version 2 or higher";
    protected String uniqueIdNotAllowed$str() {
        return uniqueIdNotAllowed;
    }
    @Override
    public final IllegalArgumentException uniqueIdNotAllowed() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), uniqueIdNotAllowed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String extensionsNotAllowed = "ELY10009: Extensions are only allowed in certificates with version 3 or higher";
    protected String extensionsNotAllowed$str() {
        return extensionsNotAllowed;
    }
    @Override
    public final IllegalArgumentException extensionsNotAllowed() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), extensionsNotAllowed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeyForCert = "ELY10010: X.509 encoding of public key with algorithm \"%s\" failed";
    protected String invalidKeyForCert$str() {
        return invalidKeyForCert;
    }
    @Override
    public final IllegalArgumentException invalidKeyForCert(final String publicKeyAlgorithm, final Exception cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidKeyForCert$str(), publicKeyAlgorithm), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String certSigningFailed = "ELY10011: Failed to sign certificate";
    protected String certSigningFailed$str() {
        return certSigningFailed;
    }
    @Override
    public final IllegalArgumentException certSigningFailed(final Exception cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), certSigningFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serialNumberTooSmall = "ELY10012: Certificate serial number must be positive";
    protected String serialNumberTooSmall$str() {
        return serialNumberTooSmall;
    }
    @Override
    public final IllegalArgumentException serialNumberTooSmall() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), serialNumberTooSmall$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serialNumberTooLarge = "ELY10013: Certificate serial number too large (cannot exceed 20 octets)";
    protected String serialNumberTooLarge$str() {
        return serialNumberTooLarge;
    }
    @Override
    public final IllegalArgumentException serialNumberTooLarge() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), serialNumberTooLarge$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String certRequestInfoSigningFailed = "ELY10014: Failed to sign certification request info";
    protected String certRequestInfoSigningFailed$str() {
        return certRequestInfoSigningFailed;
    }
    @Override
    public final IllegalArgumentException certRequestInfoSigningFailed(final Exception cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), certRequestInfoSigningFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noCertificateGiven = "ELY10015: No certificate given";
    protected String noCertificateGiven$str() {
        return noCertificateGiven;
    }
    @Override
    public final IllegalArgumentException noCertificateGiven() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noCertificateGiven$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noDnGiven = "ELY10017: No DN given";
    protected String noDnGiven$str() {
        return noDnGiven;
    }
    @Override
    public final IllegalArgumentException noDnGiven() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noDnGiven$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String selfSignedCertificateGenerationFailed = "ELY10018: Failed to generate self-signed X.509 certificate";
    protected String selfSignedCertificateGenerationFailed$str() {
        return selfSignedCertificateGenerationFailed;
    }
    @Override
    public final IllegalArgumentException selfSignedCertificateGenerationFailed(final Exception cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), selfSignedCertificateGenerationFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToDetermineDefaultCompatibleSignatureAlgorithmName = "ELY10019: Unable to determine default compatible signature algorithm name for key algorithm name \"%s\"";
    protected String unableToDetermineDefaultCompatibleSignatureAlgorithmName$str() {
        return unableToDetermineDefaultCompatibleSignatureAlgorithmName;
    }
    @Override
    public final IllegalArgumentException unableToDetermineDefaultCompatibleSignatureAlgorithmName(final String keyAlgorithmName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unableToDetermineDefaultCompatibleSignatureAlgorithmName$str(), keyAlgorithmName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String certificateExtensionCreationFromStringNotSupported = "ELY10020: Creating an X.509 certificate extension from a string value is not supported for extension name \"%s\"";
    protected String certificateExtensionCreationFromStringNotSupported$str() {
        return certificateExtensionCreationFromStringNotSupported;
    }
    @Override
    public final IllegalArgumentException certificateExtensionCreationFromStringNotSupported(final String extensionName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), certificateExtensionCreationFromStringNotSupported$str(), extensionName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidCertificateExtensionStringValue1 = "ELY10021: Invalid X.509 certificate extension string value \"%s\"";
    protected String invalidCertificateExtensionStringValue1$str() {
        return invalidCertificateExtensionStringValue1;
    }
    @Override
    public final IllegalArgumentException invalidCertificateExtensionStringValue(final String extensionValue) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidCertificateExtensionStringValue1$str(), extensionValue));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String certificateExtensionCreationFromStringFailed = "ELY10022: Failed to create X.509 certificate extension from string value";
    protected String certificateExtensionCreationFromStringFailed$str() {
        return certificateExtensionCreationFromStringFailed;
    }
    @Override
    public final IllegalArgumentException certificateExtensionCreationFromStringFailed(final Exception cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), certificateExtensionCreationFromStringFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String certificateExtensionMustBeNonCritical = "ELY10023: X.509 certificate extension \"%s\" must be non-critical";
    protected String certificateExtensionMustBeNonCritical$str() {
        return certificateExtensionMustBeNonCritical;
    }
    @Override
    public final IllegalArgumentException certificateExtensionMustBeNonCritical(final String extensionName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), certificateExtensionMustBeNonCritical$str(), extensionName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidCertificateExtensionStringValue0 = "ELY10024: Invalid X.509 certificate extension string value";
    protected String invalidCertificateExtensionStringValue0$str() {
        return invalidCertificateExtensionStringValue0;
    }
    @Override
    public final IllegalArgumentException invalidCertificateExtensionStringValue() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidCertificateExtensionStringValue0$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
