package org.wildfly.security.x500.cert.acme;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.wildfly.security.x500.cert.acme.AcmeException;
import org.jboss.logging.BasicLogger;
import java.time.Instant;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import java.lang.Exception;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-04-12T16:08:03+0100")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String unableToDetermineKeySize = "ELY10016: Unable to determine key size";
    protected String unableToDetermineKeySize$str() {
        return unableToDetermineKeySize;
    }
    @Override
    public final IllegalArgumentException unableToDetermineKeySize() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unableToDetermineKeySize$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToDetermineDefaultCompatibleSignatureAlgorithmName = "ELY10019: Unable to determine default compatible signature algorithm name for key algorithm name \"%s\"";
    protected String unableToDetermineDefaultCompatibleSignatureAlgorithmName$str() {
        return unableToDetermineDefaultCompatibleSignatureAlgorithmName;
    }
    @Override
    public final IllegalArgumentException unableToDetermineDefaultCompatibleSignatureAlgorithmName(final String keyAlgorithmName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unableToDetermineDefaultCompatibleSignatureAlgorithmName$str(), keyAlgorithmName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String acmeAccountKeyPairGenerationFailed = "ELY10029: Failed to generate ACME account key pair";
    protected String acmeAccountKeyPairGenerationFailed$str() {
        return acmeAccountKeyPairGenerationFailed;
    }
    @Override
    public final IllegalArgumentException acmeAccountKeyPairGenerationFailed(final Exception cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), acmeAccountKeyPairGenerationFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noAcmeServerUrlGiven = "ELY10030: No ACME server URL given";
    protected String noAcmeServerUrlGiven$str() {
        return noAcmeServerUrlGiven;
    }
    @Override
    public final IllegalArgumentException noAcmeServerUrlGiven() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noAcmeServerUrlGiven$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedAcmeAccountSignatureAlgorithm = "ELY10031: Unsupported ACME account signature algorithm \"%s\"";
    protected String unsupportedAcmeAccountSignatureAlgorithm$str() {
        return unsupportedAcmeAccountSignatureAlgorithm;
    }
    @Override
    public final IllegalArgumentException unsupportedAcmeAccountSignatureAlgorithm(final String signatureAlgorithm) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unsupportedAcmeAccountSignatureAlgorithm$str(), signatureAlgorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToCreateAcmeSignature = "ELY10032: Unable to create ACME signature";
    protected String unableToCreateAcmeSignature$str() {
        return unableToCreateAcmeSignature;
    }
    @Override
    public final IllegalArgumentException unableToCreateAcmeSignature(final Exception cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unableToCreateAcmeSignature$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToRetrieveAcmeServerDirectoryUrls = "ELY10033: Unable to retrieve ACME server directory URLs";
    protected String unableToRetrieveAcmeServerDirectoryUrls$str() {
        return unableToRetrieveAcmeServerDirectoryUrls;
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException unableToRetrieveAcmeServerDirectoryUrls(final Exception cause) {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), unableToRetrieveAcmeServerDirectoryUrls$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noNonceProvidedByAcmeServer = "ELY10034: No nonce provided by ACME server";
    protected String noNonceProvidedByAcmeServer$str() {
        return noNonceProvidedByAcmeServer;
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException noNonceProvidedByAcmeServer() {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), noNonceProvidedByAcmeServer$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noAccountLocationUrlProvidedByAcmeServer = "ELY10035: No account location URL provided by ACME server";
    protected String noAccountLocationUrlProvidedByAcmeServer$str() {
        return noAccountLocationUrlProvidedByAcmeServer;
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException noAccountLocationUrlProvidedByAcmeServer() {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), noAccountLocationUrlProvidedByAcmeServer$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToObtainNewNonceFromAcmeServer = "ELY10036: Unable to obtain new nonce from ACME server";
    protected String unableToObtainNewNonceFromAcmeServer$str() {
        return unableToObtainNewNonceFromAcmeServer;
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException unableToObtainNewNonceFromAcmeServer() {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), unableToObtainNewNonceFromAcmeServer$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToObtainJsonResponseFromAcmeServer = "ELY10037: Unable to obtain JSON response from ACME server";
    protected String unableToObtainJsonResponseFromAcmeServer$str() {
        return unableToObtainJsonResponseFromAcmeServer;
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException unableToObtainJsonResponseFromAcmeServer(final Exception cause) {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), unableToObtainJsonResponseFromAcmeServer$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedResponseCodeFromAcmeServer = "ELY10038: Unexpected HTTP status code in response from ACME server \"%d\": \"%s\"";
    protected String unexpectedResponseCodeFromAcmeServer$str() {
        return unexpectedResponseCodeFromAcmeServer;
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException unexpectedResponseCodeFromAcmeServer(final int responseCode, final String responseMessage) {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), unexpectedResponseCodeFromAcmeServer$str(), responseCode, responseMessage));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String badAcmeNonce = "ELY10039: Bad ACME replay nonce, maximum retries attempted";
    protected String badAcmeNonce$str() {
        return badAcmeNonce;
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException badAcmeNonce() {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), badAcmeNonce$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedContentTypeFromAcmeServer = "ELY10040: Unexpected content type in response from ACME server \"%s\"";
    protected String unexpectedContentTypeFromAcmeServer$str() {
        return unexpectedContentTypeFromAcmeServer;
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException unexpectedContentTypeFromAcmeServer(final String contentType) {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), unexpectedContentTypeFromAcmeServer$str(), contentType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidContentTypeFromAcmeServer = "ELY10041: Invalid content type in response from ACME server";
    protected String invalidContentTypeFromAcmeServer$str() {
        return invalidContentTypeFromAcmeServer;
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException invalidContentTypeFromAcmeServer() {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), invalidContentTypeFromAcmeServer$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String domainNameIsNull = "ELY10042: Domain name is null";
    protected String domainNameIsNull$str() {
        return domainNameIsNull;
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException domainNameIsNull() {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), domainNameIsNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String domainNamesIsEmpty = "ELY10043: Domain names is empty";
    protected String domainNamesIsEmpty$str() {
        return domainNamesIsEmpty;
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException domainNamesIsEmpty() {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), domainNamesIsEmpty$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noCertificateUrlProvidedByAcmeServer = "ELY10044: No certificate URL provided by ACME server";
    protected String noCertificateUrlProvidedByAcmeServer$str() {
        return noCertificateUrlProvidedByAcmeServer;
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException noCertificateUrlProvidedByAcmeServer() {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), noCertificateUrlProvidedByAcmeServer$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noCertificateWillBeIssuedByAcmeServer = "ELY10045: No certificate will be issued by the ACME server";
    protected String noCertificateWillBeIssuedByAcmeServer$str() {
        return noCertificateWillBeIssuedByAcmeServer;
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException noCertificateWillBeIssuedByAcmeServer() {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), noCertificateWillBeIssuedByAcmeServer$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToGetEncodedFormOfCertificateToBeRevoked = "ELY10046: Unable to get encoded form of certificate to be revoked";
    protected String unableToGetEncodedFormOfCertificateToBeRevoked$str() {
        return unableToGetEncodedFormOfCertificateToBeRevoked;
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException unableToGetEncodedFormOfCertificateToBeRevoked(final Exception cause) {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), unableToGetEncodedFormOfCertificateToBeRevoked$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToDetermineKeyAuthorizationString = "ELY10047: Unable to determine key authorization string";
    protected String unableToDetermineKeyAuthorizationString$str() {
        return unableToDetermineKeyAuthorizationString;
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException unableToDetermineKeyAuthorizationString(final Exception cause) {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), unableToDetermineKeyAuthorizationString$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String challengeResponseFailedValidationByAcmeServer = "ELY10048: Challenge response failed validation by the ACME server";
    protected String challengeResponseFailedValidationByAcmeServer$str() {
        return challengeResponseFailedValidationByAcmeServer;
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException challengeResponseFailedValidationByAcmeServer() {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), challengeResponseFailedValidationByAcmeServer$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToDownloadCertificateChainFromAcmeServer = "ELY10049: Unable to download certificate chain from ACME server";
    protected String unableToDownloadCertificateChainFromAcmeServer$str() {
        return unableToDownloadCertificateChainFromAcmeServer;
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException unableToDownloadCertificateChainFromAcmeServer(final Exception cause) {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), unableToDownloadCertificateChainFromAcmeServer$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String acmeAccountDoesNotExist = "ELY10050: ACME account does not exist";
    protected String acmeAccountDoesNotExist$str() {
        return acmeAccountDoesNotExist;
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException acmeAccountDoesNotExist() {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), acmeAccountDoesNotExist$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String userActionRequired = "ELY10051: User action required since the ACME server's terms of service have changed, visit \"%s\" for details";
    protected String userActionRequired$str() {
        return userActionRequired;
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException userActionRequired(final String url) {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), userActionRequired$str(), url));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String rateLimitExceededTryAgainLater = "ELY10052: Rate limit has been exceeded, try again after \"%s\"";
    protected String rateLimitExceededTryAgainLater$str() {
        return rateLimitExceededTryAgainLater;
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException rateLimitExceededTryAgainLater(final Instant instant) {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), rateLimitExceededTryAgainLater$str(), instant));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String rateLimitExceeded = "ELY10053: Rate limit has been exceeded";
    protected String rateLimitExceeded$str() {
        return rateLimitExceeded;
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException rateLimitExceeded() {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), rateLimitExceeded$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String resourceNotSupportedByAcmeServer = "ELY10054: Resource not supported by the ACME server \"%s\"";
    protected String resourceNotSupportedByAcmeServer$str() {
        return resourceNotSupportedByAcmeServer;
    }
    @Override
    public final org.wildfly.security.x500.cert.acme.AcmeException resourceNotSupportedByAcmeServer(final String resource) {
        final org.wildfly.security.x500.cert.acme.AcmeException result = new org.wildfly.security.x500.cert.acme.AcmeException(String.format(getLoggingLocale(), resourceNotSupportedByAcmeServer$str(), resource));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedAcmeAccountPublicKeyType = "ELY10055: Unsupported ACME account public key type \"%s\"";
    protected String unsupportedAcmeAccountPublicKeyType$str() {
        return unsupportedAcmeAccountPublicKeyType;
    }
    @Override
    public final IllegalArgumentException unsupportedAcmeAccountPublicKeyType(final String keyAlgorithmName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unsupportedAcmeAccountPublicKeyType$str(), keyAlgorithmName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToDetermineCurveParameterFromAlgHeader = "ELY10056: Unable to determine curve parameter from alg header \"%s\"";
    protected String unableToDetermineCurveParameterFromAlgHeader$str() {
        return unableToDetermineCurveParameterFromAlgHeader;
    }
    @Override
    public final IllegalArgumentException unableToDetermineCurveParameterFromAlgHeader(final String algHeader) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unableToDetermineCurveParameterFromAlgHeader$str(), algHeader));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
