/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http;

import java.io.InputStream;
import java.util.function.Consumer;
import org.wildfly.security.http.HttpScopeNotification;
import org.wildfly.security.http._private.ElytronMessages;

public interface HttpScope {
    default public String getID() {
        return null;
    }

    default public boolean exists() {
        return true;
    }

    default public boolean create() {
        return false;
    }

    default public boolean supportsAttachments() {
        return false;
    }

    default public void setAttachment(String key, Object value) {
        throw ElytronMessages.log.noAttachmentSupport();
    }

    default public Object getAttachment(String key) {
        throw ElytronMessages.log.noAttachmentSupport();
    }

    default public <T> T getAttachment(String key, Class<T> type) {
        Object attachment = this.getAttachment(key);
        if (attachment != null && type.isInstance(attachment)) {
            return type.cast(attachment);
        }
        return null;
    }

    default public boolean supportsInvalidation() {
        return false;
    }

    default public boolean invalidate() {
        return false;
    }

    default public boolean supportsResources() {
        return false;
    }

    default public InputStream getResource(String path) {
        return null;
    }

    default public boolean supportsNotifications() {
        return false;
    }

    default public void registerForNotification(Consumer<HttpScopeNotification> notificationConsumer) {
    }
}

