/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.keystore;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.concurrent.atomic.AtomicReference;
import org.wildfly.security.credential._private.ElytronMessages;
import org.wildfly.security.keystore.DelegatingKeyStoreSpi;
import org.wildfly.security.keystore.KeyStoreFactory;

class AtomicLoadKeyStoreSpi
extends DelegatingKeyStoreSpi {
    private final KeyStoreFactory keyStoreFactory;
    private final AtomicReference<KeyStore> currentStore = new AtomicReference();

    AtomicLoadKeyStoreSpi(KeyStoreFactory keyStoreFactory) {
        this.keyStoreFactory = keyStoreFactory;
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        ElytronMessages.tls.tracef("AtomicLoadKeyStore loading:  stream = %s,  password = %b", (Object)stream, (Object)(password != null ? 1 : 0));
        try {
            KeyStore keyStore = this.keyStoreFactory.getInstance();
            keyStore.load(stream, password);
            this.currentStore.set(keyStore);
        }
        catch (KeyStoreException e) {
            throw ElytronMessages.log.unableToCreateKeyStore(e);
        }
    }

    KeyStore getCurrentKeyStore() {
        return this.currentStore.get();
    }

    void restoreKeyStore(KeyStore keyStore) {
        this.currentStore.set(keyStore);
    }

    @Override
    protected KeyStore getKeyStore() {
        return this.currentStore.get();
    }
}

