/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;
import org.wildfly.security.auth.server.RealmUnavailableException;

@MessageLogger(projectCode="ELY", length=5)
@ValidIdRanges(value={@ValidIdRange(min=1066, max=1077), @ValidIdRange(min=4001, max=4031), @ValidIdRange(min=5015, max=5017), @ValidIdRange(min=15000, max=15999)})
interface ElytronMessages
extends BasicLogger {
    public static final ElytronMessages log = Logger.getMessageLogger(ElytronMessages.class, "org.wildfly.security");
    public static final ElytronMessages tls = Logger.getMessageLogger(ElytronMessages.class, "org.wildfly.security.tls");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1066, value="Invalid string count for mechanism database entry \"%s\"")
    public void warnInvalidStringCountForMechanismDatabaseEntry(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1067, value="Invalid key exchange \"%s\" for mechanism database entry \"%s\"")
    public void warnInvalidKeyExchangeForMechanismDatabaseEntry(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1068, value="Invalid authentication \"%s\" for mechanism database entry \"%s\"")
    public void warnInvalidAuthenticationForMechanismDatabaseEntry(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1069, value="Invalid encryption \"%s\" for mechanism database entry \"%s\"")
    public void warnInvalidEncryptionForMechanismDatabaseEntry(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1070, value="Invalid digest \"%s\" for mechanism database entry \"%s\"")
    public void warnInvalidDigestForMechanismDatabaseEntry(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1071, value="Invalid protocol \"%s\" for mechanism database entry \"%s\"")
    public void warnInvalidProtocolForMechanismDatabaseEntry(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1072, value="Invalid level \"%s\" for mechanism database entry \"%s\"")
    public void warnInvalidLevelForMechanismDatabaseEntry(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1073, value="Invalid strength bits \"%s\" for mechanism database entry \"%s\"")
    public void warnInvalidStrengthBitsForMechanismDatabaseEntry(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1074, value="Invalid algorithm bits \"%s\" for mechanism database entry \"%s\"")
    public void warnInvalidAlgorithmBitsForMechanismDatabaseEntry(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1075, value="Invalid duplicate mechanism database entry \"%s\"")
    public void warnInvalidDuplicateMechanismDatabaseEntry(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1076, value="Invalid duplicate OpenSSL-style alias \"%s\" for mechanism database entry \"%s\" (original is \"%s\")")
    public void warnInvalidDuplicateOpenSslStyleAliasForMechanismDatabaseEntry(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1077, value="Invalid alias \"%s\" for missing mechanism database entry \"%s\"")
    public void warnInvalidAliasForMissingMechanismDatabaseEntry(String var1, String var2);

    @Message(id=4001, value="No algorithm found matching TLS/SSL protocol selection criteria")
    public NoSuchAlgorithmException noAlgorithmForSslProtocol();

    @Message(id=4002, value="Empty certificate chain is not trusted")
    public CertificateException emptyChainNotTrusted();

    @Message(id=4003, value="Certificate not trusted due to realm failure for principal [%s]")
    public CertificateException notTrustedRealmProblem(@Cause RealmUnavailableException var1, Principal var2);

    @Message(id=4004, value="Credential validation failed: certificate is not trusted for principal [%s]")
    public CertificateException notTrusted(Principal var1);

    @Message(id=4005, value="No default trust manager available")
    public NoSuchAlgorithmException noDefaultTrustManager();

    @Message(id=4006, value="No context for SSL connection")
    public SSLHandshakeException noContextForSslConnection();

    @Message(id=4007, value="SSL channel is closed")
    public SSLException sslClosed();

    @Message(id=4008, value="Initial SSL/TLS data is not a handshake record")
    public SSLHandshakeException notHandshakeRecord();

    @Message(id=4009, value="Initial SSL/TLS handshake record is invalid")
    public SSLHandshakeException invalidHandshakeRecord();

    @Message(id=4010, value="Initial SSL/TLS handshake spans multiple records")
    public SSLHandshakeException multiRecordSSLHandshake();

    @Message(id=4011, value="Expected \"client hello\" record")
    public SSLHandshakeException expectedClientHello();

    @Message(id=4012, value="Unsupported SSL/TLS record")
    public SSLHandshakeException unsupportedSslRecord();

    @Message(id=4013, value="Invalid TLS extension data")
    public SSLProtocolException invalidTlsExt();

    @Message(id=4014, value="Not enough data in record to fill declared item size")
    public SSLProtocolException notEnoughData();

    @Message(id=4015, value="Empty host name in SNI record data")
    public SSLProtocolException emptyHostNameSni();

    @Message(id=4016, value="Duplicated SNI server name of type %d")
    public SSLProtocolException duplicatedSniServerName(int var1);

    @Message(id=4017, value="Unknown authentication name \"%s\"")
    public IllegalArgumentException unknownAuthenticationName(String var1);

    @Message(id=4018, value="Unknown encryption name \"%s\"")
    public IllegalArgumentException unknownEncryptionName(String var1);

    @Message(id=4019, value="Unknown key exchange name \"%s\"")
    public IllegalArgumentException unknownKeyExchangeName(String var1);

    @Message(id=4024, value="Invalid client mode, expected %s, got %s")
    public IllegalArgumentException invalidClientMode(boolean var1, boolean var2);

    @Message(id=4026, value="Could not create trust manager [%s]")
    public IllegalStateException sslErrorCreatingTrustManager(String var1, @Cause Throwable var2);

    @Message(id=4027, value="SecurityDomain of SSLContext does not support X509PeerCertificateChainEvidence verification")
    public IllegalArgumentException securityDomainOfSSLContextDoesNotSupportX509();

    @Message(id=4029, value="Default context cannot be null")
    public IllegalStateException defaultContextCannotBeNull();

    @Message(id=4030, value="No context for SSL connection")
    public SSLException noSNIContextForSslConnection();

    @Message(id=4031, value="TrustManagerFactory algorithm [%s] does not support certificate revocation")
    public IllegalStateException sslErrorCreatingRevocationTrustManager(String var1, @Cause Throwable var2);

    @Message(id=5015, value="Unexpected character U+%04x at offset %d of mechanism selection string \"%s\"")
    public IllegalArgumentException mechSelectorUnexpectedChar(int var1, long var2, String var4);

    @Message(id=5016, value="Unrecognized token \"%s\" in mechanism selection string \"%s\"")
    public IllegalArgumentException mechSelectorUnknownToken(String var1, String var2);

    @Message(id=5017, value="Token \"%s\" not allowed at offset %d of mechanism selection string \"%s\"")
    public IllegalArgumentException mechSelectorTokenNotAllowed(String var1, long var2, String var4);

    @Message(id=15000, value="Uknown cipher suite name '%s' in names string '%s'")
    public IllegalArgumentException unknownCipherSuiteName(String var1, String var2);
}

