package org.wildfly.security.asn1;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.wildfly.security.asn1.ASN1Exception;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import org.jboss.logging.Logger;
import java.util.Arrays;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-03-20T15:37:42+0000")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String unableToLoadOidsFromPropertiesFile = "ELY00012: Unable to load OIDs database from properties file";
    protected String unableToLoadOidsFromPropertiesFile$str() {
        return unableToLoadOidsFromPropertiesFile;
    }
    @Override
    public final IllegalStateException unableToLoadOidsFromPropertiesFile(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unableToLoadOidsFromPropertiesFile$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnUnexpectedTag = "ELY07004: Unexpected ASN.1 tag encountered";
    protected String asnUnexpectedTag$str() {
        return asnUnexpectedTag;
    }
    @Override
    public final org.wildfly.security.asn1.ASN1Exception asnUnexpectedTag() {
        final org.wildfly.security.asn1.ASN1Exception result = new org.wildfly.security.asn1.ASN1Exception(String.format(getLoggingLocale(), asnUnexpectedTag$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnUnableToReadCertificateData = "ELY07005: Unable to read X.509 certificate data";
    protected String asnUnableToReadCertificateData$str() {
        return asnUnableToReadCertificateData;
    }
    @Override
    public final org.wildfly.security.asn1.ASN1Exception asnUnableToReadCertificateData(final Throwable cause) {
        final org.wildfly.security.asn1.ASN1Exception result = new org.wildfly.security.asn1.ASN1Exception(String.format(getLoggingLocale(), asnUnableToReadCertificateData$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSequenceToEnd = "ELY07009: No sequence to end";
    protected String noSequenceToEnd$str() {
        return noSequenceToEnd;
    }
    @Override
    public final IllegalStateException noSequenceToEnd() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noSequenceToEnd$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSetToEnd = "ELY07010: No set to end";
    protected String noSetToEnd$str() {
        return noSetToEnd;
    }
    @Override
    public final IllegalStateException noSetToEnd() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noSetToEnd$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noExplicitlyTaggedElementToEnd = "ELY07011: No explicitly tagged element to end";
    protected String noExplicitlyTaggedElementToEnd$str() {
        return noExplicitlyTaggedElementToEnd;
    }
    @Override
    public final IllegalStateException noExplicitlyTaggedElementToEnd() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noExplicitlyTaggedElementToEnd$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnUnexpectedEndOfInput = "ELY07012: Unexpected end of input";
    protected String asnUnexpectedEndOfInput$str() {
        return asnUnexpectedEndOfInput;
    }
    @Override
    public final org.wildfly.security.asn1.ASN1Exception asnUnexpectedEndOfInput() {
        final org.wildfly.security.asn1.ASN1Exception result = new org.wildfly.security.asn1.ASN1Exception(String.format(getLoggingLocale(), asnUnexpectedEndOfInput$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnInvalidNumberOfUnusedBits = "ELY07013: Invalid number of unused bits";
    protected String asnInvalidNumberOfUnusedBits$str() {
        return asnInvalidNumberOfUnusedBits;
    }
    @Override
    public final org.wildfly.security.asn1.ASN1Exception asnInvalidNumberOfUnusedBits() {
        final org.wildfly.security.asn1.ASN1Exception result = new org.wildfly.security.asn1.ASN1Exception(String.format(getLoggingLocale(), asnInvalidNumberOfUnusedBits$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnNonZeroLengthForNullTypeTag = "ELY07014: Non-zero length encountered for null type tag";
    protected String asnNonZeroLengthForNullTypeTag$str() {
        return asnNonZeroLengthForNullTypeTag;
    }
    @Override
    public final org.wildfly.security.asn1.ASN1Exception asnNonZeroLengthForNullTypeTag() {
        final org.wildfly.security.asn1.ASN1Exception result = new org.wildfly.security.asn1.ASN1Exception(String.format(getLoggingLocale(), asnNonZeroLengthForNullTypeTag$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnInvalidHighTagNumberForm = "ELY07015: Invalid high-tag-number form";
    protected String asnInvalidHighTagNumberForm$str() {
        return asnInvalidHighTagNumberForm;
    }
    @Override
    public final org.wildfly.security.asn1.ASN1Exception asnInvalidHighTagNumberForm() {
        final org.wildfly.security.asn1.ASN1Exception result = new org.wildfly.security.asn1.ASN1Exception(String.format(getLoggingLocale(), asnInvalidHighTagNumberForm$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnLengthEncodingExceeds4bytes = "ELY07016: Length encoding exceeds 4 bytes";
    protected String asnLengthEncodingExceeds4bytes$str() {
        return asnLengthEncodingExceeds4bytes;
    }
    @Override
    public final org.wildfly.security.asn1.ASN1Exception asnLengthEncodingExceeds4bytes() {
        final org.wildfly.security.asn1.ASN1Exception result = new org.wildfly.security.asn1.ASN1Exception(String.format(getLoggingLocale(), asnLengthEncodingExceeds4bytes$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnInvalidOidCharacter = "ELY07017: Invalid OID character";
    protected String asnInvalidOidCharacter$str() {
        return asnInvalidOidCharacter;
    }
    @Override
    public final org.wildfly.security.asn1.ASN1Exception asnInvalidOidCharacter() {
        final org.wildfly.security.asn1.ASN1Exception result = new org.wildfly.security.asn1.ASN1Exception(String.format(getLoggingLocale(), asnInvalidOidCharacter$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnOidMustHaveAtLeast2Components = "ELY07018: OID must have at least 2 components";
    protected String asnOidMustHaveAtLeast2Components$str() {
        return asnOidMustHaveAtLeast2Components;
    }
    @Override
    public final org.wildfly.security.asn1.ASN1Exception asnOidMustHaveAtLeast2Components() {
        final org.wildfly.security.asn1.ASN1Exception result = new org.wildfly.security.asn1.ASN1Exception(String.format(getLoggingLocale(), asnOidMustHaveAtLeast2Components$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnInvalidValueForFirstOidComponent = "ELY07019: Invalid value for first OID component; expected 0, 1, or 2";
    protected String asnInvalidValueForFirstOidComponent$str() {
        return asnInvalidValueForFirstOidComponent;
    }
    @Override
    public final org.wildfly.security.asn1.ASN1Exception asnInvalidValueForFirstOidComponent() {
        final org.wildfly.security.asn1.ASN1Exception result = new org.wildfly.security.asn1.ASN1Exception(String.format(getLoggingLocale(), asnInvalidValueForFirstOidComponent$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnInvalidValueForSecondOidComponent = "ELY07020: Invalid value for second OID component; expected a value between 0 and 39 (inclusive)";
    protected String asnInvalidValueForSecondOidComponent$str() {
        return asnInvalidValueForSecondOidComponent;
    }
    @Override
    public final org.wildfly.security.asn1.ASN1Exception asnInvalidValueForSecondOidComponent() {
        final org.wildfly.security.asn1.ASN1Exception result = new org.wildfly.security.asn1.ASN1Exception(String.format(getLoggingLocale(), asnInvalidValueForSecondOidComponent$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnInvalidLength = "ELY07021: Invalid length";
    protected String asnInvalidLength$str() {
        return asnInvalidLength;
    }
    @Override
    public final org.wildfly.security.asn1.ASN1Exception asnInvalidLength() {
        final org.wildfly.security.asn1.ASN1Exception result = new org.wildfly.security.asn1.ASN1Exception(String.format(getLoggingLocale(), asnInvalidLength$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnUnknownTagType = "ELY07022: Unknown tag type: %d";
    protected String asnUnknownTagType$str() {
        return asnUnknownTagType;
    }
    @Override
    public final org.wildfly.security.asn1.ASN1Exception asnUnknownTagType(final int type) {
        final org.wildfly.security.asn1.ASN1Exception result = new org.wildfly.security.asn1.ASN1Exception(String.format(getLoggingLocale(), asnUnknownTagType$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnUnexpectedCharacterByteForPrintableString = "ELY07023: Unexpected character byte for printable string";
    protected String asnUnexpectedCharacterByteForPrintableString$str() {
        return asnUnexpectedCharacterByteForPrintableString;
    }
    @Override
    public final org.wildfly.security.asn1.ASN1Exception asnUnexpectedCharacterByteForPrintableString() {
        final org.wildfly.security.asn1.ASN1Exception result = new org.wildfly.security.asn1.ASN1Exception(String.format(getLoggingLocale(), asnUnexpectedCharacterByteForPrintableString$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnInvalidLengthForBooleanTypeTag = "ELY07024: Invalid length encountered for boolean type tag";
    protected String asnInvalidLengthForBooleanTypeTag$str() {
        return asnInvalidLengthForBooleanTypeTag;
    }
    @Override
    public final org.wildfly.security.asn1.ASN1Exception asnInvalidLengthForBooleanTypeTag() {
        final org.wildfly.security.asn1.ASN1Exception result = new org.wildfly.security.asn1.ASN1Exception(String.format(getLoggingLocale(), asnInvalidLengthForBooleanTypeTag$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
