package org.wildfly.security.password.impl;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import java.security.NoSuchAlgorithmException;
import org.jboss.logging.Logger;
import javax.security.sasl.SaslException;
import java.security.InvalidKeyException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-03-20T15:39:07+0000")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String emptyParameter = "ELY00002: Parameter %s is empty";
    protected String emptyParameter$str() {
        return emptyParameter;
    }
    @Override
    public final IllegalArgumentException emptyParameter(final String parameter) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), emptyParameter$str(), parameter));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unrecognizedAlgorithm = "ELY00004: Unrecognized algorithm \"%s\"";
    protected String unrecognizedAlgorithm$str() {
        return unrecognizedAlgorithm;
    }
    @Override
    public final IllegalArgumentException unrecognizedAlgorithm(final String algorithm) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unrecognizedAlgorithm$str(), algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidOTPAlgorithm = "ELY05151: Invalid OTP algorithm \"%s\"";
    protected String mechInvalidOTPAlgorithm$str() {
        return mechInvalidOTPAlgorithm;
    }
    @Override
    public final SaslException mechInvalidOTPAlgorithm(final String algorithm) {
        final SaslException result = new SaslException(String.format(getLoggingLocale(), mechInvalidOTPAlgorithm$str(), algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecNoSuchMessageDigestAlgorithm = "ELY08013: No such MessageDigest algorithm for \"%s\"";
    protected String invalidKeySpecNoSuchMessageDigestAlgorithm$str() {
        return invalidKeySpecNoSuchMessageDigestAlgorithm;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecNoSuchMessageDigestAlgorithm(final String algorithm) {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecNoSuchMessageDigestAlgorithm$str(), algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeyNoSuchMessageDigestAlgorithm = "ELY08014: No such MessageDigest algorithm for \"%s\"";
    protected String invalidKeyNoSuchMessageDigestAlgorithm$str() {
        return invalidKeyNoSuchMessageDigestAlgorithm;
    }
    @Override
    public final InvalidKeyException invalidKeyNoSuchMessageDigestAlgorithm(final String algorithm) {
        final InvalidKeyException result = new InvalidKeyException(String.format(getLoggingLocale(), invalidKeyNoSuchMessageDigestAlgorithm$str(), algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeyCannotVerifyPassword = "ELY08015: Cannot verify password";
    protected String invalidKeyCannotVerifyPassword$str() {
        return invalidKeyCannotVerifyPassword;
    }
    @Override
    public final InvalidKeyException invalidKeyCannotVerifyPassword(final Throwable cause) {
        final InvalidKeyException result = new InvalidKeyException(String.format(getLoggingLocale(), invalidKeyCannotVerifyPassword$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeyDesCryptPasswordHashMustBeBytes = "ELY08017: DES crypt password hash must be %d bytes";
    protected String invalidKeyDesCryptPasswordHashMustBeBytes$str() {
        return invalidKeyDesCryptPasswordHashMustBeBytes;
    }
    @Override
    public final InvalidKeyException invalidKeyDesCryptPasswordHashMustBeBytes(final int bytes) {
        final InvalidKeyException result = new InvalidKeyException(String.format(getLoggingLocale(), invalidKeyDesCryptPasswordHashMustBeBytes$str(), bytes));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidParameterSpecSaltMustBeBytesBits = "ELY08018: Salt must be %d bytes (%d bits)";
    protected String invalidParameterSpecSaltMustBeBytesBits$str() {
        return invalidParameterSpecSaltMustBeBytesBits;
    }
    @Override
    public final InvalidParameterSpecException invalidParameterSpecSaltMustBeBytesBits(final int bytes, final int bits) {
        final InvalidParameterSpecException result = new InvalidParameterSpecException(String.format(getLoggingLocale(), invalidParameterSpecSaltMustBeBytesBits$str(), bytes, bits));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidNumberOfRoundsMustBeIntBetween = "ELY08020: Invalid number of rounds. Must be an integer between %d and %d, inclusive";
    protected String invalidNumberOfRoundsMustBeIntBetween$str() {
        return invalidNumberOfRoundsMustBeIntBetween;
    }
    @Override
    public final IllegalArgumentException invalidNumberOfRoundsMustBeIntBetween(final int min, final int max) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidNumberOfRoundsMustBeIntBetween$str(), min, max));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidSaltMustBeBytesLong = "ELY08021: Invalid salt: must be %d bytes long";
    protected String invalidSaltMustBeBytesLong$str() {
        return invalidSaltMustBeBytesLong;
    }
    @Override
    public final IllegalArgumentException invalidSaltMustBeBytesLong(final int length) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidSaltMustBeBytesLong$str(), length));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecBsdDesCryptPasswordHashMustBeBytes = "ELY08022: BSD DES crypt password hash must be %d bytes";
    protected String invalidKeySpecBsdDesCryptPasswordHashMustBeBytes$str() {
        return invalidKeySpecBsdDesCryptPasswordHashMustBeBytes;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecBsdDesCryptPasswordHashMustBeBytes(final int bytes) {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecBsdDesCryptPasswordHashMustBeBytes$str(), bytes));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidParameterSpecSaltMustBeBytes = "ELY08023: Salt must be %d bytes";
    protected String invalidParameterSpecSaltMustBeBytes$str() {
        return invalidParameterSpecSaltMustBeBytes;
    }
    @Override
    public final InvalidParameterSpecException invalidParameterSpecSaltMustBeBytes(final int bytes) {
        final InvalidParameterSpecException result = new InvalidParameterSpecException(String.format(getLoggingLocale(), invalidParameterSpecSaltMustBeBytes$str(), bytes));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeyBsdDesCryptPasswordHashMustBeBytes = "ELY08024: BSD DES crypt password hash must be %d bytes";
    protected String invalidKeyBsdDesCryptPasswordHashMustBeBytes$str() {
        return invalidKeyBsdDesCryptPasswordHashMustBeBytes;
    }
    @Override
    public final InvalidKeyException invalidKeyBsdDesCryptPasswordHashMustBeBytes(final int bytes) {
        final InvalidKeyException result = new InvalidKeyException(String.format(getLoggingLocale(), invalidKeyBsdDesCryptPasswordHashMustBeBytes$str(), bytes));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecExpectedSpecGotSpec = "ELY08025: Expected to get a \"%s\" as spec, got \"%s\"";
    protected String invalidKeySpecExpectedSpecGotSpec$str() {
        return invalidKeySpecExpectedSpecGotSpec;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecExpectedSpecGotSpec(final String expected, final String got) {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecExpectedSpecGotSpec$str(), expected, got));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec = "ELY08026: Unknown algorithm or incompatible PasswordSpec";
    protected String invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec$str() {
        return invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec;
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeyUnknownUnknownPasswordTypeOrAlgorithm = "ELY08027: Unknown password type or algorithm";
    protected String invalidKeyUnknownUnknownPasswordTypeOrAlgorithm$str() {
        return invalidKeyUnknownUnknownPasswordTypeOrAlgorithm;
    }
    @Override
    public final InvalidKeyException invalidKeyUnknownUnknownPasswordTypeOrAlgorithm() {
        final InvalidKeyException result = new InvalidKeyException(String.format(getLoggingLocale(), invalidKeyUnknownUnknownPasswordTypeOrAlgorithm$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSuchAlgorithmInvalidAlgorithm = "ELY08028: Invalid algorithm \"%s\"";
    protected String noSuchAlgorithmInvalidAlgorithm$str() {
        return noSuchAlgorithmInvalidAlgorithm;
    }
    @Override
    public final NoSuchAlgorithmException noSuchAlgorithmInvalidAlgorithm(final String algorithm) {
        final NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(getLoggingLocale(), noSuchAlgorithmInvalidAlgorithm$str(), algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
