package org.wildfly.security.permission;

import java.util.Locale;
import org.wildfly.security.permission.PermissionVerifier;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.SecurityException;
import java.lang.String;
import org.jboss.logging.Logger;
import org.wildfly.security.permission.InvalidPermissionClassException;
import org.jboss.logging.BasicLogger;
import java.security.Permission;
import java.lang.Throwable;
import java.io.InvalidObjectException;
import java.util.Arrays;
import java.lang.ClassNotFoundException;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-03-20T15:38:49+0000")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String permissionCollectionMustBeReadOnly = "ELY03013: Permission collection must be read-only";
    protected String permissionCollectionMustBeReadOnly$str() {
        return permissionCollectionMustBeReadOnly;
    }
    @Override
    public final SecurityException permissionCollectionMustBeReadOnly() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), permissionCollectionMustBeReadOnly$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String permissionClassMissing = "ELY03015: Could not load permission class \"%s\"";
    protected String permissionClassMissing$str() {
        return permissionClassMissing;
    }
    @Override
    public final org.wildfly.security.permission.InvalidPermissionClassException permissionClassMissing(final String className, final ClassNotFoundException cause) {
        final org.wildfly.security.permission.InvalidPermissionClassException result = new org.wildfly.security.permission.InvalidPermissionClassException(String.format(getLoggingLocale(), permissionClassMissing$str(), className), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String permissionInstantiation = "ELY03016: Could not instantiate permission class \"%s\"";
    protected String permissionInstantiation$str() {
        return permissionInstantiation;
    }
    @Override
    public final org.wildfly.security.permission.InvalidPermissionClassException permissionInstantiation(final String className, final Throwable cause) {
        final org.wildfly.security.permission.InvalidPermissionClassException result = new org.wildfly.security.permission.InvalidPermissionClassException(String.format(getLoggingLocale(), permissionInstantiation$str(), className), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noPermissionConstructor = "ELY03017: No valid permission constructor found on class \"%s\"";
    protected String noPermissionConstructor$str() {
        return noPermissionConstructor;
    }
    @Override
    public final org.wildfly.security.permission.InvalidPermissionClassException noPermissionConstructor(final String className) {
        final org.wildfly.security.permission.InvalidPermissionClassException result = new org.wildfly.security.permission.InvalidPermissionClassException(String.format(getLoggingLocale(), noPermissionConstructor$str(), className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String readOnlyPermissionCollection = "ELY03018: Cannot add permissions to a read-only permission collection";
    protected String readOnlyPermissionCollection$str() {
        return readOnlyPermissionCollection;
    }
    @Override
    public final SecurityException readOnlyPermissionCollection() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), readOnlyPermissionCollection$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidObjectNull = "ELY03019: Failure to deserialize object: field \"%s\" is null";
    protected String invalidObjectNull$str() {
        return invalidObjectNull;
    }
    @Override
    public final InvalidObjectException invalidObjectNull(final String fieldName) {
        final InvalidObjectException result = new InvalidObjectException(String.format(getLoggingLocale(), invalidObjectNull$str(), fieldName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expectedEmptyActions = "ELY03020: Expected empty actions string, got \"%s\"";
    protected String expectedEmptyActions$str() {
        return expectedEmptyActions;
    }
    @Override
    public final IllegalArgumentException expectedEmptyActions(final String actions) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), expectedEmptyActions$str(), actions));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPermissionType = "ELY03021: Invalid permission type; expected %s, got %s";
    protected String invalidPermissionType$str() {
        return invalidPermissionType;
    }
    @Override
    public final IllegalArgumentException invalidPermissionType(final Class<? extends Permission> expected, final Permission actual) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidPermissionType$str(), expected, actual));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String permissionCheckFailed = "ELY03022: Permission check failed: %s is not implied by %s";
    protected String permissionCheckFailed$str() {
        return permissionCheckFailed;
    }
    @Override
    public final SecurityException permissionCheckFailed(final Permission permission, final org.wildfly.security.permission.PermissionVerifier permissionVerifier) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), permissionCheckFailed$str(), permission, permissionVerifier));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
