package org.wildfly.security.auth.realm;

import java.util.Locale;
import java.nio.file.Path;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.RealmUnavailableException;
import java.lang.String;
import java.io.IOException;
import java.security.KeyStoreException;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Arrays;
import java.security.Principal;
import java.lang.IllegalArgumentException;
import java.util.NoSuchElementException;


import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-03-22T11:54:15+0000")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String noRealmFoundInProperties = "ELY01006: No realm name found in users property file - non-plain-text users file must contain \"#$REALM_NAME=RealmName$\" line";
    protected String noRealmFoundInProperties$str() {
        return noRealmFoundInProperties;
    }
    @Override
    public final RealmUnavailableException noRealmFoundInProperties() {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), noRealmFoundInProperties$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void debugJAASAuthenticationFailure(final Principal principal, final Throwable cause) {
        super.log.logf(FQCN, DEBUG, cause, debugJAASAuthenticationFailure$str(), principal);
    }
    private static final String debugJAASAuthenticationFailure = "ELY01007: JAAS authentication failed for principal %s";
    protected String debugJAASAuthenticationFailure$str() {
        return debugJAASAuthenticationFailure;
    }
    private static final String failedToCreateLoginContext = "ELY01008: Failed to create login context";
    protected String failedToCreateLoginContext$str() {
        return failedToCreateLoginContext;
    }
    @Override
    public final RealmUnavailableException failedToCreateLoginContext(final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), failedToCreateLoginContext$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToInstantiateCustomHandler = "ELY01009: Failed to instantiate custom CallbackHandler";
    protected String failedToInstantiateCustomHandler$str() {
        return failedToInstantiateCustomHandler;
    }
    @Override
    public final RealmUnavailableException failedToInstantiateCustomHandler(final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), failedToInstantiateCustomHandler$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemRealmFailedToOpen = "ELY01012: Filesystem-backed realm unexpectedly failed to open path \"%s\" for identity name \"%s\"";
    protected String fileSystemRealmFailedToOpen$str() {
        return fileSystemRealmFailedToOpen;
    }
    @Override
    public final RealmUnavailableException fileSystemRealmFailedToOpen(final Path path, final String finalName, final IOException cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmFailedToOpen$str(), path, finalName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemRealmFailedToRead = "ELY01013: Filesystem-backed realm unexpectedly failed to read path \"%s\" for identity name \"%s\"";
    protected String fileSystemRealmFailedToRead$str() {
        return fileSystemRealmFailedToRead;
    }
    @Override
    public final RealmUnavailableException fileSystemRealmFailedToRead(final Path path, final String finalName, final Exception cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmFailedToRead$str(), path, finalName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemRealmInvalidContent = "ELY01015: Filesystem-backed realm encountered invalid file content in path \"%s\" line %d for identity name \"%s\"";
    protected String fileSystemRealmInvalidContent$str() {
        return fileSystemRealmInvalidContent;
    }
    @Override
    public final RealmUnavailableException fileSystemRealmInvalidContent(final Path path, final int lineNumber, final String name) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmInvalidContent$str(), path, lineNumber, name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemRealmMissingAttribute = "ELY01016: Filesystem-backed realm encountered missing required attribute \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    protected String fileSystemRealmMissingAttribute$str() {
        return fileSystemRealmMissingAttribute;
    }
    @Override
    public final RealmUnavailableException fileSystemRealmMissingAttribute(final String attribute, final Path path, final int lineNumber, final String name) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmMissingAttribute$str(), attribute, path, lineNumber, name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemRealmInvalidPasswordFormat = "ELY01017: Filesystem-backed realm encountered invalid password format \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    protected String fileSystemRealmInvalidPasswordFormat$str() {
        return fileSystemRealmInvalidPasswordFormat;
    }
    @Override
    public final RealmUnavailableException fileSystemRealmInvalidPasswordFormat(final String format, final Path path, final int lineNumber, final String name) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmInvalidPasswordFormat$str(), format, path, lineNumber, name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemRealmInvalidPasswordAlgorithm = "ELY01018: Filesystem-backed realm encountered invalid password algorithm \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    protected String fileSystemRealmInvalidPasswordAlgorithm$str() {
        return fileSystemRealmInvalidPasswordAlgorithm;
    }
    @Override
    public final RealmUnavailableException fileSystemRealmInvalidPasswordAlgorithm(final String algorithm, final Path path, final int lineNumber, final String name) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmInvalidPasswordAlgorithm$str(), algorithm, path, lineNumber, name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemUpdatedFailed = "ELY01020: Filesystem-backed realm failed to update identity \"%s\"";
    protected String fileSystemUpdatedFailed$str() {
        return fileSystemUpdatedFailed;
    }
    @Override
    public final RealmUnavailableException fileSystemUpdatedFailed(final String name, final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemUpdatedFailed$str(), name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemRealmDeleteFailed = "ELY01021: Filesystem-backed realm failed to delete identity \"%s\"";
    protected String fileSystemRealmDeleteFailed$str() {
        return fileSystemRealmDeleteFailed;
    }
    @Override
    public final RealmUnavailableException fileSystemRealmDeleteFailed(final String name, final IOException e) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmDeleteFailed$str(), name), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemRealmNotFound = "ELY01022: Filesystem-backed realm failed to find identity \"%s\"";
    protected String fileSystemRealmNotFound$str() {
        return fileSystemRealmNotFound;
    }
    @Override
    public final RealmUnavailableException fileSystemRealmNotFound(final String name) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmNotFound$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemRealmFailedToWrite = "ELY01023: Filesystem-backed realm failed to write to file \"%s\" for identity \"%s\"";
    protected String fileSystemRealmFailedToWrite$str() {
        return fileSystemRealmFailedToWrite;
    }
    @Override
    public final RealmUnavailableException fileSystemRealmFailedToWrite(final Path tempPath, final String name, final Exception e) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmFailedToWrite$str(), tempPath, name), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemRealmAlreadyExists = "ELY01024: Filesystem-backed realm cannot create duplicate identity for identity \"%s\"";
    protected String fileSystemRealmAlreadyExists$str() {
        return fileSystemRealmAlreadyExists;
    }
    @Override
    public final RealmUnavailableException fileSystemRealmAlreadyExists(final String name, final Throwable e) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmAlreadyExists$str(), name), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemRealmCertificateReadError = "ELY01025: Filesystem-backed realm encountered invalid certificate format \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    protected String fileSystemRealmCertificateReadError$str() {
        return fileSystemRealmCertificateReadError;
    }
    @Override
    public final RealmUnavailableException fileSystemRealmCertificateReadError(final String format, final Path path, final int lineNumber, final String name) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmCertificateReadError$str(), format, path, lineNumber, name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemRealmUnsupportedKeyFormat = "ELY01026: Filesystem-backed realm encountered invalid key format \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    protected String fileSystemRealmUnsupportedKeyFormat$str() {
        return fileSystemRealmUnsupportedKeyFormat;
    }
    @Override
    public final RealmUnavailableException fileSystemRealmUnsupportedKeyFormat(final String format, final Path path, final int lineNumber, final String name) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmUnsupportedKeyFormat$str(), format, path, lineNumber, name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemRealmUnsupportedKeyAlgorithm = "ELY01027: Filesystem-backed realm encountered invalid key algorithm for format \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    protected String fileSystemRealmUnsupportedKeyAlgorithm$str() {
        return fileSystemRealmUnsupportedKeyAlgorithm;
    }
    @Override
    public final RealmUnavailableException fileSystemRealmUnsupportedKeyAlgorithm(final String format, final Path path, final int lineNumber, final String name, final Exception e) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmUnsupportedKeyAlgorithm$str(), format, path, lineNumber, name), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidName = "ELY01064: Invalid identity name";
    protected String invalidName$str() {
        return invalidName;
    }
    @Override
    public final IllegalArgumentException invalidName() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemRealmInvalidOtpDefinition = "ELY01081: Filesystem-backed realm encountered invalid OTP definition in path \"%s\" line %d for identity name \"%s\"";
    protected String fileSystemRealmInvalidOtpDefinition$str() {
        return fileSystemRealmInvalidOtpDefinition;
    }
    @Override
    public final RealmUnavailableException fileSystemRealmInvalidOtpDefinition(final Path path, final int lineNumber, final String name, final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmInvalidOtpDefinition$str(), path, lineNumber, name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileSystemRealmInvalidOtpAlgorithm = "ELY01082: Filesystem-backed realm encountered invalid OTP algorithm \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    protected String fileSystemRealmInvalidOtpAlgorithm$str() {
        return fileSystemRealmInvalidOtpAlgorithm;
    }
    @Override
    public final RealmUnavailableException fileSystemRealmInvalidOtpAlgorithm(final String algorithm, final Path path, final int lineNumber, final String name, final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), fileSystemRealmInvalidOtpAlgorithm$str(), algorithm, path, lineNumber, name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String decodingHashedPasswordFromPropertiesRealmFailed = "ELY01138: Decoding hashed password from users property file failed - should not be set as plain-text property file?";
    protected String decodingHashedPasswordFromPropertiesRealmFailed$str() {
        return decodingHashedPasswordFromPropertiesRealmFailed;
    }
    @Override
    public final RealmUnavailableException decodingHashedPasswordFromPropertiesRealmFailed(final Exception e) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), decodingHashedPasswordFromPropertiesRealmFailed$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String realmCacheUnexpectedType = "ELY01145: Security realm [%s] must implement [%s]";
    protected String realmCacheUnexpectedType$str() {
        return realmCacheUnexpectedType;
    }
    @Override
    public final IllegalArgumentException realmCacheUnexpectedType(final SecurityRealm realm, final Class<? extends CacheableSecurityRealm> expectedType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), realmCacheUnexpectedType$str(), realm, expectedType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToReadKeyStore = "ELY01154: Failed to read key store";
    protected String failedToReadKeyStore$str() {
        return failedToReadKeyStore;
    }
    @Override
    public final RealmUnavailableException failedToReadKeyStore(final KeyStoreException e) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), failedToReadKeyStore$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidUnicodeSequence = "ELY11005: Invalid unicode endoding, offending sequence: %s.";
    protected String invalidUnicodeSequence$str() {
        return invalidUnicodeSequence;
    }
    @Override
    public final IOException invalidUnicodeSequence(final String s, final NoSuchElementException nsee) {
        final IOException result = new IOException(String.format(getLoggingLocale(), invalidUnicodeSequence$str(), s), nsee);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
