package org.wildfly.security.auth.realm.token._private;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.wildfly.security.auth.server.RealmUnavailableException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.RuntimeException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-03-22T11:55:41+0000")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String tokenRealmFailedToObtainPrincipal = "ELY01104: OAuth2-based realm failed to obtain principal";
    protected String tokenRealmFailedToObtainPrincipal$str() {
        return tokenRealmFailedToObtainPrincipal;
    }
    @Override
    public final RuntimeException tokenRealmFailedToObtainPrincipal(final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), tokenRealmFailedToObtainPrincipal$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tokenRealmOAuth2TokenIntrospectionFailed = "ELY01105: OAuth2-based realm failed to introspect token";
    protected String tokenRealmOAuth2TokenIntrospectionFailed$str() {
        return tokenRealmOAuth2TokenIntrospectionFailed;
    }
    @Override
    public final RealmUnavailableException tokenRealmOAuth2TokenIntrospectionFailed(final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), tokenRealmOAuth2TokenIntrospectionFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tokenRealmFailedToObtainPrincipalWithClaim = "ELY01113: Token-based realm failed to obtain principal from token using claim [%s]";
    protected String tokenRealmFailedToObtainPrincipalWithClaim$str() {
        return tokenRealmFailedToObtainPrincipalWithClaim;
    }
    @Override
    public final IllegalStateException tokenRealmFailedToObtainPrincipalWithClaim(final String claimName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), tokenRealmFailedToObtainPrincipalWithClaim$str(), claimName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tokenRealmJwtInvalidFormat = "ELY01114: Invalid token format. Tokens must have a signature part accordingly with JWS specification";
    protected String tokenRealmJwtInvalidFormat$str() {
        return tokenRealmJwtInvalidFormat;
    }
    @Override
    public final IllegalArgumentException tokenRealmJwtInvalidFormat() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), tokenRealmJwtInvalidFormat$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tokenRealmJwtParseFailed = "ELY01115: Failed to parse token";
    protected String tokenRealmJwtParseFailed$str() {
        return tokenRealmJwtParseFailed;
    }
    @Override
    public final IllegalStateException tokenRealmJwtParseFailed(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), tokenRealmJwtParseFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tokenRealmJwtSignatureCheckFailed = "ELY01116: Signature verification failed";
    protected String tokenRealmJwtSignatureCheckFailed$str() {
        return tokenRealmJwtSignatureCheckFailed;
    }
    @Override
    public final IllegalStateException tokenRealmJwtSignatureCheckFailed(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), tokenRealmJwtSignatureCheckFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tokenRealmJwtSignatureInvalidAlgorithm = "ELY01117: Invalid signature algorithm [%s]";
    protected String tokenRealmJwtSignatureInvalidAlgorithm$str() {
        return tokenRealmJwtSignatureInvalidAlgorithm;
    }
    @Override
    public final IllegalArgumentException tokenRealmJwtSignatureInvalidAlgorithm(final String algorithm) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), tokenRealmJwtSignatureInvalidAlgorithm$str(), algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tokenRealmJwtInvalidPublicKeyPem = "ELY01118: Public key could not be obtained. Probably due to an invalid PEM format.";
    protected String tokenRealmJwtInvalidPublicKeyPem$str() {
        return tokenRealmJwtInvalidPublicKeyPem;
    }
    @Override
    public final IllegalArgumentException tokenRealmJwtInvalidPublicKeyPem() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), tokenRealmJwtInvalidPublicKeyPem$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void tokenRealmJwtWarnNoIssuerIgnoringIssuerCheck() {
        super.log.logf(FQCN, WARN, null, tokenRealmJwtWarnNoIssuerIgnoringIssuerCheck$str());
    }
    private static final String tokenRealmJwtWarnNoIssuerIgnoringIssuerCheck = "ELY01126: Jwt-based token realm not configured with a list of valid issuers. Ignoring issuer verification.";
    protected String tokenRealmJwtWarnNoIssuerIgnoringIssuerCheck$str() {
        return tokenRealmJwtWarnNoIssuerIgnoringIssuerCheck;
    }
    @Override
    public final void tokenRealmJwtWarnNoAudienceIgnoringAudienceCheck() {
        super.log.logf(FQCN, WARN, null, tokenRealmJwtWarnNoAudienceIgnoringAudienceCheck$str());
    }
    private static final String tokenRealmJwtWarnNoAudienceIgnoringAudienceCheck = "ELY01127: Jwt-based token not configured with a list of valid audiences. Ignoring audience verification.";
    protected String tokenRealmJwtWarnNoAudienceIgnoringAudienceCheck$str() {
        return tokenRealmJwtWarnNoAudienceIgnoringAudienceCheck;
    }
    @Override
    public final void tokenRealmJwtWarnNoPublicKeyIgnoringSignatureCheck() {
        super.log.logf(FQCN, WARN, null, tokenRealmJwtWarnNoPublicKeyIgnoringSignatureCheck$str());
    }
    private static final String tokenRealmJwtWarnNoPublicKeyIgnoringSignatureCheck = "ELY01128: Jwt-based token not configured with a public key. Ignoring signature verification.";
    protected String tokenRealmJwtWarnNoPublicKeyIgnoringSignatureCheck$str() {
        return tokenRealmJwtWarnNoPublicKeyIgnoringSignatureCheck;
    }
    @Override
    public final void unableToFetchJwks(final String url) {
        super.log.logf(FQCN, WARN, null, unableToFetchJwks$str(), url);
    }
    private static final String unableToFetchJwks = "ELY01178: Unable to update jwk set from \"%1$s\".";
    protected String unableToFetchJwks$str() {
        return unableToFetchJwks;
    }
    @Override
    public final void tokenRealmJwtNoSSLIgnoringJku() {
        super.log.logf(FQCN, WARN, null, tokenRealmJwtNoSSLIgnoringJku$str());
    }
    private static final String tokenRealmJwtNoSSLIgnoringJku = "ELY01179: SSL not configured. jku claim will not be supported.";
    protected String tokenRealmJwtNoSSLIgnoringJku$str() {
        return tokenRealmJwtNoSSLIgnoringJku;
    }
    @Override
    public final void tokenRealmJwkMissingClaim(final String claim) {
        super.log.logf(FQCN, INFO, null, tokenRealmJwkMissingClaim$str(), claim);
    }
    private static final String tokenRealmJwkMissingClaim = "ELY01180: Fetched jwk does not contain \"%1$s\" claim, ignoring...";
    protected String tokenRealmJwkMissingClaim$str() {
        return tokenRealmJwkMissingClaim;
    }
}
