package org.wildfly.security.auth.util;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.security.GeneralSecurityException;
import java.io.IOException;
import java.lang.String;
import org.jboss.logging.Logger;
import org.jboss.logging.BasicLogger;
import javax.security.auth.login.LoginException;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-03-22T11:54:37+0000")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String builderAlreadyBuilt = "ELY00003: This builder has already been built";
    protected String builderAlreadyBuilt$str() {
        return builderAlreadyBuilt;
    }
    @Override
    public final IllegalStateException builderAlreadyBuilt() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), builderAlreadyBuilt$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patternRequiresCaptureGroup = "ELY01065: Pattern requires a capture group";
    protected String patternRequiresCaptureGroup$str() {
        return patternRequiresCaptureGroup;
    }
    @Override
    public final IllegalArgumentException patternRequiresCaptureGroup() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), patternRequiresCaptureGroup$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToPerformInitialLogin = "ELY01121: Unable to perform initial JAAS login.";
    protected String unableToPerformInitialLogin$str() {
        return unableToPerformInitialLogin;
    }
    @Override
    public final GeneralSecurityException unableToPerformInitialLogin(final LoginException cause) {
        final GeneralSecurityException result = new GeneralSecurityException(String.format(getLoggingLocale(), unableToPerformInitialLogin$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noKerberosPrincipalsFound = "ELY01122: No Kerberos principals found.";
    protected String noKerberosPrincipalsFound$str() {
        return noKerberosPrincipalsFound;
    }
    @Override
    public final GeneralSecurityException noKerberosPrincipalsFound() {
        final GeneralSecurityException result = new GeneralSecurityException(String.format(getLoggingLocale(), noKerberosPrincipalsFound$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tooManyKerberosPrincipalsFound = "ELY01123: Too many Kerberos principals found.";
    protected String tooManyKerberosPrincipalsFound$str() {
        return tooManyKerberosPrincipalsFound;
    }
    @Override
    public final GeneralSecurityException tooManyKerberosPrincipalsFound() {
        final GeneralSecurityException result = new GeneralSecurityException(String.format(getLoggingLocale(), tooManyKerberosPrincipalsFound$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyTabDoesNotExists = "ELY01160: KeyTab [%s] does not exists.";
    protected String keyTabDoesNotExists$str() {
        return keyTabDoesNotExists;
    }
    @Override
    public final IOException keyTabDoesNotExists(final String keyTab) {
        final IOException result = new IOException(String.format(getLoggingLocale(), keyTabDoesNotExists$str(), keyTab));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noKeysForPrincipalInKeyTab = "ELY01161: No keys for Kerberos principal [%s] was found in KeyTab [%s].";
    protected String noKeysForPrincipalInKeyTab$str() {
        return noKeysForPrincipalInKeyTab;
    }
    @Override
    public final IOException noKeysForPrincipalInKeyTab(final String principal, final String keyTab) {
        final IOException result = new IOException(String.format(getLoggingLocale(), noKeysForPrincipalInKeyTab$str(), principal, keyTab));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String initialLoginSkipped = "ELY01165: Initial JAAS login skipped as it has failed in last %d seconds";
    protected String initialLoginSkipped$str() {
        return initialLoginSkipped;
    }
    @Override
    public final GeneralSecurityException initialLoginSkipped(final long seconds) {
        final GeneralSecurityException result = new GeneralSecurityException(String.format(getLoggingLocale(), initialLoginSkipped$str(), seconds));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tooManyKerberosTicketsFound = "ELY03031: Too many KerberosTicket instances in private credentials";
    protected String tooManyKerberosTicketsFound$str() {
        return tooManyKerberosTicketsFound;
    }
    @Override
    public final GeneralSecurityException tooManyKerberosTicketsFound() {
        final GeneralSecurityException result = new GeneralSecurityException(String.format(getLoggingLocale(), tooManyKerberosTicketsFound$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
