package org.wildfly.security.mechanism._private;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.wildfly.security.mechanism.ScramServerException;
import org.jboss.logging.DelegatingBasicLogger;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.asn1.ASN1Exception;
import java.lang.NumberFormatException;
import java.lang.SecurityException;
import java.lang.String;
import org.jboss.logging.Logger;
import org.wildfly.security.mechanism.ScramServerErrorCode;
import java.lang.Exception;
import java.lang.RuntimeException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import org.wildfly.security.mechanism.AuthenticationMechanismException;


import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-03-22T11:54:56+0000")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void credentialDestroyingFailed(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, credentialDestroyingFailed$str());
    }
    private static final String credentialDestroyingFailed = "ELY00007: Credential destroying failed";
    protected String credentialDestroyingFailed$str() {
        return credentialDestroyingFailed;
    }
    private static final String authenticationFailedEvidenceVerification = "ELY01151: Evidence Verification Failed.";
    protected String authenticationFailedEvidenceVerification$str() {
        return authenticationFailedEvidenceVerification;
    }
    @Override
    public final SecurityException authenticationFailedEvidenceVerification() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), authenticationFailedEvidenceVerification$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechMessageAfterComplete = "ELY05001: Authentication mechanism exchange received a message after authentication was already complete";
    protected String mechMessageAfterComplete$str() {
        return mechMessageAfterComplete;
    }
    @Override
    public final AuthenticationMechanismException mechMessageAfterComplete() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechMessageAfterComplete$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUserNameContainsInvalidCharacter = "ELY05002: Authentication mechanism user name contains an invalid or disallowed character";
    protected String mechUserNameContainsInvalidCharacter$str() {
        return mechUserNameContainsInvalidCharacter;
    }
    @Override
    public final AuthenticationMechanismException mechUserNameContainsInvalidCharacter() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUserNameContainsInvalidCharacter$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechAuthorizationFailed0 = "ELY05004: Authentication mechanism authorization failed";
    protected String mechAuthorizationFailed0$str() {
        return mechAuthorizationFailed0;
    }
    @Override
    public final AuthenticationMechanismException mechAuthorizationFailed(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechAuthorizationFailed0$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechAuthenticationNotComplete = "ELY05005: Authentication mechanism authentication is not yet complete";
    protected String mechAuthenticationNotComplete$str() {
        return mechAuthenticationNotComplete;
    }
    @Override
    public final IllegalStateException mechAuthenticationNotComplete() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), mechAuthenticationNotComplete$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechNoSecurityLayer = "ELY05006: Authentication mechanism does not support security layer (wrapping/unwrapping)";
    protected String mechNoSecurityLayer$str() {
        return mechNoSecurityLayer;
    }
    @Override
    public final IllegalStateException mechNoSecurityLayer() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), mechNoSecurityLayer$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidMessageReceived = "ELY05007: Invalid authentication mechanism negotiation message received";
    protected String mechInvalidMessageReceived$str() {
        return mechInvalidMessageReceived;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidMessageReceived() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidMessageReceived$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechNoLoginNameGiven = "ELY05008: No authentication mechanism login name was given";
    protected String mechNoLoginNameGiven$str() {
        return mechNoLoginNameGiven;
    }
    @Override
    public final AuthenticationMechanismException mechNoLoginNameGiven() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechNoLoginNameGiven$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechNoPasswordGiven = "ELY05009: No authentication mechanism password was given";
    protected String mechNoPasswordGiven$str() {
        return mechNoPasswordGiven;
    }
    @Override
    public final AuthenticationMechanismException mechNoPasswordGiven() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechNoPasswordGiven$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechMalformedFields = "ELY05010: Authentication mechanism authentication failed due to one or more malformed fields";
    protected String mechMalformedFields$str() {
        return mechMalformedFields;
    }
    @Override
    public final AuthenticationMechanismException mechMalformedFields(final IllegalArgumentException ex) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechMalformedFields$str()), ex);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechMessageTooLong = "ELY05011: Authentication mechanism message is too long";
    protected String mechMessageTooLong$str() {
        return mechMessageTooLong;
    }
    @Override
    public final AuthenticationMechanismException mechMessageTooLong() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechMessageTooLong$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechServerSideAuthenticationFailed = "ELY05012: Authentication mechanism server-side authentication failed";
    protected String mechServerSideAuthenticationFailed$str() {
        return mechServerSideAuthenticationFailed;
    }
    @Override
    public final AuthenticationMechanismException mechServerSideAuthenticationFailed(final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechServerSideAuthenticationFailed$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechPasswordNotVerified = "ELY05013: Authentication mechanism password not verified";
    protected String mechPasswordNotVerified$str() {
        return mechPasswordNotVerified;
    }
    @Override
    public final AuthenticationMechanismException mechPasswordNotVerified() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechPasswordNotVerified$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechAuthorizationFailed2 = "ELY05014: Authentication mechanism authorization failed: \"%s\" running as \"%s\"";
    protected String mechAuthorizationFailed2$str() {
        return mechAuthorizationFailed2;
    }
    @Override
    public final AuthenticationMechanismException mechAuthorizationFailed(final String userName, final String authorizationId) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechAuthorizationFailed2$str(), userName, authorizationId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechChannelBindingChanged = "ELY05018: Channel binding data changed";
    protected String mechChannelBindingChanged$str() {
        return mechChannelBindingChanged;
    }
    @Override
    public final AuthenticationMechanismException mechChannelBindingChanged() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechChannelBindingChanged$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechNoTokenGiven = "ELY05019: No token was given";
    protected String mechNoTokenGiven$str() {
        return mechNoTokenGiven;
    }
    @Override
    public final AuthenticationMechanismException mechNoTokenGiven() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechNoTokenGiven$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInitialChallengeMustBeEmpty = "ELY05022: Initial challenge must be empty";
    protected String mechInitialChallengeMustBeEmpty$str() {
        return mechInitialChallengeMustBeEmpty;
    }
    @Override
    public final AuthenticationMechanismException mechInitialChallengeMustBeEmpty() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInitialChallengeMustBeEmpty$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToSetChannelBinding = "ELY05023: Unable to set channel binding";
    protected String mechUnableToSetChannelBinding$str() {
        return mechUnableToSetChannelBinding;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToSetChannelBinding(final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToSetChannelBinding$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechFailedToDetermineChannelBindingStatus = "ELY05024: Failed to determine channel binding status";
    protected String mechFailedToDetermineChannelBindingStatus$str() {
        return mechFailedToDetermineChannelBindingStatus;
    }
    @Override
    public final AuthenticationMechanismException mechFailedToDetermineChannelBindingStatus(final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechFailedToDetermineChannelBindingStatus$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechMutualAuthenticationNotEnabled = "ELY05025: Mutual authentication not enabled";
    protected String mechMutualAuthenticationNotEnabled$str() {
        return mechMutualAuthenticationNotEnabled;
    }
    @Override
    public final AuthenticationMechanismException mechMutualAuthenticationNotEnabled() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechMutualAuthenticationNotEnabled$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechMechanismToOidMappingFailed = "ELY05026: Unable to map SASL mechanism name to a GSS-API OID";
    protected String mechMechanismToOidMappingFailed$str() {
        return mechMechanismToOidMappingFailed;
    }
    @Override
    public final AuthenticationMechanismException mechMechanismToOidMappingFailed(final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechMechanismToOidMappingFailed$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToDisposeGssContext = "ELY05027: Unable to dispose of GSSContext";
    protected String mechUnableToDisposeGssContext$str() {
        return mechUnableToDisposeGssContext;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToDisposeGssContext(final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToDisposeGssContext$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToCreateNameForAcceptor = "ELY05028: Unable to create name for acceptor";
    protected String mechUnableToCreateNameForAcceptor$str() {
        return mechUnableToCreateNameForAcceptor;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToCreateNameForAcceptor(final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToCreateNameForAcceptor$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToCreateGssContext = "ELY05029: Unable to create GSSContext";
    protected String mechUnableToCreateGssContext$str() {
        return mechUnableToCreateGssContext;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToCreateGssContext(final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToCreateGssContext$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToSetGssContextRequestFlags = "ELY05030: Unable to set GSSContext request flags";
    protected String mechUnableToSetGssContextRequestFlags$str() {
        return mechUnableToSetGssContextRequestFlags;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToSetGssContextRequestFlags(final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToSetGssContextRequestFlags$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToAcceptClientMessage = "ELY05031: Unable to accept SASL client message";
    protected String mechUnableToAcceptClientMessage$str() {
        return mechUnableToAcceptClientMessage;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToAcceptClientMessage(final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToAcceptClientMessage$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechGssApiMechanismMismatch = "ELY05032: GSS-API mechanism mismatch between SASL client and server";
    protected String mechGssApiMechanismMismatch$str() {
        return mechGssApiMechanismMismatch;
    }
    @Override
    public final AuthenticationMechanismException mechGssApiMechanismMismatch() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechGssApiMechanismMismatch$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechChannelBindingNotSupported = "ELY05033: Channel binding not supported for this SASL mechanism";
    protected String mechChannelBindingNotSupported$str() {
        return mechChannelBindingNotSupported;
    }
    @Override
    public final AuthenticationMechanismException mechChannelBindingNotSupported() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechChannelBindingNotSupported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechChannelBindingTypeMismatch = "ELY05034: Channel binding type mismatch between SASL client and server";
    protected String mechChannelBindingTypeMismatch$str() {
        return mechChannelBindingTypeMismatch;
    }
    @Override
    public final AuthenticationMechanismException mechChannelBindingTypeMismatch() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechChannelBindingTypeMismatch$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechChannelBindingNotProvided = "ELY05035: Channel binding not provided by client";
    protected String mechChannelBindingNotProvided$str() {
        return mechChannelBindingNotProvided;
    }
    @Override
    public final AuthenticationMechanismException mechChannelBindingNotProvided() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechChannelBindingNotProvided$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToDeterminePeerName = "ELY05036: Unable to determine peer name";
    protected String mechUnableToDeterminePeerName$str() {
        return mechUnableToDeterminePeerName;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToDeterminePeerName(final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToDeterminePeerName$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechClientRefusesToInitiateAuthentication = "ELY05037: Authentication mechanism client refuses to initiate authentication";
    protected String mechClientRefusesToInitiateAuthentication$str() {
        return mechClientRefusesToInitiateAuthentication;
    }
    @Override
    public final AuthenticationMechanismException mechClientRefusesToInitiateAuthentication() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechClientRefusesToInitiateAuthentication$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechNoncesDoNotMatch = "ELY05038: Nonces do not match";
    protected String mechNoncesDoNotMatch$str() {
        return mechNoncesDoNotMatch;
    }
    @Override
    public final AuthenticationMechanismException mechNoncesDoNotMatch() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechNoncesDoNotMatch$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidNonceLength = "ELY05039: Invalid length of nonce received";
    protected String invalidNonceLength$str() {
        return invalidNonceLength;
    }
    @Override
    public final AuthenticationMechanismException invalidNonceLength() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), invalidNonceLength$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechIterationCountIsTooLow = "ELY05040: Iteration count %d is below the minimum of %d";
    protected String mechIterationCountIsTooLow$str() {
        return mechIterationCountIsTooLow;
    }
    @Override
    public final AuthenticationMechanismException mechIterationCountIsTooLow(final int iterationCount, final int minimumIterationCount) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechIterationCountIsTooLow$str(), iterationCount, minimumIterationCount));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechIterationCountIsTooHigh = "ELY05041: Iteration count %d is above the maximum of %d";
    protected String mechIterationCountIsTooHigh$str() {
        return mechIterationCountIsTooHigh;
    }
    @Override
    public final AuthenticationMechanismException mechIterationCountIsTooHigh(final int iterationCount, final int maximumIterationCount) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechIterationCountIsTooHigh$str(), iterationCount, maximumIterationCount));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidServerMessage = "ELY05043: Invalid server message";
    protected String mechInvalidServerMessage$str() {
        return mechInvalidServerMessage;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidServerMessage() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidServerMessage$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidServerMessageWithCause = "ELY05044: Invalid server message";
    protected String mechInvalidServerMessageWithCause$str() {
        return mechInvalidServerMessageWithCause;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidServerMessageWithCause(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidServerMessageWithCause$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidClientMessage = "ELY05045: Invalid client message";
    protected String mechInvalidClientMessage$str() {
        return mechInvalidClientMessage;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidClientMessage() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidClientMessage$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidClientMessageWithCause = "ELY05046: Invalid client message";
    protected String mechInvalidClientMessageWithCause$str() {
        return mechInvalidClientMessageWithCause;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidClientMessageWithCause(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidClientMessageWithCause$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnmatchedMechanism = "ELY05047: [%s] Authentication mechanism message is for mismatched mechanism \"%s\"";
    protected String mechUnmatchedMechanism$str() {
        return mechUnmatchedMechanism;
    }
    @Override
    public final AuthenticationMechanismException mechUnmatchedMechanism(final String mechName, final String otherMechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnmatchedMechanism$str(), mechName, otherMechName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechServerAuthenticityCannotBeVerified = "ELY05049: Server authenticity cannot be verified";
    protected String mechServerAuthenticityCannotBeVerified$str() {
        return mechServerAuthenticityCannotBeVerified;
    }
    @Override
    public final AuthenticationMechanismException mechServerAuthenticityCannotBeVerified() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechServerAuthenticityCannotBeVerified$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechCallbackHandlerDoesNotSupportUserName = "ELY05050: Callback handler does not support user name";
    protected String mechCallbackHandlerDoesNotSupportUserName$str() {
        return mechCallbackHandlerDoesNotSupportUserName;
    }
    @Override
    public final AuthenticationMechanismException mechCallbackHandlerDoesNotSupportUserName(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechCallbackHandlerDoesNotSupportUserName$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechCallbackHandlerDoesNotSupportCredentialAcquisition = "ELY05051: Callback handler does not support credential acquisition";
    protected String mechCallbackHandlerDoesNotSupportCredentialAcquisition$str() {
        return mechCallbackHandlerDoesNotSupportCredentialAcquisition;
    }
    @Override
    public final AuthenticationMechanismException mechCallbackHandlerDoesNotSupportCredentialAcquisition(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechCallbackHandlerDoesNotSupportCredentialAcquisition$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechAuthorizationUnsupported = "ELY05052: Callback handler does not support authorization";
    protected String mechAuthorizationUnsupported$str() {
        return mechAuthorizationUnsupported;
    }
    @Override
    public final AuthenticationMechanismException mechAuthorizationUnsupported(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechAuthorizationUnsupported$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechCallbackHandlerFailedForUnknownReason = "ELY05053: Callback handler failed for unknown reason";
    protected String mechCallbackHandlerFailedForUnknownReason$str() {
        return mechCallbackHandlerFailedForUnknownReason;
    }
    @Override
    public final AuthenticationMechanismException mechCallbackHandlerFailedForUnknownReason(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechCallbackHandlerFailedForUnknownReason$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechAuthenticationRejectedInvalidProof = "ELY05055: Authentication rejected (invalid proof)";
    protected String mechAuthenticationRejectedInvalidProof$str() {
        return mechAuthenticationRejectedInvalidProof;
    }
    @Override
    public final AuthenticationMechanismException mechAuthenticationRejectedInvalidProof() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechAuthenticationRejectedInvalidProof$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechClientSentExtraMessage = "ELY05056: Client sent extra message";
    protected String mechClientSentExtraMessage$str() {
        return mechClientSentExtraMessage;
    }
    @Override
    public final AuthenticationMechanismException mechClientSentExtraMessage() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechClientSentExtraMessage$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechServerSentExtraMessage = "ELY05057: Server sent extra message";
    protected String mechServerSentExtraMessage$str() {
        return mechServerSentExtraMessage;
    }
    @Override
    public final AuthenticationMechanismException mechServerSentExtraMessage() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechServerSentExtraMessage$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechAuthenticationFailed = "ELY05058: Authentication failed";
    protected String mechAuthenticationFailed$str() {
        return mechAuthenticationFailed;
    }
    @Override
    public final AuthenticationMechanismException mechAuthenticationFailed() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechAuthenticationFailed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String emptyNumber = "ELY05060: Empty number";
    protected String emptyNumber$str() {
        return emptyNumber;
    }
    @Override
    public final NumberFormatException emptyNumber() {
        final NumberFormatException result = new NumberFormatException(String.format(getLoggingLocale(), emptyNumber$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidNumericCharacter = "ELY05061: Invalid numeric character";
    protected String invalidNumericCharacter$str() {
        return invalidNumericCharacter;
    }
    @Override
    public final NumberFormatException invalidNumericCharacter() {
        final NumberFormatException result = new NumberFormatException(String.format(getLoggingLocale(), invalidNumericCharacter$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tooBigNumber = "ELY05062: Too big number";
    protected String tooBigNumber$str() {
        return tooBigNumber;
    }
    @Override
    public final NumberFormatException tooBigNumber() {
        final NumberFormatException result = new NumberFormatException(String.format(getLoggingLocale(), tooBigNumber$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechCannotGetTwoWayPasswordChars = "ELY05063: Cannot get clear password from two way password";
    protected String mechCannotGetTwoWayPasswordChars$str() {
        return mechCannotGetTwoWayPasswordChars;
    }
    @Override
    public final AuthenticationMechanismException mechCannotGetTwoWayPasswordChars(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechCannotGetTwoWayPasswordChars$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechMacAlgorithmNotSupported = "ELY05064: Hashing algorithm not supported";
    protected String mechMacAlgorithmNotSupported$str() {
        return mechMacAlgorithmNotSupported;
    }
    @Override
    public final AuthenticationMechanismException mechMacAlgorithmNotSupported(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechMacAlgorithmNotSupported$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechKeywordCannotBeEmpty = "ELY05065: keyword cannot be empty";
    protected String mechKeywordCannotBeEmpty$str() {
        return mechKeywordCannotBeEmpty;
    }
    @Override
    public final AuthenticationMechanismException mechKeywordCannotBeEmpty() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechKeywordCannotBeEmpty$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechNoValueFoundForKeyword = "ELY05066: No value found for keyword: %s";
    protected String mechNoValueFoundForKeyword$str() {
        return mechNoValueFoundForKeyword;
    }
    @Override
    public final AuthenticationMechanismException mechNoValueFoundForKeyword(final String keyword) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechNoValueFoundForKeyword$str(), keyword));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechKeywordNotFollowedByEqual = "ELY05067: '=' expected after keyword: %s";
    protected String mechKeywordNotFollowedByEqual$str() {
        return mechKeywordNotFollowedByEqual;
    }
    @Override
    public final AuthenticationMechanismException mechKeywordNotFollowedByEqual(final String keyword) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechKeywordNotFollowedByEqual$str(), keyword));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnmatchedQuoteFoundForValue = "ELY05068: Unmatched quote found for value: %s";
    protected String mechUnmatchedQuoteFoundForValue$str() {
        return mechUnmatchedQuoteFoundForValue;
    }
    @Override
    public final AuthenticationMechanismException mechUnmatchedQuoteFoundForValue(final String value) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnmatchedQuoteFoundForValue$str(), value));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechExpectingCommaOrLinearWhitespaceAfterQuoted = "ELY05069: Expecting comma or linear whitespace after quoted string: %s";
    protected String mechExpectingCommaOrLinearWhitespaceAfterQuoted$str() {
        return mechExpectingCommaOrLinearWhitespaceAfterQuoted;
    }
    @Override
    public final AuthenticationMechanismException mechExpectingCommaOrLinearWhitespaceAfterQuoted(final String value) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechExpectingCommaOrLinearWhitespaceAfterQuoted$str(), value));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechMessageTypeMustEqual = "ELY05070: MessageType must equal to %d, but it is %d";
    protected String mechMessageTypeMustEqual$str() {
        return mechMessageTypeMustEqual;
    }
    @Override
    public final AuthenticationMechanismException mechMessageTypeMustEqual(final int expected, final int actual) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechMessageTypeMustEqual$str(), expected, actual));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechBadSequenceNumberWhileUnwrapping = "ELY05071: Bad sequence number while unwrapping: expected %d, but %d received";
    protected String mechBadSequenceNumberWhileUnwrapping$str() {
        return mechBadSequenceNumberWhileUnwrapping;
    }
    @Override
    public final AuthenticationMechanismException mechBadSequenceNumberWhileUnwrapping(final int expected, final int actual) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechBadSequenceNumberWhileUnwrapping$str(), expected, actual));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechProblemDuringCrypt = "ELY05072: Problem during crypt";
    protected String mechProblemDuringCrypt$str() {
        return mechProblemDuringCrypt;
    }
    @Override
    public final AuthenticationMechanismException mechProblemDuringCrypt(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechProblemDuringCrypt$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechProblemDuringDecrypt = "ELY05073: Problem during decrypt";
    protected String mechProblemDuringDecrypt$str() {
        return mechProblemDuringDecrypt;
    }
    @Override
    public final AuthenticationMechanismException mechProblemDuringDecrypt(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechProblemDuringDecrypt$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnknownCipher = "ELY05074: Unknown cipher \"%s\"";
    protected String mechUnknownCipher$str() {
        return mechUnknownCipher;
    }
    @Override
    public final AuthenticationMechanismException mechUnknownCipher(final String cipher) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnknownCipher$str(), cipher));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechAuthorizationIdChanged = "ELY05075: Authorization ID changed unexpectedly";
    protected String mechAuthorizationIdChanged$str() {
        return mechAuthorizationIdChanged;
    }
    @Override
    public final AuthenticationMechanismException mechAuthorizationIdChanged() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechAuthorizationIdChanged$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechProblemGettingRequiredCipher = "ELY05076: Problem getting required cipher. Check your transformation mapper settings.";
    protected String mechProblemGettingRequiredCipher$str() {
        return mechProblemGettingRequiredCipher;
    }
    @Override
    public final AuthenticationMechanismException mechProblemGettingRequiredCipher(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechProblemGettingRequiredCipher$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechNoCommonProtectionLayer = "ELY05077: No common protection layer between client and server";
    protected String mechNoCommonProtectionLayer$str() {
        return mechNoCommonProtectionLayer;
    }
    @Override
    public final AuthenticationMechanismException mechNoCommonProtectionLayer() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechNoCommonProtectionLayer$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechNoCommonCipher = "ELY05078: No common cipher between client and server";
    protected String mechNoCommonCipher$str() {
        return mechNoCommonCipher;
    }
    @Override
    public final AuthenticationMechanismException mechNoCommonCipher() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechNoCommonCipher$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechNoCiphersOfferedByServer = "ELY05079: No ciphers offered by server";
    protected String mechNoCiphersOfferedByServer$str() {
        return mechNoCiphersOfferedByServer;
    }
    @Override
    public final AuthenticationMechanismException mechNoCiphersOfferedByServer() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechNoCiphersOfferedByServer$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechNotProvidedUserName = "ELY05080: Callback handler not provided user name";
    protected String mechNotProvidedUserName$str() {
        return mechNotProvidedUserName;
    }
    @Override
    public final AuthenticationMechanismException mechNotProvidedUserName() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechNotProvidedUserName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechMissingDirective = "ELY05083: Missing \"%s\" directive";
    protected String mechMissingDirective$str() {
        return mechMissingDirective;
    }
    @Override
    public final AuthenticationMechanismException mechMissingDirective(final String directive) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechMissingDirective$str(), directive));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechNonceCountMustEqual = "ELY05084: nonce-count must equal to %d, but it is %d";
    protected String mechNonceCountMustEqual$str() {
        return mechNonceCountMustEqual;
    }
    @Override
    public final AuthenticationMechanismException mechNonceCountMustEqual(final int expected, final int actual) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechNonceCountMustEqual$str(), expected, actual));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnsupportedCharset = "ELY05085: Server is set to not support %s charset";
    protected String mechUnsupportedCharset$str() {
        return mechUnsupportedCharset;
    }
    @Override
    public final AuthenticationMechanismException mechUnsupportedCharset(final String charset) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnsupportedCharset$str(), charset));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnknownCharset = "ELY05086: Charset can be only \"utf-8\" or unspecified (to use ISO 8859-1)";
    protected String mechUnknownCharset$str() {
        return mechUnknownCharset;
    }
    @Override
    public final AuthenticationMechanismException mechUnknownCharset() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnknownCharset$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechDisallowedClientRealm = "ELY05087: Client selected realm not offered by server (%s)";
    protected String mechDisallowedClientRealm$str() {
        return mechDisallowedClientRealm;
    }
    @Override
    public final AuthenticationMechanismException mechDisallowedClientRealm(final String clientRealm) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechDisallowedClientRealm$str(), clientRealm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechMismatchedWrongDigestUri = "ELY05088: digest-uri \"%s\" not accepted";
    protected String mechMismatchedWrongDigestUri$str() {
        return mechMismatchedWrongDigestUri;
    }
    @Override
    public final AuthenticationMechanismException mechMismatchedWrongDigestUri(final String actual) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechMismatchedWrongDigestUri$str(), actual));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnexpectedQop = "ELY05089: Unexpected qop value: \"%s\"";
    protected String mechUnexpectedQop$str() {
        return mechUnexpectedQop;
    }
    @Override
    public final AuthenticationMechanismException mechUnexpectedQop(final String qop) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnexpectedQop$str(), qop));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String wrappingNotConfigured = "ELY05090: Wrapping is not configured";
    protected String wrappingNotConfigured$str() {
        return wrappingNotConfigured;
    }
    @Override
    public final IllegalStateException wrappingNotConfigured() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), wrappingNotConfigured$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechAuthenticationNameTooLong = "ELY05091: Authentication name string is too long";
    protected String mechAuthenticationNameTooLong$str() {
        return mechAuthenticationNameTooLong;
    }
    @Override
    public final AuthenticationMechanismException mechAuthenticationNameTooLong() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechAuthenticationNameTooLong$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechAuthenticationNameIsEmpty = "ELY05092: Authentication name is empty";
    protected String mechAuthenticationNameIsEmpty$str() {
        return mechAuthenticationNameIsEmpty;
    }
    @Override
    public final AuthenticationMechanismException mechAuthenticationNameIsEmpty() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechAuthenticationNameIsEmpty$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechAnonymousAuthorizationDenied = "ELY05093: Authorization for anonymous access is denied";
    protected String mechAnonymousAuthorizationDenied$str() {
        return mechAnonymousAuthorizationDenied;
    }
    @Override
    public final AuthenticationMechanismException mechAnonymousAuthorizationDenied() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechAnonymousAuthorizationDenied$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String requiredNegativePadding = "ELY05094: Required padded length (%d) is less than length of conversion result (%d)";
    protected String requiredNegativePadding$str() {
        return requiredNegativePadding;
    }
    @Override
    public final IllegalArgumentException requiredNegativePadding(final int totalLength, final int hexLength) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), requiredNegativePadding$str(), totalLength, hexLength));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidKeyForDigestHMAC = "ELY05095: Invalid key provided for Digest HMAC computing";
    protected String mechInvalidKeyForDigestHMAC$str() {
        return mechInvalidKeyForDigestHMAC;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidKeyForDigestHMAC() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidKeyForDigestHMAC$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToDetermineSubjectName = "ELY05097: Unable to determine subject name from X.509 certificate";
    protected String unableToDetermineSubjectName$str() {
        return unableToDetermineSubjectName;
    }
    @Override
    public final IllegalStateException unableToDetermineSubjectName(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unableToDetermineSubjectName$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToVerifyClientSignature = "ELY05098: Unable to verify client signature";
    protected String mechUnableToVerifyClientSignature$str() {
        return mechUnableToVerifyClientSignature;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToVerifyClientSignature(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToVerifyClientSignature$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToVerifyServerSignature = "ELY05099: Unable to verify server signature";
    protected String mechUnableToVerifyServerSignature$str() {
        return mechUnableToVerifyServerSignature;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToVerifyServerSignature(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToVerifyServerSignature$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechCallbackHandlerNotProvidedServerCertificate = "ELY05101: Callback handler not provided server certificate";
    protected String mechCallbackHandlerNotProvidedServerCertificate$str() {
        return mechCallbackHandlerNotProvidedServerCertificate;
    }
    @Override
    public final AuthenticationMechanismException mechCallbackHandlerNotProvidedServerCertificate() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechCallbackHandlerNotProvidedServerCertificate$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechCallbackHandlerNotProvidedClientCertificate = "ELY05102: Callback handler not provided client certificate";
    protected String mechCallbackHandlerNotProvidedClientCertificate$str() {
        return mechCallbackHandlerNotProvidedClientCertificate;
    }
    @Override
    public final AuthenticationMechanismException mechCallbackHandlerNotProvidedClientCertificate() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechCallbackHandlerNotProvidedClientCertificate$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechServerIdentifierMismatch = "ELY05103: Server identifier mismatch";
    protected String mechServerIdentifierMismatch$str() {
        return mechServerIdentifierMismatch;
    }
    @Override
    public final AuthenticationMechanismException mechServerIdentifierMismatch() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechServerIdentifierMismatch$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechClientIdentifierMismatch = "ELY05104: Client identifier mismatch";
    protected String mechClientIdentifierMismatch$str() {
        return mechClientIdentifierMismatch;
    }
    @Override
    public final AuthenticationMechanismException mechClientIdentifierMismatch() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechClientIdentifierMismatch$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToDetermineClientName = "ELY05105: Unable to determine client name";
    protected String mechUnableToDetermineClientName$str() {
        return mechUnableToDetermineClientName;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToDetermineClientName(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToDetermineClientName$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechCallbackHandlerNotProvidedPrivateKey = "ELY05106: Callback handler not provided private key";
    protected String mechCallbackHandlerNotProvidedPrivateKey$str() {
        return mechCallbackHandlerNotProvidedPrivateKey;
    }
    @Override
    public final AuthenticationMechanismException mechCallbackHandlerNotProvidedPrivateKey() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechCallbackHandlerNotProvidedPrivateKey$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToCreateSignature = "ELY05107: Unable to create signature";
    protected String mechUnableToCreateSignature$str() {
        return mechUnableToCreateSignature;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToCreateSignature(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToCreateSignature$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToCreateResponseToken = "ELY05108: Unable to create response token";
    protected String mechUnableToCreateResponseToken$str() {
        return mechUnableToCreateResponseToken;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToCreateResponseToken(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToCreateResponseToken$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToCreateResponseTokenWithCause = "ELY05109: Unable to create response token";
    protected String mechUnableToCreateResponseTokenWithCause$str() {
        return mechUnableToCreateResponseTokenWithCause;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToCreateResponseTokenWithCause(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToCreateResponseTokenWithCause$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechGettingSupportedMechanismsFailed = "ELY05112: Getting authentication mechanisms supported by GSS-API failed";
    protected String mechGettingSupportedMechanismsFailed$str() {
        return mechGettingSupportedMechanismsFailed;
    }
    @Override
    public final AuthenticationMechanismException mechGettingSupportedMechanismsFailed(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechGettingSupportedMechanismsFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToInitialiseOid = "ELY05113: Unable to initialize OID of Kerberos V5";
    protected String unableToInitialiseOid$str() {
        return unableToInitialiseOid;
    }
    @Override
    public final RuntimeException unableToInitialiseOid(final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), unableToInitialiseOid$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechReceiveBufferIsGreaterThanMaximum = "ELY05114: Receive buffer requested '%d' is greater than supported maximum '%d'";
    protected String mechReceiveBufferIsGreaterThanMaximum$str() {
        return mechReceiveBufferIsGreaterThanMaximum;
    }
    @Override
    public final AuthenticationMechanismException mechReceiveBufferIsGreaterThanMaximum(final int requested, final int maximum) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechReceiveBufferIsGreaterThanMaximum$str(), requested, maximum));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToWrapMessage = "ELY05115: Unable to wrap message";
    protected String mechUnableToWrapMessage$str() {
        return mechUnableToWrapMessage;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToWrapMessage(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToWrapMessage$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToUnwrapMessage = "ELY05116: Unable to unwrap message";
    protected String mechUnableToUnwrapMessage$str() {
        return mechUnableToUnwrapMessage;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToUnwrapMessage(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToUnwrapMessage$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToUnwrapSecurityLayerNegotiationMessage = "ELY05117: Unable to unwrap security layer negotiation message";
    protected String mechUnableToUnwrapSecurityLayerNegotiationMessage$str() {
        return mechUnableToUnwrapSecurityLayerNegotiationMessage;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToUnwrapSecurityLayerNegotiationMessage(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToUnwrapSecurityLayerNegotiationMessage$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidMessageOnUnwrapping = "ELY05118: Invalid message of length %d on unwrapping";
    protected String mechInvalidMessageOnUnwrapping$str() {
        return mechInvalidMessageOnUnwrapping;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidMessageOnUnwrapping(final int length) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidMessageOnUnwrapping$str(), length));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechNegotiatedMechanismWasNotKerberosV5 = "ELY05119: Negotiated mechanism was not Kerberos V5";
    protected String mechNegotiatedMechanismWasNotKerberosV5$str() {
        return mechNegotiatedMechanismWasNotKerberosV5;
    }
    @Override
    public final AuthenticationMechanismException mechNegotiatedMechanismWasNotKerberosV5() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechNegotiatedMechanismWasNotKerberosV5$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInsufficientQopsAvailable = "ELY05120: Insufficient levels of protection available for supported security layers";
    protected String mechInsufficientQopsAvailable$str() {
        return mechInsufficientQopsAvailable;
    }
    @Override
    public final AuthenticationMechanismException mechInsufficientQopsAvailable() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInsufficientQopsAvailable$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToGenerateChallenge = "ELY05121: Unable to generate security layer challenge";
    protected String mechUnableToGenerateChallenge$str() {
        return mechUnableToGenerateChallenge;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToGenerateChallenge(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToGenerateChallenge$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechSelectedUnofferedQop = "ELY05122: Client selected a security layer that was not offered by server";
    protected String mechSelectedUnofferedQop$str() {
        return mechSelectedUnofferedQop;
    }
    @Override
    public final AuthenticationMechanismException mechSelectedUnofferedQop() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechSelectedUnofferedQop$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechNoSecurityLayerButLengthReceived = "ELY05123: No security layer selected but message length received";
    protected String mechNoSecurityLayerButLengthReceived$str() {
        return mechNoSecurityLayerButLengthReceived;
    }
    @Override
    public final AuthenticationMechanismException mechNoSecurityLayerButLengthReceived() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechNoSecurityLayerButLengthReceived$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToGetMaximumSizeOfMessage = "ELY05124: Unable to get maximum size of message before wrap";
    protected String mechUnableToGetMaximumSizeOfMessage$str() {
        return mechUnableToGetMaximumSizeOfMessage;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToGetMaximumSizeOfMessage(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToGetMaximumSizeOfMessage$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToHandleResponseFromServer = "ELY05125: Unable to handle response from server";
    protected String mechUnableToHandleResponseFromServer$str() {
        return mechUnableToHandleResponseFromServer;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToHandleResponseFromServer(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToHandleResponseFromServer$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechBadLengthOfMessageForNegotiatingSecurityLayer = "ELY05126: Bad length of message for negotiating security layer";
    protected String mechBadLengthOfMessageForNegotiatingSecurityLayer$str() {
        return mechBadLengthOfMessageForNegotiatingSecurityLayer;
    }
    @Override
    public final AuthenticationMechanismException mechBadLengthOfMessageForNegotiatingSecurityLayer() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechBadLengthOfMessageForNegotiatingSecurityLayer$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechReceivedMaxMessageSizeWhenNoSecurityLayer = "ELY05127: No security layer supported by server but maximum message size received: \"%d\"";
    protected String mechReceivedMaxMessageSizeWhenNoSecurityLayer$str() {
        return mechReceivedMaxMessageSizeWhenNoSecurityLayer;
    }
    @Override
    public final AuthenticationMechanismException mechReceivedMaxMessageSizeWhenNoSecurityLayer(final int length) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechReceivedMaxMessageSizeWhenNoSecurityLayer$str(), length));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechFailedToReadChallengeFile = "ELY05128: Failed to read challenge file";
    protected String mechFailedToReadChallengeFile$str() {
        return mechFailedToReadChallengeFile;
    }
    @Override
    public final AuthenticationMechanismException mechFailedToReadChallengeFile(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechFailedToReadChallengeFile$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechFailedToCreateChallengeFile = "ELY05129: Failed to create challenge file";
    protected String mechFailedToCreateChallengeFile$str() {
        return mechFailedToCreateChallengeFile;
    }
    @Override
    public final AuthenticationMechanismException mechFailedToCreateChallengeFile(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechFailedToCreateChallengeFile$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechAuthorizationIdTooLong = "ELY05150: Authentication mechanism authorization ID is too long";
    protected String mechAuthorizationIdTooLong$str() {
        return mechAuthorizationIdTooLong;
    }
    @Override
    public final AuthenticationMechanismException mechAuthorizationIdTooLong() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechAuthorizationIdTooLong$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidOTPAlgorithm = "ELY05151: Invalid OTP algorithm \"%s\"";
    protected String mechInvalidOTPAlgorithm$str() {
        return mechInvalidOTPAlgorithm;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidOTPAlgorithm(final String algorithm) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidOTPAlgorithm$str(), algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidOTPResponseType = "ELY05152: Invalid OTP response type";
    protected String mechInvalidOTPResponseType$str() {
        return mechInvalidOTPResponseType;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidOTPResponseType() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidOTPResponseType$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechIncorrectParity = "ELY05153: Incorrect parity in SASL client message";
    protected String mechIncorrectParity$str() {
        return mechIncorrectParity;
    }
    @Override
    public final AuthenticationMechanismException mechIncorrectParity() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechIncorrectParity$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidCharacterInSeed = "ELY05154: Invalid character in seed";
    protected String mechInvalidCharacterInSeed$str() {
        return mechInvalidCharacterInSeed;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidCharacterInSeed() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidCharacterInSeed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidOTPSeed = "ELY05155: Invalid OTP seed, must be between 1 and 16 characters long";
    protected String mechInvalidOTPSeed$str() {
        return mechInvalidOTPSeed;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidOTPSeed() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidOTPSeed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidOTPPassPhrase = "ELY05156: Invalid OTP pass phrase, must be between 10 and 63 characters long";
    protected String mechInvalidOTPPassPhrase$str() {
        return mechInvalidOTPPassPhrase;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidOTPPassPhrase() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidOTPPassPhrase$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidOTPSequenceNumber = "ELY05157: Invalid OTP sequence number";
    protected String mechInvalidOTPSequenceNumber$str() {
        return mechInvalidOTPSequenceNumber;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidOTPSequenceNumber() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidOTPSequenceNumber$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidOTP = "ELY05158: Invalid OTP";
    protected String mechInvalidOTP$str() {
        return mechInvalidOTP;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidOTP() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidOTP$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechOTPPassPhraseAndSeedMustNotMatch = "ELY05159: OTP pass phrase and seed must not match";
    protected String mechOTPPassPhraseAndSeedMustNotMatch$str() {
        return mechOTPPassPhraseAndSeedMustNotMatch;
    }
    @Override
    public final AuthenticationMechanismException mechOTPPassPhraseAndSeedMustNotMatch() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechOTPPassPhraseAndSeedMustNotMatch$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidOTPAlternateDictionary = "ELY05160: Invalid OTP alternate dictionary";
    protected String mechInvalidOTPAlternateDictionary$str() {
        return mechInvalidOTPAlternateDictionary;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidOTPAlternateDictionary() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidOTPAlternateDictionary$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToRetrievePassword = "ELY05161: Unable to retrieve password for \"%s\"";
    protected String mechUnableToRetrievePassword$str() {
        return mechUnableToRetrievePassword;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToRetrievePassword(final String userName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToRetrievePassword$str(), userName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToUpdatePassword = "ELY05162: Unable to update password for \"%s\"";
    protected String mechUnableToUpdatePassword$str() {
        return mechUnableToUpdatePassword;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToUpdatePassword(final String userName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToUpdatePassword$str(), userName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechServerTimedOut = "ELY05163: Authentication mechanism server timed out";
    protected String mechServerTimedOut$str() {
        return mechServerTimedOut;
    }
    @Override
    public final AuthenticationMechanismException mechServerTimedOut() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechServerTimedOut$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToObtainExclusiveAccess = "ELY05164: Unable to obtain exclusive access for \"%s\"";
    protected String mechUnableToObtainExclusiveAccess$str() {
        return mechUnableToObtainExclusiveAccess;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToObtainExclusiveAccess(final String userName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToObtainExclusiveAccess$str(), userName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechOTPReinitializationFailed = "ELY05165: OTP re-initialization failed";
    protected String mechOTPReinitializationFailed$str() {
        return mechOTPReinitializationFailed;
    }
    @Override
    public final AuthenticationMechanismException mechOTPReinitializationFailed(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechOTPReinitializationFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String scramServerRejectedAuthentication = "ELY05166: Server rejected authentication";
    protected String scramServerRejectedAuthentication$str() {
        return scramServerRejectedAuthentication;
    }
    @Override
    public final ScramServerException scramServerRejectedAuthentication(final ScramServerErrorCode errorCode) {
        final ScramServerException result = new ScramServerException(String.format(getLoggingLocale(), scramServerRejectedAuthentication$str()), errorCode);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechInvalidOTPPasswordFormatType = "ELY05167: Invalid OTP password format type";
    protected String mechInvalidOTPPasswordFormatType$str() {
        return mechInvalidOTPPasswordFormatType;
    }
    @Override
    public final AuthenticationMechanismException mechInvalidOTPPasswordFormatType() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidOTPPasswordFormatType$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnsupportedAlgorithm = "ELY05168: Unsupported algorithm selected \"%s\"";
    protected String mechUnsupportedAlgorithm$str() {
        return mechUnsupportedAlgorithm;
    }
    @Override
    public final AuthenticationMechanismException mechUnsupportedAlgorithm(final String algorithm) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnsupportedAlgorithm$str(), algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechResponseTokenMismatch = "ELY05169: [%s] Clients response token does not match expected token";
    protected String mechResponseTokenMismatch$str() {
        return mechResponseTokenMismatch;
    }
    @Override
    public final String mechResponseTokenMismatch(final String mechName) {
        return String.format(getLoggingLocale(), mechResponseTokenMismatch$str(), mechName);
    }
    private static final String mechProblemDuringCryptResultIsNull = "ELY05170: Problem during crypt: The encrypted result is null. The input data has a length of zero or too short to result in a new block.";
    protected String mechProblemDuringCryptResultIsNull$str() {
        return mechProblemDuringCryptResultIsNull;
    }
    @Override
    public final AuthenticationMechanismException mechProblemDuringCryptResultIsNull() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechProblemDuringCryptResultIsNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechProblemDuringDecryptResultIsNull = "ELY05171: Problem during decrypt: The decrypted result is null. The input data has a length of zero or too short to result in a new block.";
    protected String mechProblemDuringDecryptResultIsNull$str() {
        return mechProblemDuringDecryptResultIsNull;
    }
    @Override
    public final AuthenticationMechanismException mechProblemDuringDecryptResultIsNull() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechProblemDuringDecryptResultIsNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToObtainServerCredential = "ELY05173: Unable to obtain server credential.";
    protected String unableToObtainServerCredential$str() {
        return unableToObtainServerCredential;
    }
    @Override
    public final AuthenticationMechanismException unableToObtainServerCredential() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), unableToObtainServerCredential$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechNotChosenRealm = "ELY05174: Callback handler has not chosen realm";
    protected String mechNotChosenRealm$str() {
        return mechNotChosenRealm;
    }
    @Override
    public final AuthenticationMechanismException mechNotChosenRealm() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechNotChosenRealm$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechUnableToDetermineBoundServerName = "ELY05175: Unable to determine bound server name";
    protected String mechUnableToDetermineBoundServerName$str() {
        return mechUnableToDetermineBoundServerName;
    }
    @Override
    public final AuthenticationMechanismException mechUnableToDetermineBoundServerName(final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToDetermineBoundServerName$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechCallbackHandlerUnsupportedCallback = "ELY05176: Unsupported callback";
    protected String mechCallbackHandlerUnsupportedCallback$str() {
        return mechCallbackHandlerUnsupportedCallback;
    }
    @Override
    public final AuthenticationMechanismException mechCallbackHandlerUnsupportedCallback(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechCallbackHandlerUnsupportedCallback$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechOneOfDirectivesHasToBeDefined = "ELY05177: One of \"%s\" and \"%s\" directives has to be defined";
    protected String mechOneOfDirectivesHasToBeDefined$str() {
        return mechOneOfDirectivesHasToBeDefined;
    }
    @Override
    public final AuthenticationMechanismException mechOneOfDirectivesHasToBeDefined(final String directive1, final String directive2) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechOneOfDirectivesHasToBeDefined$str(), directive1, directive2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String incorrectlyFormattedHeader = "ELY06001: An incorrectly formatted '%s'header was encountered.";
    protected String incorrectlyFormattedHeader$str() {
        return incorrectlyFormattedHeader;
    }
    @Override
    public final String incorrectlyFormattedHeader(final String headerName) {
        return String.format(getLoggingLocale(), incorrectlyFormattedHeader$str(), headerName);
    }
    private static final String authenticationFailed2 = "ELY06002: An authentication attempt for user '%s' failed validation using mechanism '%s'.";
    protected String authenticationFailed2$str() {
        return authenticationFailed2;
    }
    @Override
    public final String authenticationFailed(final String username, final String mechanismName) {
        return String.format(getLoggingLocale(), authenticationFailed2$str(), username, mechanismName);
    }
    private static final String authenticationFailed0 = "ELY06003: An authentication attempt failed validation.";
    protected String authenticationFailed0$str() {
        return authenticationFailed0;
    }
    @Override
    public final String authenticationFailed() {
        return String.format(getLoggingLocale(), authenticationFailed0$str());
    }
    private static final String authorizationFailed = "ELY06006: An authorization check for user '%s' failed.";
    protected String authorizationFailed$str() {
        return authorizationFailed;
    }
    @Override
    public final String authorizationFailed(final String username) {
        return String.format(getLoggingLocale(), authorizationFailed$str(), username);
    }
    private static final String usernameOrPasswordMissing = "ELY06007: Username or password missing from authentication attempt.";
    protected String usernameOrPasswordMissing$str() {
        return usernameOrPasswordMissing;
    }
    @Override
    public final String usernameOrPasswordMissing() {
        return String.format(getLoggingLocale(), usernameOrPasswordMissing$str());
    }
    private static final String digestMechanismRequireRealm = "ELY06015: Unable to authenticate using DIGEST mechanism - realm name needs to be specified";
    protected String digestMechanismRequireRealm$str() {
        return digestMechanismRequireRealm;
    }
    @Override
    public final HttpAuthenticationException digestMechanismRequireRealm() {
        final HttpAuthenticationException result = new HttpAuthenticationException(String.format(getLoggingLocale(), digestMechanismRequireRealm$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String digestMechanismInvalidRealm = "ELY06019: Unable to authenticate using DIGEST mechanism - mechanism realm name (%s) is not valid";
    protected String digestMechanismInvalidRealm$str() {
        return digestMechanismInvalidRealm;
    }
    @Override
    public final HttpAuthenticationException digestMechanismInvalidRealm(final String realm) {
        final HttpAuthenticationException result = new HttpAuthenticationException(String.format(getLoggingLocale(), digestMechanismInvalidRealm$str(), realm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsuitableScope = "ELY06020: Scope unsuitable for use with authentication state '%s'";
    protected String unsuitableScope$str() {
        return unsuitableScope;
    }
    @Override
    public final IllegalArgumentException unsuitableScope(final String scopeName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unsuitableScope$str(), scopeName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToIdentifyHttpScope = "ELY06021: Unable to identify suitable HttpScope for mechanism state storage";
    protected String unableToIdentifyHttpScope$str() {
        return unableToIdentifyHttpScope;
    }
    @Override
    public final IllegalArgumentException unableToIdentifyHttpScope() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unableToIdentifyHttpScope$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidNonceCount = "ELY06022: Invalid nonce count %s";
    protected String invalidNonceCount$str() {
        return invalidNonceCount;
    }
    @Override
    public final HttpAuthenticationException invalidNonceCount(final int nonceCount) {
        final HttpAuthenticationException result = new HttpAuthenticationException(String.format(getLoggingLocale(), invalidNonceCount$str(), nonceCount));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnUnrecognisedAlgorithm = "ELY07001: Unrecognized encoding algorithm [%s]";
    protected String asnUnrecognisedAlgorithm$str() {
        return asnUnrecognisedAlgorithm;
    }
    @Override
    public final ASN1Exception asnUnrecognisedAlgorithm(final String algorithm) {
        final ASN1Exception result = new ASN1Exception(String.format(getLoggingLocale(), asnUnrecognisedAlgorithm$str(), algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnInvalidGeneralNameType = "ELY07002: Invalid general name type";
    protected String asnInvalidGeneralNameType$str() {
        return asnInvalidGeneralNameType;
    }
    @Override
    public final ASN1Exception asnInvalidGeneralNameType() {
        final ASN1Exception result = new ASN1Exception(String.format(getLoggingLocale(), asnInvalidGeneralNameType$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnUnexpectedTag = "ELY07004: Unexpected ASN.1 tag encountered";
    protected String asnUnexpectedTag$str() {
        return asnUnexpectedTag;
    }
    @Override
    public final ASN1Exception asnUnexpectedTag() {
        final ASN1Exception result = new ASN1Exception(String.format(getLoggingLocale(), asnUnexpectedTag$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
