package org.wildfly.security.util;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.security.GeneralSecurityException;
import java.lang.String;
import java.io.IOException;
import org.jboss.logging.Logger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-03-22T11:52:51+0000")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String generalInvalidName = "ELY00009: Invalid name \"%s\"";
    protected String generalInvalidName$str() {
        return generalInvalidName;
    }
    @Override
    public final IllegalArgumentException generalInvalidName(final String str) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), generalInvalidName$str(), str));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String iterationCountNotSpecified = "ELY03025: Iteration count not specified for password based encryption";
    protected String iterationCountNotSpecified$str() {
        return iterationCountNotSpecified;
    }
    @Override
    public final IllegalArgumentException iterationCountNotSpecified() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), iterationCountNotSpecified$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String saltNotSpecified = "ELY03026: Salt not specified for password based encryption";
    protected String saltNotSpecified$str() {
        return saltNotSpecified;
    }
    @Override
    public final IllegalArgumentException saltNotSpecified() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), saltNotSpecified$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String initialKeyNotSpecified = "ELY03027: Initial key not specified for password based encryption";
    protected String initialKeyNotSpecified$str() {
        return initialKeyNotSpecified;
    }
    @Override
    public final IllegalArgumentException initialKeyNotSpecified() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), initialKeyNotSpecified$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String securityProviderDoesnExist = "ELY03028: Security provider \"%s\" doesn't exist";
    protected String securityProviderDoesnExist$str() {
        return securityProviderDoesnExist;
    }
    @Override
    public final IllegalArgumentException securityProviderDoesnExist(final String providerName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), securityProviderDoesnExist$str(), providerName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSuchKeyAlgorithm = "ELY03029: No such key algorithm \"%s\"";
    protected String noSuchKeyAlgorithm$str() {
        return noSuchKeyAlgorithm;
    }
    @Override
    public final IllegalArgumentException noSuchKeyAlgorithm(final String algorithmName, final GeneralSecurityException cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noSuchKeyAlgorithm$str(), algorithmName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String closed = "ELY03030: I/O operation failed: closed";
    protected String closed$str() {
        return closed;
    }
    @Override
    public final IOException closed() {
        final IOException result = new IOException(String.format(getLoggingLocale(), closed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String wrongBase64InPBCompatibleMode = "ELY03032: Base64 string created with unsupported PicketBox version \"%s\"";
    protected String wrongBase64InPBCompatibleMode$str() {
        return wrongBase64InPBCompatibleMode;
    }
    @Override
    public final IllegalArgumentException wrongBase64InPBCompatibleMode(final String base64) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), wrongBase64InPBCompatibleMode$str(), base64));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechanismNotSupported = "ELY04020: Mechanism \"%s\" not supported by transformation mapper";
    protected String mechanismNotSupported$str() {
        return mechanismNotSupported;
    }
    @Override
    public final IllegalArgumentException mechanismNotSupported(final String mechanism) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), mechanismNotSupported$str(), mechanism));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToEncode = "ELY08030: Failed to encode parameter specification";
    protected String failedToEncode$str() {
        return failedToEncode;
    }
    @Override
    public final InvalidParameterSpecException failedToEncode(final Throwable cause) {
        final InvalidParameterSpecException result = new InvalidParameterSpecException(String.format(getLoggingLocale(), failedToEncode$str()));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToDecode = "ELY08031: Failed to decode parameter specification";
    protected String failedToDecode$str() {
        return failedToDecode;
    }
    @Override
    public final IOException failedToDecode(final Throwable cause) {
        final IOException result = new IOException(String.format(getLoggingLocale(), failedToDecode$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidParameterSpec = "ELY08032: Invalid parameter specification type (expected %s, got %s)";
    protected String invalidParameterSpec$str() {
        return invalidParameterSpec;
    }
    @Override
    public final InvalidParameterSpecException invalidParameterSpec(final Class<?> expected, final Class<?> actual) {
        final InvalidParameterSpecException result = new InvalidParameterSpecException(String.format(getLoggingLocale(), invalidParameterSpec$str(), expected, actual));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidFormat = "ELY08033: Invalid format given (expected %s, got %s)";
    protected String invalidFormat$str() {
        return invalidFormat;
    }
    @Override
    public final IOException invalidFormat(final String expected, final String actual) {
        final IOException result = new IOException(String.format(getLoggingLocale(), invalidFormat$str(), expected, actual));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String algorithmParametersNotInitialized = "ELY08034: Algorithm parameters instance not initialized";
    protected String algorithmParametersNotInitialized$str() {
        return algorithmParametersNotInitialized;
    }
    @Override
    public final IllegalStateException algorithmParametersNotInitialized() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), algorithmParametersNotInitialized$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
