package org.wildfly.security.auth.realm.ldap;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.wildfly.security.auth.server.RealmUnavailableException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import java.lang.RuntimeException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import javax.naming.NamingException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2024-04-16T22:22:42-0400")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String emptyParameter$str() {
        return "ELY00002: Parameter %s is empty";
    }
    @Override
    public final IllegalArgumentException emptyParameter(final String parameter) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), emptyParameter$str(), parameter));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String builderAlreadyBuilt$str() {
        return "ELY00003: This builder has already been built";
    }
    @Override
    public final IllegalStateException builderAlreadyBuilt() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), builderAlreadyBuilt$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unrecognizedAlgorithm$str() {
        return "ELY00004: Unrecognized algorithm \"%s\"";
    }
    @Override
    public final IllegalArgumentException unrecognizedAlgorithm(final String algorithm) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unrecognizedAlgorithm$str(), algorithm));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void credentialDestroyingFailed(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, credentialDestroyingFailed$str());
    }
    protected String credentialDestroyingFailed$str() {
        return "ELY00007: Credential destroying failed";
    }
    protected String couldNotObtainCredential$str() {
        return "ELY01041: Could not obtain credential";
    }
    @Override
    public final RuntimeException couldNotObtainCredential() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), couldNotObtainCredential$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotObtainCredentialWithCause$str() {
        return "ELY01042: Could not obtain credential";
    }
    @Override
    public final RuntimeException couldNotObtainCredentialWithCause(final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), couldNotObtainCredentialWithCause$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String insufficientDataToFormDigestAndSalt$str() {
        return "ELY01053: Insufficient data to form a digest and a salt";
    }
    @Override
    public final InvalidKeySpecException insufficientDataToFormDigestAndSalt() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), insufficientDataToFormDigestAndSalt$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noDirContextSupplierSet$str() {
        return "ELY01057: No DirContext supplier set";
    }
    @Override
    public final IllegalStateException noDirContextSupplierSet() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noDirContextSupplierSet$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noPrincipalMappingDefinition$str() {
        return "ELY01058: No principal mapping definition";
    }
    @Override
    public final IllegalStateException noPrincipalMappingDefinition() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noPrincipalMappingDefinition$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotObtainPrincipal$str() {
        return "ELY01060: Could not obtain principal";
    }
    @Override
    public final RuntimeException couldNotObtainPrincipal() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), couldNotObtainPrincipal$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noProviderUrlSet$str() {
        return "ELY01062: No provider URL has been set";
    }
    @Override
    public final IllegalStateException noProviderUrlSet() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noProviderUrlSet$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidName$str() {
        return "ELY01064: Invalid identity name";
    }
    @Override
    public final IllegalArgumentException invalidName() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidName$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ldapRealmFailedObtainAttributes$str() {
        return "ELY01079: Ldap-backed realm failed to obtain attributes for entry [%s]";
    }
    @Override
    public final RuntimeException ldapRealmFailedObtainAttributes(final String dn, final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), ldapRealmFailedObtainAttributes$str(), dn), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ldapRealmInvalidRdnForAttribute$str() {
        return "ELY01080: Attribute [%s] value [%s] must be in X.500 format in order to obtain RDN [%s].";
    }
    @Override
    public final RuntimeException ldapRealmInvalidRdnForAttribute(final String attributeName, final String value, final String rdn, final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), ldapRealmInvalidRdnForAttribute$str(), attributeName, value, rdn), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ldapRealmIdentityNotExists$str() {
        return "ELY01083: Ldap-backed realm cannot to obtain not existing identity \"%s\"";
    }
    @Override
    public final RealmUnavailableException ldapRealmIdentityNotExists(final String identity) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), ldapRealmIdentityNotExists$str(), identity));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ldapRealmErrorWhileConsumingResultsFromSearch$str() {
        return "ELY01084: Error while consuming results from search. SearchDn [%s], Filter [%s], Filter Args [%s].";
    }
    @Override
    public final RuntimeException ldapRealmErrorWhileConsumingResultsFromSearch(final String searchDn, final String filter, final String filterArgs, final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), ldapRealmErrorWhileConsumingResultsFromSearch$str(), searchDn, filter, filterArgs), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ldapRealmsPersisterNotSupported$str() {
        return "ELY01085: LDAP realm persister does not support given credential type";
    }
    @Override
    public final RealmUnavailableException ldapRealmsPersisterNotSupported() {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), ldapRealmsPersisterNotSupported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ldapRealmCredentialPersistingFailed$str() {
        return "ELY01086: Persisting credential %s into Ldap-backed realm failed. Identity dn: \"%s\"";
    }
    @Override
    public final RealmUnavailableException ldapRealmCredentialPersistingFailed(final String credential, final String dn, final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), ldapRealmCredentialPersistingFailed$str(), credential, dn), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ldapRealmCredentialClearingFailed$str() {
        return "ELY01087: Clearing credentials from Ldap-backed realm failed. Identity dn: \"%s\"";
    }
    @Override
    public final RealmUnavailableException ldapRealmCredentialClearingFailed(final String dn, final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), ldapRealmCredentialClearingFailed$str(), dn), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownLdapPasswordScheme$str() {
        return "ELY01090: Unknown LDAP password scheme";
    }
    @Override
    public final InvalidKeySpecException unknownLdapPasswordScheme() {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), unknownLdapPasswordScheme$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noSuchIdentity$str() {
        return "ELY01096: No such identity";
    }
    @Override
    public final RealmUnavailableException noSuchIdentity() {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), noSuchIdentity$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ldapRealmFailedDeleteIdentityFromServer$str() {
        return "ELY01097: Ldap-backed realm failed to delete identity from server";
    }
    @Override
    public final RealmUnavailableException ldapRealmFailedDeleteIdentityFromServer(final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), ldapRealmFailedDeleteIdentityFromServer$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ldapRealmFailedCreateIdentityOnServer$str() {
        return "ELY01098: Ldap-backed realm failed to create identity on server";
    }
    @Override
    public final RealmUnavailableException ldapRealmFailedCreateIdentityOnServer(final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), ldapRealmFailedCreateIdentityOnServer$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ldapRealmNotConfiguredToSupportCreatingIdentities$str() {
        return "ELY01099: Ldap-backed realm is not configured to allow create new identities (new identity parent and attributes has to be set)";
    }
    @Override
    public final RealmUnavailableException ldapRealmNotConfiguredToSupportCreatingIdentities() {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), ldapRealmNotConfiguredToSupportCreatingIdentities$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ldapRealmCannotSetAttributeWithoutMapping$str() {
        return "ELY01100: Ldap-backed realm does not contain mapping to set Elytron attribute \"%s\" of identity \"%s\"";
    }
    @Override
    public final RealmUnavailableException ldapRealmCannotSetAttributeWithoutMapping(final String attribute, final String identity) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), ldapRealmCannotSetAttributeWithoutMapping$str(), attribute, identity));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void ldapRealmDoesNotSupportSettingFilteredAttribute(final String attribute, final String identity) {
        super.log.logf(FQCN, WARN, null, ldapRealmDoesNotSupportSettingFilteredAttribute$str(), attribute, identity);
    }
    protected String ldapRealmDoesNotSupportSettingFilteredAttribute$str() {
        return "ELY01101: Ldap-backed realm does not support setting of filtered attribute \"%s\" (identity \"%s\")";
    }
    protected String ldapRealmRequiresExactlyOneRdnAttribute$str() {
        return "ELY01102: Ldap-backed realm requires exactly one value of attribute \"%s\" mapped to RDN (identity \"%s\")";
    }
    @Override
    public final RealmUnavailableException ldapRealmRequiresExactlyOneRdnAttribute(final String attribute, final String identity) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), ldapRealmRequiresExactlyOneRdnAttribute$str(), attribute, identity));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ldapRealmAttributesSettingFailed$str() {
        return "ELY01103: Ldap-backed realm failed to set attributes of identity \"%s\"";
    }
    @Override
    public final RealmUnavailableException ldapRealmAttributesSettingFailed(final String identity, final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), ldapRealmAttributesSettingFailed$str(), identity), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ldapRealmIdentitySearchFailed$str() {
        return "ELY01108: Ldap-backed realm identity search failed";
    }
    @Override
    public final RealmUnavailableException ldapRealmIdentitySearchFailed(final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), ldapRealmIdentitySearchFailed$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ldapRealmNotConfiguredToSupportIteratingOverIdentities$str() {
        return "ELY01109: Ldap-backed realm is not configured to allow iterate over identities (iterator filter has to be set)";
    }
    @Override
    public final RealmUnavailableException ldapRealmNotConfiguredToSupportIteratingOverIdentities() {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), ldapRealmNotConfiguredToSupportIteratingOverIdentities$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ldapRealmFailedToObtainContext$str() {
        return "ELY01125: Ldap-backed realm failed to obtain context";
    }
    @Override
    public final RealmUnavailableException ldapRealmFailedToObtainContext(final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), ldapRealmFailedToObtainContext$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void ldapRealmDeferRegistration() {
        super.log.logf(FQCN, INFO, null, ldapRealmDeferRegistration$str());
    }
    protected String ldapRealmDeferRegistration$str() {
        return "ELY01146: LDAP Realm unable to register listener, defering action.";
    }
    protected String ldapInvalidLdapName$str() {
        return "ELY01147: Invalid LDAP name [%s]";
    }
    @Override
    public final RuntimeException ldapInvalidLdapName(final String name, final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), ldapInvalidLdapName$str(), name), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String obtainingDirContextCredentialFromAuthenticationContextFailed$str() {
        return "ELY01150: Obtaining DirContext credentials from AuthenticationContext failed.";
    }
    @Override
    public final NamingException obtainingDirContextCredentialFromAuthenticationContextFailed(final Throwable cause) {
        final NamingException result = new NamingException(String.format(getLoggingLocale(), obtainingDirContextCredentialFromAuthenticationContextFailed$str()));
        result.initCause(cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String directLdapVerificationFailed$str() {
        return "ELY01153: Direct LDAP verification failed with DN [%s] and absolute DN [%s]";
    }
    @Override
    public final RealmUnavailableException directLdapVerificationFailed(final String distinguishedName, final String absoluteName, final Exception e) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), directLdapVerificationFailed$str(), distinguishedName, absoluteName), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String threadLocalSslSocketFactoryThreadLocalNotSet$str() {
        return "ELY04025: DirContext tries to connect without ThreadLocalSSLSocketFactory thread local setting";
    }
    @Override
    public final IllegalStateException threadLocalSslSocketFactoryThreadLocalNotSet() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), threadLocalSslSocketFactoryThreadLocalNotSet$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
