package org.wildfly.security.audit;

import java.util.Locale;
import java.io.Serializable;
import java.net.PortUnreachableException;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import java.io.IOException;
import org.jboss.logging.Logger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import org.wildfly.security.audit.EventPriority;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.FATAL;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2024-10-31T11:15:49-0400")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void endpointUnavaiable(final String priority, final String message, final Throwable cause) {
        super.log.logf(FQCN, FATAL, cause, endpointUnavaiable$str(), priority, message);
    }
    protected String endpointUnavaiable$str() {
        return "ELY11001: Endpoint unable to handle SecurityEvent priority=%s, message=%s";
    }
    protected String invalidEventPriority$str() {
        return "ELY11002: Invalid EventPriority '%s' passed to AuditEndpoint.";
    }
    @Override
    public final IllegalArgumentException invalidEventPriority(final org.wildfly.security.audit.EventPriority eventPriority) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidEventPriority$str(), eventPriority));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void unableToRotateLogFile(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, unableToRotateLogFile$str());
    }
    protected String unableToRotateLogFile$str() {
        return "ELY11003: Unable to rotate log file";
    }
    protected String rotatingBySecondUnsupported$str() {
        return "ELY11004: Invalid suffix \"%s\" - rotating by second or millisecond is not supported";
    }
    @Override
    public final IllegalArgumentException rotatingBySecondUnsupported(final String suffix) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), rotatingBySecondUnsupported$str(), suffix));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void unableToAcceptEvent(final Throwable cause) {
        super.log.logf(FQCN, FATAL, cause, unableToAcceptEvent$str());
    }
    protected String unableToAcceptEvent$str() {
        return "ELY11007: Endpoint unable to accept SecurityEvent.";
    }
    protected String syslogMaximumReconnectAttemptsReached$str() {
        return "ELY12001: The maximum reconnect attempts value of %s was reached. The syslog endpoint will be shutdown.";
    }
    @Override
    public final IOException syslogMaximumReconnectAttemptsReached(final int reconnectAttempts) {
        final IOException result = new IOException(String.format(getLoggingLocale(), syslogMaximumReconnectAttemptsReached$str(), reconnectAttempts));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String udpPortUnavailable$str() {
        return "ELY12002: The configured UDP port is unavailable.";
    }
    @Override
    public final PortUnreachableException udpPortUnavailable(final Throwable cause) {
        final PortUnreachableException result = new PortUnreachableException(String.format(getLoggingLocale(), udpPortUnavailable$str()));
        result.initCause(cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String badReconnectAttemptsNumber$str() {
        return "ELY12003: The reconnect attempts value of %s is invalid. Please use an integer value >= -1.";
    }
    @Override
    public final IllegalArgumentException badReconnectAttemptsNumber(final int reconnectAttempts) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), badReconnectAttemptsNumber$str(), reconnectAttempts));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
