package org.wildfly.security.credential.source;

import java.util.Locale;
import java.io.InterruptedIOException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.io.IOException;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.jboss.logging.Logger;
import javax.security.sasl.SaslException;
import java.lang.Exception;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Class;
import java.util.Arrays;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2025-02-26T19:35:18-0500")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String unableToReadCredential$str() {
        return "ELY01030: Unable to read credential";
    }
    @Override
    public final IOException unableToReadCredential(final Exception e) {
        final IOException result = new IOException(String.format(getLoggingLocale(), unableToReadCredential$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String mechCallbackHandlerFailedForUnknownReason$str() {
        return "ELY05053: Callback handler failed for unknown reason";
    }
    @Override
    public final SaslException mechCallbackHandlerFailedForUnknownReason(final Throwable cause) {
        final SaslException result = new SaslException(String.format(getLoggingLocale(), mechCallbackHandlerFailedForUnknownReason$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUnableToHandleResponseFromServer$str() {
        return "ELY05125: Unable to handle response from server";
    }
    @Override
    public final SaslException mechUnableToHandleResponseFromServer(final Throwable cause) {
        final SaslException result = new SaslException(String.format(getLoggingLocale(), mechUnableToHandleResponseFromServer$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String credentialCommandInterrupted$str() {
        return "ELY09506: Credential store command interrupted";
    }
    @Override
    public final InterruptedIOException credentialCommandInterrupted() {
        final InterruptedIOException result = new InterruptedIOException(String.format(getLoggingLocale(), credentialCommandInterrupted$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToReadCredentialTypeFromStore$str() {
        return "ELY09511: Unable to read credential %s from store";
    }
    @Override
    public final CredentialStoreException unableToReadCredentialTypeFromStore(final Class<? extends org.wildfly.security.credential.Credential> credentialType) {
        final CredentialStoreException result = new CredentialStoreException(String.format(getLoggingLocale(), unableToReadCredentialTypeFromStore$str(), credentialType));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
