/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.adapter;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.GradleProject;

public class GradleDependencyAdapter {
    private static final String PREFIX = "--- ";
    private static final String SUFFIX = " (*)";
    private static final String VERSION_UP = "-> ";
    private Path rootPath;

    public GradleDependencyAdapter(Path projectDir) {
        this.rootPath = projectDir;
    }

    public List<String> parseDependencies() {
        return this.parseDependencies(Configuration.RUNTIME);
    }

    public List<String> parseDependencies(Configuration configuration) {
        System.out.println(this.rootPath);
        GradleConnector connector = GradleConnector.newConnector().forProjectDirectory(this.rootPath.toFile());
        ProjectConnection connection = connector.connect();
        GradleProject project = (GradleProject)connection.getModel(GradleProject.class);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ((BuildLauncher)((BuildLauncher)connection.newBuild().withArguments(new String[]{"dependencies", "--configuration", configuration.literal})).setStandardOutput((OutputStream)bout)).run();
        connection.close();
        String deps = new String(bout.toByteArray());
        LinkedList<String> coordinates = new LinkedList<String>();
        Scanner scanner = new Scanner(deps);
        while (scanner.hasNextLine()) {
            String[] coords;
            String line = scanner.nextLine();
            if (!line.contains(PREFIX)) continue;
            if ((line = line.substring(line.indexOf(PREFIX) + PREFIX.length(), line.length())).endsWith(SUFFIX)) {
                line = line.substring(0, line.indexOf(SUFFIX));
            }
            if (3 == (coords = line.split(":")).length) {
                String version = coords[2];
                if (version.contains(VERSION_UP)) {
                    String s = coords[0] + ":" + coords[1] + ":" + version.substring(version.indexOf(VERSION_UP) + VERSION_UP.length(), version.length());
                    coordinates.add(s);
                    continue;
                }
                coordinates.add(line);
                continue;
            }
            throw new IllegalArgumentException("Unexpected input format");
        }
        scanner.close();
        return coordinates;
    }

    public static enum Configuration {
        ARCHIVE("archives"),
        DEFAULT("default"),
        COMPILE("compile"),
        RUNTIME("runtime"),
        TEST_COMPILE("testCompile"),
        TEST_RUNTIME("testRuntime");

        private String literal;

        private Configuration(String literal) {
            this.literal = literal;
        }
    }
}

